/*
 * Decompiled with CFR 0.152.
 */
package info.textgrid.lab.core.metadataeditor;

import com.logabit.xlayout.XLayout;
import com.logabit.xlayout.XLayoutFactory;
import com.logabit.xlayout.source.XLayoutSource;
import info.textgrid.lab.core.metadataeditor.Activator;
import info.textgrid.lab.core.metadataeditor.IMetadataPart;
import info.textgrid.lab.core.metadataeditor.Messages;
import info.textgrid.lab.core.metadataeditor.MetaDataView;
import info.textgrid.lab.core.metadataeditor.elements.IControl;
import info.textgrid.lab.core.model.CrudServiceException;
import info.textgrid.lab.core.model.TextGridObject;
import info.textgrid.lab.core.model.TextGridProject;
import info.textgrid.lab.core.model.TextGridProjectFile;
import info.textgrid.namespaces.metadata.core._2010.ObjectType;
import info.textgrid.namespaces.metadata.projectfile._2008_11_27.TgProjectFile;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.lang.reflect.InvocationTargetException;
import java.util.List;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMElement;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.forms.widgets.ScrolledForm;
import org.eclipse.ui.forms.widgets.Section;

public class MetaDataSection
implements IMetadataPart {
    private XLayoutFactory factory = XLayoutFactory.getFactory();
    private XLayout layout = null;
    private XLayoutSource xmlInputSource = null;
    private TextGridObject tgObj = null;
    private InputStream inputFromOM = null;
    private Composite parent = null;
    private Composite top = null;
    private ScrolledForm metadataForm = null;
    private boolean isProjectFileLoaded = false;
    private OMElement _omElem = null;
    private MetaDataView.OBJECT_TYPE objectType = MetaDataView.OBJECT_TYPE.ITEM;
    private boolean editable = true;
    private boolean validateActive = true;

    public MetaDataSection(Composite parent, ScrolledForm scrolledForm, TextGridObject tgo) {
        this.parent = parent;
        this.metadataForm = scrolledForm;
        this.rebuild(false, null);
        this.setNewTGObject(tgo, tgo != null);
    }

    public void setVisible(boolean visible) {
        if (this.layout != null) {
            this.layout.setVisible(visible);
        }
    }

    private void rebuild(boolean readProjectFile, TextGridProject project) {
        InputStream custom_input;
        this.layout = this.factory.createXLayout();
        this.layout.registerMetadataPart(this);
        if (this.top != null) {
            this.top.dispose();
        }
        this.top = new Composite(this.parent, 0);
        this.top.setBackground(this.parent.getBackground());
        this.top.setLayout(this.parent.getLayout());
        this.top.setLayoutData(this.parent.getLayoutData());
        this.top.setData(this.parent.getData());
        this.xmlInputSource = null;
        String type = this.objectType.toString();
        InputStream input_xul = this.getClass().getClassLoader().getResourceAsStream("metadata-" + type + ".xl.xml");
        boolean xul_inputSource_created = false;
        if (readProjectFile && (custom_input = this.getInputStreamFromProjectFile(project)) != null) {
            try {
                String xul_content = MetaDataView.convertStreamToString(input_xul);
                String custom_content = MetaDataView.convertStreamToString(custom_input);
                xul_content = xul_content.replaceFirst("<tg:custom-placeholder.*?/>", custom_content);
                this.xmlInputSource = new XLayoutSource("MetaData-XUL" + type + "_" + String.valueOf(System.currentTimeMillis()), new ByteArrayInputStream(xul_content.getBytes("UTF-8")));
                xul_inputSource_created = true;
            }
            catch (Exception e2) {
                Activator.handleError(e2);
                return;
            }
        }
        if (!xul_inputSource_created) {
            this.xmlInputSource = new XLayoutSource("MetaData-XUL" + type, input_xul);
        }
        this.layout.draw(this.top, this.xmlInputSource, type, false);
        this.editable = true;
        if (this.metadataForm != null) {
            this.metadataForm.reflow(true);
        }
        this.parent.layout(true, true);
    }

    public void setNewTGObject(final TextGridObject tgo, boolean reloadProjectFile) {
        this.tgObj = tgo;
        if (this.tgObj != null) {
            this.objectType = null;
            this.checkObjectType(this.tgObj);
            if (this.objectType == null) {
                String format = null;
                try {
                    format = this.tgObj.getMetadata().getGeneric().getProvided().getFormat();
                }
                catch (CrudServiceException e1) {
                    Activator.handleError(e1, "Format not found!", new Object[0]);
                    return;
                }
                if (format != null) {
                    this.objectType = format.contains("tg.work+") ? MetaDataView.OBJECT_TYPE.WORK : (format.contains("tg.edition+") ? MetaDataView.OBJECT_TYPE.EDITION : (format.contains("tg.collection+") ? MetaDataView.OBJECT_TYPE.COLLECTION : MetaDataView.OBJECT_TYPE.ITEM));
                }
            }
            if (reloadProjectFile) {
                this.rebuild(true, null);
            }
            Job getJob = new Job(Messages.MetaDataSection_getMetadata){

                protected IStatus run(IProgressMonitor monitor) {
                    if (monitor == null) {
                        monitor = new NullProgressMonitor();
                    }
                    try {
                        MetaDataSection.this._omElem = tgo.getMetadataXML();
                    }
                    catch (CoreException e) {
                        Activator.handleError(e);
                        return Status.CANCEL_STATUS;
                    }
                    return Status.OK_STATUS;
                }
            };
            getJob.schedule();
            try {
                getJob.join();
            }
            catch (InterruptedException interruptedException) {}
            if (getJob.getResult() != Status.OK_STATUS) {
                return;
            }
            this.layout.setOMElement(this._omElem, this.objectType.toString(), tgo.getURI().toString());
        }
    }

    public void setMetadataXML(OMElement elem, String type, TextGridProject project) {
        this.validateActive = false;
        this.internalRebuild(type, project);
        Text format = (Text)this.layout.getControl("txtFormat");
        if (format != null) {
            format.setEnabled(false);
        }
        if (elem != null) {
            this.layout.setOMElement(elem, type, null);
        }
    }

    private void internalRebuild(String type, TextGridProject project) {
        this.layout = this.factory.createXLayout();
        this.layout.registerMetadataPart(this);
        if (this.top != null) {
            this.top.dispose();
        }
        this.top = new Composite(this.parent, 0);
        this.top.setBackground(this.parent.getBackground());
        this.top.setLayout(this.parent.getLayout());
        this.top.setLayoutData(this.parent.getLayoutData());
        this.top.setData(this.parent.getData());
        this.xmlInputSource = null;
        InputStream input_xul = this.getClass().getClassLoader().getResourceAsStream("metadata-" + type + ".xl.xml");
        boolean xul_inputSource_created = false;
        InputStream custom_input = this.getInputStreamFromProjectFile(project);
        if (custom_input != null) {
            try {
                String xul_content = MetaDataView.convertStreamToString(input_xul);
                String custom_content = MetaDataView.convertStreamToString(custom_input);
                xul_content = xul_content.replaceFirst("<tg:custom-placeholder.*?/>", custom_content);
                this.xmlInputSource = new XLayoutSource("MetaData-XUL" + type + "_" + String.valueOf(System.currentTimeMillis()), new ByteArrayInputStream(xul_content.getBytes("UTF-8")));
                xul_inputSource_created = true;
            }
            catch (Exception e2) {
                Activator.handleError(e2);
                return;
            }
        }
        if (!xul_inputSource_created) {
            this.xmlInputSource = new XLayoutSource("MetaData-XUL" + type, input_xul);
        }
        this.layout.draw(this.top, this.xmlInputSource, type, false);
        this.editable = true;
        if (this.metadataForm != null) {
            this.metadataForm.reflow(true);
        }
        this.parent.layout(true, true);
    }

    private void checkObjectType(TextGridObject obj) {
        if (obj != null) {
            try {
                ObjectType type = obj.getMetadata();
                if (type.getItem() != null) {
                    this.objectType = MetaDataView.OBJECT_TYPE.ITEM;
                } else if (type.getWork() != null) {
                    this.objectType = MetaDataView.OBJECT_TYPE.WORK;
                } else if (type.getEdition() != null) {
                    this.objectType = MetaDataView.OBJECT_TYPE.EDITION;
                } else if (type.getCollection() != null) {
                    this.objectType = MetaDataView.OBJECT_TYPE.COLLECTION;
                } else {
                    String contentTypeId = obj.getContentTypeID();
                    if (contentTypeId != null && !"".equals(contentTypeId)) {
                        this.objectType = contentTypeId.toLowerCase().contains("tg.work+") ? MetaDataView.OBJECT_TYPE.WORK : (contentTypeId.toLowerCase().contains("tg.edition+") ? MetaDataView.OBJECT_TYPE.EDITION : (contentTypeId.toLowerCase().contains("tg.collection+") ? MetaDataView.OBJECT_TYPE.COLLECTION : MetaDataView.OBJECT_TYPE.ITEM));
                    }
                }
            }
            catch (CrudServiceException e) {
                Activator.handleError(e, Messages.MetaDataSection_fetchFailed, new Object[0]);
            }
            catch (CoreException e) {
                Activator.handleError(e, Messages.MetaDataSection_fetchFailed, new Object[0]);
            }
        }
    }

    public boolean isMetadataSectionCreated() {
        return this.layout != null;
    }

    public boolean isProjectFileLoaded() {
        return this.isProjectFileLoaded;
    }

    public void setEditable(boolean editable) {
        if (editable == this.editable) {
            return;
        }
        List<Control> controls = this.layout.getAllControls();
        for (Control c : controls) {
            if (c == null || c.isDisposed() || c instanceof Label || c instanceof Section || c instanceof Composite && !(c instanceof Combo) || c instanceof Link) continue;
            c.setEnabled(editable);
        }
        this.editable = editable;
    }

    public XLayout getXLayout() {
        return this.layout;
    }

    public OMElement getMetadataXML() {
        return this.layout.getOMElement();
    }

    public void updateTextGridObject() {
        if (this.tgObj != null) {
            this.tgObj.setMetadataXML(this.layout.getOMElement());
        }
    }

    public TextGridObject getTextGridObject() {
        this.updateTextGridObject();
        return this.tgObj;
    }

    public boolean checkAllFields() {
        boolean valid = true;
        if (this.layout != null) {
            for (IControl c : this.layout.getAllControlElements()) {
                valid &= c.validate();
            }
        }
        return valid;
    }

    public void writeToGrid() {
        OMElement omElem = this.layout.getOMElement();
        this.tgObj.setMetadataXML(omElem);
        Job saveJob = new Job(Messages.MetaDataSection_makePersistent){

            protected IStatus run(IProgressMonitor monitor) {
                if (monitor == null) {
                    monitor = new NullProgressMonitor();
                }
                try {
                    MetaDataSection.this.tgObj.reloadMetadata(false);
                    MetaDataSection.this.tgObj.makeMetadataPersistent(monitor);
                }
                catch (CoreException e) {
                    Activator.handleError(e, Messages.MetaDataSection_saveFailed, new Object[0]);
                    return Status.CANCEL_STATUS;
                }
                return Status.OK_STATUS;
            }
        };
        saveJob.schedule();
        try {
            saveJob.join();
        }
        catch (InterruptedException e) {
            Activator.handleError(e);
        }
        if (saveJob.getResult() != Status.OK_STATUS) {
            return;
        }
        System.out.println(Messages.MetaDataSection_saved);
    }

    public void reloadProjectFile(TextGridProject project) {
        this.rebuild(true, project);
    }

    private InputStream getInputStreamFromProjectFile(TextGridProject p) {
        this.inputFromOM = null;
        TextGridProject project = null;
        if (p == null) {
            if (this.tgObj == null) {
                return null;
            }
            try {
                project = this.tgObj.getProjectInstance();
            }
            catch (CrudServiceException e1) {
                Activator.handleError(e1);
            }
            catch (CoreException e1) {
                Activator.handleError(e1);
            }
            if (project == null) {
                return null;
            }
        } else {
            project = p;
        }
        final TextGridProjectFile projectFile = new TextGridProjectFile(project);
        IRunnableWithProgress fetchJob = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) {
                try {
                    OMElement xul_elem;
                    if (monitor == null) {
                        monitor = new NullProgressMonitor();
                    }
                    monitor.beginTask(Messages.MetaDataSection_fetchingProjectfile, -1);
                    TgProjectFile projectFileData = projectFile.getProjectFileData(false, true, monitor);
                    OMElement[] appDataChildren = TextGridProjectFile.extractAppDataChildren((TgProjectFile)projectFileData);
                    OMElement mySection = null;
                    if (appDataChildren != null && appDataChildren.length > 0) {
                        OMElement[] oMElementArray = appDataChildren;
                        int n = appDataChildren.length;
                        int n2 = 0;
                        while (n2 < n) {
                            OMElement child = oMElementArray[n2];
                            if (child.getQName().equals(TextGridProjectFile.metadataSectionQName)) {
                                mySection = child;
                                break;
                            }
                            ++n2;
                        }
                    }
                    if (mySection != null && (xul_elem = mySection.getFirstChildWithName(new QName("tr"))) != null) {
                        ByteArrayOutputStream baos = new ByteArrayOutputStream();
                        OutputStreamWriter w = new OutputStreamWriter((OutputStream)baos, "UTF-8");
                        xul_elem.serialize((Writer)w);
                        MetaDataSection.this.inputFromOM = new ByteArrayInputStream(baos.toByteArray());
                        ((Writer)w).flush();
                        ((Writer)w).close();
                        baos.close();
                    }
                    monitor.done();
                }
                catch (Exception e) {
                    Activator.handleError(e);
                }
            }
        };
        try {
            PlatformUI.getWorkbench().getActiveWorkbenchWindow().getWorkbench().getProgressService().busyCursorWhile(fetchJob);
        }
        catch (InvocationTargetException e) {
            Activator.handleError(e);
        }
        catch (InterruptedException e) {
            Activator.handleError(e);
        }
        return this.inputFromOM;
    }

    @Override
    public boolean validate() {
        if (!this.validateActive) {
            return false;
        }
        this.checkAllFields();
        return true;
    }

    @Override
    @Deprecated
    public void update() {
        this.updateTextGridObject();
    }

    @Override
    public boolean isEditable() {
        return this.editable;
    }
}

