/*
 * Decompiled with CFR 0.152.
 */
package info.textgrid.lab.ui.core.locking;

import java.text.MessageFormat;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.ui.statushandlers.StatusManager;

public class JobChangeLogger
implements IJobChangeListener {
    private String name;

    public JobChangeLogger(String name, Object ... args) {
        this.name = MessageFormat.format(name, args);
    }

    private void log(String message, Object ... args) {
        String composedMessage = this.formatMessage(message, args);
        StatusManager.getManager().handle((IStatus)new Status(1, "info.textgrid.lab.ui.core", composedMessage), 1);
    }

    private String formatMessage(String message, Object ... args) {
        String composedMessage = String.valueOf(MessageFormat.format(message, args)) + ": " + this.name;
        return composedMessage;
    }

    public void aboutToRun(IJobChangeEvent event) {
        this.log("about to run", new Object[0]);
    }

    public void awake(IJobChangeEvent event) {
        this.log("awake", new Object[0]);
    }

    public void done(IJobChangeEvent event) {
        MultiStatus multiStatus = new MultiStatus("info.textgrid.lab.ui.core", 0, this.formatMessage("done", new Object[0]), null);
        multiStatus.add(event.getResult());
        StatusManager.getManager().handle((IStatus)multiStatus);
    }

    public void running(IJobChangeEvent event) {
        this.log("running", new Object[0]);
    }

    public void scheduled(IJobChangeEvent event) {
        this.log("scheduled in {0} min", event.getDelay() / 60000L);
    }

    public void sleeping(IJobChangeEvent event) {
        this.log("sleeping", new Object[0]);
    }
}

