/*
 * Decompiled with CFR 0.152.
 */
package net.sf.vex.action;

import java.util.ArrayList;
import net.sf.vex.action.AbstractVexAction;
import net.sf.vex.action.ActionUtils;
import net.sf.vex.action.TableCellCallback;
import net.sf.vex.core.IntRange;
import net.sf.vex.widget.IVexWidget;

public class MoveColumnLeftAction
extends AbstractVexAction {
    @Override
    public void run(final IVexWidget vexWidget) {
        final ActionUtils.RowColumnInfo rcInfo = ActionUtils.getRowColumnInfo(vexWidget);
        if (rcInfo == null || rcInfo.cellIndex < 1) {
            return;
        }
        vexWidget.doWork(true, new Runnable(){

            @Override
            public void run() {
                final ArrayList sourceCells = new ArrayList();
                final ArrayList destCells = new ArrayList();
                ActionUtils.iterateTableCells(vexWidget, new TableCellCallback(){
                    Object prevCell = null;

                    @Override
                    public void startRow(Object row, int rowIndex) {
                    }

                    @Override
                    public void onCell(Object row, Object cell, int rowIndex, int cellIndex) {
                        if (cellIndex == rcInfo.cellIndex) {
                            sourceCells.add(this.prevCell);
                            destCells.add(cell);
                        } else if (cellIndex == rcInfo.cellIndex - 1) {
                            this.prevCell = cell;
                        }
                    }

                    @Override
                    public void endRow(Object row, int rowIndex) {
                    }
                });
                int i = sourceCells.size() - 1;
                while (i >= 0) {
                    Object source = sourceCells.get(i);
                    final IntRange sourceRange = ActionUtils.getOuterRange(source);
                    Object dest = destCells.get(i);
                    vexWidget.moveTo(ActionUtils.getOuterRange(dest).getEnd());
                    vexWidget.savePosition(new Runnable(){

                        @Override
                        public void run() {
                            vexWidget.moveTo(sourceRange.getStart());
                            vexWidget.moveTo(sourceRange.getEnd(), true);
                            vexWidget.cutSelection();
                        }
                    });
                    vexWidget.paste();
                    --i;
                }
            }
        });
    }

    @Override
    public boolean isEnabled(IVexWidget vexWidget) {
        ActionUtils.RowColumnInfo rcInfo = ActionUtils.getRowColumnInfo(vexWidget);
        return rcInfo != null && rcInfo.cellIndex > 0;
    }
}

