/*
 * Decompiled with CFR 0.152.
 */
package net.sf.vex.css;

import info.textgrid.lab.xmleditor.sac.VexSac;
import java.io.CharArrayReader;
import java.io.IOException;
import java.io.Reader;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import net.sf.vex.css.AbstractProperty;
import net.sf.vex.css.BorderStyleProperty;
import net.sf.vex.css.BorderWidthProperty;
import net.sf.vex.css.ColorProperty;
import net.sf.vex.css.FontSizeProperty;
import net.sf.vex.css.FontStyleProperty;
import net.sf.vex.css.FontVariantProperty;
import net.sf.vex.css.FontWeightProperty;
import net.sf.vex.css.PropertyDecl;
import net.sf.vex.css.Rule;
import net.sf.vex.css.SacFactory;
import net.sf.vex.css.StyleSheet;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.osgi.util.NLS;
import org.eclipse.ui.statushandlers.StatusManager;
import org.w3c.css.sac.CSSException;
import org.w3c.css.sac.CSSParseException;
import org.w3c.css.sac.DocumentHandler;
import org.w3c.css.sac.ErrorHandler;
import org.w3c.css.sac.InputSource;
import org.w3c.css.sac.LexicalUnit;
import org.w3c.css.sac.Parser;
import org.w3c.css.sac.SACMediaList;
import org.w3c.css.sac.Selector;
import org.w3c.css.sac.SelectorList;

public class StyleSheetReader {
    private byte source = 0;

    protected static Parser createParser() {
        Parser p = VexSac.getParser();
        p.setErrorHandler(new ErrorHandler(){

            private String message(CSSParseException exception) {
                return NLS.bind((String)"Error parsing CSS {3}: {0} In line {1}, column {2}", (Object[])new Object[]{exception.getMessage(), exception.getLineNumber(), exception.getColumnNumber(), exception.getURI()});
            }

            public void error(CSSParseException exception) throws CSSException {
                StatusManager.getManager().handle((IStatus)new Status(4, "net.sf.vex.toolkit", this.message(exception), (Throwable)exception));
            }

            public void fatalError(CSSParseException exception) throws CSSException {
                StatusManager.getManager().handle((IStatus)new Status(4, "net.sf.vex.toolkit", this.message(exception), (Throwable)exception));
            }

            public void warning(CSSParseException exception) throws CSSException {
                StatusManager.getManager().handle((IStatus)new Status(2, "net.sf.vex.toolkit", this.message(exception), (Throwable)exception));
            }
        });
        return p;
    }

    public StyleSheet read(URL url) throws IOException, CSSException {
        return this.read(new InputSource(url.toString()), url);
    }

    public StyleSheet read(String s) throws CSSException, IOException {
        CharArrayReader reader = new CharArrayReader(s.toCharArray());
        return this.read(new InputSource((Reader)reader), null);
    }

    public StyleSheet read(InputSource inputSource, URL url) throws CSSException, IOException {
        Parser parser = StyleSheetReader.createParser();
        ArrayList rules = new ArrayList();
        StyleSheetBuilder ssBuilder = new StyleSheetBuilder(this.source, rules, url);
        parser.setDocumentHandler((DocumentHandler)ssBuilder);
        parser.parseStyleSheet(inputSource);
        Rule[] ruleArray = rules.toArray(new Rule[rules.size()]);
        return new StyleSheet(ruleArray);
    }

    public byte getSource() {
        return this.source;
    }

    public void setSource(byte source) {
        this.source = source;
    }

    private static class StyleSheetBuilder
    implements DocumentHandler {
        private byte source;
        private List rules;
        private List currentRules;
        private URL url;
        SacFactory factory = new SacFactory();

        public StyleSheetBuilder(byte source, List rules, URL url) {
            this.source = source;
            this.rules = rules;
            this.url = url;
        }

        public void comment(String text) {
        }

        public void endDocument(InputSource source) {
        }

        public void endFontFace() {
        }

        public void endMedia(SACMediaList media) {
        }

        public void endPage(String name, String pseudo_page) {
        }

        public void endSelector(SelectorList selectors) {
            this.rules.addAll(this.currentRules);
            this.currentRules = null;
        }

        public void ignorableAtRule(String atRule) {
        }

        public void importStyle(String uri, SACMediaList media, String defaultNamespaceURI) {
            if (this.url == null) {
                return;
            }
            try {
                Parser parser = StyleSheetReader.createParser();
                URL importUrl = new URL(this.url, uri);
                StyleSheetBuilder ssBuilder = new StyleSheetBuilder(this.source, this.rules, importUrl);
                parser.setDocumentHandler((DocumentHandler)ssBuilder);
                parser.parseStyleSheet(new InputSource(importUrl.toString()));
            }
            catch (CSSException cSSException) {
            }
            catch (IOException iOException) {}
        }

        public void namespaceDeclaration(String prefix, String uri) {
        }

        public void property(String name, LexicalUnit value, boolean important) {
            LexicalUnit val = this.factory.cloneLexicalUnit(value);
            if (name.equalsIgnoreCase("border")) {
                this.expandBorder(val, important);
            } else if (name.equalsIgnoreCase("border-bottom")) {
                this.expandBorder(val, "border-bottom", important);
            } else if (name.equalsIgnoreCase("border-left")) {
                this.expandBorder(val, "border-left", important);
            } else if (name.equalsIgnoreCase("border-right")) {
                this.expandBorder(val, "border-right", important);
            } else if (name.equalsIgnoreCase("border-top")) {
                this.expandBorder(val, "border-top", important);
            } else if (name.equalsIgnoreCase("border-color")) {
                this.expandBorderColor(val, important);
            } else if (name.equalsIgnoreCase("border-style")) {
                this.expandBorderStyle(val, important);
            } else if (name.equalsIgnoreCase("border-width")) {
                this.expandBorderWidth(val, important);
            } else if (name.equalsIgnoreCase("font")) {
                this.expandFont(val, important);
            } else if (name.equalsIgnoreCase("margin")) {
                this.expandMargin(val, important);
            } else if (name.equalsIgnoreCase("padding")) {
                this.expandPadding(val, important);
            } else {
                this.addDecl(name, val, important);
            }
        }

        public void startDocument(InputSource source) {
        }

        public void startFontFace() {
        }

        public void startMedia(SACMediaList media) {
        }

        public void startPage(String name, String pseudo_page) {
        }

        public void startSelector(SelectorList selectors) {
            this.currentRules = new ArrayList();
            int i = 0;
            while (i < selectors.getLength()) {
                Selector selector = this.factory.cloneSelector(selectors.item(i));
                Rule rule = new Rule(this.source, selector);
                this.currentRules.add(rule);
                ++i;
            }
        }

        private void addDecl(String name, LexicalUnit value, boolean important) {
            for (Rule rule : this.currentRules) {
                rule.add(new PropertyDecl(rule, name.toLowerCase(), value, important));
            }
        }

        private void expandBorder(LexicalUnit value, boolean important) {
            this.expandBorder(value, "border-bottom", important);
            this.expandBorder(value, "border-left", important);
            this.expandBorder(value, "border-right", important);
            this.expandBorder(value, "border-top", important);
        }

        private void expandBorder(LexicalUnit value, String whichBorder, boolean important) {
            int i;
            if (AbstractProperty.isInherit(value)) {
                this.addDecl(String.valueOf(whichBorder) + "-color", value, important);
                this.addDecl(String.valueOf(whichBorder) + "-style", value, important);
                this.addDecl(String.valueOf(whichBorder) + "-width", value, important);
                return;
            }
            LexicalUnit[] lus = StyleSheetBuilder.getLexicalUnitList(value);
            if (BorderWidthProperty.isBorderWidth(lus[i = 0])) {
                this.addDecl(String.valueOf(whichBorder) + "-width", lus[i], important);
                ++i;
            }
            if (i < lus.length && BorderStyleProperty.isBorderStyle(lus[i])) {
                this.addDecl(String.valueOf(whichBorder) + "-style", lus[i], important);
                ++i;
            }
            if (i < lus.length && ColorProperty.isColor(lus[i])) {
                this.addDecl(String.valueOf(whichBorder) + "-color", lus[i], important);
                ++i;
            }
        }

        private void expandBorderColor(LexicalUnit value, boolean important) {
            if (AbstractProperty.isInherit(value)) {
                this.addDecl("border-top-color", value, important);
                this.addDecl("border-left-color", value, important);
                this.addDecl("border-right-color", value, important);
                this.addDecl("border-bottom-color", value, important);
                return;
            }
            LexicalUnit[] lus = StyleSheetBuilder.getLexicalUnitList(value);
            if (lus.length >= 4) {
                this.addDecl("border-top-color", lus[0], important);
                this.addDecl("border-right-color", lus[1], important);
                this.addDecl("border-bottom-color", lus[2], important);
                this.addDecl("border-left-color", lus[3], important);
            } else if (lus.length == 3) {
                this.addDecl("border-top-color", lus[0], important);
                this.addDecl("border-left-color", lus[1], important);
                this.addDecl("border-right-color", lus[1], important);
                this.addDecl("border-bottom-color", lus[2], important);
            } else if (lus.length == 2) {
                this.addDecl("border-top-color", lus[0], important);
                this.addDecl("border-left-color", lus[1], important);
                this.addDecl("border-right-color", lus[1], important);
                this.addDecl("border-bottom-color", lus[0], important);
            } else if (lus.length == 1) {
                this.addDecl("border-top-color", lus[0], important);
                this.addDecl("border-left-color", lus[0], important);
                this.addDecl("border-right-color", lus[0], important);
                this.addDecl("border-bottom-color", lus[0], important);
            }
        }

        private void expandBorderStyle(LexicalUnit value, boolean important) {
            if (AbstractProperty.isInherit(value)) {
                this.addDecl("border-top-style", value, important);
                this.addDecl("border-left-style", value, important);
                this.addDecl("border-right-style", value, important);
                this.addDecl("border-bottom-style", value, important);
                return;
            }
            LexicalUnit[] lus = StyleSheetBuilder.getLexicalUnitList(value);
            if (lus.length >= 4) {
                this.addDecl("border-top-style", lus[0], important);
                this.addDecl("border-right-style", lus[1], important);
                this.addDecl("border-bottom-style", lus[2], important);
                this.addDecl("border-left-style", lus[3], important);
            } else if (lus.length == 3) {
                this.addDecl("border-top-style", lus[0], important);
                this.addDecl("border-left-style", lus[1], important);
                this.addDecl("border-right-style", lus[1], important);
                this.addDecl("border-bottom-style", lus[2], important);
            } else if (lus.length == 2) {
                this.addDecl("border-top-style", lus[0], important);
                this.addDecl("border-left-style", lus[1], important);
                this.addDecl("border-right-style", lus[1], important);
                this.addDecl("border-bottom-style", lus[0], important);
            } else if (lus.length == 1) {
                this.addDecl("border-top-style", lus[0], important);
                this.addDecl("border-left-style", lus[0], important);
                this.addDecl("border-right-style", lus[0], important);
                this.addDecl("border-bottom-style", lus[0], important);
            }
        }

        private void expandBorderWidth(LexicalUnit value, boolean important) {
            if (AbstractProperty.isInherit(value)) {
                this.addDecl("border-top-width", value, important);
                this.addDecl("border-left-width", value, important);
                this.addDecl("border-right-width", value, important);
                this.addDecl("border-bottom-width", value, important);
                return;
            }
            LexicalUnit[] lus = StyleSheetBuilder.getLexicalUnitList(value);
            if (lus.length >= 4) {
                this.addDecl("border-top-width", lus[0], important);
                this.addDecl("border-right-width", lus[1], important);
                this.addDecl("border-bottom-width", lus[2], important);
                this.addDecl("border-left-width", lus[3], important);
            } else if (lus.length == 3) {
                this.addDecl("border-top-width", lus[0], important);
                this.addDecl("border-left-width", lus[1], important);
                this.addDecl("border-right-width", lus[1], important);
                this.addDecl("border-bottom-width", lus[2], important);
            } else if (lus.length == 2) {
                this.addDecl("border-top-width", lus[0], important);
                this.addDecl("border-left-width", lus[1], important);
                this.addDecl("border-right-width", lus[1], important);
                this.addDecl("border-bottom-width", lus[0], important);
            } else if (lus.length == 1) {
                this.addDecl("border-top-width", lus[0], important);
                this.addDecl("border-left-width", lus[0], important);
                this.addDecl("border-right-width", lus[0], important);
                this.addDecl("border-bottom-width", lus[0], important);
            }
        }

        private void expandFont(LexicalUnit value, boolean important) {
            if (AbstractProperty.isInherit(value)) {
                this.addDecl("font-style", value, important);
                this.addDecl("font-variant", value, important);
                this.addDecl("font-weight", value, important);
                this.addDecl("font-size", value, important);
                this.addDecl("font-family", value, important);
                return;
            }
            int i = 0;
            LexicalUnit[] lus = StyleSheetBuilder.getLexicalUnitList(value);
            int n = lus.length;
            if (i < n && FontStyleProperty.isFontStyle(lus[i])) {
                this.addDecl("font-style", lus[i], important);
                ++i;
            }
            if (i < n && FontVariantProperty.isFontVariant(lus[i])) {
                this.addDecl("font-variant", lus[i], important);
                ++i;
            }
            if (i < n && FontWeightProperty.isFontWeight(lus[i])) {
                this.addDecl("font-weight", lus[i], important);
                ++i;
            }
            if (i < n && FontSizeProperty.isFontSize(lus[i])) {
                this.addDecl("font-size", lus[i], important);
                ++i;
            }
            if (i < n && lus[i].getLexicalUnitType() == 4) {
                if (++i < n) {
                    this.addDecl("line-height", lus[i], important);
                }
                ++i;
            }
            if (i < n) {
                this.addDecl("font-family", lus[i], important);
            }
        }

        private void expandMargin(LexicalUnit value, boolean important) {
            if (AbstractProperty.isInherit(value)) {
                this.addDecl("margin-top", value, important);
                this.addDecl("margin-right", value, important);
                this.addDecl("margin-bottom", value, important);
                this.addDecl("margin-left", value, important);
                return;
            }
            LexicalUnit[] lus = StyleSheetBuilder.getLexicalUnitList(value);
            if (lus.length >= 4) {
                this.addDecl("margin-top", lus[0], important);
                this.addDecl("margin-right", lus[1], important);
                this.addDecl("margin-bottom", lus[2], important);
                this.addDecl("margin-left", lus[3], important);
            } else if (lus.length == 3) {
                this.addDecl("margin-top", lus[0], important);
                this.addDecl("margin-left", lus[1], important);
                this.addDecl("margin-right", lus[1], important);
                this.addDecl("margin-bottom", lus[2], important);
            } else if (lus.length == 2) {
                this.addDecl("margin-top", lus[0], important);
                this.addDecl("margin-left", lus[1], important);
                this.addDecl("margin-right", lus[1], important);
                this.addDecl("margin-bottom", lus[0], important);
            } else if (lus.length == 1) {
                this.addDecl("margin-top", lus[0], important);
                this.addDecl("margin-left", lus[0], important);
                this.addDecl("margin-right", lus[0], important);
                this.addDecl("margin-bottom", lus[0], important);
            }
        }

        private void expandPadding(LexicalUnit value, boolean important) {
            if (AbstractProperty.isInherit(value)) {
                this.addDecl("padding-top", value, important);
                this.addDecl("padding-left", value, important);
                this.addDecl("padding-right", value, important);
                this.addDecl("padding-bottom", value, important);
                return;
            }
            LexicalUnit[] lus = StyleSheetBuilder.getLexicalUnitList(value);
            if (lus.length >= 4) {
                this.addDecl("padding-top", lus[0], important);
                this.addDecl("padding-right", lus[1], important);
                this.addDecl("padding-bottom", lus[2], important);
                this.addDecl("padding-left", lus[3], important);
            } else if (lus.length == 3) {
                this.addDecl("padding-top", lus[0], important);
                this.addDecl("padding-left", lus[1], important);
                this.addDecl("padding-right", lus[1], important);
                this.addDecl("padding-bottom", lus[2], important);
            } else if (lus.length == 2) {
                this.addDecl("padding-top", lus[0], important);
                this.addDecl("padding-left", lus[1], important);
                this.addDecl("padding-right", lus[1], important);
                this.addDecl("padding-bottom", lus[0], important);
            } else if (lus.length == 1) {
                this.addDecl("padding-top", lus[0], important);
                this.addDecl("padding-left", lus[0], important);
                this.addDecl("padding-right", lus[0], important);
                this.addDecl("padding-bottom", lus[0], important);
            }
        }

        private static LexicalUnit[] getLexicalUnitList(LexicalUnit lu) {
            ArrayList<LexicalUnit> lus = new ArrayList<LexicalUnit>();
            while (lu != null) {
                lus.add(lu);
                lu = lu.getNextLexicalUnit();
            }
            return lus.toArray(new LexicalUnit[lus.size()]);
        }
    }
}

