/*
 * Decompiled with CFR 0.152.
 */
package net.sf.vex.css;

import net.sf.vex.css.AbstractProperty;
import net.sf.vex.css.Styles;
import org.w3c.css.sac.LexicalUnit;

public class TextDecorationProperty
extends AbstractProperty {
    public TextDecorationProperty() {
        super("text-decoration");
    }

    @Override
    public Object calculate(LexicalUnit lu, Styles parentStyles, Styles styles) {
        if (TextDecorationProperty.isTextDecoration(lu)) {
            return lu.getStringValue();
        }
        if (parentStyles != null) {
            return parentStyles.getTextDecoration();
        }
        return "none";
    }

    private static boolean isTextDecoration(LexicalUnit lu) {
        if (lu == null) {
            return false;
        }
        if (lu.getLexicalUnitType() == 35) {
            String s = lu.getStringValue();
            return s.equalsIgnoreCase("none") || s.equalsIgnoreCase("underline") || s.equalsIgnoreCase("overline") || s.equalsIgnoreCase("line-through") || s.equalsIgnoreCase("blink");
        }
        return false;
    }
}

