/*
 * Decompiled with CFR 0.152.
 */
package info.textgrid.lab.core.aggregations.ui.model;

import info.textgrid.lab.authn.RBACSession;
import info.textgrid.lab.core.aggregations.ui.AggregationsUIPlugin;
import info.textgrid.lab.core.aggregations.ui.model.ISectionListener;
import info.textgrid.lab.core.aggregations.ui.model.Messages;
import info.textgrid.lab.core.aggregations.ui.model.SectionEvent;
import info.textgrid.lab.core.aggregations.ui.model.TGOentry;
import info.textgrid.lab.core.aggregations.ui.treeWriter.AggregationWriter;
import info.textgrid.lab.core.aggregations.ui.views.AggregationComposerEditor;
import info.textgrid.lab.core.model.TGContentType;
import info.textgrid.lab.core.model.TextGridObject;
import info.textgrid.lab.core.model.TextGridProject;
import info.textgrid.namespaces.metadata.agent._2010.AgentRoleType;
import info.textgrid.namespaces.metadata.agent._2010.AgentType;
import info.textgrid.namespaces.metadata.agent._2010.PersonType;
import info.textgrid.namespaces.metadata.core._2010.EditionType;
import java.net.URI;
import java.util.ArrayList;
import java.util.UUID;
import javax.xml.stream.XMLStreamException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.ListenerList;

public class Aggregation {
    public static final TGContentType CONTENT_TYPE = TGContentType.getContentType((String)"text/tg.aggregation+xml");
    private ArrayList<Object> children;
    private Aggregation parent;
    private String uuid;
    private TextGridObject object;
    protected ListenerList listeners;
    private boolean latest = true;
    private TextGridObject revision = null;

    public Aggregation(Aggregation parent, String name, TextGridObject object, TextGridProject project) {
        this.children = new ArrayList();
        this.parent = parent;
        this.listeners = new ListenerList();
        this.object = object == null ? TextGridObject.getNewObjectInstance((TextGridProject)project, (TGContentType)CONTENT_TYPE, (String)name) : object;
        TextGridObject.addListener((TextGridObject.ITextGridObjectListener)new TextGridObject.ITextGridObjectListener(){

            public void textGridObjectChanged(TextGridObject.ITextGridObjectListener.Event event, TextGridObject object) {
                if (object == Aggregation.this.object) {
                    Aggregation.this.fireRename();
                }
            }
        });
        if (parent != null) {
            parent.addChild(this);
        }
        this.uuid = UUID.randomUUID().toString();
    }

    public Aggregation(Aggregation parent, String name, TextGridObject object, TextGridProject project, boolean test) {
        this.object = object == null ? TextGridObject.getNewObjectInstance((TextGridProject)project, (TGContentType)CONTENT_TYPE, (String)name) : object;
    }

    public void addListener(ISectionListener listener) {
        this.listeners.add((Object)listener);
    }

    public void removeListener(ISectionListener listener) {
        this.listeners.remove((Object)listener);
    }

    protected void fireAdd(Object added) {
        Object[] objectArray = this.listeners.getListeners();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object listener = objectArray[n2];
            ((ISectionListener)listener).add(new SectionEvent(added));
            ++n2;
        }
    }

    protected void fireRemove(Object removed) {
        Object[] objectArray = this.listeners.getListeners();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object listener = objectArray[n2];
            ((ISectionListener)listener).remove(new SectionEvent(removed));
            ++n2;
        }
    }

    protected void fireRename() {
        Object[] objectArray = this.listeners.getListeners();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object listener = objectArray[n2];
            ((ISectionListener)listener).rename(new SectionEvent(this));
            ++n2;
        }
    }

    public void addChild(Object child) {
        if (child == null) {
            throw new NullPointerException();
        }
        if (!(child instanceof Aggregation) && !(child instanceof TGOentry)) {
            throw new IllegalArgumentException();
        }
        this.children.add(child);
        this.fireAdd(child);
    }

    public Object[] getChildren() {
        return this.children.toArray(new Object[this.children.size()]);
    }

    public String getName() {
        try {
            return this.getObject().getTitle();
        }
        catch (CoreException e) {
            AggregationsUIPlugin.handleError(e, Messages.Aggregation_EM_CouldNotRetrieveTitle, this.object);
            return Messages.Aggregation_InvalidMetadata;
        }
    }

    public Aggregation getParent() {
        return this.parent;
    }

    public boolean hasParent(Aggregation aggregation) {
        if (this.parent == null) {
            return false;
        }
        return this.parent.equals(aggregation) || this.parent.hasParent(aggregation);
    }

    public void removeChild(Object child) {
        this.children.remove(child);
        this.fireRemove(child);
    }

    public void setParent(Aggregation newParent) {
        if (this.parent != null) {
            this.parent.removeChild(this);
        }
        this.parent = newParent;
    }

    public String toString() {
        return this.getName();
    }

    public void addBefore(Object before, Object newObject) {
        Aggregation oldParent;
        if (!(newObject instanceof Aggregation) && !(newObject instanceof TGOentry)) {
            throw new IllegalArgumentException();
        }
        if (before.equals(newObject)) {
            return;
        }
        int index = 0;
        if (newObject instanceof Aggregation) {
            if (((Aggregation)newObject).getParent() != null) {
                oldParent = ((Aggregation)newObject).getParent();
                oldParent.removeChild(newObject);
            }
            ((Aggregation)newObject).setParent(this);
        } else {
            if (((TGOentry)newObject).getParent() != null) {
                oldParent = ((TGOentry)newObject).getParent();
                oldParent.removeChild(newObject);
            }
            ((TGOentry)newObject).setParent(this);
        }
        int i = 0;
        while (i < this.children.size()) {
            if (this.children.get(i).equals(before)) {
                index = i;
            }
            ++i;
        }
        this.children.add(index, newObject);
        this.fireAdd(newObject);
    }

    public void addAfter(Object after, Object newObject) {
        Aggregation oldParent;
        if (!(newObject instanceof Aggregation) && !(newObject instanceof TGOentry)) {
            throw new IllegalArgumentException();
        }
        if (after.equals(newObject)) {
            return;
        }
        int index = 0;
        if (newObject instanceof Aggregation) {
            if (((Aggregation)newObject).getParent() != null) {
                oldParent = ((Aggregation)newObject).getParent();
                oldParent.removeChild(newObject);
            }
            ((Aggregation)newObject).setParent(this);
        } else {
            if (((TGOentry)newObject).getParent() != null) {
                oldParent = ((TGOentry)newObject).getParent();
                oldParent.removeChild(newObject);
            }
            ((TGOentry)newObject).setParent(this);
        }
        int i = 0;
        while (i < this.children.size()) {
            if (this.children.get(i).equals(after)) {
                index = i + 1;
            }
            ++i;
        }
        this.children.add(index, newObject);
        this.fireAdd(newObject);
    }

    public String getUuid() {
        return this.uuid;
    }

    public void setName(String name) {
        throw new IllegalStateException(Messages.Aggregation_EM_AggregationWithoutName);
    }

    public void delete() {
        this.parent.removeChild(this);
        this.setParent(null);
    }

    public void setObject(TextGridObject object) {
        this.object = object;
    }

    public TextGridObject getObject() {
        return this.object;
    }

    public void save(IProgressMonitor monitor, boolean saveAsRevision) throws XMLStreamException, CoreException {
        AggregationWriter.saveAggregationTree(this, saveAsRevision, null, monitor);
    }

    public void resetChildren() {
        this.children = new ArrayList();
        this.listeners = new ListenerList();
    }

    @Deprecated
    public void setObjectToEdition() {
        this.getObject().setContentType(AggregationComposerEditor.EDITION_CONTENT_TYPE);
        AgentType agent = new AgentType();
        PersonType person = RBACSession.getInstance().getPerson();
        agent.setId(person.getId());
        agent.setRole(AgentRoleType.EDITOR);
        agent.setValue(person.getValue());
        EditionType.License license = new EditionType.License();
        this.getObject().setEditionMetadata(null, agent, null, null, license);
        this.getObject().setTitle("Edition");
    }

    @Deprecated
    public void setObjectToItem() {
        this.getObject().setContentType(AggregationComposerEditor.AGGREGATION_CONTENT_TYPE);
        PersonType rightsHolder = new PersonType();
        rightsHolder.setId(RBACSession.getInstance().getEPPN());
        rightsHolder.setValue(RBACSession.getInstance().getFullName(RBACSession.getInstance().getEPPN()));
        this.getObject().setItemMetadata(rightsHolder);
        this.getObject().setTitle("Aggregation");
    }

    @Deprecated
    public void setObjectToCollection() {
        this.getObject().setContentType(AggregationComposerEditor.COLLECTION_CONTENT_TYPE);
        PersonType collector = RBACSession.getInstance().getPerson();
        this.getObject().setCollectionMetadata(collector, null, null, null, null, null);
        this.getObject().setTitle("Collection");
    }

    public void setLatest(boolean latest) {
        this.latest = latest;
    }

    public boolean getLatest() {
        return this.latest;
    }

    public TextGridObject getRevision() {
        return this.revision;
    }

    public void setRevision(TextGridObject revision) {
        this.revision = revision;
    }

    public URI getURI() {
        if (this.getLatest()) {
            return URI.create(this.getObject().getLatestURI());
        }
        if (this.getRevision() != null) {
            return this.getRevision().getURI();
        }
        return this.getObject().getURI();
    }
}

