/*
 * Decompiled with CFR 0.152.
 */
package info.textgrid.lab.core.aggregations.ui.model;

import com.google.common.collect.ImmutableSet;
import info.textgrid.lab.core.aggregations.ui.AggregationsUIPlugin;
import info.textgrid.lab.core.aggregations.ui.model.Aggregation;
import info.textgrid.lab.core.aggregations.ui.model.Messages;
import info.textgrid.lab.core.aggregations.ui.model.TGOentry;
import info.textgrid.lab.core.aggregations.ui.views.AggregationComposerEditor;
import info.textgrid.lab.core.model.RestrictedTextGridObject;
import info.textgrid.lab.core.model.TGObjectReference;
import info.textgrid.lab.core.model.TextGridObject;
import info.textgrid.lab.core.swtutils.AdapterUtils;
import java.net.URI;
import java.util.ArrayList;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.util.LocalSelectionTransfer;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerDropAdapter;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.TransferData;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class SectionTreeDropAdapter
extends ViewerDropAdapter {
    TreeViewer viewer;
    AggregationComposerEditor view;
    private String circleObj = "";
    private String operation = "";
    private ArrayList<Object> childList = new ArrayList();
    private ArrayList<URI> parentList = new ArrayList();

    public SectionTreeDropAdapter(TreeViewer viewer, AggregationComposerEditor view) {
        super((Viewer)viewer);
        this.viewer = viewer;
        this.view = view;
    }

    public boolean performDrop(Object data) {
        Boolean insertFlag = null;
        Object target = this.getCurrentTarget();
        if (target == null) {
            target = this.view.getAggregationRoot();
        }
        if (target instanceof Aggregation) {
            insertFlag = this.insert(target, data, this.getCurrentLocation());
            if (insertFlag.booleanValue()) {
                this.view.setIsChanged(true);
            }
            return insertFlag;
        }
        if (target instanceof TGOentry) {
            int location = this.getCurrentLocation();
            if (location == 3) {
                return false;
            }
            insertFlag = this.insert(target, data, location);
            if (insertFlag.booleanValue()) {
                this.view.setIsChanged(true);
            }
            return insertFlag;
        }
        return false;
    }

    private boolean insert(Object target, Object data, int location) {
        block42: {
            if (target == this.view.getAggregationRoot() && (location == 1 || location == 2)) {
                return false;
            }
            boolean moveAggregation = this.dataContainsParent(target, data);
            if (!moveAggregation) {
                MessageDialog.openError((Shell)Display.getCurrent().getActiveShell(), (String)"Drag & Drop", (String)(" Object" + Messages.SectionTreeDropAdapter_IM_NoMoveInSubAggregation));
                return false;
            }
            if (!(data instanceof IStructuredSelection)) break block42;
            IStructuredSelection selection = (IStructuredSelection)data;
            TGOentry tgoEntry = null;
            this.view.setIsBusy(true);
            for (Object temp : selection) {
                block41: {
                    TGOentry targetEntry;
                    TGOentry entry;
                    block44: {
                        block43: {
                            if (temp instanceof TGOentry) {
                                tgoEntry = (TGOentry)temp;
                                temp = ((TGOentry)temp).isRestrictedTextGridObject() ? ((TGOentry)temp).getRestrictedTgo() : ((TGOentry)temp).getTgo();
                            } else if (temp instanceof TGObjectReference) {
                                temp = AdapterUtils.getAdapter(temp, TextGridObject.class);
                            }
                            if (!(temp instanceof TextGridObject) && !(temp instanceof RestrictedTextGridObject)) break block41;
                            TextGridObject tgo = null;
                            if (temp instanceof TextGridObject) {
                                temp = new TGOentry(((TextGridObject)temp).getURI().toString());
                                tgo = ((TGOentry)temp).getTgo();
                            } else {
                                temp = new TGOentry((RestrictedTextGridObject)temp);
                            }
                            if (!(target instanceof Aggregation)) break block43;
                            Aggregation targetSection = (Aggregation)target;
                            if (targetSection == this.view.getViewerRoot()) {
                                targetSection = this.view.getAggregationRoot();
                            }
                            try {
                                if (tgo.getContentTypeID().contains("aggregation")) {
                                    Aggregation newAggregation = new Aggregation(targetSection, tgo.getTitle(), tgo, this.view.getTargetProject());
                                    this.view.importAggregation(newAggregation, tgo);
                                } else if (temp instanceof TGOentry) {
                                    entry = (TGOentry)temp;
                                    switch (location) {
                                        case 1: {
                                            targetSection.getParent().addBefore(targetSection, entry);
                                            break;
                                        }
                                        case 2: {
                                            targetSection.getParent().addAfter(targetSection, entry);
                                            break;
                                        }
                                        default: {
                                            entry.setParent(targetSection);
                                            targetSection.addChild(entry);
                                            break;
                                        }
                                    }
                                }
                                break block41;
                            }
                            catch (CoreException e) {
                                AggregationsUIPlugin.handleError(e, "SectionTreeDropAdapter Error", new Object[0]);
                            }
                            break block41;
                        }
                        if (!(target instanceof TGOentry)) break block41;
                        targetEntry = (TGOentry)target;
                        if (!(temp instanceof Aggregation)) break block44;
                        Aggregation aggregation = (Aggregation)temp;
                        if (aggregation.equals(targetEntry.getParent()) || targetEntry.getParent().hasParent(aggregation)) {
                            return false;
                        }
                        switch (location) {
                            case 1: {
                                targetEntry.getParent().addBefore(targetEntry, aggregation);
                                break block41;
                            }
                            case 2: {
                                targetEntry.getParent().addAfter(targetEntry, aggregation);
                                break block41;
                            }
                            default: {
                                return false;
                            }
                        }
                    }
                    if (temp instanceof TGOentry) {
                        entry = (TGOentry)temp;
                        switch (location) {
                            case 1: {
                                targetEntry.getParent().addBefore(targetEntry, entry);
                                break;
                            }
                            case 2: {
                                targetEntry.getParent().addAfter(targetEntry, entry);
                                break;
                            }
                            default: {
                                return false;
                            }
                        }
                    }
                }
                if (temp instanceof Aggregation) {
                    if (target instanceof Aggregation) {
                        if (location == 1) {
                            ((Aggregation)temp).setParent(((Aggregation)target).getParent());
                            ((Aggregation)target).getParent().addBefore(target, temp);
                        } else if (location == 2) {
                            ((Aggregation)temp).setParent((Aggregation)target);
                            ((Aggregation)target).addAfter(target, temp);
                        } else if (location == 3) {
                            ((Aggregation)temp).setParent((Aggregation)target);
                            ((Aggregation)target).addChild(temp);
                        }
                    } else if (target instanceof TGOentry) {
                        TGOentry targetEntry = (TGOentry)target;
                        switch (location) {
                            case 1: {
                                targetEntry.getParent().addBefore(targetEntry, temp);
                                break;
                            }
                            case 2: {
                                targetEntry.getParent().addAfter(targetEntry, temp);
                                break;
                            }
                            default: {
                                return false;
                            }
                        }
                    }
                }
                if (tgoEntry == null) continue;
                tgoEntry.delete();
                tgoEntry = null;
            }
            this.view.getViewer().refresh();
            this.view.setIsBusy(false);
            return true;
        }
        return false;
    }

    public boolean validateDrop(Object target, int op, TransferData type) {
        if (!LocalSelectionTransfer.getTransfer().isSupportedType(type)) {
            return false;
        }
        Aggregation targetAggregation = null;
        if (target instanceof Aggregation) {
            targetAggregation = (Aggregation)target;
        } else if (target instanceof TGOentry) {
            targetAggregation = ((TGOentry)target).getParent();
        }
        if (targetAggregation == null) {
            return false;
        }
        ImmutableSet.Builder forbiddenURIBuilder = ImmutableSet.builder();
        while (targetAggregation != null) {
            forbiddenURIBuilder.add((Object)targetAggregation.getURI());
            targetAggregation = targetAggregation.getParent();
        }
        ImmutableSet forbiddenURIs = forbiddenURIBuilder.build();
        ISelection selection = LocalSelectionTransfer.getTransfer().getSelection();
        if (selection instanceof IStructuredSelection) {
            IStructuredSelection sel = (IStructuredSelection)selection;
            for (Object item : sel.toList()) {
                if (!(item instanceof Aggregation) || !forbiddenURIs.contains((Object)((Aggregation)item).getURI())) continue;
                return false;
            }
        }
        return true;
    }

    public void dragOver(DropTargetEvent event) {
        super.dragOver(event);
        this.getDropTarget(event);
        event.feedback = 24;
        if (this.getCurrentLocation() == 1) {
            event.feedback |= 2;
        } else if (this.getCurrentLocation() == 2) {
            event.feedback |= 4;
        } else if (this.getCurrentLocation() == 3) {
            event.feedback |= 1;
        }
    }

    public void getDropTarget(DropTargetEvent event) {
        switch (event.detail) {
            case 2: {
                this.operation = "moved";
                break;
            }
            case 1: {
                this.operation = "copied";
                break;
            }
            default: {
                this.operation = "unknown";
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean dataContainsParent(Object target, Object data) {
        if (!(target instanceof Aggregation)) {
            return true;
        }
        if (data instanceof IStructuredSelection) {
            IStructuredSelection selection = (IStructuredSelection)data;
            this.parentList.clear();
            Aggregation parent = ((Aggregation)target).getParent();
            while (parent != null) {
                this.parentList.add(parent.getObject().getURI());
                parent = parent.getParent();
            }
            this.parentList.add(this.view.getAggregationRoot().getObject().getURI());
            for (Object temp : selection) {
                if (temp instanceof TGOentry) {
                    return true;
                }
                URI tgUri = temp instanceof TGObjectReference ? ((TGObjectReference)temp).getTgo().getURI() : ((Aggregation)temp).getObject().getURI();
                String tgObjName = "";
                TextGridObject tgo = null;
                try {
                    if (temp instanceof TGObjectReference) {
                        tgObjName = ((TGObjectReference)temp).getTgo().getNameCandidate();
                        tgo = ((TGObjectReference)temp).getTgo();
                    } else {
                        tgObjName = ((Aggregation)temp).getObject().getNameCandidate();
                    }
                }
                catch (CoreException e) {
                    AggregationsUIPlugin.handleError(e, "SectionTreeDropAdapter Error", new Object[0]);
                }
                if (target instanceof Aggregation) {
                    Aggregation targetSection = (Aggregation)target;
                    if (targetSection == this.view.getViewerRoot()) {
                        targetSection = this.view.getAggregationRoot();
                    }
                    try {
                        if (tgo.getContentTypeID().contains("aggregation")) {
                            Aggregation newAggregation = new Aggregation(targetSection, tgo.getTitle(), tgo, this.view.getTargetProject(), true);
                            this.view.resetChildList();
                            this.view.proofImportAggregation(newAggregation, tgo);
                            this.childList = this.view.getChildList();
                            this.childList.add(tgo.getURI());
                            for (URI object : this.parentList) {
                                if (!this.childList.contains(object)) continue;
                                return false;
                            }
                        }
                    }
                    catch (CoreException e) {
                        AggregationsUIPlugin.handleError(e, "SectionTreeDropAdapter Error", new Object[0]);
                    }
                    catch (Exception e) {
                        AggregationsUIPlugin.handleError(e, "SectionTreeDropAdapter Error", new Object[0]);
                    }
                }
                for (URI uri : this.parentList) {
                    if (!uri.equals(tgUri) && !this.view.getAggregationRoot().getObject().getURI().equals(tgUri) && !((Aggregation)target).getObject().getURI().equals(tgUri)) continue;
                    this.circleObj = String.valueOf(tgObjName) + " (" + tgUri + ")";
                    return false;
                }
            }
        }
        return true;
    }
}

