/*
 * Decompiled with CFR 0.152.
 */
package info.textgrid.lab.protocol.textgrid;

import info.textgrid.lab.authn.RBACSession;
import info.textgrid.lab.conf.OfflineException;
import info.textgrid.lab.conf.client.ConfClient;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import org.osgi.service.url.AbstractURLStreamHandlerService;

public class TextGridURLHandler
extends AbstractURLStreamHandlerService {
    public static final String PROTOCOL = "textgrid";

    public URLConnection openConnection(URL u) throws IOException {
        return this.openCrudConnection(u);
    }

    private URLConnection openCrudConnection(URL u) throws OfflineException, MalformedURLException, IOException {
        String crudSOAP = ConfClient.getInstance().getValue("tgcrud");
        String restURL = crudSOAP.substring(0, crudSOAP.lastIndexOf(47) + 1).concat("rest/").concat(u.toExternalForm()).concat("/data");
        String sid = RBACSession.getInstance().getSID(false);
        if (!sid.isEmpty()) {
            restURL = restURL.concat("?sessionId=").concat(sid);
        }
        URL crudURL = new URL(restURL);
        return crudURL.openConnection();
    }
}

