/*
 * Decompiled with CFR 0.152.
 */
package info.textgrid.lab.linkeditor.model.graphics;

import info.textgrid.lab.linkeditor.model.graphics.TGShape;
import org.apache.axiom.om.OMContainer;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.OMNamespace;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;

public class TGRectangle
extends TGShape {
    private Rectangle rect = null;

    public TGRectangle(String imageUri) {
        this(0, 0, 0, 0, imageUri);
    }

    public TGRectangle(int x, int y, int width, int height, String imageUri) {
        this.rect = new Rectangle(x, y, width, height);
        this.imageUri = imageUri;
    }

    public TGRectangle(Rectangle rect, String imageUri) {
        if (rect != null) {
            this.rect = new Rectangle(rect.x, rect.y, rect.width, rect.height);
        }
        this.imageUri = imageUri;
    }

    @Override
    public TGShape clone() {
        TGRectangle r = new TGRectangle(this.rect.x, this.rect.y, this.rect.width, this.rect.height, this.imageUri);
        r.setWritingMode(this.getWritingMode());
        r.setLinked(this.isLinked());
        r.setRotationValue(this.getRotationValue());
        r.setLayerValues(new Integer(this.getLayer()), this.getLayerName(), this.getLayerRGB());
        r.assocLink = this.assocLink;
        return r;
    }

    public Rectangle getRectangle() {
        return this.rect;
    }

    public Rectangle getOuterRectangle() {
        if (Math.abs(this.rotate) == 90.0 || Math.abs(this.rotate) == 270.0) {
            return this.getBoundry2();
        }
        if (this.rotate % 180.0 != 0.0) {
            return this.getBoundry();
        }
        return this.rect;
    }

    public boolean contains(Point p) {
        return this.rect.contains(p.x, p.y);
    }

    @Override
    public boolean contains(int x, int y) {
        return this.getOuterRectangle().contains(x, y);
    }

    public Rectangle getBoundry() {
        Rectangle rectNew = null;
        int max = (int)Math.sqrt(this.rect.width * this.rect.width + this.rect.height * this.rect.height);
        Point p = this.getCenter();
        int x = p.x - max / 2;
        int y = p.y - max / 2;
        rectNew = new Rectangle(x, y, max, max);
        return rectNew;
    }

    public Rectangle getBoundry2() {
        Rectangle rectNew = null;
        Point p = this.getCenter();
        int x = p.x - this.rect.height / 2;
        int y = p.y - this.rect.width / 2;
        rectNew = new Rectangle(x, y, this.rect.height, this.rect.width);
        return rectNew;
    }

    public Point getCenter() {
        Point pm = new Point(this.rect.x + this.rect.width / 2, this.rect.y + this.rect.height / 2);
        return pm;
    }

    public String toString() {
        return String.valueOf(super.hashCode()) + this.rect.toString() + " imageUri: " + this.imageUri;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof TGRectangle)) {
            return false;
        }
        TGRectangle other = (TGRectangle)obj;
        return other != null ? this.rect.equals((Object)other.rect) && this.imageUri.equals(other.imageUri) : false;
    }

    @Override
    public boolean isCompletedShape() {
        return this.rect.width != 0 && this.rect.height != 0;
    }

    @Override
    public void move(int dx, int dy) {
        this.rect.x += dx;
        this.rect.y += dy;
    }

    @Override
    public void resize(int dx, int dy, int cursor) {
        switch (cursor) {
            case 12: {
                this.rect.width += dx;
                break;
            }
            case 13: {
                this.rect.x += dx;
                this.rect.width -= dx;
                break;
            }
            case 10: {
                this.rect.y += dy;
                this.rect.height -= dy;
                break;
            }
            case 11: {
                this.rect.height += dy;
                break;
            }
            case 14: {
                this.rect.y += dy;
                this.rect.height -= dy;
                this.rect.width += dx;
                break;
            }
            case 15: {
                this.rect.width += dx;
                this.rect.height += dy;
                break;
            }
            case 17: {
                this.rect.y += dy;
                this.rect.height -= dy;
                this.rect.x += dx;
                this.rect.width -= dx;
                break;
            }
            case 16: {
                this.rect.height += dy;
                this.rect.x += dx;
                this.rect.width -= dx;
            }
        }
    }

    @Override
    public OMElement createOMElement(OMFactory factory, OMElement parent, OMNamespace ns, int imageWidth, int imageHeight) {
        OMElement rectElem = factory.createOMElement("rect", ns, (OMContainer)parent);
        double value = 0.0;
        value = (double)this.rect.x * 100.0 / (double)imageWidth;
        rectElem.addAttribute("x", String.valueOf(String.valueOf(value)) + "%", null);
        value = (double)this.rect.y * 100.0 / (double)imageHeight;
        rectElem.addAttribute("y", String.valueOf(String.valueOf(value)) + "%", null);
        value = (double)this.rect.width * 100.0 / (double)imageWidth;
        rectElem.addAttribute("width", String.valueOf(String.valueOf(value)) + "%", null);
        value = (double)this.rect.height * 100.0 / (double)imageHeight;
        rectElem.addAttribute("height", String.valueOf(String.valueOf(value)) + "%", null);
        double xPos = (double)this.rect.x * 100.0 / (double)imageWidth + (double)this.rect.width * 100.0 / (double)imageWidth / 2.0;
        double yPos = (double)this.rect.y * 100.0 / (double)imageHeight + (double)this.rect.height * 100.0 / (double)imageHeight / 2.0;
        rectElem.addAttribute("transform", "rotate(" + this.getRotationValue() + ", " + xPos + "%" + ", " + yPos + "%" + ")", null);
        return rectElem;
    }

    @Override
    public TGShape.TYPE getType() {
        return TGShape.TYPE.RECT;
    }

    public static void main(String[] args) {
        TGRectangle r = new TGRectangle(0, 6, 6, 6, "testuri");
        r.setRotationValue(45.0);
    }
}

