/*
 * Decompiled with CFR 0.152.
 */
package info.textgrid.lab.xmleditor.mpeditor;

import info.textgrid.lab.core.model.TextGridObject;
import info.textgrid.lab.core.model.util.ResourceDeltaPrinter;
import info.textgrid.lab.core.swtutils.AdapterUtils;
import info.textgrid.lab.xmleditor.mpeditor.Activator;
import info.textgrid.lab.xmleditor.mpeditor.MPXmlEditorActionBarContributor;
import info.textgrid.lab.xmleditor.mpeditor.Messages;
import info.textgrid.lab.xmleditor.mpeditor.PreviewPage;
import net.sf.vex.editor.VexEditorPage;
import net.sf.vex.swt.TextSelectionVex;
import net.sf.vex.swt.VexWidget;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IFindReplaceTarget;
import org.eclipse.jface.text.IFindReplaceTargetExtension;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.viewers.IPostSelectionProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IEditorActionBarContributor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IPerspectiveDescriptor;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartReference;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.help.IWorkbenchHelpSystem;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ui.part.MultiPageEditorPart;
import org.eclipse.ui.part.MultiPageEditorSite;
import org.eclipse.ui.part.MultiPageSelectionProvider;
import org.eclipse.ui.progress.UIJob;
import org.eclipse.ui.statushandlers.StatusManager;
import org.eclipse.ui.views.contentoutline.IContentOutlinePage;
import org.eclipse.wst.sse.core.StructuredModelManager;
import org.eclipse.wst.sse.core.internal.provisional.IModelManager;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;
import org.eclipse.wst.sse.core.internal.provisional.IndexedRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocument;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegion;
import org.eclipse.wst.sse.ui.StructuredTextEditor;
import org.eclipse.wst.sse.ui.internal.StructuredTextViewer;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMModel;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMNode;
import org.eclipse.wst.xml.ui.internal.Logger;
import org.eclipse.wst.xml.ui.internal.tabletree.AbstractXMLMultiPageEditorPart;
import org.eclipse.wst.xml.ui.internal.tabletree.XMLMultiPageEditorActionBarContributor;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.Text;
import org.w3c.dom.traversal.DocumentTraversal;
import org.w3c.dom.traversal.NodeIterator;

public class MPXmlEditorPart
extends AbstractXMLMultiPageEditorPart {
    public static final String ID = "info.textgrid.lab.xmleditor.mpeditor.MPEditorPart";
    private static final long MAX_FILE_SIZE = 0x800000L;
    private VexEditorPage wysiwymEditor;
    private int fWysiwymEditorIndex;
    private StructuredTextEditor sourceEditor;
    private IDocument document;
    private TextEditorPostSelectionAdapter fTextEditorSelectionListener;
    private ReopenResourceChangeListener reopenListener;
    private int fSourceEditorIndex;
    private int fDesignEditorIndex;
    private int fPreviewViewIndex = -1;
    private PreviewPage previewPage;

    @Override
    public Object getAdapter(Class key) {
        StructuredTextEditor sourceEditor;
        Object result = null;
        if (IContentOutlinePage.class.isAssignableFrom(key) && (sourceEditor = this.getSourceEditor()) != null) {
            result = sourceEditor.getAdapter(key);
        }
        if (result == null) {
            result = super.getAdapter(key);
        }
        return result;
    }

    private void selectInWysiwymPage(IStructuredSelection selection, boolean justCursor) {
        if (selection.isEmpty()) {
            return;
        }
        IDOMNode firstNode = (IDOMNode)AdapterUtils.getAdapter((Object)selection.getFirstElement(), IDOMNode.class);
        IDOMNode lastNode = (IDOMNode)AdapterUtils.getAdapter(selection.toList().get(Math.max(0, selection.size() - 1)), IDOMNode.class);
        if (firstNode != null && lastNode != null) {
            VexEditorPage vex = this.getWysiwymEditor();
            if (justCursor) {
                vex.gotoDOMNode(firstNode);
            } else {
                vex.selectDOMNodes(firstNode, lastNode);
            }
        }
    }

    private void selectInSourcePage(SelectionChangedEvent event, IStructuredSelection sel) {
        Object firstElement;
        Object lastElement = firstElement = sel.getFirstElement();
        if (sel.size() > 1) {
            lastElement = sel.toList().get(sel.size() - 1);
        }
        IndexedRegion firstIR = (IndexedRegion)AdapterUtils.getAdapter((Object)firstElement, IndexedRegion.class);
        IndexedRegion lastIR = (IndexedRegion)AdapterUtils.getAdapter((Object)lastElement, IndexedRegion.class);
        if (firstIR != null && lastIR != null) {
            int startOffset = firstIR.getStartOffset();
            int length = lastIR.getEndOffset() - startOffset;
            this.getSourceEditor().selectAndReveal(startOffset, length);
        } else {
            Activator.handleProblem(1, new Exception(), "Could not get IndexedRegions from selection {0} on event {1}.", sel, event);
        }
    }

    public final Region selectByID(String id) {
        IModelManager modelManager = StructuredModelManager.getModelManager();
        IDocument document = this.getDocument();
        if (document instanceof IStructuredDocument) {
            IStructuredDocument sdocument = (IStructuredDocument)document;
            IStructuredModel modelForRead = modelManager.getModelForRead(sdocument);
            try {
                IDOMModel domModel;
                Element element;
                IndexedRegion indexedRegion;
                if (modelForRead instanceof IDOMModel && (indexedRegion = (IndexedRegion)AdapterUtils.getAdapter((Object)(element = this.getElementByIdNS((Document)(domModel = (IDOMModel)modelForRead).getDocument(), id)), IndexedRegion.class)) != null) {
                    Region region = new Region(indexedRegion.getStartOffset(), indexedRegion.getEndOffset() - indexedRegion.getStartOffset());
                    this.sourceEditor.selectAndReveal(region.getOffset(), region.getLength());
                    Region region2 = region;
                    return region2;
                }
            }
            finally {
                if (modelForRead != null) {
                    modelForRead.releaseFromRead();
                }
            }
        }
        return null;
    }

    public Region selectByIDandText(String id, String text) {
        Region parentRegion = this.selectByID(id);
        if (parentRegion == null) {
            return null;
        }
        IFindReplaceTarget find = this.getSourceEditor().getTextViewer().getFindReplaceTarget();
        ((IFindReplaceTargetExtension)find).beginSession();
        try {
            ((IFindReplaceTargetExtension)find).setScope((IRegion)parentRegion);
            int findAndSelect = find.findAndSelect(0, text, true, true, false);
            if (findAndSelect >= 0) {
                Region region = new Region(findAndSelect, text.length());
                new SelectAndRevealJob(region).schedule(2000L);
                Region region2 = region;
                return region2;
            }
            return null;
        }
        finally {
            ((IFindReplaceTargetExtension)find).endSession();
        }
    }

    private Element getElementByIdNS(Document document, String id) {
        if (id == null) {
            return null;
        }
        NodeIterator it = ((DocumentTraversal)((Object)document)).createNodeIterator(document, -1, null, false);
        if (it == null) {
            return null;
        }
        Node node = it.nextNode();
        while (node != null) {
            Element element;
            if (node.getNodeType() == 1 && ((element = (Element)node).hasAttribute("id") && id.equals(element.getAttribute("id")) || element.hasAttributeNS("http://www.w3.org/XML/1998/namespace", "id") && id.equals(element.getAttributeNS("http://www.w3.org/XML/1998/namespace", "id")))) {
                return element;
            }
            node = it.nextNode();
        }
        return null;
    }

    protected void createAndAddWysiwymPage(StructuredTextEditor textEditor, IDocument document2) throws PartInitException {
        VexEditorPage vexEditor;
        this.wysiwymEditor = vexEditor = new VexEditorPage(textEditor, this.document);
        this.fWysiwymEditorIndex = this.addPage((IEditorPart)vexEditor, this.getEditorInput());
        this.setPageText(this.fWysiwymEditorIndex, Messages.MPXmlEditorPart_1);
        SelectionSyncListener listener = new SelectionSyncListener();
        this.wysiwymEditor.getEditorSite().getSelectionProvider().addSelectionChangedListener((ISelectionChangedListener)listener);
        this.getSite().getWorkbenchWindow().getSelectionService().addPostSelectionListener("org.eclipse.ui.views.ContentOutline", (ISelectionListener)new OutlineSelectionListener());
    }

    private IWorkbenchHelpSystem getHelpSystem() {
        return Activator.getDefault().getWorkbench().getHelpSystem();
    }

    public StructuredTextEditor getSourceEditor() {
        if (this.sourceEditor == null) {
            this.fetchUpstreamEditors();
        }
        return this.sourceEditor;
    }

    private void fetchUpstreamEditors() {
        int i = 0;
        while (i < this.getPageCount()) {
            IEditorPart editor = this.getEditor(i);
            if (editor instanceof StructuredTextEditor) {
                this.sourceEditor = (StructuredTextEditor)editor;
            }
            ++i;
        }
    }

    public int getWysiwymEditorIndex() {
        return this.fWysiwymEditorIndex;
    }

    @Override
    protected void createPages() {
        super.createPages();
        StructuredTextEditor textEditor = this.getSourceEditor();
        this.fSourceEditorIndex = this.getSourcePageIndex();
        this.fDesignEditorIndex = this.getDesignPageIndex();
        this.document = (IDocument)(textEditor != null ? textEditor.getAdapter(IDocument.class) : null);
        try {
            this.createAndAddWysiwymPage(textEditor, this.document);
        }
        catch (PartInitException e) {
            Activator.handleProblem(4, e, NLS.bind((String)"Could not create WYSIWYM editor page for ", (Object)this.getEditorInput()), new Object[0]);
        }
        if (Activator.getDefault().getPreferenceStore().getBoolean("previewPage")) {
            this.previewPage = new PreviewPage(this.getContainer(), 0);
            this.fPreviewViewIndex = this.addPage((Control)this.previewPage);
            this.setPageText(this.fPreviewViewIndex, Messages.MPXmlEditorPart_PreviewPageLabel);
            this.getHelpSystem().setHelp((Control)this.previewPage, "info.textgrid.lab.xmleditor.mpeditor.PreviewPage");
        }
    }

    @Override
    protected IEditorSite createSite(IEditorPart editor) {
        Object site = null;
        site = editor == this.wysiwymEditor ? new WysiwymMPESite(this, editor) : (editor instanceof StructuredTextEditor ? new MultiPageEditorSite(this, editor){

            public IEditorActionBarContributor getActionBarContributor() {
                IEditorActionBarContributor contributor = super.getActionBarContributor();
                IEditorActionBarContributor multiContributor = MPXmlEditorPart.this.getEditorSite().getActionBarContributor();
                if (multiContributor instanceof XMLMultiPageEditorActionBarContributor) {
                    contributor = ((MPXmlEditorActionBarContributor)multiContributor).getSourceViewerActionContributor();
                }
                return contributor;
            }

            public String getId() {
                return "org.eclipse.core.runtime.xml";
            }
        } : super.createSite(editor));
        return site;
    }

    @Override
    protected void pageChange(int newPageIndex) {
        try {
            if (newPageIndex == this.fWysiwymEditorIndex && this.wysiwymEditor instanceof VexEditorPage) {
                Point selection = this.getSourceEditor().getTextViewer().getSelectedRange();
                VexEditorPage vexEditorPage = this.wysiwymEditor;
                vexEditorPage.selectSourceRegion((IRegion)new Region(selection.x, selection.y));
                vexEditorPage.notifyActivate();
                this.getSite().getPage().showActionSet("net.sf.vex.editor.appearanceActions");
            } else {
                this.getSite().getPage().hideActionSet("net.sf.vex.editor.appearanceActions");
            }
            IActionBars actBar = this.getEditorSite().getActionBars();
            IToolBarManager toolbarMgr = actBar.getToolBarManager();
            if (newPageIndex == this.fWysiwymEditorIndex) {
                if (toolbarMgr.getItems().length > 0) {
                    int i = 0;
                    while (i < toolbarMgr.getItems().length) {
                        toolbarMgr.getItems()[i].setVisible(true);
                        ++i;
                    }
                }
                toolbarMgr.update(true);
            } else if (newPageIndex == this.fSourceEditorIndex) {
                if (toolbarMgr.getItems().length > 0) {
                    int i = 0;
                    while (i < toolbarMgr.getItems().length) {
                        if (toolbarMgr.getItems()[i].getId() == "Fonts") {
                            toolbarMgr.getItems()[i].setVisible(false);
                        } else if (toolbarMgr.getItems()[i].getId() == "Style") {
                            toolbarMgr.getItems()[i].setVisible(false);
                        } else if (toolbarMgr.getItems()[i].getId() == "F_Add") {
                            toolbarMgr.getItems()[i].setVisible(true);
                        } else if (toolbarMgr.getItems()[i].getId() == "F_Rem") {
                            toolbarMgr.getItems()[i].setVisible(true);
                        } else if (toolbarMgr.getItems()[i].getId() != "Fonts" && toolbarMgr.getItems()[i].getId() != "Style") {
                            toolbarMgr.getItems()[i].setVisible(true);
                        }
                        ++i;
                    }
                    toolbarMgr.update(true);
                }
            } else if (newPageIndex == this.fDesignEditorIndex) {
                if (toolbarMgr.getItems().length > 0) {
                    int i = 0;
                    while (i < toolbarMgr.getItems().length) {
                        if (toolbarMgr.getItems()[i].isVisible()) {
                            toolbarMgr.getItems()[i].setVisible(false);
                        }
                        ++i;
                    }
                    toolbarMgr.update(true);
                }
            } else if (newPageIndex == this.fPreviewViewIndex) {
                this.reloadPreview();
            }
        }
        finally {
            super.pageChange(newPageIndex);
        }
    }

    public void reloadPreview() {
        this.previewPage.setDocument(this.sourceEditor.getDocumentProvider().getDocument((Object)this.getEditorInput()));
    }

    protected void setInputWithNotify(IEditorInput input) {
        Assert.isLegal((input != null ? 1 : 0) != 0);
        this.setInput(input);
        this.firePropertyChange(258);
    }

    @Override
    protected void setInput(IEditorInput input) {
        if (input instanceof IFileEditorInput) {
            IFile file;
            TextGridObject textGridObject;
            if (Activator.isDebugging("info.textgrid.lab.xmleditor.mpeditor/debug/resource-change")) {
                TracingResourceChangeListener resourceChangeListener = new TracingResourceChangeListener();
                ResourcesPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)resourceChangeListener);
            }
            if ((textGridObject = (TextGridObject)AdapterUtils.getAdapter((Object)(file = ((IFileEditorInput)input).getFile()), TextGridObject.class)) != null && textGridObject.isNew()) {
                this.reopenListener = new ReopenResourceChangeListener(file, textGridObject);
                file.getWorkspace().addResourceChangeListener((IResourceChangeListener)this.reopenListener);
                this.checkMaxSize(null, input, textGridObject);
            }
        }
        super.setInput(input);
        this.adjustPerspective();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean checkMaxSize(IEditorSite site, IEditorInput input, TextGridObject textGridObject) {
        try {
            if (textGridObject.getSize() <= 0x800000L) return true;
            int choice = new MessageDialog(site.getShell(), NLS.bind((String)Messages.MPXmlEditorPart_OpeningX, (Object)textGridObject), null, NLS.bind((String)Messages.MPXmlEditorPart_TooLargeWarning, (Object)textGridObject), 3, new String[]{Messages.MPXmlEditorPart_Cancel, Messages.MPXmlEditorPart_OpenInTextEditor, Messages.MPXmlEditorPart_Continue}, 1).open();
            final IWorkbenchPage page = site.getPage();
            UIJob closeJob = new UIJob(Messages.MPXmlEditorPart_ClosingEditor){

                public IStatus runInUIThread(IProgressMonitor monitor) {
                    page.closeEditor((IEditorPart)MPXmlEditorPart.this, false);
                    return Status.OK_STATUS;
                }
            };
            switch (choice) {
                case -1: 
                case 0: {
                    closeJob.schedule();
                    return false;
                }
                case 1: {
                    site.getPage().openEditor((IEditorInput)new FileEditorInput((IFile)AdapterUtils.getAdapter((Object)textGridObject, IFile.class)), "org.eclipse.ui.DefaultTextEditor");
                    closeJob.schedule();
                    return false;
                }
            }
            return true;
        }
        catch (CoreException e) {
            StatusManager.getManager().handle(e, "info.textgrid.lab.xmleditor.mpeditor");
        }
        return true;
    }

    @Override
    public void init(IEditorSite site, IEditorInput input) throws PartInitException {
        TextGridObject object;
        super.init(site, input);
        if (input instanceof IFileEditorInput && (object = (TextGridObject)AdapterUtils.getAdapter((Object)((IFileEditorInput)input).getFile(), TextGridObject.class)) != null && !this.checkMaxSize(site, input, object)) {
            throw new PartInitException(Messages.MPXmlEditorPart_WillBeClosed);
        }
    }

    private void adjustPerspective() {
        IWorkbenchPage page = this.getSite().getPage();
        if (page == null) {
            return;
        }
        IPerspectiveDescriptor perspective = page.getPerspective();
        if (perspective == null) {
            return;
        }
        if ("info.textgrid.lab.welcome.XMLEditorPerspective".equals(perspective.getId())) {
            try {
                page.showView("info.textgrid.lab.core.metadataeditor.view");
            }
            catch (PartInitException e) {
                StatusManager.getManager().handle((CoreException)((Object)e), "info.textgrid.lab.xmleditor.mpeditor");
            }
        }
    }

    public VexEditorPage getWysiwymEditor() {
        return this.wysiwymEditor;
    }

    public void setActivePage(int pageIndex) {
        super.setActivePage(pageIndex);
    }

    @Override
    protected void connectDesignPage() {
        if (this.getDesignViewer() != null) {
            this.getDesignViewer().setDocument(this.getDocument());
        }
        if (this.getDesignViewer().getSelectionProvider() instanceof IPostSelectionProvider) {
            ((IPostSelectionProvider)this.getDesignViewer().getSelectionProvider()).addPostSelectionChangedListener(new ISelectionChangedListener(){

                public void selectionChanged(SelectionChangedEvent event) {
                    ((MultiPageSelectionProvider)MPXmlEditorPart.this.getSite().getSelectionProvider()).firePostSelectionChanged(event);
                }
            });
        }
        this.getDesignViewer().getSelectionProvider().addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                ((MultiPageSelectionProvider)MPXmlEditorPart.this.getSite().getSelectionProvider()).fireSelectionChanged(event);
            }
        });
        if (this.getDesignViewer().getSelectionProvider() instanceof IPostSelectionProvider) {
            ((IPostSelectionProvider)this.getDesignViewer().getSelectionProvider()).addPostSelectionChangedListener(new ISelectionChangedListener(){

                public void selectionChanged(SelectionChangedEvent event) {
                    if (MPXmlEditorPart.this.getActivePage() != MPXmlEditorPart.this.getSourcePageIndex()) {
                        MPXmlEditorPart.this.getTextEditor().getSelectionProvider().setSelection(event.getSelection());
                    }
                    if (MPXmlEditorPart.this.getDesignViewer().equals(event.getSource())) {
                        try {
                            MPXmlEditorPart.this.updateStatusLine(event.getSelection());
                        }
                        catch (Exception exception) {
                            Logger.logException((Throwable)exception);
                        }
                    }
                }
            });
        } else {
            this.getDesignViewer().getSelectionProvider().addSelectionChangedListener(new ISelectionChangedListener(){

                public void selectionChanged(SelectionChangedEvent event) {
                    if (MPXmlEditorPart.this.getActivePage() != MPXmlEditorPart.this.getSourcePageIndex()) {
                        MPXmlEditorPart.this.getTextEditor().getSelectionProvider().setSelection(event.getSelection());
                    }
                }
            });
        }
        this.getDesignViewer().getControl().addListener(8, new Listener(){

            public void handleEvent(Event event) {
                ISelection selection = MPXmlEditorPart.this.getDesignViewer().getSelectionProvider().getSelection();
                int start = -1;
                int length = -1;
                if (selection instanceof IStructuredSelection) {
                    IStructuredSelection structuredSelection = (IStructuredSelection)selection;
                    Object o = structuredSelection.getFirstElement();
                    Object o2 = null;
                    o2 = structuredSelection.size() > 1 ? structuredSelection.toArray()[structuredSelection.size() - 1] : o;
                    if (o instanceof IndexedRegion) {
                        start = ((IndexedRegion)o).getStartOffset();
                        length = ((IndexedRegion)o2).getEndOffset() - start;
                    } else if (o2 instanceof ITextRegion) {
                        start = ((ITextRegion)o).getStart();
                        length = ((ITextRegion)o2).getEnd() - start;
                    }
                } else if (selection instanceof ITextSelection) {
                    start = ((ITextSelection)selection).getOffset();
                    length = ((ITextSelection)selection).getLength();
                }
                if (start > -1 && length > -1) {
                    MPXmlEditorPart.this.getTextEditor().selectAndReveal(start, length);
                }
            }
        });
        ISelectionProvider provider = this.getTextEditor().getSelectionProvider();
        if (this.fTextEditorSelectionListener == null) {
            this.fTextEditorSelectionListener = new TextEditorPostSelectionAdapter();
        }
        if (provider instanceof IPostSelectionProvider) {
            this.fTextEditorSelectionListener.forcePostSelection = false;
            ((IPostSelectionProvider)provider).addPostSelectionChangedListener((ISelectionChangedListener)this.fTextEditorSelectionListener);
        } else {
            this.fTextEditorSelectionListener.forcePostSelection = true;
            provider.addSelectionChangedListener((ISelectionChangedListener)this.fTextEditorSelectionListener);
        }
    }

    @Override
    public void dispose() {
        super.dispose();
        if (this.reopenListener != null) {
            ResourcesPlugin.getWorkspace().removeResourceChangeListener((IResourceChangeListener)this.reopenListener);
        }
    }

    public PreviewPage getPreviewPage() {
        return this.previewPage;
    }

    private final class OutlineSelectionListener
    implements ISelectionListener {
        private OutlineSelectionListener() {
        }

        public void selectionChanged(IWorkbenchPart part, ISelection selection) {
            IWorkbenchPartReference activePartReference = MPXmlEditorPart.this.getSite().getWorkbenchWindow().getActivePage().getActivePartReference();
            if (MPXmlEditorPart.this.getActiveEditor() instanceof VexEditorPage && activePartReference != null && activePartReference.getId().equals("org.eclipse.ui.views.ContentOutline") && selection instanceof IStructuredSelection) {
                MPXmlEditorPart.this.selectInWysiwymPage((IStructuredSelection)selection, false);
            }
        }
    }

    private final class ReopenResourceChangeListener
    implements IResourceChangeListener {
        private final IFile file;
        private final TextGridObject textGridObject;

        public ReopenResourceChangeListener(IFile file, TextGridObject textGridObject) {
            this.file = file;
            this.textGridObject = textGridObject;
        }

        public void resourceChanged(IResourceChangeEvent event) {
            IResourceDelta delta = event.getDelta().findMember(this.file.getFullPath());
            if (delta != null && delta.getKind() == 2) {
                UIJob job = new UIJob(NLS.bind((String)Messages.MPXmlEditorPart_ReopeningX, (Object)this.textGridObject)){

                    public IStatus runInUIThread(IProgressMonitor monitor) {
                        IFile savedFile = (IFile)AdapterUtils.getAdapter((Object)ReopenResourceChangeListener.this.textGridObject, IFile.class);
                        if (savedFile != null) {
                            try {
                                MPXmlEditorPart.this.getSite().getPage().openEditor((IEditorInput)new FileEditorInput(savedFile), MPXmlEditorPart.ID, true);
                                return Status.OK_STATUS;
                            }
                            catch (PartInitException e) {
                                return e.getStatus();
                            }
                        }
                        return new Status(4, "info.textgrid.lab.xmleditor.mpeditor", NLS.bind((String)"Tried to open a new editor for {0}, but could not make a resource out of it.", (Object)ReopenResourceChangeListener.this.textGridObject));
                    }
                };
                ISchedulingRule rule = ResourcesPlugin.getWorkspace().getRuleFactory().refreshRule((IResource)this.file);
                job.setRule(rule);
                job.schedule(200L);
            }
        }
    }

    private class SelectAndRevealJob
    extends UIJob {
        private final Region region;

        public SelectAndRevealJob(Region region) {
            super(NLS.bind((String)"Re-revealing {0} ...", (Object)region));
            this.region = region;
        }

        public IStatus runInUIThread(IProgressMonitor monitor) {
            StructuredTextViewer viewer = MPXmlEditorPart.this.getSourceEditor().getTextViewer();
            if (viewer.getControl() == null || viewer.getControl().isDisposed()) {
                return Status.CANCEL_STATUS;
            }
            Point currentSelection = viewer.getSelectedRange();
            if (currentSelection.x == this.region.getOffset() && currentSelection.y == this.region.getLength()) {
                viewer.revealRange(this.region.getOffset(), this.region.getLength());
            } else {
                StatusManager.getManager().handle((IStatus)new Status(2, "info.textgrid.lab.xmleditor.mpeditor", NLS.bind((String)"Not re-revealing {0} since selection has changed to {1}", (Object)this.region, (Object)currentSelection)));
            }
            return Status.OK_STATUS;
        }
    }

    private final class SelectionSyncListener
    implements ISelectionChangedListener {
        private SelectionSyncListener() {
        }

        public void selectionChanged(SelectionChangedEvent event) {
            if (event.getSource() instanceof VexWidget) {
                if (event.getSelection() instanceof TextSelectionVex) {
                    TextSelectionVex sel = (TextSelectionVex)event.getSelection();
                    MPXmlEditorPart.this.getSourceEditor().selectAndReveal(sel.getSourceStartOffset(), sel.getSourceEndOffset() - sel.getSourceStartOffset());
                } else if (event.getSelection() instanceof IStructuredSelection) {
                    if (!((VexWidget)event.getSource()).hasSelection()) {
                        return;
                    }
                    IStructuredSelection sel = (IStructuredSelection)event.getSelection();
                    MPXmlEditorPart.this.selectInSourcePage(event, sel);
                }
            }
        }
    }

    private class TextEditorPostSelectionAdapter
    extends UIJob
    implements ISelectionChangedListener {
        boolean forcePostSelection;
        ISelection selection;

        public TextEditorPostSelectionAdapter() {
            super(MPXmlEditorPart.this.getTitle());
            this.forcePostSelection = false;
            this.selection = null;
            this.setUser(true);
        }

        public IStatus runInUIThread(IProgressMonitor monitor) {
            if (this.selection != null) {
                MPXmlEditorPart.this.getDesignViewer().getSelectionProvider().setSelection(this.fixSelection(this.selection));
            }
            return Status.OK_STATUS;
        }

        public void selectionChanged(SelectionChangedEvent event) {
            if (!(MPXmlEditorPart.this.getDesignViewer() == null || MPXmlEditorPart.this.getActivePage() == MPXmlEditorPart.this.getDesignPageIndex() && ((Object)((Object)MPXmlEditorPart.this)).equals(MPXmlEditorPart.this.getSite().getPage().getActivePart()))) {
                if (this.forcePostSelection) {
                    this.selection = event.getSelection();
                    this.schedule(200L);
                } else {
                    MPXmlEditorPart.this.getDesignViewer().getSelectionProvider().setSelection(this.fixSelection(event.getSelection()));
                }
            }
        }

        protected ISelection fixSelection(ISelection selection) {
            IStructuredSelection sel;
            if (selection instanceof IStructuredSelection && (sel = (IStructuredSelection)selection).getFirstElement() instanceof Text) {
                selection = new StructuredSelection((Object)((Text)sel.getFirstElement()).getParentNode());
            }
            return selection;
        }
    }

    private final class TracingResourceChangeListener
    implements IResourceChangeListener {
        private TracingResourceChangeListener() {
        }

        public void resourceChanged(IResourceChangeEvent event) {
            IResource resource = event.getResource();
            Object source = event.getSource();
            int type = event.getType();
            IResourceDelta delta = event.getDelta();
            int kind = delta.getKind();
            System.out.println(event + "\n " + "  resource: " + resource + "\n" + "  source:   " + source + "\n" + "  type: " + type + ", kind: " + kind + "\n" + "  delta:    ");
            System.out.println(ResourceDeltaPrinter.build((IResourceDelta)delta));
            new Exception("Resource changed event above triggered by: ").printStackTrace(System.out);
        }
    }

    public final class WysiwymMPESite
    extends MultiPageEditorSite {
        public WysiwymMPESite(MultiPageEditorPart multiPageEditor, IEditorPart editor) {
            super(multiPageEditor, editor);
        }

        public IEditorActionBarContributor getActionBarContributor() {
            IEditorActionBarContributor contributor = super.getActionBarContributor();
            IEditorActionBarContributor multiContributor = MPXmlEditorPart.this.getEditorSite().getActionBarContributor();
            if (multiContributor instanceof MPXmlEditorActionBarContributor) {
                contributor = ((MPXmlEditorActionBarContributor)multiContributor).getWysiwymActionBarContributor();
            }
            return contributor;
        }
    }
}

