/*
 * Decompiled with CFR 0.152.
 */
package info.textgrid.lab.linkeditor.model.links;

import info.textgrid.lab.linkeditor.model.graphics.TGPolygon;
import info.textgrid.lab.linkeditor.model.links.ILink;
import org.eclipse.jface.text.source.Annotation;

public class PolyLink
implements ILink {
    private TGPolygon poly = null;
    private String textUri = null;
    private String startAnchorId;
    private String endAnchorId;
    private boolean visible = true;
    private Annotation selectedAnnotation = null;
    private Annotation unselectedAnnotation = null;

    public PolyLink(TGPolygon poly, String startAnchorId, String endAnchorId, String textUri, boolean visible) {
        this.poly = poly;
        this.startAnchorId = startAnchorId;
        this.endAnchorId = endAnchorId;
        this.poly.setLinked(true);
        this.textUri = textUri;
        this.visible = visible;
        poly.setAssocLink(this);
    }

    public boolean equals(Object obj) {
        PolyLink other = null;
        if (!(obj instanceof PolyLink)) {
            return false;
        }
        other = (PolyLink)obj;
        return this.poly.equals(other.poly) && this.startAnchorId.equals(other.startAnchorId) && this.endAnchorId.equals(other.endAnchorId) && this.textUri.equals(other.textUri);
    }

    @Override
    public boolean equalsExceptShape(ILink link) {
        if (!(link instanceof PolyLink)) {
            return false;
        }
        PolyLink other = (PolyLink)link;
        return this.poly.getImageUri().equals(other.poly.getImageUri()) && this.startAnchorId.equals(other.startAnchorId) && this.endAnchorId.equals(other.endAnchorId) && this.textUri.equals(other.textUri);
    }

    @Override
    public String getCoords() {
        return this.poly.getPointsSequenceString();
    }

    @Override
    public String getLink() {
        return String.valueOf(this.getCoords()) + ";" + this.getTextUri() + ";" + this.getImageUri() + ";" + this.getStartAnchorId() + ";" + this.getEndAnchorId();
    }

    @Override
    public TGPolygon getShape() {
        return this.poly;
    }

    @Override
    public String getImageUri() {
        return this.poly.getImageUri();
    }

    @Override
    public String getTextUri() {
        return this.textUri;
    }

    @Override
    public void setImageUri(String uri) {
        this.poly.setImageUri(uri);
    }

    @Override
    public void setTextUri(String uri) {
        this.textUri = uri;
    }

    @Override
    public String getEndAnchorId() {
        return this.endAnchorId;
    }

    @Override
    public String getStartAnchorId() {
        return this.startAnchorId;
    }

    @Override
    public void setEndAnchorId(String endAnchorId) {
        this.endAnchorId = endAnchorId;
    }

    @Override
    public void setStartAnchorId(String startAnchorId) {
        this.startAnchorId = startAnchorId;
    }

    @Override
    public boolean isVisible() {
        return this.visible;
    }

    @Override
    public void setVisible(boolean visible) {
        this.visible = visible;
    }

    @Override
    public void setSelectedAnnotation(Annotation anno) {
        this.selectedAnnotation = anno;
    }

    @Override
    public void setUnselectedAnnotation(Annotation anno) {
        this.unselectedAnnotation = anno;
    }

    @Override
    public Annotation getSelectedAnnotation() {
        return this.selectedAnnotation;
    }

    @Override
    public Annotation getUnselectedAnnotation() {
        return this.unselectedAnnotation;
    }
}

