/*
 * Decompiled with CFR 0.152.
 */
package net.sf.vex.editor;

import java.util.ArrayList;
import net.sf.vex.css.StyleSheet;
import net.sf.vex.dom.IVexDocument;
import net.sf.vex.dom.IVexElement;
import net.sf.vex.dom.IWhitespacePolicy;
import net.sf.vex.editor.IOutlineProvider;
import net.sf.vex.editor.VexEditor;
import net.sf.vex.widget.CssWhitespacePolicy;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.Viewer;

public class DefaultOutlineProvider
implements IOutlineProvider {
    private IWhitespacePolicy whitespacePolicy;
    private ITreeContentProvider contentProvider;
    private IBaseLabelProvider labelProvider;

    @Override
    public void init(VexEditor editor) {
        StyleSheet ss = editor.getVexWidget().getStyleSheet();
        this.whitespacePolicy = new CssWhitespacePolicy(ss);
        this.contentProvider = new ContentProvider();
        this.labelProvider = new LabelProvider(){

            public String getText(Object o) {
                IVexElement e = (IVexElement)o;
                String s = e.getText();
                if (s.length() > 30) {
                    s = String.valueOf(s.substring(0, 30)) + "...";
                }
                return String.valueOf(e.getName()) + ": " + s;
            }
        };
    }

    @Override
    public ITreeContentProvider getContentProvider() {
        return this.contentProvider;
    }

    @Override
    public IBaseLabelProvider getLabelProvider() {
        return this.labelProvider;
    }

    @Override
    public IVexElement getOutlineElement(IVexElement child) {
        IVexElement element = child;
        while (element != null) {
            if (this.whitespacePolicy.isBlock(element)) {
                return element;
            }
            element = element.getParent();
        }
        return element;
    }

    private class ContentProvider
    implements ITreeContentProvider {
        private ContentProvider() {
        }

        public Object[] getChildren(Object parentElement) {
            ArrayList<IVexElement> blockChildren = new ArrayList<IVexElement>();
            IVexElement[] children = ((IVexElement)parentElement).getChildElements();
            int i = 0;
            while (i < children.length) {
                if (DefaultOutlineProvider.this.whitespacePolicy.isBlock(children[i])) {
                    blockChildren.add(children[i]);
                }
                ++i;
            }
            return blockChildren.toArray();
        }

        public Object getParent(Object element) {
            return ((IVexElement)element).getParent();
        }

        public boolean hasChildren(Object o) {
            return this.hasBlockChild((IVexElement)o);
        }

        public Object[] getElements(Object inputElement) {
            return new Object[]{((IVexDocument)inputElement).getRootElement()};
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        private boolean hasBlockChild(IVexElement element) {
            IVexElement[] children = element.getChildElements();
            int i = 0;
            while (i < children.length) {
                if (DefaultOutlineProvider.this.whitespacePolicy.isBlock(children[i])) {
                    return true;
                }
                ++i;
            }
            return false;
        }
    }
}

