/*
 * Decompiled with CFR 0.152.
 */
package net.sf.vex.editor.config;

import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URL;
import net.sf.vex.editor.config.ConfigSource;

public abstract class ConfigItem
implements Comparable,
Serializable {
    private String id;
    private String name;
    private String resourcePath;
    private ConfigSource config;

    public ConfigItem(ConfigSource config) {
        this.config = config;
    }

    public int compareTo(Object o) {
        return this.getName().compareTo(((ConfigItem)o).getName());
    }

    public String generateSimpleId() {
        String base = "id";
        int i = 1;
        while (true) {
            String id = String.valueOf(base) + i;
            if (this.getConfig().getItem(id) == null) {
                return id;
            }
            ++i;
        }
    }

    public ConfigSource getConfig() {
        return this.config;
    }

    public abstract String getExtensionPointId();

    public String getSimpleId() {
        return this.id;
    }

    public String getUniqueId() {
        return this.id == null ? null : String.valueOf(this.getConfig().getUniqueIdentifer()) + "." + this.id;
    }

    public String getName() {
        return this.name;
    }

    public String getResourcePath() {
        return this.resourcePath;
    }

    public URL getResourceUrl() throws MalformedURLException {
        if (this.resourcePath == null) {
            return null;
        }
        return new URL(this.getConfig().getBaseUrl(), this.getResourcePath());
    }

    protected boolean isBlank(String s) {
        return s == null || s.length() == 0;
    }

    public boolean isValid() {
        return !this.isBlank(this.id) && !this.isBlank(this.name);
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setResourcePath(String resourcePath) {
        this.resourcePath = resourcePath;
    }

    public void setSimpleId(String id) {
        this.id = id;
    }
}

