/*
 * Decompiled with CFR 0.152.
 */
package net.sf.vex.core;

public class IntRange {
    private int start;
    private int end;

    public IntRange(int start, int end) {
        if (start > end) {
            throw new IllegalArgumentException("start (" + start + ") is greater than end (" + end + ")");
        }
        this.start = start;
        this.end = end;
    }

    public int getStart() {
        return this.start;
    }

    public int getEnd() {
        return this.end;
    }

    public IntRange intersection(IntRange range) {
        if (this.intersects(range)) {
            return new IntRange(Math.max(this.start, range.start), Math.min(this.end, range.end));
        }
        return null;
    }

    public boolean intersects(IntRange range) {
        return this.start <= range.end && this.end >= range.start;
    }

    public boolean isEmpty() {
        return this.start == this.end;
    }

    public IntRange union(IntRange range) {
        return new IntRange(Math.min(this.start, range.start), Math.min(this.end, range.end));
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("IntRange(");
        sb.append(this.start);
        sb.append(",");
        sb.append(this.end);
        sb.append(")");
        return sb.toString();
    }
}

