/*
 * Decompiled with CFR 0.152.
 */
package net.sf.vex.layout;

import net.sf.vex.core.Insets;
import net.sf.vex.dom.IVexElement;
import net.sf.vex.layout.Box;
import net.sf.vex.layout.CompositeInlineBox;
import net.sf.vex.layout.InlineBox;
import net.sf.vex.layout.InlineElementBox;
import net.sf.vex.layout.LayoutContext;

public class LineBox
extends CompositeInlineBox {
    private IVexElement element;
    private InlineBox[] children;
    private InlineBox firstContentChild = null;
    private InlineBox lastContentChild = null;
    private int baseline;

    public LineBox(LayoutContext context, IVexElement element, InlineBox[] children) {
        this.element = element;
        this.children = children;
        int height = 0;
        int x = 0;
        this.baseline = 0;
        int i = 0;
        while (i < children.length) {
            InlineBox child = children[i];
            Insets ins = Insets.ZERO_INSETS;
            ins = child.getInsets(context, this.getWidth());
            child.setX(x);
            this.baseline = Math.max(this.baseline, child.getBaseline());
            x += child.getWidth() + ins.getRight() + ins.getLeft();
            height = Math.max(height, child.getHeight() + ins.getTop() + ins.getBottom());
            if (child.hasContent()) {
                if (this.firstContentChild == null) {
                    this.firstContentChild = child;
                }
                this.lastContentChild = child;
            }
            ++i;
        }
        i = 0;
        while (i < children.length) {
            Insets ins = Insets.ZERO_INSETS;
            if (children[i] instanceof InlineElementBox) {
                ins = children[i].getInsets(context, this.getWidth());
            }
            children[i].setY((height - children[i].getHeight() - ins.getTop() - ins.getBottom()) / 2);
            ++i;
        }
        this.setHeight(height);
        this.setWidth(x);
    }

    @Override
    public int getBaseline() {
        return this.baseline;
    }

    @Override
    public Box[] getChildren() {
        return this.children;
    }

    @Override
    public IVexElement getElement() {
        return this.element;
    }

    @Override
    public int getEndOffset() {
        return this.lastContentChild.getEndOffset();
    }

    @Override
    public int getStartOffset() {
        return this.firstContentChild.getStartOffset();
    }

    @Override
    public boolean hasContent() {
        return this.firstContentChild != null;
    }

    @Override
    public InlineBox.Pair split(LayoutContext context, InlineBox[] lefts, InlineBox[] rights) {
        LineBox left = null;
        LineBox right = null;
        if (lefts.length > 0) {
            left = new LineBox(context, this.getElement(), lefts);
        }
        if (rights.length > 0) {
            right = new LineBox(context, this.getElement(), rights);
        }
        return new InlineBox.Pair(left, right);
    }

    public String toString() {
        Box[] children = this.getChildren();
        StringBuffer sb = new StringBuffer();
        int i = 0;
        while (i < children.length) {
            sb.append(children[i]);
            ++i;
        }
        return sb.toString();
    }
}

