/*
 * Decompiled with CFR 0.152.
 */
package info.textgrid.lab.core.aggregations.ui.treeWriter;

import com.google.common.collect.Lists;
import info.textgrid.lab.core.aggregations.ui.model.Aggregation;
import info.textgrid.lab.core.aggregations.ui.model.TGOentry;
import info.textgrid.lab.core.aggregations.ui.treeWriter.Messages;
import info.textgrid.lab.core.model.TextGridObject;
import info.textgrid.lab.core.swtutils.AdapterUtils;
import info.textgrid.lab.newsearch.SearchRequest;
import info.textgrid.lab.ui.core.Activator;
import info.textgrid.namespaces.middleware.tgsearch.TextgridUris;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.util.LinkedList;
import java.util.List;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.osgi.util.NLS;
import org.eclipse.ui.statushandlers.StatusManager;

public class AggregationWriter {
    private static final String ORE_NS = "http://www.openarchives.org/ore/terms/";
    public static final String RDF_NS = "http://www.w3.org/1999/02/22-rdf-syntax-ns#";

    public static void saveAggregationTree(Aggregation root, boolean asRevision, List<URI> knownParents, IProgressMonitor monitor) throws CoreException, XMLStreamException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)(100 + 100 * root.getChildren().length + 100));
        if (knownParents == null) {
            if (root.getObject().isNew()) {
                knownParents = Lists.newArrayList();
            } else {
                TextgridUris parents = new SearchRequest(SearchRequest.EndPoint.STANDARD).getSearchClient().getParents(root.getObject().getLatestURI());
                List textgridUri = parents.getTextgridUri();
                knownParents = Lists.newArrayListWithExpectedSize((int)(textgridUri.size() + 4));
                for (String uri : textgridUri) {
                    knownParents.add(URI.create(uri.split("\\.")[0]));
                }
            }
        }
        knownParents.add(URI.create(root.getObject().getLatestURI()));
        progress.worked(100);
        if (progress.isCanceled()) {
            return;
        }
        LinkedList aggregationURIs = Lists.newLinkedList();
        Object[] objectArray = root.getChildren();
        int n = objectArray.length;
        int uri = 0;
        while (uri < n) {
            Object child = objectArray[uri];
            if (child instanceof Aggregation) {
                Aggregation childAggregation = (Aggregation)child;
                TextGridObject childObject = childAggregation.getObject();
                if (knownParents.contains(childAggregation.getObject().getLatestURI())) {
                    StatusManager.getManager().handle((IStatus)new Status(2, "info.textgrid.lab.ui.core", NLS.bind((String)"{0} cannot be included in {1} since it is already one of its ancestors. Skipping.", (Object)childObject, (Object)root.getObject())), 2);
                    progress.worked(10);
                } else {
                    if (!childObject.isPublic() || childObject.hasPermissions(4) || asRevision && childObject.getProjectInstance().hasPermissions(2)) {
                        AggregationWriter.saveAggregationTree(childAggregation, asRevision, knownParents, (IProgressMonitor)progress.newChild(100));
                    } else {
                        progress.worked(100);
                    }
                    if (progress.isCanceled()) {
                        return;
                    }
                    if (childObject.isNew()) {
                        long timeout = System.currentTimeMillis() + 10000L;
                        while (childObject.isNew()) {
                            if (System.currentTimeMillis() > timeout) {
                                throw new CoreException((IStatus)new Status(4, "info.textgrid.lab.core.aggregations.ui", NLS.bind((String)Messages.AggregationWriter_EM_NoURI, (Object)childAggregation.getObject().getTitle())));
                            }
                            try {
                                Thread.sleep(250L);
                            }
                            catch (InterruptedException interruptedException) {}
                            if (!progress.isCanceled()) continue;
                            return;
                        }
                    }
                    aggregationURIs.add(childAggregation.getURI());
                }
            } else if (child instanceof TGOentry) {
                aggregationURIs.add(((TGOentry)child).getURI());
                progress.worked(100);
            } else if (child instanceof TextGridObject) {
                aggregationURIs.add(((TextGridObject)child).getURI());
                progress.worked(100);
            } else {
                Activator.handleError(null, (String)Messages.AggregationWriter_EM_StrangeObject, (Object[])new Object[]{root, child});
            }
            ++uri;
        }
        TextGridObject rootObject = root.getObject();
        progress.setTaskName(NLS.bind((String)"Saving {0}", (Object)rootObject));
        if (asRevision) {
            rootObject.prepareNewRevision((IProgressMonitor)progress.newChild(10));
        } else {
            progress.worked(10);
        }
        IFile rootFile = (IFile)AdapterUtils.getAdapter((Object)rootObject, IFile.class);
        rootFile.setContents(AggregationWriter.getAggregationStream(aggregationURIs), true, false, (IProgressMonitor)progress.newChild(90));
        knownParents.remove(knownParents.size() - 1);
    }

    public static InputStream getAggregationStream(List<URI> aggregationURIs) throws XMLStreamException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        AggregationWriter.writeAggregation(aggregationURIs, baos);
        return new ByteArrayInputStream(baos.toByteArray());
    }

    public static void writeAggregation(List<URI> uris, OutputStream output) throws XMLStreamException {
        XMLOutputFactory outputFactory = XMLOutputFactory.newInstance();
        XMLStreamWriter writer = outputFactory.createXMLStreamWriter(output);
        writer.writeStartDocument();
        writer.setPrefix("rdf", RDF_NS);
        writer.writeStartElement(RDF_NS, "RDF");
        writer.writeNamespace("rdf", RDF_NS);
        writer.writeNamespace("ore", ORE_NS);
        writer.writeStartElement(RDF_NS, "Description");
        for (URI uri : uris) {
            writer.writeEmptyElement(ORE_NS, "aggregates");
            writer.writeAttribute("rdf:resource", uri.toString());
        }
        writer.writeEndElement();
        writer.writeEndElement();
        writer.writeEndDocument();
        writer.flush();
        writer.close();
    }
}

