/*
 * Decompiled with CFR 0.152.
 */
package info.textgrid.lab.core.importexport.model;

import com.google.common.base.Optional;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import info.textgrid._import.ImportObject;
import info.textgrid._import.RewriteMethod;
import info.textgrid.lab.core.importexport.model.ISpecialImportEntrySupplier;
import info.textgrid.lab.core.importexport.model.ImportModel;
import info.textgrid.lab.core.importexport.model.Messages;
import info.textgrid.lab.core.importexport.model.RewriteSetup;
import info.textgrid.lab.core.model.CrudServiceException;
import info.textgrid.lab.core.model.TGContentType;
import info.textgrid.lab.core.model.TGObjectReference;
import info.textgrid.lab.core.model.TextGridObject;
import info.textgrid.lab.core.model.TextGridProject;
import info.textgrid.namespaces.metadata.core._2010.ObjectType;
import info.textgrid.utils.export.aggregations.IAggregation;
import info.textgrid.utils.export.aggregations.IAggregationEntry;
import java.io.File;
import java.net.URI;
import java.util.List;
import org.apache.commons.io.FilenameUtils;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.osgi.util.NLS;
import org.eclipse.ui.statushandlers.StatusManager;

public class ImportEntry
extends ImportObject
implements IAggregationEntry,
IAggregation {
    private TGObjectReference objectRef;
    private File file;
    private File metadataFile;
    private final List<ImportEntry> children = Lists.newArrayList();
    private ImportModel model;
    private RewriteSetup rewriteSetup;
    private ISpecialImportEntrySupplier supplier;
    private URI existingURI;
    private String existingProjectID;
    private Optional<ImportEntry> parent = Optional.absent();
    private boolean isInitialized = false;

    public String getTextgridUri() {
        if (this.getObjectRef() == null && super.getTextgridUri() != null) {
            this.setObjectRef(new TGObjectReference(super.getTextgridUri(), TextGridObject.getInstanceOffline((URI)URI.create(super.getTextgridUri()))));
        }
        if (this.getObjectRef() == null) {
            return null;
        }
        if (this.getObjectRef().getRefUri().startsWith("textgrid".concat(":"))) {
            return this.getObjectRef().getRefUri();
        }
        if (this.getObject().getPreparedURI() != null) {
            return this.getObject().getPreparedURI().toString();
        }
        return this.getObject().getURI().toString();
    }

    public ImportEntry() {
    }

    ImportEntry(File file, TextGridProject targetProject, ISpecialImportEntrySupplier supplier, ImportModel importModel, IProgressMonitor monitor) {
        this();
        IProgressMonitor progress = monitor;
        this.setModel(importModel);
        this.setLocalData(file.getPath());
        this.setSupplier(supplier);
        TGContentType contentType = TGContentType.getByFilename((String)file.getPath());
        if (contentType == null) {
            contentType = TGContentType.getContentType((String)"unknown/unknown");
        }
        TextGridObject textGridObject = TextGridObject.getNewObjectInstance((TextGridProject)targetProject, (TGContentType)contentType);
        progress.worked(20);
        if (file.isDirectory()) {
            textGridObject.setContentType(TGContentType.getContentType((String)"text/tg.aggregation+xml"));
            this.setRewriteSetup(RewriteSetup.of(RewriteMethod.XML, "internal:textgrid#aggregation"));
        }
        String name = file.getName();
        String title = contentType.isUnknown() ? name : FilenameUtils.removeExtension((String)name);
        if ("".equals(title)) {
            title = name;
        }
        textGridObject.setTitle(title);
        this.setLocalData(file.getPath());
        this.setTextgridUri(textGridObject.getURI().toString());
        File metaFile = new File(file.getPath().concat(".meta"));
        this.tryReadMetafile(metaFile, progress, false);
        this.isInitialized = true;
        progress.worked(10);
    }

    private void tryReadMetafile(File metaFile, IProgressMonitor progress, boolean forceNewObject) {
        TextGridObject textGridObject = this.getObject();
        if (metaFile.exists()) {
            ObjectType metadata = ImportModel.readMetadata(metaFile);
            progress.worked(10);
            if (metadata != null && metadata.getGeneric() != null && metadata.getGeneric().getProvided() != null && metadata.getGeneric().getProvided().getFormat() != null) {
                try {
                    this.setExistingURI(URI.create(metadata.getGeneric().getGenerated().getTextgridUri().getValue()));
                    this.setExistingProjectID(metadata.getGeneric().getGenerated().getProject().getId());
                    if (forceNewObject) {
                        textGridObject = TextGridObject.getNewObjectInstance((String)this.existingProjectID, (String)metadata.getGeneric().getProvided().getFormat());
                        this.setObjectRef(new TGObjectReference(textGridObject.getURI().toString(), textGridObject));
                    }
                }
                catch (NullPointerException nullPointerException) {}
                textGridObject.setMetadata(ImportModel.clearGenerated(metadata));
                this.setLocalMetadata(metaFile.getPath());
            } else {
                StatusManager.getManager().handle((IStatus)new Status(2, "info.textgrid.lab.core.importexport", NLS.bind((String)Messages.ImportModel_Could_not_read_meta, (Object)metaFile.getName())), 3);
            }
        }
    }

    public TextGridObject getObject() {
        TGObjectReference ref = this.getObjectRef();
        if (ref == null) {
            return null;
        }
        return ref.getTgo();
    }

    public void setTextgridUri(String value) {
        URI uri = URI.create(value);
        if (uri != null) {
            this.setObjectRef(new TGObjectReference(value, TextGridObject.getInstanceOffline((URI)uri)));
        }
    }

    public String getLocalData() {
        if (this.getFile() == null) {
            if (super.getLocalData() == null) {
                return null;
            }
            this.setLocalData(super.getLocalData());
        }
        if (this.getModel() != null && this.getModel().getRoot() != null && this.getFile().isAbsolute()) {
            return new Path(this.getFile().getPath()).makeRelativeTo(this.getModel().getRoot()).toPortableString();
        }
        return new Path(this.getFile().getPath()).toPortableString();
    }

    public void setLocalData(String value) {
        if (this.getModel() != null && this.getModel().getRoot() != null && !new File(value).isAbsolute()) {
            this.setFile(new File(this.getModel().getRoot().toFile(), value));
        } else {
            this.setFile(new File(value));
        }
    }

    protected void adjustFile(Optional<IPath> oldRoot) {
        if (this.getModel() != null && this.getModel().getRoot() != null) {
            Object relativePath = this.getFile().isAbsolute() && oldRoot.isPresent() ? new Path(this.getFile().getPath()).makeRelativeTo((IPath)oldRoot.get()) : new Path(this.getFile().getPath());
            this.setFile(this.getModel().getRoot().append((IPath)relativePath).toFile());
        }
    }

    public void setObjectRef(TGObjectReference object) {
        this.objectRef = object;
        super.setTextgridUri(object.getRefUri());
    }

    public TGObjectReference getObjectRef() {
        return this.objectRef;
    }

    public void addChild(ImportEntry importEntry) {
        this.children.add(importEntry);
        importEntry.parent = Optional.of((Object)((Object)this));
    }

    public boolean mayHaveChildren() {
        return true;
    }

    public List<ImportEntry> getChildEntries() {
        return this.children;
    }

    void setModel(ImportModel model) {
        this.model = model;
    }

    public ImportModel getModel() {
        return this.model;
    }

    public ImportEntry addFile(File file, IProgressMonitor monitor, ISpecialImportEntrySupplier supplier) {
        if (this.model == null) {
            throw new IllegalStateException("Cannot add files before associating a model.");
        }
        ImportEntry entry = this.model.addFile(file, false, monitor, supplier);
        this.addChild(entry);
        return entry;
    }

    public ImportEntry addObject(TGObjectReference textGridObject, File parent, IProgressMonitor monitor) {
        if (this.model == null) {
            throw new IllegalStateException("Cannot add files before associating a model.");
        }
        ImportEntry entry = this.model.addObject(textGridObject, false, parent, monitor);
        this.addChild(entry);
        return entry;
    }

    public RewriteSetup getRewriteSetup() {
        if (this.rewriteSetup == null || this.rewriteSetup.getMethod() != this.getRewriteMethod() || this.getRewriteConfig() != null && !this.rewriteSetup.getUri().equals(URI.create(this.getRewriteConfig()))) {
            this.rewriteSetup = RewriteSetup.of(this.getRewriteMethod(), this.getRewriteConfig());
            if (this.rewriteSetup == null) {
                this.rewriteSetup = new RewriteSetup(this.getModel(), URI.create(this.getRewriteConfig()));
            }
        }
        return this.rewriteSetup;
    }

    public void setRewriteSetup(RewriteSetup setup) {
        this.rewriteSetup = setup;
        this.setRewriteMethod(setup.getMethod());
        if (setup.getUri() == null) {
            this.setRewriteConfig(null);
        } else {
            this.setRewriteConfig(setup.getUri().toString());
        }
    }

    public File getLocalFile() {
        return this.getFile();
    }

    void setFile(File file) {
        this.file = file;
        super.setLocalData(this.getLocalData());
    }

    File getFile() {
        return this.file;
    }

    public File getLocalMetadataFile() {
        if (this.metadataFile == null) {
            File localMD;
            String md = this.getLocalMetadata();
            this.metadataFile = md == null ? new File(this.getLocalFile().getPath().concat(".meta")) : (!(localMD = new File(md)).isAbsolute() && this.getModel() != null && this.getModel().getRoot() != null ? this.getModel().getRoot().append(md).toFile() : localMD);
        }
        return this.metadataFile;
    }

    public void setLocalMetadata(String value) {
        this.metadataFile = null;
        super.setLocalMetadata(value);
    }

    public void setOriginalURI(URI uri) {
    }

    public void setSupplier(ISpecialImportEntrySupplier supplier) {
        this.supplier = supplier;
    }

    public ImportEntry addFile(File child, IProgressMonitor monitor) {
        return this.addFile(child, monitor, null);
    }

    public ISpecialImportEntrySupplier getSupplier() {
        return this.supplier;
    }

    public String toString() {
        return String.format("ImportEntry [TextGrid URI = %s, Local Data = %s, Rewrite Setup = %s]", this.getTextgridUri(), this.getLocalData(), this.getRewriteSetup());
    }

    protected void sanitize() {
        if (this.file == null && this.localData != null) {
            this.setLocalData(this.localData);
        } else if (this.file != null) {
            this.localData = this.getLocalData();
        }
        if (this.objectRef == null && this.textgridUri != null) {
            this.setTextgridUri(this.textgridUri);
        } else if (this.objectRef != null && this.textgridUri == null) {
            this.textgridUri = this.getTextgridUri();
        }
    }

    private void setExistingURI(URI existingURI) {
        this.existingURI = existingURI;
    }

    private URI getExistingURI() {
        return this.existingURI;
    }

    public TextGridObject getExistingObject() {
        if (this.isReimport()) {
            return TextGridObject.getInstanceOffline((URI)this.getExistingURI());
        }
        return null;
    }

    public boolean isReimport() {
        return this.existingURI != null;
    }

    public boolean isNewRevisionImport() {
        return this.isReimport() && this.model.importAsNewRevision() && this.model.getTargetProject().getId().equals(this.getExistingProjectID());
    }

    private void setExistingProjectID(String existingProjectID) {
        this.existingProjectID = existingProjectID;
    }

    String getExistingProjectID() {
        return this.existingProjectID;
    }

    protected void initializeLoadedEntryForImport(IProgressMonitor monitor) {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)10);
        if (!this.isInitialized) {
            this.tryReadMetafile(this.getLocalMetadataFile(), (IProgressMonitor)progress.newChild(10), true);
            this.isInitialized = true;
        } else {
            progress.worked(10);
        }
        progress.done();
    }

    public ImmutableList<? extends IAggregationEntry> getChildren() {
        return ImmutableList.copyOf(this.getChildEntries());
    }

    public ObjectType getMetadata() {
        try {
            return this.getObject().getMetadataForReading();
        }
        catch (CrudServiceException e) {
            throw new IllegalStateException(e);
        }
    }

    public Optional<? extends IAggregation> getParent() {
        return this.parent;
    }

    public URI getTextGridURI() {
        return URI.create(this.getTextgridUri());
    }

    public Optional<? extends IAggregationEntry> getWork() {
        return Optional.absent();
    }
}

