/*
 * Decompiled with CFR 0.152.
 */
package info.textgrid.lab.ui.core.locking;

import info.textgrid.lab.core.model.TextGridObject;
import info.textgrid.lab.core.swtutils.AdapterUtils;
import info.textgrid.lab.ui.core.locking.LockingService;
import java.text.MessageFormat;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IPartListener2;
import org.eclipse.ui.IWorkbenchPartReference;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.statushandlers.StatusManager;

public class LockingPartListener
implements IPartListener2 {
    TextGridObject object;

    public LockingPartListener(TextGridObject object) {
        this.object = object;
    }

    public void partActivated(IWorkbenchPartReference partRef) {
    }

    public void partBroughtToTop(IWorkbenchPartReference partRef) {
    }

    public void partClosed(IWorkbenchPartReference partRef) {
        if (partRef instanceof IEditorReference) {
            try {
                IEditorInput editorInput = ((IEditorReference)partRef).getEditorInput();
                TextGridObject editedObject = (TextGridObject)AdapterUtils.getAdapter((Object)editorInput, TextGridObject.class);
                if (editedObject.equals(this.object)) {
                    this.doUnlockObject(partRef);
                } else {
                    StatusManager.getManager().handle((IStatus)new Status(1, "info.textgrid.lab.ui.core", MessageFormat.format("Watchdog for {2} ignores that part {0} ({1}) has been closed", partRef.getPartName(), partRef.getId(), this.object)));
                }
            }
            catch (PartInitException e) {
                StatusManager.getManager().handle((CoreException)((Object)e), "info.textgrid.lab.ui.core");
            }
        }
    }

    private void doUnlockObject(IWorkbenchPartReference partRef) {
        StatusManager.getManager().handle((IStatus)new Status(1, "info.textgrid.lab.ui.core", MessageFormat.format("Part {0} ({1}) closed: Object {2} will be unlocked, says {3}", partRef.getPartName(), partRef.getId(), this.object, this)));
        LockingService.getInstance().unlockObject(this.object);
        this.object.setOpenAsReadOnly(false);
    }

    public void partDeactivated(IWorkbenchPartReference partRef) {
    }

    public void partOpened(IWorkbenchPartReference partRef) {
    }

    public void partHidden(IWorkbenchPartReference partRef) {
    }

    public void partVisible(IWorkbenchPartReference partRef) {
    }

    public void partInputChanged(IWorkbenchPartReference partRef) {
    }
}

