/*
 * Decompiled with CFR 0.152.
 */
package net.sf.vex.css;

import java.util.HashMap;
import java.util.Map;
import net.sf.vex.core.Color;
import net.sf.vex.core.Log;
import net.sf.vex.css.AbstractProperty;
import net.sf.vex.css.Styles;
import org.w3c.css.sac.LexicalUnit;

public class ColorProperty
extends AbstractProperty {
    private static Map colorNames = new HashMap();

    static {
        colorNames.put("aqua", new Color(0, 255, 255));
        colorNames.put("black", new Color(0, 0, 0));
        colorNames.put("blue", new Color(0, 0, 255));
        colorNames.put("fuchsia", new Color(255, 0, 255));
        colorNames.put("gray", new Color(128, 128, 128));
        colorNames.put("green", new Color(0, 128, 0));
        colorNames.put("lime", new Color(0, 255, 0));
        colorNames.put("maroon", new Color(128, 0, 0));
        colorNames.put("navy", new Color(0, 0, 128));
        colorNames.put("olive", new Color(128, 128, 0));
        colorNames.put("orange", new Color(255, 165, 0));
        colorNames.put("purple", new Color(128, 0, 128));
        colorNames.put("red", new Color(255, 0, 0));
        colorNames.put("silver", new Color(192, 192, 192));
        colorNames.put("teal", new Color(0, 128, 128));
        colorNames.put("white", new Color(255, 255, 255));
        colorNames.put("yellow", new Color(255, 255, 0));
    }

    public ColorProperty(String name) {
        super(name);
    }

    @Override
    public Object calculate(LexicalUnit lu, Styles parentStyles, Styles styles) {
        boolean inherit;
        boolean bl = inherit = ColorProperty.isInherit(lu) || this.getName().equalsIgnoreCase("color");
        if (ColorProperty.isColor(lu)) {
            return ColorProperty.getColor(lu);
        }
        if (inherit && parentStyles != null) {
            return parentStyles.get(this.getName());
        }
        if (this.getName().equalsIgnoreCase("color")) {
            return Color.BLACK;
        }
        if (this.getName().equalsIgnoreCase("background-color")) {
            return null;
        }
        return styles.getColor();
    }

    public static boolean isColor(LexicalUnit lu) {
        if (lu == null) {
            return false;
        }
        if (lu.getLexicalUnitType() == 35 && colorNames.containsKey(lu.getStringValue().toLowerCase())) {
            return true;
        }
        return lu.getLexicalUnitType() == 27;
    }

    private static Color getColor(LexicalUnit lu) {
        if (lu.getLexicalUnitType() == 35) {
            String s = lu.getStringValue();
            if (colorNames.containsKey(s.toLowerCase())) {
                return (Color)colorNames.get(s.toLowerCase());
            }
            return null;
        }
        if (lu.getLexicalUnitType() == 27) {
            lu = lu.getParameters();
            int red = ColorProperty.getColorPart(lu);
            lu = lu.getNextLexicalUnit();
            lu = lu.getNextLexicalUnit();
            int green = ColorProperty.getColorPart(lu);
            lu = lu.getNextLexicalUnit();
            lu = lu.getNextLexicalUnit();
            int blue = ColorProperty.getColorPart(lu);
            if (red == -1 || green == -1 || blue == -1) {
                return null;
            }
            return new Color(red, green, blue);
        }
        Log.logWarning("WARNING: unsupported color type: " + lu);
        return null;
    }

    private static int getColorPart(LexicalUnit lu) {
        int value;
        if (lu.getLexicalUnitType() == 13) {
            value = lu.getIntegerValue();
        } else if (lu.getLexicalUnitType() == 23) {
            value = Math.round(lu.getFloatValue() * 255.0f);
        } else {
            Log.logWarning("WARNING: unsupported color part " + lu);
            return -1;
        }
        return Math.max(0, Math.min(255, value));
    }
}

