/*
 * Decompiled with CFR 0.152.
 */
package info.textgrid.lab.xmleditor.dialogs;

import info.textgrid.lab.core.model.TextGridObject;
import info.textgrid.lab.core.swtutils.AdapterUtils;
import info.textgrid.lab.ui.core.utils.TextGridObjectTableViewer;
import info.textgrid.lab.xmleditor.dialogs.Messages;
import info.textgrid.lab.xmleditor.mpeditor.MPXmlEditorPart;
import java.net.URI;
import java.net.URISyntaxException;
import net.sf.vex.editor.VexEditorPage;
import net.sf.vex.editor.action.ShowInlineElementMarkersAction;
import net.sf.vex.widget.IVexWidget;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.progress.UIJob;
import org.eclipse.wst.sse.core.StructuredModelManager;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocument;
import org.eclipse.wst.sse.ui.StructuredTextEditor;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMDocument;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMModel;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.ProcessingInstruction;

public class AssociateStylesheetDialog
extends TitleAreaDialog {
    private Table table;
    private Button defaultButton;
    private TextGridObjectTableViewer viewer;
    private StructuredTextEditor sourceEditor;
    private VexEditorPage vexEditor;
    private TextGridObject currentStylesheet;
    private IEditorPart editor;
    private VexEditorPage.StylesheetInfo stylesheetInfo;

    public AssociateStylesheetDialog(Shell parentShell, IEditorPart editor) {
        super(parentShell);
        this.editor = editor;
    }

    protected Control createDialogArea(Composite parent) {
        this.findActiveStylesheet();
        this.setMessage(Messages.AssociateStylesheetDialog_SelectStylesheetMessage);
        this.setTitle(Messages.AssociateStylesheetDialog_DialogTitle);
        Composite area = (Composite)super.createDialogArea(parent);
        Composite container = new Composite(area, 0);
        container.setLayout((Layout)new GridLayout(1, false));
        container.setLayoutData((Object)new GridData(1808));
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, "info.textgrid.lab.xmleditor.mpeditor.SetCSSDialog");
        this.viewer = new TextGridObjectTableViewer(container, 0);
        this.table = this.viewer.getTable();
        GridData gd_table = new GridData(4, 4, true, true, 1, 1);
        gd_table.minimumHeight = 200;
        this.table.setLayoutData((Object)gd_table);
        this.viewer.queryMetadata("format:\"text/css\"");
        this.defaultButton = new Button(container, 16);
        this.defaultButton.setText(Messages.AssociateStylesheetDialog_DefaultStylesheetBtn);
        SingleSelectionAdapter singleSelectionAdapter = new SingleSelectionAdapter();
        this.defaultButton.addSelectionListener((SelectionListener)singleSelectionAdapter);
        this.table.addSelectionListener((SelectionListener)singleSelectionAdapter);
        this.defaultButton.setSelection(true);
        if (this.currentStylesheet != null) {
            this.viewer.setDefaultSelection(new TextGridObject[]{this.currentStylesheet});
        }
        return area;
    }

    protected void findActiveStylesheet() {
        block8: {
            if (this.editor == null) {
                this.editor = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActiveEditor();
            }
            if (this.editor instanceof MPXmlEditorPart) {
                MPXmlEditorPart xmlEditor = (MPXmlEditorPart)this.editor;
                this.sourceEditor = xmlEditor.getSourceEditor();
                this.vexEditor = xmlEditor.getWysiwymEditor();
                IDocument document = this.sourceEditor.getDocumentProvider().getDocument((Object)this.sourceEditor.getEditorInput());
                IDOMModel model = (IDOMModel)StructuredModelManager.getModelManager().getModelForRead((IStructuredDocument)document);
                try {
                    try {
                        this.stylesheetInfo = VexEditorPage.findActiveStylesheet((IDOMModel)model);
                        if (this.stylesheetInfo == null) break block8;
                        if (!"textgrid".equals(this.stylesheetInfo.stylesheetURI.getScheme())) {
                            this.setErrorMessage(NLS.bind((String)Messages.AssociateStylesheetDialog_ErrorTextGridURIsOnly, (Object)this.stylesheetInfo.stylesheetURI));
                            break block8;
                        }
                        this.currentStylesheet = TextGridObject.getInstanceOffline((URI)this.stylesheetInfo.stylesheetURI);
                    }
                    catch (URISyntaxException uRISyntaxException) {
                        this.setErrorMessage(Messages.AssociateStylesheetDialog_InvalidXMLStylesheet);
                        model.releaseFromRead();
                    }
                }
                finally {
                    model.releaseFromRead();
                }
            }
        }
    }

    protected void okPressed() {
        boolean useDefault = this.defaultButton.getSelection();
        TextGridObject newStylesheet = useDefault ? null : (TextGridObject)AdapterUtils.getAdapter((Object)((IStructuredSelection)this.viewer.getSelection()).getFirstElement(), TextGridObject.class);
        IDocument document = this.sourceEditor.getDocumentProvider().getDocument((Object)this.sourceEditor.getEditorInput());
        IDOMModel model = (IDOMModel)StructuredModelManager.getModelManager().getModelForEdit((IStructuredDocument)document);
        try {
            IDOMDocument domDocument = model.getDocument();
            if (this.stylesheetInfo != null && this.stylesheetInfo.stylesheetNode != null) {
                NodeList childNodes = domDocument.getChildNodes();
                int i = 0;
                while (i < childNodes.getLength()) {
                    Node node = childNodes.item(i);
                    if (node.equals(this.stylesheetInfo.stylesheetNode)) {
                        if (useDefault) {
                            domDocument.removeChild(node);
                        } else {
                            ((ProcessingInstruction)node).setData("type=\"text/css\" href=\"" + newStylesheet.getLatestURI() + "\"");
                        }
                    }
                    ++i;
                }
            } else if (!useDefault) {
                ProcessingInstruction pi = domDocument.createProcessingInstruction("xml-stylesheet", "type=\"text/css\" href=\"" + newStylesheet.getLatestURI() + "\"");
                domDocument.insertBefore(pi, domDocument.getDocumentElement());
            }
        }
        finally {
            model.releaseFromEdit();
        }
        if (this.vexEditor != null && this.vexEditor.getVexWidget() != null) {
            this.vexEditor.setStylesheet(useDefault ? null : newStylesheet.getLatestURI());
            UIJob tg1565 = new UIJob(Messages.AssociateStylesheetDialog_UpdatingWYSIWYM){

                public IStatus runInUIThread(IProgressMonitor monitor) {
                    new ShowInlineElementMarkersAction().run((IVexWidget)AssociateStylesheetDialog.this.vexEditor.getVexWidget());
                    new ShowInlineElementMarkersAction().run((IVexWidget)AssociateStylesheetDialog.this.vexEditor.getVexWidget());
                    return Status.OK_STATUS;
                }
            };
            tg1565.schedule();
        }
        super.okPressed();
    }

    private final class SingleSelectionAdapter
    extends SelectionAdapter {
        private SingleSelectionAdapter() {
        }

        public void widgetSelected(SelectionEvent e) {
            if (e.widget == AssociateStylesheetDialog.this.defaultButton && AssociateStylesheetDialog.this.defaultButton.getSelection()) {
                AssociateStylesheetDialog.this.viewer.setSelection((ISelection)new StructuredSelection());
            } else if (!AssociateStylesheetDialog.this.viewer.getSelection().isEmpty()) {
                AssociateStylesheetDialog.this.defaultButton.setSelection(false);
            }
        }
    }
}

