/*
 * Decompiled with CFR 0.152.
 */
package net.sf.vex.editor;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class Association {
    private Map l2r = new HashMap();
    private Map r2l = new HashMap();

    public void add(Object left, Object right) {
        ArrayList<Object> rights = (ArrayList<Object>)this.l2r.get(left);
        if (rights == null) {
            rights = new ArrayList<Object>();
            this.l2r.put(left, rights);
        }
        rights.add(right);
        ArrayList<Object> lefts = (ArrayList<Object>)this.r2l.get(right);
        if (lefts == null) {
            lefts = new ArrayList<Object>();
            this.r2l.put(right, lefts);
        }
        lefts.add(left);
    }

    public Collection getLeftsForRight(Object right) {
        Collection lefts = (Collection)this.r2l.get(right);
        if (lefts == null) {
            return Collections.EMPTY_LIST;
        }
        return Collections.unmodifiableCollection(lefts);
    }

    public Collection getRightsForLeft(Object left) {
        Collection rights = (Collection)this.l2r.get(left);
        if (rights == null) {
            return Collections.EMPTY_LIST;
        }
        return Collections.unmodifiableCollection(rights);
    }

    public void remove(Object left, Object right) {
        Collection lefts;
        Collection rights = (Collection)this.l2r.get(left);
        if (rights != null) {
            rights.remove(right);
            if (rights.size() == 0) {
                this.l2r.remove(left);
            }
        }
        if ((lefts = (Collection)this.r2l.get(right)) != null) {
            lefts.remove(left);
            if (lefts.size() == 0) {
                this.r2l.remove(right);
            }
        }
    }

    public void removeLeft(Object left) {
        Collection rights = (Collection)this.l2r.get(left);
        if (rights == null) {
            return;
        }
        this.l2r.remove(left);
        for (Object right : rights) {
            Collection lefts = (Collection)this.r2l.get(right);
            lefts.remove(left);
            if (!lefts.isEmpty()) continue;
            this.r2l.remove(right);
        }
    }

    public void removeRight(Object right) {
        Collection lefts = (Collection)this.r2l.get(right);
        if (lefts == null) {
            return;
        }
        this.r2l.remove(right);
        for (Object left : lefts) {
            Collection rights = (Collection)this.l2r.get(left);
            rights.remove(right);
            if (!rights.isEmpty()) continue;
            this.l2r.remove(left);
        }
    }
}

