/*
 * Decompiled with CFR 0.152.
 */
package net.sf.vex.editor.config;

import java.io.IOException;
import java.net.URL;
import java.text.MessageFormat;
import net.sf.vex.editor.VexPlugin;
import net.sf.vex.editor.config.ConfigSource;
import net.sf.vex.editor.config.ConfigurationElementWrapper;
import net.sf.vex.editor.config.Messages;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.Platform;

public class ConfigPlugin
extends ConfigSource {
    public static final String SER_FILE_PREFIX = ".vexConfig-";
    public static final String SER_FILE_SUFFIX = ".ser";
    private String namespace;

    protected ConfigPlugin(String namespace) {
        this.namespace = namespace;
    }

    public static ConfigPlugin load(String namespace) {
        ConfigPlugin configPlugin = new ConfigPlugin(namespace);
        configPlugin.setUniqueIdentifer(namespace);
        IExtension[] exts = Platform.getExtensionRegistry().getExtensions(namespace);
        int i = 0;
        while (i < exts.length) {
            IExtension ext = exts[i];
            try {
                configPlugin.addItem(ext.getExtensionPointUniqueIdentifier(), ext.getSimpleIdentifier(), ext.getLabel(), ConfigurationElementWrapper.convertArray(ext.getConfigurationElements()));
            }
            catch (IOException e) {
                String message = MessageFormat.format(Messages.getString("ConfigPlugin.loadError"), ext.getSimpleIdentifier(), namespace);
                VexPlugin.getInstance().log(4, message, e);
                return null;
            }
            ++i;
        }
        configPlugin.parseResources(null);
        return configPlugin.isEmpty() ? null : configPlugin;
    }

    @Override
    public URL getBaseUrl() {
        return Platform.getBundle((String)this.namespace).getEntry("plugin.xml");
    }
}

