/*
 * Decompiled with CFR 0.152.
 */
package net.sf.vex.editor.config;

import java.io.IOException;
import java.io.Serializable;
import java.net.URL;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.sf.vex.editor.VexPlugin;
import net.sf.vex.editor.config.ConfigItem;
import net.sf.vex.editor.config.ConfigRegistry;
import net.sf.vex.editor.config.IBuildProblemHandler;
import net.sf.vex.editor.config.IConfigElement;
import net.sf.vex.editor.config.IConfigItemFactory;
import net.sf.vex.editor.config.Messages;

public abstract class ConfigSource
implements Serializable {
    private String id;
    private List items = new ArrayList();
    private Map parsedResources = new HashMap();

    public void addItem(ConfigItem item) {
        this.items.add(item);
    }

    public ConfigItem addItem(String extensionPoint, String simpleIdentifier, String name, IConfigElement[] configElements) throws IOException {
        IConfigItemFactory factory = ConfigRegistry.getInstance().getConfigItemFactory(extensionPoint);
        if (factory != null) {
            ConfigItem item = factory.createItem(this, configElements);
            item.setSimpleId(simpleIdentifier);
            item.setName(name);
            this.addItem(item);
            return item;
        }
        return null;
    }

    public void remove(ConfigItem item) {
        this.items.remove(item);
    }

    public void removeAllItems() {
        this.items.clear();
    }

    public void removeAllResources() {
        this.parsedResources.clear();
    }

    public void removeResource(String uri) {
        this.parsedResources.remove(uri);
    }

    public List getAllItems() {
        return this.items;
    }

    public Collection getAllItems(String type) {
        ArrayList<ConfigItem> items = new ArrayList<ConfigItem>();
        for (ConfigItem item : this.items) {
            if (!item.getExtensionPointId().equals(type)) continue;
            items.add(item);
        }
        return items;
    }

    public abstract URL getBaseUrl();

    public ConfigItem getItem(String simpleId) {
        for (ConfigItem item : this.items) {
            if (item.getSimpleId() == null || !item.getSimpleId().equals(simpleId)) continue;
            return item;
        }
        return null;
    }

    public ConfigItem getItemForResource(String resourcePath) {
        for (ConfigItem item : this.items) {
            if (!item.getResourcePath().equals(resourcePath)) continue;
            return item;
        }
        return null;
    }

    public Object getParsedResource(String uri) {
        return this.parsedResources.get(uri);
    }

    public String getUniqueIdentifer() {
        return this.id;
    }

    public Collection getValidItems(String type) {
        Collection allItems = this.getAllItems(type);
        ArrayList<ConfigItem> validItems = new ArrayList<ConfigItem>();
        for (ConfigItem item : allItems) {
            if (!item.isValid()) continue;
            validItems.add(item);
        }
        return validItems;
    }

    public boolean isEmpty() {
        return this.items.isEmpty();
    }

    public void parseResources(IBuildProblemHandler problemHandler) {
        for (ConfigItem item : this.items) {
            String uri = item.getResourcePath();
            if (this.parsedResources.containsKey(uri)) continue;
            IConfigItemFactory factory = ConfigRegistry.getInstance().getConfigItemFactory(item.getExtensionPointId());
            try {
                Object parsedResource = factory.parseResource(this.getBaseUrl(), uri, problemHandler);
                this.parsedResources.put(uri, parsedResource);
            }
            catch (IOException ex) {
                String message = MessageFormat.format(Messages.getString("ConfigSource.errorParsingUri"), uri);
                VexPlugin.getInstance().log(4, message, ex);
            }
        }
    }

    public void setUniqueIdentifer(String id) {
        this.id = id;
    }
}

