/*
 * Decompiled with CFR 0.152.
 */
package info.textgrid.utils.linkrewriter;

import com.google.common.collect.Maps;
import info.textgrid._import.ImportObject;
import info.textgrid._import.ImportSpec;
import info.textgrid._import.RevisionPolicyType;
import info.textgrid._import.RewriteMethod;
import java.net.URI;
import java.net.URISyntaxException;
import java.text.MessageFormat;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ImportMapping
implements Iterable<ImportObject> {
    private final Map<URI, ImportObject> textgridMap = Maps.newLinkedHashMap();
    private final Map<URI, ImportObject> localMap = Maps.newHashMap();
    private ImportSpec importSpec;
    private static Logger logger = Logger.getLogger(ImportMapping.class.getCanonicalName());

    public ImportObject getImportObjectForTextGridURI(String textGridURI) {
        return this.getImportObjectForTextGridURI(ImportMapping.makeURI(textGridURI));
    }

    public ImportObject getImportObjectForTextGridURI(URI textGridURI) {
        return this.textgridMap.get(textGridURI);
    }

    public ImportObject getImportObjectForLocalURI(String localURI) {
        return this.getImportObjectForLocalURI(ImportMapping.makeURI(localURI));
    }

    public ImportObject getImportObjectForLocalURI(URI localURI) {
        return this.localMap.get(localURI);
    }

    public void add(ImportObject ... importObjects) {
        for (ImportObject importObject : importObjects) {
            this.textgridMap.put(ImportMapping.makeURI(importObject.getTextgridUri()), importObject);
            this.localMap.put(ImportMapping.makeURI(importObject.getLocalData()), importObject);
        }
    }

    public static URI makeURI(String in) throws IllegalArgumentException {
        if (in == null) {
            return null;
        }
        try {
            return new URI(in);
        }
        catch (URISyntaxException e) {
            try {
                URI uri = new URI(null, in, null);
                logger.fine(MessageFormat.format("Input string {0} is not a valid URI, interpreting as file instead -> {1} ({2})", in, uri, e.getReason()));
                return uri;
            }
            catch (URISyntaxException e1) {
                String error = MessageFormat.format("Input String \"{0}\" could neither be interpreted as URI ({1}) nor as file name ({2})", in, e.getReason(), e1.getReason());
                logger.log(Level.SEVERE, error, e);
                throw new IllegalArgumentException(error, e);
            }
        }
    }

    public ImportMapping add(String textgridURI, String localURI, String localMetadata, RewriteMethod rewriteMethod) {
        return this.add(ImportMapping.makeURI(textgridURI), ImportMapping.makeURI(localURI), ImportMapping.makeURI(localMetadata), rewriteMethod);
    }

    public ImportMapping add(URI textgridURI, URI localURI, URI localMetadata, RewriteMethod rewriteMethod) {
        ImportObject importObject = new ImportObject();
        importObject.setTextgridUri(textgridURI.toString());
        importObject.setLocalData(localURI.toString());
        if (localMetadata != null) {
            importObject.setLocalMetadata(localMetadata.toString());
        }
        importObject.setRewriteMethod(rewriteMethod);
        this.add(importObject);
        return this;
    }

    public Collection<? extends ImportObject> getImportObjects() {
        return this.textgridMap.values();
    }

    @Override
    public Iterator<ImportObject> iterator() {
        return this.textgridMap.values().iterator();
    }

    public ImportSpec toImportSpec() {
        if (this.importSpec == null) {
            this.importSpec = new ImportSpec();
        } else {
            this.importSpec.getImportObject().clear();
        }
        this.importSpec.getImportObject().addAll(this.textgridMap.values());
        return this.importSpec;
    }

    public ImportMapping(ImportSpec importSpec) {
        this();
        for (ImportObject object : importSpec.getImportObject()) {
            this.add(object);
        }
        this.importSpec = importSpec;
    }

    public RevisionPolicyType getImportRevisionPolicy() {
        if (this.importSpec != null && this.importSpec.getRevisionPolicy() != null && this.importSpec.getRevisionPolicy().getImport() != null) {
            return this.importSpec.getRevisionPolicy().getImport();
        }
        return RevisionPolicyType.ACTUAL;
    }

    public ImportMapping() {
    }
}

