/*
 * Decompiled with CFR 0.152.
 */
package net.sf.vex.editor;

import info.textgrid.lab.core.swtutils.AdapterUtils;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EventObject;
import java.util.LinkedList;
import java.util.List;
import net.sf.vex.action.ConfigureFavorite;
import net.sf.vex.action.DeleteColumnAction;
import net.sf.vex.action.DeleteRowAction;
import net.sf.vex.action.DuplicateSelectionAction;
import net.sf.vex.action.FontsList;
import net.sf.vex.action.GEditorContentAssistant;
import net.sf.vex.action.IVexAction;
import net.sf.vex.action.InsertColumnAfterAction;
import net.sf.vex.action.InsertColumnBeforeAction;
import net.sf.vex.action.InsertRowAboveAction;
import net.sf.vex.action.InsertRowBelowAction;
import net.sf.vex.action.MoveColumnLeftAction;
import net.sf.vex.action.MoveColumnRightAction;
import net.sf.vex.action.MoveRowDownAction;
import net.sf.vex.action.MoveRowUpAction;
import net.sf.vex.action.NextTableCellAction;
import net.sf.vex.action.PasteTextAction;
import net.sf.vex.action.PreviousTableCellAction;
import net.sf.vex.action.RemoveElementAction;
import net.sf.vex.action.RestoreLastSelectionAction;
import net.sf.vex.action.SplitAction;
import net.sf.vex.action.SplitItemAction;
import net.sf.vex.core.ListenerList;
import net.sf.vex.css.StyleSheet;
import net.sf.vex.css.StyleSheetReader;
import net.sf.vex.dom.DocumentReader;
import net.sf.vex.dom.DocumentWriter;
import net.sf.vex.dom.IVexDocument;
import net.sf.vex.dom.IVexElement;
import net.sf.vex.dom.IWhitespacePolicy;
import net.sf.vex.dom.IWhitespacePolicyFactory;
import net.sf.vex.dom.Validator;
import net.sf.vex.editor.DocumentOutlinePage;
import net.sf.vex.editor.DocumentTypeSelectionDialog;
import net.sf.vex.editor.ElementPropertySource;
import net.sf.vex.editor.IVexActionBarContributor;
import net.sf.vex.editor.IVexEditorListener;
import net.sf.vex.editor.Messages;
import net.sf.vex.editor.PreferenceChangeHandler;
import net.sf.vex.editor.SelectionProvider;
import net.sf.vex.editor.VexEditorEvent;
import net.sf.vex.editor.VexPlugin;
import net.sf.vex.editor.action.ChangeElementAction;
import net.sf.vex.editor.action.InsertElementAction;
import net.sf.vex.editor.action.VexActionAdapter;
import net.sf.vex.editor.config.ConfigEvent;
import net.sf.vex.editor.config.ConfigRegistry;
import net.sf.vex.editor.config.DocumentType;
import net.sf.vex.editor.config.IConfigListener;
import net.sf.vex.editor.config.Style;
import net.sf.vex.swt.TextSelectionVex;
import net.sf.vex.swt.VexWidget;
import net.sf.vex.widget.CssWhitespacePolicy;
import net.sf.vex.widget.IVexWidget;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.URIUtil;
import org.eclipse.core.internal.runtime.Activator;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.IPreferencesService;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.ControlContribution;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IKeyBindingService;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.SaveAsDialog;
import org.eclipse.ui.editors.text.ILocationProvider;
import org.eclipse.ui.help.IWorkbenchHelpSystem;
import org.eclipse.ui.part.EditorPart;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ui.statushandlers.StatusManager;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.ui.views.contentoutline.IContentOutlinePage;
import org.eclipse.ui.views.properties.IPropertySheetPage;
import org.eclipse.ui.views.properties.IPropertySource;
import org.eclipse.ui.views.properties.IPropertySourceProvider;
import org.eclipse.ui.views.properties.PropertySheetPage;
import org.osgi.service.prefs.BackingStoreException;
import org.w3c.css.sac.CSSException;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class VexEditor
extends EditorPart {
    private static final String CONTEXT_HELP_ID = "info.textgrid.lab.xmleditor.mpeditor.WysiwymPage";
    public static final String ID = "net.sf.vex.editor.VexEditor";
    private State state = State.UNLOADED;
    private boolean debugging;
    private Composite parentControl;
    private Label loadingLabel;
    private boolean loaded;
    private DocumentType doctype;
    public static IVexDocument doc;
    Style style;
    private VexWidget vexWidget;
    private int savedUndoDepth;
    private boolean wasDirty;
    private boolean updateDoctypeDecl;
    private final ListenerList vexEditorListeners = new ListenerList(IVexEditorListener.class, VexEditorEvent.class);
    private final SelectionProvider selectionProvider = new SelectionProvider();
    public List favoriteElementArray = new LinkedList();
    boolean v_test = false;
    private final IConfigListener configListener = new IConfigListener(){

        @Override
        public void configChanged(ConfigEvent e) {
            String currId;
            ConfigRegistry registry;
            Style newStyle;
            if (VexEditor.this.style != null && (newStyle = (Style)(registry = ConfigRegistry.getInstance()).getConfigItem("net.sf.vex.editor.styles", currId = VexEditor.this.style.getUniqueId())) != null) {
                VexEditor.this.vexWidget.setStyleSheet(newStyle.getStyleSheet());
                VexEditor.this.style = newStyle;
            }
        }

        @Override
        public void configLoaded(ConfigEvent e) {
            VexEditor.this.loadInput();
        }
    };
    private final ISelectionChangedListener selectionChangedListener = new ISelectionChangedListener(){

        public void selectionChanged(SelectionChangedEvent event) {
            if (VexEditor.this.isDirty() != VexEditor.this.isWasDirty()) {
                VexEditor.this.firePropertyChange(257);
                VexEditor.this.setWasDirty(VexEditor.this.isDirty());
            }
            VexEditor.this.setStatus(VexEditor.this.getLocation());
        }
    };
    private final EntityResolver entityResolver = new EntityResolver(){

        @Override
        public InputSource resolveEntity(String publicId, String systemId) throws SAXException, IOException {
            if (VexEditor.this.getDoctype() == null) {
                URL url;
                if (publicId != null) {
                    VexEditor.this.setDoctype(DocumentType.getDocumentType(publicId));
                }
                if (VexEditor.this.getDoctype() == null) {
                    DocumentTypeSelectionDialog dlg = DocumentTypeSelectionDialog.create(VexEditor.this.getSite().getShell(), publicId);
                    dlg.open();
                    VexEditor.this.setDoctype(dlg.getDoctype());
                    VexEditor.this.setUpdateDoctypeDecl(dlg.alwaysUseThisDoctype());
                    if (VexEditor.this.getDoctype() == null) {
                        throw new NoRegisteredDoctypeException(publicId);
                    }
                }
                if ((url = VexEditor.this.getDoctype().getResourceUrl()) == null) {
                    String message = MessageFormat.format(Messages.getString("VexEditor.noUrlForDoctype"), publicId);
                    throw new RuntimeException(message);
                }
                return new InputSource(url.toString());
            }
            return null;
        }
    };
    private final IWhitespacePolicyFactory wsFactory = new IWhitespacePolicyFactory(){

        public IWhitespacePolicy getPolicy(String publicId) {
            if (VexEditor.this.getDoctype() == null) {
                DocumentTypeSelectionDialog dlg = DocumentTypeSelectionDialog.create(VexEditor.this.getSite().getShell(), publicId);
                dlg.open();
                VexEditor.this.setDoctype(dlg.getDoctype());
                VexEditor.this.setUpdateDoctypeDecl(dlg.alwaysUseThisDoctype());
                if (VexEditor.this.getDoctype() == null) {
                    throw new NoRegisteredDoctypeException(null);
                }
            }
            VexEditor.this.style = VexEditor.findStyleForDoctype(VexEditor.this.getDoctype().getPublicId());
            if (VexEditor.this.style == null) {
                throw new NoStyleForDoctypeException(VexEditor.this.getDoctype());
            }
            return new CssWhitespacePolicy(VexEditor.this.style.getStyleSheet());
        }
    };
    private final ResourceChangeListener resourceChangeListener = new ResourceChangeListener();

    public ISelectionChangedListener getSelectionChangedListener() {
        return this.selectionChangedListener;
    }

    public SelectionProvider getSelectionProvider() {
        return this.selectionProvider;
    }

    public VexEditor() {
        this.setDebugging(VexPlugin.getInstance().isDebugging() && "true".equalsIgnoreCase(Platform.getDebugOption((String)"net.sf.vex.editor/debug/layout")));
    }

    public void addVexEditorListener(IVexEditorListener listener) {
        this.vexEditorListeners.add((Object)listener);
    }

    public void dispose() {
        super.dispose();
        VexPlugin.getInstance().unregisterEditor(this);
        if (this.parentControl != null) {
            ConfigRegistry.getInstance().removeConfigListener(this.configListener);
        }
        if (this.getEditorInput() instanceof IFileEditorInput) {
            ResourcesPlugin.getWorkspace().removeResourceChangeListener((IResourceChangeListener)this.resourceChangeListener);
        }
    }

    public void doSave(IProgressMonitor monitor) {
        block16: {
            IEditorInput input = this.getEditorInput();
            OutputStream os = null;
            try {
                try {
                    this.resourceChangeListener.setSaving(true);
                    DocumentWriter writer = new DocumentWriter();
                    writer.setWhitespacePolicy((IWhitespacePolicy)new CssWhitespacePolicy(this.style.getStyleSheet()));
                    if (input instanceof IFileEditorInput) {
                        ByteArrayOutputStream baos = new ByteArrayOutputStream();
                        writer.write(this.getDoc(), (OutputStream)baos);
                        baos.close();
                        ByteArrayInputStream bais = new ByteArrayInputStream(baos.toByteArray());
                        ((IFileEditorInput)input).getFile().setContents((InputStream)bais, false, false, monitor);
                    } else {
                        os = EFS.getStore((URI)URIUtil.toURI((IPath)((ILocationProvider)input).getPath((Object)input))).openOutputStream(0, monitor);
                        writer.write(this.getDoc(), os);
                    }
                    this.setSavedUndoDepth(this.vexWidget.getUndoDepth());
                    this.firePropertyChange(257);
                }
                catch (Exception ex) {
                    monitor.setCanceled(true);
                    String title = Messages.getString("VexEditor.errorSaving.title");
                    String message = MessageFormat.format(Messages.getString("VexEditor.errorSaving.message"), input.getName(), ex.getMessage());
                    MessageDialog.openError((Shell)this.getEditorSite().getShell(), (String)title, (String)message);
                    VexPlugin.getInstance().log(4, message, ex);
                    if (os != null) {
                        try {
                            os.close();
                        }
                        catch (IOException iOException) {}
                    }
                    this.resourceChangeListener.setSaving(false);
                    break block16;
                }
            }
            catch (Throwable throwable) {
                if (os != null) {
                    try {
                        os.close();
                    }
                    catch (IOException iOException) {}
                }
                this.resourceChangeListener.setSaving(false);
                throw throwable;
            }
            if (os != null) {
                try {
                    os.close();
                }
                catch (IOException iOException) {}
            }
            this.resourceChangeListener.setSaving(false);
        }
    }

    public void doSaveAs() {
        SaveAsDialog dlg = new SaveAsDialog(this.getSite().getShell());
        int result = dlg.open();
        if (result == 0) {
            IPath path = dlg.getResult();
            try {
                try {
                    this.resourceChangeListener.setSaving(true);
                    ByteArrayOutputStream baos = new ByteArrayOutputStream();
                    DocumentWriter writer = new DocumentWriter();
                    writer.setWhitespacePolicy((IWhitespacePolicy)new CssWhitespacePolicy(this.style.getStyleSheet()));
                    writer.write(this.getDoc(), (OutputStream)baos);
                    baos.close();
                    ByteArrayInputStream bais = new ByteArrayInputStream(baos.toByteArray());
                    IFile file = ResourcesPlugin.getWorkspace().getRoot().getFile(path);
                    file.create((InputStream)bais, false, null);
                    FileEditorInput input = new FileEditorInput(file);
                    this.setInput((IEditorInput)input);
                    this.setSavedUndoDepth(this.vexWidget.getUndoDepth());
                    this.firePropertyChange(257);
                    this.firePropertyChange(258);
                    this.firePropertyChange(1);
                }
                catch (Exception ex) {
                    String title = Messages.getString("VexEditor.errorSaving.title");
                    String message = MessageFormat.format(Messages.getString("VexEditor.errorSaving.message"), path, ex.getMessage());
                    MessageDialog.openError((Shell)this.getEditorSite().getShell(), (String)title, (String)message);
                    VexPlugin.getInstance().log(4, message, ex);
                    this.resourceChangeListener.setSaving(false);
                }
            }
            finally {
                this.resourceChangeListener.setSaving(false);
            }
        }
    }

    public static Style findStyleForDoctype(String publicId) {
        IPreferencesService preferences = Platform.getPreferencesService();
        String key = VexEditor.getStylePreferenceKey(publicId);
        String preferredStyleId = preferences.getString("net.sf.vex.editor", key, null, null);
        IEclipsePreferences prefs = new InstanceScope().getNode("net.sf.vex.editor");
        preferredStyleId = prefs.get(key, null);
        Style firstStyle = null;
        ConfigRegistry registry = ConfigRegistry.getInstance();
        List styles = registry.getAllConfigItems("net.sf.vex.editor.styles");
        for (Style style : styles) {
            if (!style.appliesTo(publicId)) continue;
            if (firstStyle == null) {
                firstStyle = style;
            }
            if (!style.getUniqueId().equals(preferredStyleId)) continue;
            return style;
        }
        return firstStyle;
    }

    public DocumentType getDocumentType() {
        return this.getDoctype();
    }

    public Style getStyle() {
        return this.style;
    }

    public VexWidget getVexWidget() {
        return this.vexWidget;
    }

    protected void setVexWidget(VexWidget widget) {
        this.vexWidget = widget;
    }

    public void gotoMarker(IMarker marker) {
    }

    public void init(IEditorSite site, IEditorInput input) throws PartInitException {
        this.setSite((IWorkbenchPartSite)site);
        this.setInput(input);
        this.getEditorSite().setSelectionProvider((ISelectionProvider)this.selectionProvider);
        this.getEditorSite().getSelectionProvider().addSelectionChangedListener(this.selectionChangedListener);
        if (input instanceof IFileEditorInput) {
            ResourcesPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)this.resourceChangeListener, 1);
        }
        VexPlugin.getInstance().registerEditor(this);
    }

    protected State getState() {
        return this.state;
    }

    protected void loadInput() {
        if (this.vexWidget != null) {
            this.vexEditorListeners.fireEvent("documentUnloaded", (EventObject)new VexEditorEvent(this));
        }
        this.loaded = false;
        IEditorInput input = this.getEditorInput();
        try {
            Validator validator;
            long start = System.currentTimeMillis();
            URI inputURI = null;
            if (input instanceof IFileEditorInput) {
                inputURI = ((IFileEditorInput)input).getFile().getLocationURI();
            } else if (input instanceof ILocationProvider) {
                IPath workspacePath = ((ILocationProvider)input).getPath((Object)input);
                inputURI = URIUtil.toURI((IPath)workspacePath);
            } else {
                String msg = MessageFormat.format(Messages.getString("VexEditor.unknownInputClass"), input.getClass());
                this.showLabel(msg);
                return;
            }
            DocumentReader reader = new DocumentReader();
            reader.setDebugging(this.isDebugging());
            reader.setEntityResolver(this.entityResolver);
            reader.setWhitespacePolicyFactory(this.wsFactory);
            this.setDoctype(null);
            try {
                InputStream inputStream = EFS.getStore((URI)inputURI).openInputStream(0, null);
                if (inputStream == null) {
                    throw new CoreException((IStatus)new Status(4, "net.sf.vex.editor", "Could not open file " + inputURI));
                }
                try {
                    this.setDoc(reader.read(inputStream));
                }
                finally {
                    if (inputStream != null) {
                        inputStream.close();
                    }
                }
            }
            catch (CoreException ce) {
                try {
                    URL inputURL = inputURI.toURL();
                    this.setDoc(reader.read(inputURL));
                }
                catch (MalformedURLException mue) {
                    throw new CoreException((IStatus)new Status(4, "net.sf.vex.editor", 4, "Neither EFS nor java.net.URL can handle <URI:" + inputURI + ">. \n" + "URI.toURL() failed with " + mue.getLocalizedMessage() + ". ", (Throwable)ce));
                }
            }
            if (this.isDebugging()) {
                long end = System.currentTimeMillis();
                System.out.println("Parsed document in " + (end - start) + "ms");
            }
            if ((validator = this.getDoctype().getValidator()) != null) {
                this.getDoc().setValidator(validator);
                if (this.isDebugging()) {
                    long end = System.currentTimeMillis();
                    System.out.println("Got validator in " + (end - start) + "ms");
                }
            }
            this.showVexWidget();
            this.vexWidget.setDebugging(this.isDebugging());
            this.vexWidget.setDocument(this.getDoc(), this.style.getStyleSheet());
            if (this.isUpdateDoctypeDecl()) {
                this.getDoc().setPublicID(this.getDoctype().getPublicId());
                this.getDoc().setSystemID(this.getDoctype().getSystemId());
                this.doSave(null);
            }
            this.loaded = true;
            this.setSavedUndoDepth(this.vexWidget.getUndoDepth());
            this.firePropertyChange(257);
            this.setWasDirty(this.isDirty());
            this.vexEditorListeners.fireEvent("documentLoaded", (EventObject)new VexEditorEvent(this));
        }
        catch (SAXParseException ex) {
            if (ex.getException() instanceof NoRegisteredDoctypeException) {
                NoRegisteredDoctypeException ex2 = (NoRegisteredDoctypeException)ex.getException();
                String msg = ex2.getPublicId() == null ? Messages.getString("VexEditor.noDoctype") : MessageFormat.format(Messages.getString("VexEditor.unknownDoctype"), ex2.getPublicId());
                this.showLabel(msg);
            } else if (ex.getException() instanceof NoStyleForDoctypeException) {
                String msg = MessageFormat.format(Messages.getString("VexEditor.noStyles"), this.getDoctype().getPublicId());
                this.showLabel(msg);
            } else {
                String file = ex.getSystemId();
                if (file == null) {
                    file = input.getName();
                }
                String msg = MessageFormat.format(Messages.getString("VexEditor.parseError"), new Integer(ex.getLineNumber()), file, ex.getLocalizedMessage());
                this.showLabel(msg);
                VexPlugin.getInstance().log(4, msg, ex);
            }
        }
        catch (Exception ex) {
            String msg = MessageFormat.format(Messages.getString("VexEditor.unexpectedError"), input.getName(), Platform.getLogFileLocation());
            VexPlugin.getInstance().log(4, msg, ex);
            this.showLabel(msg);
        }
    }

    public boolean isDirty() {
        if (this.vexWidget != null) {
            return this.getSavedUndoDepth() != this.vexWidget.getUndoDepth();
        }
        return false;
    }

    public boolean isLoaded() {
        return this.loaded;
    }

    protected void setLoaded(boolean loaded) {
        this.loaded = loaded;
    }

    public boolean isSaveAsAllowed() {
        return true;
    }

    public void createPartControl(Composite parent) {
        this.parentControl = parent;
        this.showLabel(Messages.getString("VexEditor.loading"));
        parent.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusGained(FocusEvent e) {
                if (VexEditor.this.getState() == State.UNLOADED) {
                    VexEditor.this.initAndLoad();
                }
            }
        });
    }

    public void initAndLoad() {
        if (this.getState() != State.UNLOADED) {
            return;
        }
        this.setState(State.LOADING);
        ConfigRegistry registry = ConfigRegistry.getInstance();
        registry.addConfigListener(this.configListener);
        if (registry.isConfigLoaded()) {
            this.loadInput();
        } else {
            this.showLabel(Messages.getString("VexEditor.loading"));
        }
    }

    public void removeVexEditorListener(IVexEditorListener listener) {
        this.vexEditorListeners.remove((Object)listener);
    }

    protected ListenerList getVexEditorListeners() {
        return this.vexEditorListeners;
    }

    public void setFocus() {
        if (this.vexWidget != null) {
            this.vexWidget.setFocus();
            this.setStatus(this.getLocation());
        }
    }

    protected void setInput(IEditorInput input) {
        super.setInput(input);
        this.setPartName(input.getName());
        this.setContentDescription(input.getName());
        this.setTitleToolTip(input.getToolTipText());
    }

    public void setStatus(String text) {
        this.getEditorSite().getActionBars().getStatusLineManager().setMessage(text);
    }

    public void setStyle(Style style) {
        this.style = style;
        if (this.vexWidget != null) {
            this.vexWidget.setStyleSheet(style.getStyleSheet());
            IEclipsePreferences prefs = new InstanceScope().getNode("net.sf.vex.editor");
            String key = VexEditor.getStylePreferenceKey(this.getDoc().getPublicID());
            prefs.put(key, style.getUniqueId());
            try {
                prefs.flush();
            }
            catch (BackingStoreException e) {
                VexPlugin.getInstance().log(4, Messages.getString("VexEditor.errorSavingStylePreference"), e);
            }
        }
    }

    protected Composite getParentControl() {
        return this.parentControl;
    }

    private static String getStylePreferenceKey(String publicId) {
        return String.valueOf(publicId) + ".style";
    }

    protected void showLabel(String message) {
        if (this.loadingLabel == null) {
            if (this.vexWidget != null) {
                this.vexWidget.dispose();
                this.vexWidget = null;
            }
            this.loadingLabel = new Label(this.parentControl, 64);
            this.loadingLabel.addPaintListener(new PaintListener(){

                public void paintControl(PaintEvent e) {
                    if (VexEditor.this.loadingLabel.isVisible() && VexEditor.this.getState() == State.UNLOADED) {
                        VexEditor.this.initAndLoad();
                    }
                }
            });
        }
        this.loadingLabel.setText(message);
        this.parentControl.layout(true);
    }

    protected void clearLoadingLabel() {
        this.loadingLabel.dispose();
        this.loadingLabel = null;
    }

    public void Favorite() {
        IActionBars actBar = this.getEditorSite().getActionBars();
        final IToolBarManager toolbarMgr = actBar.getToolBarManager();
        if (toolbarMgr.getItems().length == 0) {
            Action f_Rem = new Action("", ImageDescriptor.createFromFile(null, (String)this.getFilePathFromPluginForReading("icons/126-Loesche_Lieblingselement_in_XML.gif"))){

                public void run() {
                    IContributionItem[] items = toolbarMgr.getItems();
                    if (items.length >= 4) {
                        int i = 4;
                        while (i < items.length) {
                            toolbarMgr.remove(items[i]);
                            ++i;
                        }
                        toolbarMgr.update(true);
                        ConfigureFavorite f_elements = new ConfigureFavorite(VexEditor.this.getVexWidget());
                        f_elements.favoriteElementArray = new LinkedList();
                        VexEditor.this.favoriteElementArray = new LinkedList();
                        ((ActionContributionItem)items[1]).getAction().setEnabled(false);
                    }
                }
            };
            f_Rem.setEnabled(false);
            Action f_Add = new Action("", ImageDescriptor.createFromFile(null, (String)this.getFilePathFromPluginForReading("icons/125-Einfuege_Lieblingselement_in_XML.gif"))){

                public void run() {
                    String[][] data = null;
                    Display display = VexEditor.this.getVexWidget().getDisplay();
                    ConfigureFavorite confFavorite = new ConfigureFavorite(VexEditor.this.getVexWidget());
                    IContributionItem[] items = toolbarMgr.getItems();
                    if (items.length >= 4) {
                        int i = 4;
                        while (i < items.length) {
                            VexEditor.this.favoriteElementArray.add(items[i]);
                            ++i;
                        }
                    }
                    confFavorite.favoriteElementArray = VexEditor.this.favoriteElementArray;
                    data = confFavorite.getDocumentElements();
                    if (!confFavorite.favoriteShell.isVisible()) {
                        confFavorite.configure(display, data);
                    } else {
                        confFavorite.favoriteShell.close();
                        confFavorite.configure(display, data);
                    }
                }
            };
            f_Add.setId("F_Add");
            f_Rem.setId("F_Rem");
            toolbarMgr.add((IAction)f_Add);
            toolbarMgr.add((IAction)f_Rem);
        }
    }

    protected void showVexWidget() {
        IEditorSite editorSite;
        IVexActionBarContributor contributor;
        this.clearLoadingLabel();
        if (this.vexWidget != null) {
            return;
        }
        this.Favorite();
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        layout.verticalSpacing = 0;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        this.parentControl.setLayout((Layout)layout);
        GridData gd = new GridData();
        gd.grabExcessHorizontalSpace = true;
        gd.grabExcessVerticalSpace = true;
        gd.horizontalAlignment = 4;
        gd.verticalAlignment = 4;
        this.vexWidget = new VexWidget(this.parentControl, 512);
        gd = new GridData();
        gd.grabExcessHorizontalSpace = true;
        gd.grabExcessVerticalSpace = true;
        gd.horizontalAlignment = 4;
        gd.verticalAlignment = 4;
        this.vexWidget.setLayoutData((Object)gd);
        IWorkbenchHelpSystem helpSystem = this.getSite().getWorkbenchWindow().getWorkbench().getHelpSystem();
        helpSystem.setHelp((Control)this.vexWidget, CONTEXT_HELP_ID);
        if (helpSystem.isContextHelpDisplayed()) {
            helpSystem.displayHelp(CONTEXT_HELP_ID);
        }
        if ((contributor = (IVexActionBarContributor)(editorSite = this.getEditorSite()).getActionBarContributor()) == null) {
            StatusManager.getManager().handle((IStatus)new Status(2, "net.sf.vex.editor", "Could not get action bar contributor, thus unable to create actions.", (Throwable)new Exception()));
        } else {
            MenuManager menuMgr = contributor.getContextMenuManager();
            this.getSite().registerContextMenu(menuMgr, (ISelectionProvider)this.vexWidget);
            this.vexWidget.setMenu(menuMgr.createContextMenu((Control)this.vexWidget));
            this.setSavedUndoDepth(this.vexWidget.getUndoDepth());
            this.registerBindings();
        }
        final GEditorContentAssistant ContentWindow = new GEditorContentAssistant(this.getVexWidget());
        this.vexWidget.addSelectionChangedListener((ISelectionChangedListener)this.selectionProvider);
        this.vexWidget.addKeyListener(new KeyListener(){

            public void keyPressed(KeyEvent event) {
                Display display = VexEditor.this.getVexWidget().getDisplay();
                if (event.keyCode == 60) {
                    ConfigureFavorite f_elements = new ConfigureFavorite(VexEditor.this.getVexWidget());
                    String[][] data = f_elements.getDocumentElements();
                    ContentWindow.contentAssistMain(display, data, "true");
                }
            }

            public void keyReleased(KeyEvent arg0) {
            }
        });
        this.parentControl.layout(true);
        PreferenceChangeHandler.getInstance().setAllPreferences();
    }

    protected void registerBindings() {
        IKeyBindingService kbs = this.getSite().getKeyBindingService();
        kbs.setScopes(new String[]{"net.sf.vex.editor.VexEditorContext"});
        kbs.registerAction((IAction)new VexActionAdapter(this, new ChangeElementAction()));
        kbs.registerAction((IAction)new VexActionAdapter(this, (IVexAction)new DeleteColumnAction()));
        kbs.registerAction((IAction)new VexActionAdapter(this, (IVexAction)new DeleteRowAction()));
        kbs.registerAction((IAction)new VexActionAdapter(this, (IVexAction)new DuplicateSelectionAction()));
        kbs.registerAction((IAction)new VexActionAdapter(this, (IVexAction)new InsertColumnAfterAction()));
        kbs.registerAction((IAction)new VexActionAdapter(this, (IVexAction)new InsertColumnBeforeAction()));
        kbs.registerAction((IAction)new VexActionAdapter(this, new InsertElementAction()));
        kbs.registerAction((IAction)new VexActionAdapter(this, (IVexAction)new InsertRowAboveAction()));
        kbs.registerAction((IAction)new VexActionAdapter(this, (IVexAction)new InsertRowBelowAction()));
        kbs.registerAction((IAction)new VexActionAdapter(this, (IVexAction)new MoveColumnLeftAction()));
        kbs.registerAction((IAction)new VexActionAdapter(this, (IVexAction)new MoveColumnRightAction()));
        kbs.registerAction((IAction)new VexActionAdapter(this, (IVexAction)new MoveRowDownAction()));
        kbs.registerAction((IAction)new VexActionAdapter(this, (IVexAction)new MoveRowUpAction()));
        kbs.registerAction((IAction)new VexActionAdapter(this, (IVexAction)new NextTableCellAction()));
        kbs.registerAction((IAction)new VexActionAdapter(this, (IVexAction)new PasteTextAction()));
        kbs.registerAction((IAction)new VexActionAdapter(this, (IVexAction)new PreviousTableCellAction()));
        kbs.registerAction((IAction)new VexActionAdapter(this, (IVexAction)new RemoveElementAction()));
        kbs.registerAction((IAction)new VexActionAdapter(this, (IVexAction)new RestoreLastSelectionAction()));
        kbs.registerAction((IAction)new VexActionAdapter(this, (IVexAction)new SplitAction()));
        kbs.registerAction((IAction)new VexActionAdapter(this, (IVexAction)new SplitItemAction()));
    }

    private void handleResourceChanged(IResourceDelta delta) {
        if (delta.getKind() == 4) {
            if ((delta.getFlags() & 0x100) != 0) {
                this.handleResourceContentChanged();
            }
        } else if (delta.getKind() == 2) {
            if ((delta.getFlags() & 0x2000) != 0) {
                IPath toPath = delta.getMovedToPath();
                IFile file = ResourcesPlugin.getWorkspace().getRoot().getFile(toPath);
                this.setInput((IEditorInput)new FileEditorInput(file));
            } else if (!this.isDirty()) {
                this.getEditorSite().getPage().closeEditor((IEditorPart)this, false);
            } else {
                this.handleResourceDeleted();
            }
        }
    }

    private void handleResourceContentChanged() {
        if (!this.isDirty()) {
            this.loadInput();
        } else {
            String message = MessageFormat.format(Messages.getString("VexEditor.docChanged.message"), this.getEditorInput().getName());
            MessageDialog dlg = new MessageDialog(this.getSite().getShell(), Messages.getString("VexEditor.docChanged.title"), null, message, 3, new String[]{Messages.getString("VexEditor.docChanged.discard"), Messages.getString("VexEditor.docChanged.overwrite")}, 1);
            int result = dlg.open();
            if (result == 0) {
                this.loadInput();
            } else {
                this.doSave(null);
            }
        }
    }

    private void handleResourceDeleted() {
        String message = MessageFormat.format(Messages.getString("VexEditor.docDeleted.message"), this.getEditorInput().getName());
        MessageDialog dlg = new MessageDialog(this.getSite().getShell(), Messages.getString("VexEditor.docDeleted.title"), null, message, 3, new String[]{Messages.getString("VexEditor.docDeleted.discard"), Messages.getString("VexEditor.docDeleted.save")}, 1);
        int result = dlg.open();
        if (result == 0) {
            this.getEditorSite().getPage().closeEditor((IEditorPart)this, false);
        } else {
            this.doSaveAs();
            if (!this.getEditorInput().exists()) {
                this.getEditorSite().getPage().closeEditor((IEditorPart)this, false);
            }
        }
    }

    protected IWhitespacePolicyFactory getWsFactory() {
        return this.wsFactory;
    }

    private String getLocation() {
        ArrayList<String> path = new ArrayList<String>();
        IVexElement element = this.vexWidget.getCurrentElement();
        while (element != null) {
            path.add(element.getName());
            element = element.getParent();
        }
        Collections.reverse(path);
        StringBuffer sb = new StringBuffer(path.size() * 15);
        int i = 0;
        while (i < path.size()) {
            sb.append("/");
            sb.append(path.get(i));
            ++i;
        }
        return sb.toString();
    }

    public Object getAdapter(Class adapter) {
        if (adapter == IContentOutlinePage.class) {
            return new DocumentOutlinePage();
        }
        if (adapter == IPropertySheetPage.class) {
            PropertySheetPage page = new PropertySheetPage();
            page.setPropertySourceProvider(new IPropertySourceProvider(){

                public IPropertySource getPropertySource(Object object) {
                    if (object instanceof IVexElement) {
                        IStructuredSelection sel = (IStructuredSelection)VexEditor.this.vexWidget.getSelection();
                        boolean multi = sel != null && sel.size() > 1;
                        Validator validator = VexEditor.this.vexWidget.getDocument().getValidator();
                        return new ElementPropertySource((IVexElement)object, validator, multi);
                    }
                    return null;
                }
            });
            return page;
        }
        return super.getAdapter(adapter);
    }

    protected void setDebugging(boolean debugging) {
        this.debugging = debugging;
    }

    public boolean isDebugging() {
        return this.debugging;
    }

    protected void setDoc(IVexDocument doc) {
        VexEditor.doc = doc;
    }

    public IVexDocument getDoc() {
        return doc;
    }

    protected void setUpdateDoctypeDecl(boolean updateDoctypeDecl) {
        this.updateDoctypeDecl = updateDoctypeDecl;
    }

    public boolean isUpdateDoctypeDecl() {
        return this.updateDoctypeDecl;
    }

    protected void setDoctype(DocumentType doctype) {
        this.doctype = doctype;
    }

    public DocumentType getDoctype() {
        return this.doctype;
    }

    protected void setSavedUndoDepth(int savedUndoDepth) {
        this.savedUndoDepth = savedUndoDepth;
    }

    public int getSavedUndoDepth() {
        return this.savedUndoDepth;
    }

    protected void setWasDirty(boolean wasDirty) {
        this.wasDirty = wasDirty;
    }

    public boolean isWasDirty() {
        return this.wasDirty;
    }

    public IRegion getSelectedSourceRegion() {
        IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
        IEditorPart part = page.getActiveEditor();
        ITextEditor editor = (ITextEditor)AdapterUtils.getAdapter((Object)part, ITextEditor.class);
        if (editor != null) {
            ITextSelection selection = (ITextSelection)editor.getSelectionProvider().getSelection();
            int length = selection.getLength();
            int offset = selection.getOffset();
            return new Region(offset, length);
        }
        if (this.getVexWidget() != null) {
            TextSelectionVex vexSelection = new TextSelectionVex((IVexWidget)this.getVexWidget());
            int startOffset = vexSelection.getSourceStartOffset();
            int endOffset = vexSelection.getSourceEndOffset();
            return new Region(startOffset, endOffset - startOffset);
        }
        return null;
    }

    public String getFilePathFromPluginForReading(String path) {
        String filepath = null;
        URL filep = Activator.getDefault().getBundle("net.sf.vex.editor").getEntry(path);
        try {
            filepath = FileLocator.resolve((URL)filep).getFile();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return filepath;
    }

    public String readFileForCSS(File file) {
        String out = null;
        try {
            BufferedReader reader = new BufferedReader(new FileReader(file));
            StringBuffer buffer = new StringBuffer();
            String line = null;
            while ((line = reader.readLine()) != null) {
                buffer.append(line);
                buffer.append("\n");
            }
            out = buffer.toString();
        }
        catch (IOException iOException) {}
        return out;
    }

    String getFileName() {
        FileDialog dialog = new FileDialog(this.getVexWidget().getShell(), 4096);
        String selectedFile = dialog.open();
        if (selectedFile == null) {
            return null;
        }
        if (selectedFile.indexOf(".css") == -1) {
            MessageBox messageBox = new MessageBox(this.getVexWidget().getShell(), 0);
            messageBox.setMessage("Please select a CSS file");
            messageBox.setText("Warning");
            messageBox.open();
            return null;
        }
        File file = new File(selectedFile);
        String filename = file.getPath();
        filename = filename.replace("\\", "/");
        return filename;
    }

    protected void setState(State state) {
        this.state = state;
    }

    class FontsButton
    extends ControlContribution {
        Button btn;
        IToolBarManager toolbarMgr;

        public FontsButton(String str, IToolBarManager toolbarMgr) {
            super(str);
            this.toolbarMgr = toolbarMgr;
        }

        protected Control createControl(Composite parent) {
            this.btn = new Button(parent, 0x80000C);
            this.btn.setText("Fonts");
            this.btn.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    FontsList fontsList = new FontsList(VexEditor.this.getVexWidget());
                    fontsList.getAllFonts();
                    FontsButton.this.toolbarMgr.update(true);
                }
            });
            return this.btn;
        }
    }

    class NoRegisteredDoctypeException
    extends RuntimeException {
        private final String publicId;

        public NoRegisteredDoctypeException(String publicId) {
            this.publicId = publicId;
        }

        public String getPublicId() {
            return this.publicId;
        }
    }

    class NoStyleForDoctypeException
    extends RuntimeException {
        private final DocumentType doctype;

        public NoStyleForDoctypeException(DocumentType doctype) {
            this.doctype = doctype;
        }

        public DocumentType getDoctype() {
            return this.doctype;
        }
    }

    private class ResourceChangeListener
    implements IResourceChangeListener {
        private boolean saving;

        private ResourceChangeListener() {
        }

        public void resourceChanged(IResourceChangeEvent event) {
            if (this.saving) {
                return;
            }
            IPath path = ((IFileEditorInput)VexEditor.this.getEditorInput()).getFile().getFullPath();
            final IResourceDelta delta = event.getDelta().findMember(path);
            if (delta != null) {
                Display.getDefault().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        VexEditor.this.handleResourceChanged(delta);
                    }
                });
            }
        }

        public void setSaving(boolean saving) {
            this.saving = saving;
        }
    }

    protected static enum State {
        UNLOADED,
        LOADING,
        LOADED;

    }

    class StyleSheetButton
    extends ControlContribution {
        Button btn;
        IToolBarManager toolbarMgr;

        public StyleSheetButton(String str, IToolBarManager toolbarMgr) {
            super(str);
            this.toolbarMgr = toolbarMgr;
        }

        protected Control createControl(Composite parent) {
            this.btn = new Button(parent, 0x80000C);
            this.btn.setText("Style");
            this.btn.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    String p = VexEditor.this.getFileName();
                    if (p != null) {
                        File f = new File(p);
                        String ssheet = VexEditor.this.readFileForCSS(f);
                        StyleSheet s = null;
                        try {
                            s = new StyleSheetReader().read(ssheet);
                            VexEditor.this.getVexWidget().setStyleSheet(s);
                        }
                        catch (CSSException e1) {
                            e1.printStackTrace();
                        }
                        catch (IOException e1) {
                            e1.printStackTrace();
                        }
                    }
                }
            });
            return this.btn;
        }
    }
}

