/*
 * Decompiled with CFR 0.152.
 */
package net.sf.vex.layout;

import info.textgrid.lab.core.swtutils.IntervalMultimap;
import java.text.MessageFormat;
import java.util.List;
import net.sf.vex.VexToolkitPlugin;
import net.sf.vex.core.ColorResource;
import net.sf.vex.core.FontMetrics;
import net.sf.vex.core.FontResource;
import net.sf.vex.core.Graphics;
import net.sf.vex.core.Rectangle;
import net.sf.vex.css.Styles;
import net.sf.vex.dom.IVexDocument;
import net.sf.vex.dom.IVexElement;
import net.sf.vex.dom.IVexNode;
import net.sf.vex.dom.IVexText;
import net.sf.vex.dom.linked.LinkedDocument;
import net.sf.vex.dom.linked.LinkedNode;
import net.sf.vex.layout.AnnotationRenderingInfo;
import net.sf.vex.layout.InlineBox;
import net.sf.vex.layout.LayoutContext;
import net.sf.vex.layout.TextBox;
import net.sf.vex.layout.VexAnnotationTracker;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Position;

public class DocumentTextBox
extends TextBox {
    private int startRelative;
    private int endRelative;

    public DocumentTextBox(LayoutContext context, IVexElement element, IVexText text) {
        this(context, element, text.getStartOffset(), text.getEndOffset());
    }

    public DocumentTextBox(LayoutContext context, IVexElement element, int startOffset, int endOffset) {
        super(element);
        this.init(context, element, startOffset, endOffset);
    }

    public DocumentTextBox(LayoutContext context, IVexNode node, Styles styles, int startOffset, int endOffset) {
        super(styles, node);
        this.init(context, node, startOffset, endOffset);
    }

    private void init(LayoutContext context, IVexNode node, int startOffset, int endOffset) {
        if (startOffset > endOffset) {
            throw new IllegalStateException("DocumentTextBox: startOffset (" + startOffset + ") >= endOffset (" + endOffset + ")");
        }
        this.startRelative = startOffset - node.getStartOffset();
        this.endRelative = endOffset - node.getStartOffset();
        this.calculateSize(context);
    }

    private int getNodeStartOffset() {
        int nodeStartOffset;
        IVexNode node = this.getNode();
        if (node instanceof IVexElement) {
            nodeStartOffset = ((IVexElement)node).getStartOffset();
        } else if (node instanceof LinkedNode) {
            nodeStartOffset = ((LinkedNode)node).getStartOffset();
        } else {
            throw new IllegalStateException("Model not expected, implement here!");
        }
        return nodeStartOffset;
    }

    @Override
    public int getEndOffset() {
        if (this.endRelative == -1) {
            return -1;
        }
        return this.getNodeStartOffset() + this.endRelative - 1;
    }

    @Override
    public int getStartOffset() {
        if (this.startRelative == -1) {
            return -1;
        }
        return this.getNodeStartOffset() + this.startRelative;
    }

    @Override
    public String getText() {
        IVexDocument doc;
        IVexNode node = this.getNode();
        if (node instanceof IVexElement) {
            doc = ((IVexElement)node).getDocument();
        } else if (node instanceof LinkedNode) {
            doc = ((LinkedNode)node).getDocument();
        } else {
            throw new IllegalStateException("Model not expected, implement here!");
        }
        return doc.getText(this.getStartOffset(), this.getEndOffset() + 1);
    }

    @Override
    public boolean hasContent() {
        return true;
    }

    @Override
    public void paint(LayoutContext context, int x, int y, Rectangle area) {
        String s;
        Styles styles = this.getStyles(context);
        Graphics g = context.getGraphics();
        FontResource font = g.createFont(styles.getFont());
        FontResource oldFont = g.setFont(font);
        ColorResource foreground = g.createColor(styles.getColor());
        ColorResource oldForeground = g.setColor(foreground);
        char[] chars = this.getText().toCharArray();
        int absStart = this.getStartOffset();
        if (chars.length < this.getEndOffset() - this.getStartOffset()) {
            throw new IllegalStateException(MessageFormat.format("DocumentTextBox has less chars ({0}: \"{1}\") than it should ({2}-{3}={4}", chars.length, this.getText(), this.getEndOffset(), absStart, this.getEndOffset() - absStart));
        }
        if (chars.length == 0) {
            return;
        }
        int end = chars.length;
        if (DocumentTextBox.isNewline(chars[end - 1])) {
            --end;
        }
        int selStart = context.getSelectionStart() - this.getStartOffset();
        selStart = Math.min(Math.max(selStart, 0), end);
        int selEnd = context.getSelectionEnd() - this.getStartOffset();
        selEnd = Math.min(Math.max(selEnd, 0), end);
        if (selStart > 0) {
            g.drawChars(chars, 0, selStart - 0, x, y);
            s = new String(chars, 0, selStart - 0);
            this.paintTextDecoration(context, styles, s, absStart + 0, absStart + selStart, x, y);
        }
        if (selEnd < end) {
            int x1 = x + g.charsWidth(chars, 0, selEnd);
            g.drawChars(chars, selEnd, end - selEnd, x1, y);
            String s2 = new String(chars, selEnd, end - selEnd);
            this.paintTextDecoration(context, styles, s2, absStart + selEnd, absStart + end, x1, y);
        }
        if (selStart < selEnd) {
            s = new String(chars, selStart, selEnd - selStart);
            int x1 = x + g.charsWidth(chars, 0, selStart);
            this.paintSelectedText(context, s, x1, y);
            this.paintTextDecoration(context, styles, s, absStart + selStart, absStart + selEnd, x1, y);
        }
        g.setFont(oldFont);
        g.setColor(oldForeground);
        font.dispose();
        foreground.dispose();
    }

    @Override
    protected void paintTextAnnotations(LayoutContext context, int startOffset, int endOffset, String s, int x, int y, Graphics g, FontMetrics fm) {
        if (!VexToolkitPlugin.getDefault().getPreferenceStore().getBoolean("textAnnotations")) {
            return;
        }
        IntervalMultimap.Interval contentInterval = IntervalMultimap.Interval.of((int)startOffset, (int)endOffset);
        List<AnnotationRenderingInfo> renderingInfo = VexAnnotationTracker.getRenderingInfo(context, (IRegion)contentInterval);
        if (this.getElement() != null && this.getElement().getDocument() instanceof LinkedDocument) {
            LinkedDocument linkedDocument = (LinkedDocument)this.getElement().getDocument();
            for (AnnotationRenderingInfo rendering : renderingInfo) {
                int annoEndOffset;
                if (!rendering.isShownInText()) continue;
                Position annoContentPosition = rendering.getPositionIn(linkedDocument);
                int annoStartOffset = Math.max(annoContentPosition.offset, startOffset);
                if (annoStartOffset > (annoEndOffset = Math.min(annoContentPosition.offset + annoContentPosition.length, endOffset))) {
                    return;
                }
                String preText = linkedDocument.getText(startOffset, annoStartOffset);
                int startX = x + g.stringWidth(preText);
                String annotatedText = linkedDocument.getText(annoStartOffset, annoEndOffset);
                int lineWidth = fm.getAscent() / 12;
                int ypos = y + fm.getAscent() + lineWidth;
                ColorResource oldColor = g.getColor();
                ColorResource color = g.createColor(rendering.getColor());
                this.paintBaseLine(g, annotatedText, startX, ypos);
                if (VexToolkitPlugin.isDebugging("net.sf.vex.toolkit/debug/annotations")) {
                    System.out.println(MessageFormat.format("s = |{0}|, |{1}+{2}| ", s, preText, annotatedText));
                }
                g.setColor(oldColor);
                color.dispose();
            }
        }
    }

    @Override
    public InlineBox.Pair splitAt(LayoutContext context, int offset) {
        if (offset < 0 || offset > this.endRelative - this.startRelative) {
            throw new IllegalStateException();
        }
        int split = this.getStartOffset() + offset;
        DocumentTextBox left = offset == 0 ? null : new DocumentTextBox(context, this.getNode(), this.getStyles(context), this.getStartOffset(), split);
        DocumentTextBox right = split == this.getEndOffset() + 1 ? null : new DocumentTextBox(context, this.getNode(), this.getStyles(context), split, this.getEndOffset() + 1);
        return new InlineBox.Pair(left, right);
    }

    @Override
    public int viewToModel(LayoutContext context, int x, int y) {
        int newDelta;
        Graphics g = context.getGraphics();
        Styles styles = this.getStyles(context);
        FontResource font = g.createFont(styles.getFont());
        FontResource oldFont = g.setFont(font);
        char[] chars = this.getText().toCharArray();
        if (this.getWidth() <= 0) {
            return this.getStartOffset();
        }
        int offset = x / this.getWidth() * chars.length;
        offset = Math.max(0, offset);
        offset = Math.min(chars.length, offset);
        int delta = Math.abs(x - g.charsWidth(chars, 0, offset));
        while (offset > 0) {
            newDelta = Math.abs(x - g.charsWidth(chars, 0, offset - 1));
            if (newDelta > delta) break;
            delta = newDelta;
            --offset;
        }
        while (offset < chars.length - 1) {
            newDelta = Math.abs(x - g.charsWidth(chars, 0, offset + 1));
            if (newDelta > delta) break;
            delta = newDelta;
            ++offset;
        }
        g.setFont(oldFont);
        font.dispose();
        return this.getStartOffset() + offset;
    }
}

