/*
 * Decompiled with CFR 0.152.
 */
package info.textgrid.lab.core.efs.tgcrud;

import info.textgrid.lab.authn.RBACSession;
import info.textgrid.lab.core.efs.tgcrud.Activator;
import info.textgrid.lab.core.efs.tgcrud.CloseExceptionHandler;
import info.textgrid.lab.core.efs.tgcrud.ExceptionPassingPipedInputStream;
import info.textgrid.lab.core.efs.tgcrud.ExceptionPassingPipedOutputStream;
import info.textgrid.lab.core.efs.tgcrud.LoggingInputStream;
import info.textgrid.lab.core.efs.tgcrud.TGDummyParent;
import info.textgrid.lab.core.model.CrudServiceException;
import info.textgrid.lab.core.model.TGContentType;
import info.textgrid.lab.core.model.TextGridObject;
import info.textgrid.lab.core.model.util.LongOperation;
import info.textgrid.lab.core.model.util.ModelUtil;
import info.textgrid.lab.core.swtutils.LogUtil;
import info.textgrid.lab.core.tgcrud.client.CrudClientUtilities;
import info.textgrid.lab.log.logsession;
import info.textgrid.namespaces.metadata.core._2010.MetadataContainerType;
import info.textgrid.namespaces.metadata.core._2010.ObjectFactory;
import info.textgrid.namespaces.metadata.core._2010.ObjectType;
import info.textgrid.namespaces.middleware.tgcrud.services.tgcrudservice.AuthFault;
import info.textgrid.namespaces.middleware.tgcrud.services.tgcrudservice.DeleteType;
import info.textgrid.namespaces.middleware.tgcrud.services.tgcrudservice.IoFault;
import info.textgrid.namespaces.middleware.tgcrud.services.tgcrudservice.MetadataParseFault;
import info.textgrid.namespaces.middleware.tgcrud.services.tgcrudservice.ObjectNotFoundFault;
import info.textgrid.namespaces.middleware.tgcrud.services.tgcrudservice.ProtocolNotImplementedFault;
import info.textgrid.namespaces.middleware.tgcrud.services.tgcrudservice.ReadType;
import info.textgrid.namespaces.middleware.tgcrud.services.tgcrudservice.RelationsExistFault;
import info.textgrid.namespaces.middleware.tgcrud.services.tgcrudservice.TGCrudService;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.rmi.RemoteException;
import java.text.MessageFormat;
import java.util.Calendar;
import javax.activation.DataHandler;
import javax.xml.ws.Holder;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileInfo;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.filesystem.provider.FileInfo;
import org.eclipse.core.filesystem.provider.FileStore;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.osgi.util.NLS;
import org.eclipse.ui.statushandlers.StatusManager;

public class TGFileStore
extends FileStore
implements IFileStore {
    IFileInfo cachedFileInfo = null;
    URI efsUri;
    private final String cxfUri;
    private final URI textGridURI;

    public TGFileStore(URI uri) throws CoreException {
        this.efsUri = uri;
        this.textGridURI = TextGridObject.computeTextGridURI((URI)uri);
        this.cxfUri = this.textGridURI.toASCIIString().trim();
    }

    public String[] childNames(int options, IProgressMonitor monitor) throws CoreException {
        return new String[0];
    }

    public synchronized IFileInfo fetchInfo(int options, IProgressMonitor monitor) throws CoreException {
        if (this.cachedFileInfo == null) {
            this.cachedFileInfo = this.readFileInfo(monitor);
        }
        return this.cachedFileInfo;
    }

    protected FileInfo readFileInfo(IProgressMonitor monitor) throws CoreException {
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        monitor.beginTask(NLS.bind((String)"Getting some metadata for {0}", (Object)this.efsUri), 6);
        URI textgridUri = TextGridObject.computeTextGridURI((URI)this.efsUri);
        TextGridObject object = TextGridObject.getInstance((URI)textgridUri, (boolean)true);
        monitor.worked(2);
        FileInfo fileInfo = new FileInfo();
        fileInfo.setExists(true);
        fileInfo.setLastModified(object.getLastModified().getTimeInMillis());
        monitor.worked(1);
        fileInfo.setDirectory(false);
        fileInfo.setLength(object.getSize());
        monitor.worked(1);
        fileInfo.setName(this.efsUri.toString());
        monitor.worked(1);
        if (object.isToOpenAsReadOnly()) {
            fileInfo.setAttribute(2, true);
        }
        monitor.done();
        return fileInfo;
    }

    public void putInfo(IFileInfo info, int options, IProgressMonitor monitor) throws CoreException {
        super.putInfo(info, options, monitor);
        this.invalidateFileInfoCache();
    }

    protected synchronized void invalidateFileInfoCache() {
        this.cachedFileInfo = null;
    }

    public IFileStore getChild(String name) {
        return null;
    }

    public String getName() {
        return this.efsUri.toString();
    }

    public IFileStore getParent() {
        return new TGDummyParent(this);
    }

    public InputStream openInputStream(final int options, IProgressMonitor monitor) throws CoreException {
        if (Activator.isDebugging("info.textgrid.lab.core.efs.tgcrud/debug/reads")) {
            StatusManager.getManager().handle(new CoreException((IStatus)new Status(1, "info.textgrid.lab.core.efs.tgcrud", NLS.bind((String)"Reading from {0}", (Object)this.cxfUri))), "info.textgrid.lab.core.efs.tgcrud");
        }
        return (InputStream)new LongOperation<InputStream>(){

            public InputStream run(IProgressMonitor monitor) throws CoreException {
                return TGFileStore.this.doOpenInputStream(options, monitor);
            }
        }.runInJob(monitor, NLS.bind((String)"Reading from {0} ...", (Object)this.getTextGridObject()));
    }

    protected InputStream doOpenInputStream(int options, IProgressMonitor monitor) throws CoreException {
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        monitor.beginTask(NLS.bind((String)"Opening {0} for input", (Object)this.getTextGridObject()), -1);
        ModelUtil.checkNonUIThread((String)"Tried to open an input stream for {0} from an UI thread", (Object[])new Object[]{this.getTextGridObject()});
        ReadType readType = new ReadType();
        String logInfo = logsession.getInstance().getloginfo();
        readType.setLogParameter(logInfo);
        String sid = RBACSession.getInstance().getSID(false);
        readType.setSessionId(sid);
        readType.setUri(this.cxfUri);
        try {
            Holder metadataHolder = new Holder();
            metadataHolder.value = new ObjectFactory().createMetadataContainerType();
            Holder dataHandler = new Holder();
            TGCrudService crudServiceStub = CrudClientUtilities.getCrudServiceStub();
            Activator.logServiceCall("Calling TGcrud#read({0}, {1}, {2}) (from TGFileStore#openInputStream)", logInfo, sid, this.efsUri);
            try {
                crudServiceStub.read(sid, logInfo, this.cxfUri, metadataHolder, dataHandler);
            }
            catch (ProtocolNotImplementedFault e) {
                e.printStackTrace();
            }
            Activator.logServiceCall("... succeeded: TGcrud#read(..., {0})", this.efsUri);
            TextGridObject textGridObject = TextGridObject.getInstance((ObjectType)((MetadataContainerType)metadataHolder.value).getObject(), (boolean)true, (boolean)true);
            textGridObject.refreshWorkspaceIfNeccessary();
            DataHandler data = (DataHandler)dataHandler.value;
            if (data != null) {
                LoggingInputStream loggingInputStream = new LoggingInputStream(data.getInputStream(), new LogUtil("info.textgrid.lab.core.efs.tgcrud"));
                return loggingInputStream;
            }
            LoggingInputStream loggingInputStream = new LoggingInputStream(new ByteArrayInputStream(new byte[0]), new LogUtil("info.textgrid.lab.core.efs.tgcrud"));
            return loggingInputStream;
        }
        catch (RemoteException e) {
            throw new CrudServiceException((Throwable)e, this.textGridURI);
        }
        catch (ObjectNotFoundFault e) {
            throw new CrudServiceException((Throwable)e, this.textGridURI);
        }
        catch (IoFault e) {
            throw new CrudServiceException((Throwable)e, this.textGridURI);
        }
        catch (AuthFault e) {
            throw new CrudServiceException((Throwable)e, this.textGridURI);
        }
        catch (IOException e) {
            throw new CrudServiceException((Throwable)e, this.textGridURI);
        }
        catch (MetadataParseFault e) {
            throw new CrudServiceException((Throwable)e, this.textGridURI);
        }
        finally {
            monitor.done();
        }
    }

    public OutputStream openOutputStream(int options, IProgressMonitor monitor) throws CoreException {
        if ((options & 1) != 0) {
            throw new CoreException((IStatus)new Status(4, "info.textgrid.lab.core.efs.tgcrud", NLS.bind((String)"Appending is not implemented in TextGrid ({0})", (Object)this.efsUri)));
        }
        final TextGridObject textGridObject = this.getTextGridObject();
        if (textGridObject.getPreparedNewVersion() != null) {
            return this.openNewVersionOutputStream(options, monitor, textGridObject);
        }
        if (textGridObject.getPreparedNewRevision() != null) {
            return this.openNewRevisionOutputStream(options, monitor, textGridObject);
        }
        textGridObject.assertPermission(4, "Access denied: You are not allowed to update {0}.", new Object[]{textGridObject});
        try {
            ExceptionPassingPipedOutputStream outputStream = new ExceptionPassingPipedOutputStream();
            final ExceptionPassingPipedInputStream inputStream = new ExceptionPassingPipedInputStream(outputStream);
            outputStream.setBlockingClose(true);
            outputStream.setCloseExceptionHandler(new CloseExceptionHandler(this, "Save (update) failed"));
            Thread serviceThread = new Thread(){

                /*
                 * Exception decompiling
                 */
                @Override
                public void run() {
                    /*
                     * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
                     * 
                     * org.benf.cfr.reader.util.ConfusedCFRException: Started 6 blocks at once
                     *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
                     *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
                     *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
                     *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
                     *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
                     *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
                     *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
                     *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
                     *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
                     *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
                     *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
                     *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
                     *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
                     *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
                     *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
                     *     at org.benf.cfr.reader.Main.main(Main.java:54)
                     */
                    throw new IllegalStateException("Decompilation failed");
                }
            };
            serviceThread.setName(MessageFormat.format("Updating {0} in the TextGridRep", this.getName()));
            serviceThread.start();
            return outputStream;
        }
        catch (IOException e) {
            throw new CoreException(Activator.handleError(e, MessageFormat.format("Could not open an output stream for {0}: {1}", textGridObject, e.getMessage()), e));
        }
    }

    private OutputStream openNewVersionOutputStream(int options, IProgressMonitor monitor, TextGridObject textGridObject) throws CoreException {
        TextGridObject newVersion = textGridObject.getPreparedNewVersion();
        Assert.isNotNull((Object)newVersion, (String)NLS.bind((String)"There is no prepared new version for {0}.", (Object)textGridObject));
        IFileStore newVersionStore = EFS.getStore((URI)newVersion.getEFSURI());
        textGridObject.cancelNewVersion();
        return newVersionStore.openOutputStream(options, monitor);
    }

    private OutputStream openNewRevisionOutputStream(int options, IProgressMonitor monitor, TextGridObject textGridObject) throws CoreException {
        TextGridObject newRevision = textGridObject.getPreparedNewRevision();
        Assert.isNotNull((Object)newRevision, (String)NLS.bind((String)"There is no prepared new revision for {0}.", (Object)textGridObject));
        IFileStore newRevisionStore = EFS.getStore((URI)newRevision.getEFSURI());
        textGridObject.cancelNewRevision();
        return newRevisionStore.openOutputStream(options, monitor);
    }

    protected IOException newIOException(Throwable cause, String message, Object ... args) {
        IOException e = message != null ? new IOException(MessageFormat.format(message, args), cause) : (cause != null ? new IOException(MessageFormat.format("An error ({0}) occurred during input/output handling for {1}: {2}", cause.getClass().getSimpleName(), this.getName(), cause.getLocalizedMessage()), cause) : new IOException(MessageFormat.format("An unknown error occured during input/output handling for {0}. Please scold the programmer for not providing more details.", this.getName())));
        return e;
    }

    public URI toURI() {
        return this.efsUri;
    }

    public void delete(int options, IProgressMonitor monitor) throws CoreException {
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        monitor.beginTask(NLS.bind((String)"Deleting {0}", (Object)this.efsUri), 6);
        String logInfo = logsession.getInstance().getloginfo();
        String rbacSession = RBACSession.getInstance().getSID(true);
        ModelUtil.checkNonUIThread((String)"Deleting {0} from an UI-Thread", (Object[])new Object[]{this.getTextGridObject()});
        if (this.getTextGridObject().isComplete()) {
            this.getTextGridObject().assertPermission(8, "Access denied: You are not allowed to delete {0}", new Object[]{this.getTextGridObject()});
        }
        DeleteType deleteType = new DeleteType();
        deleteType.setLogParameter(logInfo);
        deleteType.setSessionId(rbacSession);
        try {
            Activator.logServiceCall("Calling TGCrudServiceStub#delete({0}, {1}, {2}) ...", deleteType.getLogParameter(), deleteType.getSessionId(), this.cxfUri);
            TGCrudService crudServiceStub = CrudClientUtilities.getCrudServiceStub();
            crudServiceStub.delete(rbacSession, logInfo, this.cxfUri);
            monitor.worked(1);
            Activator.logServiceCall("... delete({0}) succeeded", this.efsUri);
            monitor.worked(5);
        }
        catch (ObjectNotFoundFault e) {
            throw new CrudServiceException((Throwable)e, this.textGridURI);
        }
        catch (RelationsExistFault e) {
            throw new CrudServiceException((Throwable)e, this.textGridURI);
        }
        catch (IoFault e) {
            throw new CrudServiceException((Throwable)e, this.textGridURI);
        }
        catch (AuthFault e) {
            throw new CrudServiceException((Throwable)e, this.textGridURI);
        }
        monitor.done();
    }

    public boolean isParentOf(IFileStore other) {
        return false;
    }

    public synchronized void updateMetadata(ObjectType element) throws CrudServiceException {
        URI textgridUri = TextGridObject.computeTextGridURI((URI)this.efsUri);
        TextGridObject.getInstance((URI)textgridUri, (boolean)false).setMetadata(element);
        this.invalidateFileInfoCache();
    }

    public TextGridObject getTextGridObject() throws CrudServiceException {
        URI textgridUri = TextGridObject.computeTextGridURI((URI)this.efsUri);
        return TextGridObject.getInstance((URI)textgridUri, (boolean)false);
    }

    public File toLocalFile(int options, IProgressMonitor monitor) throws CoreException {
        File cacheFolder;
        if ((options & 0x1000) == 0) {
            if (Activator.isDebugging("info.textgrid.lab.core.efs.tgcrud/debug/localfile")) {
                System.out.println(MessageFormat.format("not caching {0} -- missing CACHE option", this.getTextGridObject()));
            }
            return null;
        }
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (String)NLS.bind((String)"Creating local copy for {0}", (Object)this.getTextGridObject()), (int)100);
        if (Activator.isDebugging("info.textgrid.lab.core.efs.tgcrud/debug/localfile")) {
            System.out.println(MessageFormat.format("Caching {0} ...", this.getTextGridObject()));
        }
        if (!(cacheFolder = Activator.getDefault().getStateLocation().append("cache").toFile()).exists()) {
            cacheFolder.mkdirs();
        }
        progress.worked(10);
        String localFileName = this.getTextGridObject().getURI().toASCIIString().replaceAll("[%:/\\*?\"<>|]", "_");
        TGContentType contentType = this.getTextGridObject().getContentType(false);
        if (contentType != null) {
            localFileName = String.valueOf(localFileName) + "." + contentType.getExtension();
        }
        progress.worked(10);
        if (progress.isCanceled()) {
            return null;
        }
        File localFile = new File(cacheFolder, localFileName);
        progress.worked(10);
        if (localFile.exists()) {
            if (Activator.isDebugging("info.textgrid.lab.core.efs.tgcrud/debug/localfile")) {
                System.out.print(MessageFormat.format("  Local file {0} exists", localFile.getName()));
            }
            Calendar remoteLastModified = this.getTextGridObject().getLastModified();
            Calendar localLastModified = Calendar.getInstance();
            localLastModified.setTimeInMillis(localFile.lastModified() + 2000L);
            if (!localLastModified.before(remoteLastModified)) {
                if (Activator.isDebugging("info.textgrid.lab.core.efs.tgcrud/debug/localfile")) {
                    System.out.println(" and is up to date. No download.");
                }
                return localFile;
            }
        }
        progress.worked(20);
        if (progress.isCanceled()) {
            return null;
        }
        if (Activator.isDebugging("info.textgrid.lab.core.efs.tgcrud/debug/localfile")) {
            System.out.print(MessageFormat.format("  Downloading to {0} ... ", localFile.getName()));
        }
        IFileStore localFileStore = EFS.getLocalFileSystem().fromLocalFile(localFile);
        try {
            this.copy(localFileStore, 2, (IProgressMonitor)progress.newChild(45));
            localFile.setLastModified(this.getTextGridObject().getLastModified().getTimeInMillis());
            if (Activator.isDebugging("info.textgrid.lab.core.efs.tgcrud/debug/localfile")) {
                System.out.println("sucess.");
            }
        }
        finally {
            localFile.deleteOnExit();
            progress.worked(5);
        }
        return localFile;
    }
}

