/*
 * Decompiled with CFR 0.152.
 */
package info.textgrid.lab.search.ui.views;

import info.textgrid.lab.authn.AuthBrowser;
import info.textgrid.lab.authn.RBACSession;
import info.textgrid.lab.core.model.TextGridProject;
import info.textgrid.lab.newsearch.SearchRequest;
import info.textgrid.lab.search.ui.Activator;
import info.textgrid.lab.search.ui.SearchLabelIcon;
import info.textgrid.lab.search.ui.SearchUICalendar;
import info.textgrid.lab.search.ui.newsearch.BaselineEncodingMainArea;
import info.textgrid.lab.search.ui.newsearch.FulltextMainArea;
import info.textgrid.lab.search.ui.newsearch.MajorSearchLanguages;
import info.textgrid.lab.search.ui.newsearch.MetadataMainArea;
import info.textgrid.lab.search.ui.newsearch.SearchContentType;
import info.textgrid.lab.search.ui.newsearch.SearchTextType;
import info.textgrid.lab.search.ui.newsearch.SearchTreeContentProvider;
import info.textgrid.lab.search.ui.views.Messages;
import info.textgrid.lab.search.ui.views.ResultView;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.NotEnabledException;
import org.eclipse.core.commands.NotHandledException;
import org.eclipse.core.commands.common.NotDefinedException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTreeViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.commands.ICommandService;
import org.eclipse.ui.dialogs.ContainerCheckedTreeViewer;
import org.eclipse.ui.part.ViewPart;

public class SearchView
extends ViewPart {
    private static SearchView searchView;
    private Composite mainComposite;
    private TabFolder folder;
    private Text simpleSearchText;
    private Text advancedSearchText;
    private Button simpleSearchButton;
    private Button rbSearchFulltext;
    private Button rbSearchMetadata;
    private Button rbSearchBoth;
    private Button cbMetadata;
    private Button cbFulltext;
    private Button cbBaselineEnc;
    private Button advancedSearchButton;
    private Button rbWordDistanceDocument;
    private Button rbWordDistanceWords;
    private Button rbEndpointStandard;
    private Button rbEndpointPublic;
    private SearchLabelIcon sliMetadata;
    private SearchLabelIcon sliFullText;
    private SearchLabelIcon sliBaseline;
    private SearchLabelIcon sliTextTypes;
    private SearchLabelIcon sliContentTypes;
    private SearchLabelIcon sliLanguages;
    private SearchLabelIcon sliDate;
    private SearchLabelIcon sliWordDistances;
    private Label simpleSearchExample;
    private Button cbDateBetween;
    private Text textFromDate;
    private Text textToDate;
    private Label ilFromDate;
    private Label ilToDate;
    private CheckboxTreeViewer textTypeTree;
    private CheckboxTreeViewer contentTypeTree;
    private ContainerCheckedTreeViewer languageTree;
    private ScrolledComposite scrolledComposite;
    private Composite compAdvancedSearch;
    private Composite compAdvancedSearch1;
    private MetadataMainArea metaDataMainArea;
    private FulltextMainArea fulltextMainArea;
    private BaselineEncodingMainArea baselineEncodingDataMainArea;
    private Font italicFont;
    private Font italicSmallFont;
    private ResultView resultView;
    private SearchTextType searchTextType;
    private SearchContentType searchContentType;
    private MajorSearchLanguages mainLanguages;
    private SearchRequest searchRequest;
    private Listener hitCountListener = null;
    private Listener partSearchReadyListener = null;
    private Spinner wordDistanceSpinner;
    private ArrayList<TextGridProject> regardedMetadataProjects = new ArrayList();
    String[] header = new String[]{Messages.SearchView_SimpleSearch, Messages.SearchView_AdvancedSearch, Messages.SearchView_XPath, Messages.SearchView_Browse};
    protected static final String ERROR_INVALID_DATE_FORMAT = "Invalid date format. The format should be yyyy-mm-dd or just yyyy.";
    protected static final String ERROR_INVALID_ORDER = "The chronological date order is incorrect.";
    protected static final String ERROR_EMPTY_SEARCH = "There is not enough information to start a search.";
    protected static final String HELP_LINK_SEARCH = "/info.textgrid.lab.help/html/labSearch/toc.html";
    private AuthBrowser.ISIDChangedListener sidChangedListener;
    private Group epComposite;

    public void createPartControl(Composite parent) {
        searchView = this;
        this.mainComposite = new Composite(parent, 2048);
        this.mainComposite.setLayout((Layout)new GridLayout(1, false));
        this.createEndpointArea(this.mainComposite);
        this.folder = new TabFolder(this.mainComposite, 2048);
        this.folder.setLayoutData((Object)new GridData(4, 4, true, true));
        int i = 0;
        while (i <= this.header.length - 3) {
            TabItem item = new TabItem(this.folder, 8);
            item.setText(this.header[i]);
            ++i;
        }
        this.createSimpleSearchControl();
        this.createAdvancedSearchControl();
        this.folder.setSelection(this.folder.getItem(0));
        this.simpleSearchText.forceFocus();
        this.sliMetadata.open();
        this.resizeScrolledComposite();
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, "info.textgrid.lab.search.ui.SearchView");
        if (RBACSession.getInstance().getSID(false).equals("")) {
            System.out.println(11111);
            this.rbEndpointStandard.setEnabled(false);
            this.rbEndpointPublic.setSelection(true);
            this.rbEndpointStandard.setSelection(false);
        }
        this.sidChangedListener = new AuthBrowser.ISIDChangedListener(){

            public void sidChanged(String newSID, String newEPPN) {
                if (!newEPPN.equalsIgnoreCase("")) {
                    SearchView.this.rbEndpointStandard.setEnabled(true);
                    SearchView.this.rbEndpointPublic.setSelection(false);
                    SearchView.this.rbEndpointStandard.setSelection(true);
                } else {
                    SearchView.this.rbEndpointStandard.setEnabled(false);
                    SearchView.this.rbEndpointPublic.setSelection(true);
                    SearchView.this.rbEndpointStandard.setSelection(false);
                }
                SearchView.this.rbEndpointStandard.update();
                SearchView.this.rbEndpointStandard.redraw();
            }
        };
        AuthBrowser.addSIDChangedListener((AuthBrowser.ISIDChangedListener)this.sidChangedListener);
    }

    public static final SearchView getInstance() {
        return searchView;
    }

    public void resizeScrolledComposite() {
        this.scrolledComposite.setMinSize(this.scrolledComposite.getContent().computeSize(-1, -1));
    }

    private void createSimpleSearchControl() {
        Composite composite = new Composite((Composite)this.folder, 4);
        this.folder.getItem(0).setControl((Control)composite);
        composite.setLayout((Layout)new GridLayout(3, false));
        GridData gd1 = new GridData(4, 4, true, false);
        composite.setLayoutData((Object)gd1);
        this.simpleSearchText = new Text(composite, 2948);
        this.simpleSearchText.setText("");
        GridData gdSearchText = new GridData(4, 2, true, false);
        gdSearchText.horizontalSpan = 3;
        this.simpleSearchText.setLayoutData((Object)gdSearchText);
        this.simpleSearchText.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent event) {
                if (event.character == '\r') {
                    SearchView.this.startSimpleSearch();
                }
            }
        });
        this.simpleSearchText.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                if (e.detail == 512) {
                    SearchView.this.startSimpleSearch();
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.rbSearchFulltext = new Button(composite, 16);
        this.rbSearchFulltext.setText(Messages.SearchView_SearchFulltext);
        this.rbSearchMetadata = new Button(composite, 16);
        this.rbSearchMetadata.setText(Messages.SearchView_SearchMetadata);
        this.rbSearchBoth = new Button(composite, 16);
        this.rbSearchBoth.setText(Messages.SearchView_SearchBoth);
        this.rbSearchBoth.setSelection(true);
        this.simpleSearchExample = new Label(composite, 0);
        this.simpleSearchExample.setText(Messages.SearchView_ExampleString);
        FontData fontData = this.simpleSearchExample.getFont().getFontData()[0];
        this.italicFont = new Font((Device)Display.getDefault(), new FontData(fontData.getName(), fontData.getHeight(), 2));
        this.italicSmallFont = new Font((Device)Display.getDefault(), new FontData(fontData.getName(), fontData.getHeight() - 2, 2));
        this.simpleSearchExample.setFont(this.italicFont);
        this.simpleSearchExample.setForeground(Display.getDefault().getSystemColor(16));
        GridData gdSearchExample = new GridData(4, 2, true, false);
        gdSearchExample.horizontalSpan = 3;
        gdSearchExample.horizontalIndent = 10;
        this.simpleSearchExample.setLayoutData((Object)gdSearchExample);
        this.simpleSearchButton = new Button(composite, 8);
        this.simpleSearchButton.setText(Messages.SearchView_SearchButtonLabel);
        this.simpleSearchButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                SearchView.this.startSimpleSearch();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
        GridData gdSSB = new GridData(3, 3, false, false);
        gdSSB.horizontalSpan = 3;
        this.simpleSearchButton.setLayoutData((Object)gdSSB);
        Link helplink = new Link(composite, 0);
        helplink.setText(Messages.SearchView_LinkLabel);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)helplink, "info.textgrid.lab.search.ui.SearchHints");
        helplink.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                this.widgetDefaultSelected(e);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                ICommandService commandService = (ICommandService)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getService(ICommandService.class);
                try {
                    commandService.getCommand("org.eclipse.ui.help.dynamicHelp").executeWithChecks(new ExecutionEvent());
                }
                catch (ExecutionException e1) {
                    Status status = new Status(4, "info.textgrid.lab.search.ui", Messages.SearchView_EM_OpenHelp1, (Throwable)e1);
                    Activator.getDefault().getLog().log((IStatus)status);
                }
                catch (NotDefinedException e1) {
                    Status status = new Status(4, "info.textgrid.lab.search.ui", Messages.SearchView_EM_OpenHelp1, (Throwable)e1);
                    Activator.getDefault().getLog().log((IStatus)status);
                }
                catch (NotEnabledException e1) {
                    Status status = new Status(4, "info.textgrid.lab.search.ui", Messages.SearchView_EM_OpenHelp1, (Throwable)e1);
                    Activator.getDefault().getLog().log((IStatus)status);
                }
                catch (NotHandledException e1) {
                    Status status = new Status(4, "info.textgrid.lab.search.ui", Messages.SearchView_EM_OpenHelp1, (Throwable)e1);
                    Activator.getDefault().getLog().log((IStatus)status);
                }
            }
        });
        GridData gdSHL = new GridData(3, 3, false, false);
        gdSHL.horizontalSpan = 3;
        helplink.setLayoutData((Object)gdSHL);
    }

    private void createAdvancedSearchControl() {
        this.scrolledComposite = new ScrolledComposite((Composite)this.folder, 772);
        this.scrolledComposite.setExpandHorizontal(true);
        this.scrolledComposite.setExpandVertical(true);
        this.folder.getItem(1).setControl((Control)this.scrolledComposite);
        this.scrolledComposite.setLayout((Layout)new FillLayout());
        this.scrolledComposite.getVerticalBar().setIncrement(10);
        this.scrolledComposite.getHorizontalBar().setIncrement(10);
        this.compAdvancedSearch = new Composite((Composite)this.scrolledComposite, 4);
        this.scrolledComposite.setContent((Control)this.compAdvancedSearch);
        GridLayout gl = new GridLayout(2, false);
        this.compAdvancedSearch.setLayout((Layout)gl);
        this.compAdvancedSearch1 = new Composite(this.compAdvancedSearch, 4);
        GridLayout gl1 = new GridLayout(1, false);
        this.compAdvancedSearch1.setLayout((Layout)gl1);
        GridData gd1 = new GridData(4, 4, true, true);
        this.compAdvancedSearch1.setLayoutData((Object)gd1);
        GridData gdRadioButtonComposite = new GridData(1, 1, false, false);
        gdRadioButtonComposite.horizontalSpan = 2;
        gdRadioButtonComposite.verticalIndent = 15;
        this.createMetadataArea();
        Label seperator1 = new Label(this.compAdvancedSearch1, 258);
        GridData gdSeperator = new GridData(4, 1, true, false);
        seperator1.setLayoutData((Object)gdSeperator);
        this.createFulltextArea(this.compAdvancedSearch1);
        Label seperator2 = new Label(this.compAdvancedSearch1, 266);
        seperator2.setLayoutData((Object)gdSeperator);
        this.advancedSearchButton = new Button(this.compAdvancedSearch1, 8);
        this.advancedSearchButton.setText(Messages.SearchView_SearchButtonLabel);
        this.advancedSearchButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                SearchView.this.startAdvancedSearch();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
        GridData gdASB = new GridData(3, 3, false, false);
        gdASB.horizontalSpan = 2;
        this.advancedSearchButton.setLayoutData((Object)gdASB);
        Link helplink = new Link(this.compAdvancedSearch1, 0);
        helplink.setText(Messages.SearchView_LinkLabel);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)helplink, "info.textgrid.lab.search.ui.SearchHints");
        helplink.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                this.widgetDefaultSelected(e);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                ICommandService commandService = (ICommandService)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getService(ICommandService.class);
                try {
                    commandService.getCommand("org.eclipse.ui.help.dynamicHelp").executeWithChecks(new ExecutionEvent());
                }
                catch (ExecutionException e1) {
                    Status status = new Status(4, "info.textgrid.lab.search.ui", Messages.SearchView_EM_OpenHelp1, (Throwable)e1);
                    Activator.getDefault().getLog().log((IStatus)status);
                }
                catch (NotDefinedException e1) {
                    Status status = new Status(4, "info.textgrid.lab.search.ui", Messages.SearchView_EM_OpenHelp1, (Throwable)e1);
                    Activator.getDefault().getLog().log((IStatus)status);
                }
                catch (NotEnabledException e1) {
                    Status status = new Status(4, "info.textgrid.lab.search.ui", Messages.SearchView_EM_OpenHelp1, (Throwable)e1);
                    Activator.getDefault().getLog().log((IStatus)status);
                }
                catch (NotHandledException e1) {
                    Status status = new Status(4, "info.textgrid.lab.search.ui", Messages.SearchView_EM_OpenHelp1, (Throwable)e1);
                    Activator.getDefault().getLog().log((IStatus)status);
                }
            }
        });
        GridData gdAHL = new GridData(3, 3, false, false);
        gdAHL.horizontalSpan = 2;
        helplink.setLayoutData((Object)gdAHL);
        this.scrolledComposite.setMinSize(this.compAdvancedSearch1.computeSize(-1, -1));
    }

    private void createMetadataArea() {
        this.sliMetadata = new SearchLabelIcon(this.compAdvancedSearch1, 0, Messages.SearchView_Metadata, this.compAdvancedSearch1, true, 1);
        this.cbMetadata = this.sliMetadata.getCheckButton();
        this.cbMetadata.setSelection(true);
        this.cbMetadata.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                if (SearchView.this.cbBaselineEnc.getSelection()) {
                    SearchView.this.cbBaselineEnc.setSelection(false);
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        Group mdComposite = new Group(this.compAdvancedSearch1, 4);
        GridLayout glMain = new GridLayout(1, false);
        mdComposite.setLayout((Layout)glMain);
        mdComposite.setVisible(false);
        GridData gd = new GridData(4, 4, true, false);
        gd.horizontalSpan = 2;
        gd.horizontalIndent = 30;
        mdComposite.setLayoutData((Object)gd);
        this.sliMetadata.setControl((Composite)mdComposite);
        Composite compMainArea = new Composite((Composite)mdComposite, 4);
        GridLayout gl = new GridLayout(1, false);
        compMainArea.setLayout((Layout)gl);
        GridData gdMain = new GridData(4, 4, true, false);
        compMainArea.setLayoutData((Object)gdMain);
        this.metaDataMainArea = new MetadataMainArea(compMainArea, this.scrolledComposite);
        this.createTextTypes((Composite)mdComposite);
        this.createContentTypeGroup((Composite)mdComposite);
        this.createLanguageGroup((Composite)mdComposite);
        this.createDateGroup((Composite)mdComposite);
    }

    private void createFulltextArea(Composite compLevel1) {
        this.sliFullText = new SearchLabelIcon(this.compAdvancedSearch1, 0, Messages.SearchView_Fulltext, this.compAdvancedSearch1, true, 0);
        this.cbFulltext = this.sliFullText.getCheckButton();
        this.cbFulltext.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                if (SearchView.this.cbBaselineEnc.getSelection()) {
                    SearchView.this.cbBaselineEnc.setSelection(false);
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        Group fulltextComposite = new Group(this.compAdvancedSearch1, 4);
        GridLayout glMain = new GridLayout(1, false);
        fulltextComposite.setLayout((Layout)glMain);
        fulltextComposite.setVisible(false);
        GridData gd = new GridData(4, 4, true, false);
        gd.horizontalSpan = 2;
        gd.horizontalIndent = 30;
        fulltextComposite.setLayoutData((Object)gd);
        this.sliFullText.setControl((Composite)fulltextComposite);
        this.advancedSearchText = new Text((Composite)fulltextComposite, 2436);
        this.advancedSearchText.setText("");
        GridData gdSearchText = new GridData(4, 2, true, false);
        this.advancedSearchText.setLayoutData((Object)gdSearchText);
        this.advancedSearchText.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent event) {
                if (event.character == '\r') {
                    SearchView.this.startAdvancedSearch();
                }
            }
        });
        Composite wordDistance = new Composite((Composite)fulltextComposite, 0);
        GridLayout wd = new GridLayout(2, false);
        wordDistance.setLayout((Layout)wd);
        wordDistance.setLayoutData((Object)new GridData(4, 2, false, false));
        Composite wordDistance1 = new Composite(wordDistance, 0);
        wordDistance1.setLayout((Layout)new GridLayout());
        wordDistance1.setLayoutData((Object)new GridData(1, 1, false, false));
        Composite wordDistance11 = new Composite(wordDistance1, 0);
        wordDistance11.setLayout((Layout)new GridLayout(1, false));
        Label wdLabel = new Label(wordDistance11, 0);
        wdLabel.setText(Messages.SearchView_WordDistances);
        wdLabel.setLayoutData((Object)gdSearchText);
        Composite wordDistance2 = new Composite(wordDistance, 0);
        wordDistance2.setLayout((Layout)new GridLayout(1, false));
        Composite wordDistance21 = new Composite(wordDistance2, 0);
        wordDistance21.setLayout((Layout)new GridLayout(1, false));
        this.rbWordDistanceDocument = new Button(wordDistance21, 16);
        this.rbWordDistanceDocument.setText(Messages.SearchView_InOneDocument);
        this.rbWordDistanceDocument.setSelection(true);
        Composite wordDistance22 = new Composite(wordDistance2, 0);
        wordDistance22.setLayout((Layout)new GridLayout(3, false));
        this.rbWordDistanceWords = new Button(wordDistance22, 16);
        this.rbWordDistanceWords.setText(Messages.SearchView_maximal);
        this.wordDistanceSpinner = new Spinner(wordDistance22, 0);
        this.wordDistanceSpinner.setValues(40, 1, 1000, 0, 1, 100);
        new Label(wordDistance22, 0).setText(Messages.SearchView_words);
        this.rbWordDistanceDocument.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                SearchView.this.rbWordDistanceWords.setSelection(false);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.rbWordDistanceWords.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                SearchView.this.rbWordDistanceDocument.setSelection(false);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
    }

    private void createBaselineEncArea(Composite compLevel1) {
        this.sliBaseline = new SearchLabelIcon(this.compAdvancedSearch1, 0, "BASELINE ENC", this.compAdvancedSearch1, true, 0);
        this.cbBaselineEnc = this.sliBaseline.getCheckButton();
        this.cbBaselineEnc.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                if (SearchView.this.cbMetadata.getSelection()) {
                    SearchView.this.cbMetadata.setSelection(false);
                }
                if (SearchView.this.cbFulltext.getSelection()) {
                    SearchView.this.cbFulltext.setSelection(false);
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        Group baselineComposite = new Group(this.compAdvancedSearch1, 4);
        GridLayout glMain = new GridLayout(1, false);
        baselineComposite.setLayout((Layout)glMain);
        baselineComposite.setVisible(false);
        GridData gd = new GridData(4, 4, true, false);
        gd.horizontalSpan = 2;
        gd.horizontalIndent = 30;
        baselineComposite.setLayoutData((Object)gd);
        this.sliBaseline.setControl((Composite)baselineComposite);
        Composite compMainArea = new Composite((Composite)baselineComposite, 4);
        GridLayout gl = new GridLayout(1, false);
        compMainArea.setLayout((Layout)gl);
        GridData gdMain = new GridData(4, 4, true, false);
        compMainArea.setLayoutData((Object)gdMain);
        this.baselineEncodingDataMainArea = new BaselineEncodingMainArea(compMainArea, this.scrolledComposite);
    }

    public void setFocus() {
        if (this.mainComposite != null) {
            this.mainComposite.setFocus();
        }
    }

    private void createTextTypes(Composite mdComposite) {
        this.searchTextType = new SearchTextType("root", "", true);
        this.sliTextTypes = new SearchLabelIcon(mdComposite, 0, Messages.SearchView_TextTypesWithMarker, this.compAdvancedSearch1, false, 0);
        Composite textTypeComposite = new Composite(mdComposite, 0);
        GridLayout gl = new GridLayout(1, false);
        gl.marginWidth = 20;
        textTypeComposite.setLayout((Layout)gl);
        textTypeComposite.setVisible(false);
        GridData gd = new GridData(4, 4, true, true);
        textTypeComposite.setLayoutData((Object)gd);
        this.sliTextTypes.setControl(textTypeComposite);
        this.textTypeTree = new ContainerCheckedTreeViewer(textTypeComposite);
        this.textTypeTree.getControl().setBackground(textTypeComposite.getBackground());
        this.textTypeTree.setSorter(new ViewerSorter());
        this.textTypeTree.setContentProvider((IContentProvider)new SearchTreeContentProvider());
        this.textTypeTree.setLabelProvider((IBaseLabelProvider)new LabelProvider());
        this.textTypeTree.setInput((Object)this.searchTextType.getChildren());
        this.textTypeTree.getControl().setLayoutData((Object)gd);
        SearchTextType[] searchTextTypeArray = this.searchTextType.getChildren();
        int n = searchTextTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            SearchTextType tt = searchTextTypeArray[n2];
            this.textTypeTree.setSubtreeChecked((Object)tt, true);
            this.textTypeTree.setExpandedState((Object)tt, true);
            ++n2;
        }
        this.textTypeTree.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                if (SearchView.this.textTypeTree.getCheckedElements().length != SearchView.this.searchTextType.getChildCount()) {
                    SearchView.this.sliTextTypes.setModification(true);
                } else {
                    SearchView.this.sliTextTypes.setModification(false);
                }
            }
        });
    }

    private void createContentTypeGroup(Composite mdComposite) {
        this.searchContentType = SearchContentType.getInstance();
        this.sliContentTypes = new SearchLabelIcon(mdComposite, 16384, Messages.SearchView_ContentTypesWithMarker, this.compAdvancedSearch1, false, 0);
        Composite contentComposite = new Composite(mdComposite, 0);
        GridLayout gl = new GridLayout(1, false);
        gl.marginWidth = 20;
        contentComposite.setLayout((Layout)gl);
        contentComposite.setVisible(false);
        GridData gd = new GridData(4, 4, true, true);
        contentComposite.setLayoutData((Object)gd);
        this.sliContentTypes.setControl(contentComposite);
        this.contentTypeTree = new ContainerCheckedTreeViewer(contentComposite);
        this.contentTypeTree.getControl().setBackground(contentComposite.getBackground());
        this.contentTypeTree.setSorter(new ViewerSorter());
        this.contentTypeTree.setContentProvider((IContentProvider)new SearchTreeContentProvider());
        this.contentTypeTree.setLabelProvider((IBaseLabelProvider)new LabelProvider());
        this.contentTypeTree.setInput((Object)this.searchContentType.getChildren());
        this.contentTypeTree.getControl().setLayoutData((Object)gd);
        SearchContentType[] searchContentTypeArray = this.searchContentType.getChildren();
        int n = searchContentTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            SearchContentType ct = searchContentTypeArray[n2];
            this.contentTypeTree.setSubtreeChecked((Object)ct, true);
            this.contentTypeTree.setExpandedState((Object)ct, true);
            ++n2;
        }
        this.contentTypeTree.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                if (SearchView.this.contentTypeTree.getCheckedElements().length != SearchView.this.searchContentType.getChildCount()) {
                    SearchView.this.sliContentTypes.setModification(true);
                } else {
                    SearchView.this.sliContentTypes.setModification(false);
                }
            }
        });
    }

    private void createLanguageGroup(Composite mdComposite) {
        this.mainLanguages = new MajorSearchLanguages("root", "", true);
        this.sliLanguages = new SearchLabelIcon(mdComposite, 0, Messages.SearchView_LanguagesWithMarker, this.compAdvancedSearch1, false, 0);
        Composite languageComposite = new Composite(mdComposite, 0);
        GridLayout gl = new GridLayout(1, false);
        gl.marginWidth = 20;
        languageComposite.setLayout((Layout)gl);
        languageComposite.setVisible(false);
        GridData gd = new GridData(4, 4, true, true);
        languageComposite.setLayoutData((Object)gd);
        this.sliLanguages.setControl(languageComposite);
        this.languageTree = new ContainerCheckedTreeViewer(languageComposite);
        this.languageTree.getControl().setBackground(languageComposite.getBackground());
        this.languageTree.setSorter(new ViewerSorter());
        this.languageTree.setContentProvider((IContentProvider)new SearchTreeContentProvider());
        this.languageTree.setLabelProvider((IBaseLabelProvider)new LabelProvider());
        this.languageTree.setInput((Object)this.mainLanguages.getChildren());
        this.languageTree.getControl().setLayoutData((Object)gd);
        MajorSearchLanguages[] majorSearchLanguagesArray = this.mainLanguages.getChildren();
        int n = majorSearchLanguagesArray.length;
        int n2 = 0;
        while (n2 < n) {
            MajorSearchLanguages ml = majorSearchLanguagesArray[n2];
            this.languageTree.setSubtreeChecked((Object)ml, true);
            this.languageTree.setExpandedState((Object)ml, true);
            ++n2;
        }
        this.languageTree.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                if (SearchView.this.languageTree.getCheckedElements().length != SearchView.this.mainLanguages.getChildCount()) {
                    SearchView.this.sliLanguages.setModification(true);
                } else {
                    SearchView.this.sliLanguages.setModification(false);
                }
            }
        });
    }

    private void createDateGroup(Composite mdComposite) {
        this.sliDate = new SearchLabelIcon(mdComposite, 0, Messages.SearchView_DateWithMarker, this.compAdvancedSearch1, false, 0);
        Composite dateComposite = new Composite(mdComposite, 0);
        GridLayout glDate = new GridLayout(4, false);
        glDate.marginLeft = 20;
        dateComposite.setLayout((Layout)glDate);
        GridData gd = new GridData(1, 2, false, false);
        dateComposite.setLayoutData((Object)gd);
        dateComposite.setVisible(false);
        this.sliDate.setControl(dateComposite);
        this.cbDateBetween = new Button(dateComposite, 32);
        this.cbDateBetween.setText(Messages.SearchView_Between);
        this.cbDateBetween.setSelection(true);
        Composite cpFromDate = new Composite(dateComposite, 0);
        GridLayout glFromDate = new GridLayout(2, false);
        glFromDate.horizontalSpacing = 0;
        cpFromDate.setLayout((Layout)glFromDate);
        this.textFromDate = new Text(cpFromDate, 2052);
        this.textFromDate.setTextLimit(10);
        GridData gdText = new GridData(131072, 131072, true, true);
        gdText.widthHint = 80;
        this.textFromDate.setLayoutData((Object)gdText);
        this.textFromDate.addKeyListener(new KeyListener(){

            public void keyReleased(KeyEvent e) {
            }

            public void keyPressed(KeyEvent e) {
                if (e.keyCode == 13) {
                    SearchView.this.startAdvancedSearch();
                }
            }
        });
        this.ilFromDate = new Label(cpFromDate, 16384);
        this.ilFromDate.setImage(Activator.getDefault().getImageRegistry().get("calendar"));
        new Label(dateComposite, 0).setText(Messages.SearchView_And);
        Composite cpToDate = new Composite(dateComposite, 0);
        cpToDate.setLayout((Layout)glFromDate);
        this.textToDate = new Text(cpToDate, 2048);
        this.textToDate.setTextLimit(10);
        this.textToDate.setLayoutData((Object)gdText);
        this.textToDate.addKeyListener(new KeyListener(){

            public void keyReleased(KeyEvent e) {
            }

            public void keyPressed(KeyEvent e) {
                if (e.keyCode == 13) {
                    SearchView.this.startAdvancedSearch();
                }
            }
        });
        this.ilToDate = new Label(cpToDate, 0);
        this.ilToDate.setImage(Activator.getDefault().getImageRegistry().get("calendar"));
        Label lbExample1 = new Label(dateComposite, 0);
        lbExample1.setText(Messages.SearchView_DateExampleFrom);
        lbExample1.setFont(this.italicSmallFont);
        lbExample1.setForeground(Display.getDefault().getSystemColor(16));
        GridData gdDateExample = new GridData(3, 2, true, false);
        gdDateExample.horizontalSpan = 2;
        lbExample1.setLayoutData((Object)gdDateExample);
        Label lbExample2 = new Label(dateComposite, 0);
        lbExample2.setText(Messages.SearchView_DateExampleTo);
        lbExample2.setFont(this.italicSmallFont);
        lbExample2.setForeground(Display.getDefault().getSystemColor(16));
        lbExample2.setLayoutData((Object)gdDateExample);
        this.ilFromDate.addMouseListener(new MouseListener(){

            public void mouseUp(MouseEvent e) {
            }

            public void mouseDown(MouseEvent e) {
                new SearchUICalendar(SearchView.this.textFromDate);
            }

            public void mouseDoubleClick(MouseEvent e) {
            }
        });
        this.ilToDate.addMouseListener(new MouseListener(){

            public void mouseUp(MouseEvent e) {
            }

            public void mouseDown(MouseEvent e) {
                new SearchUICalendar(SearchView.this.textToDate);
            }

            public void mouseDoubleClick(MouseEvent e) {
            }
        });
    }

    private void createWordDistances(Composite fulltextComposite) {
        this.sliWordDistances = new SearchLabelIcon(fulltextComposite, 0, Messages.SearchView_WordDistancesWithMarker, this.compAdvancedSearch1, false, 0);
        Composite distancesComposite = new Composite(fulltextComposite, 0);
        GridLayout gl = new GridLayout(1, false);
        gl.marginWidth = 20;
        distancesComposite.setLayout((Layout)gl);
        distancesComposite.setVisible(false);
        GridData gd = new GridData(4, 4, true, true);
        distancesComposite.setLayoutData((Object)gd);
        this.sliWordDistances.setControl(distancesComposite);
        this.fulltextMainArea = new FulltextMainArea(distancesComposite, this.scrolledComposite);
    }

    public void startSimpleSearch() {
        if (this.simpleSearchText.getText().length() == 0) {
            MessageBox mb = new MessageBox(this.getSite().getWorkbenchWindow().getShell(), 40);
            mb.setMessage(ERROR_EMPTY_SEARCH);
            if (mb.open() == 32) {
                this.simpleSearchText.setFocus();
            }
            return;
        }
        this.initResultView();
        if (this.rbEndpointPublic.getSelection()) {
            this.searchRequest = new SearchRequest(SearchRequest.EndPoint.PUBLIC);
        } else if (this.rbEndpointStandard.getSelection()) {
            this.searchRequest = new SearchRequest(SearchRequest.EndPoint.STANDARD);
        }
        this.setHitCountListener();
        this.setPartSearchReadyListener();
        this.searchRequest.setResolvePath(true);
        if (this.rbSearchFulltext.getSelection()) {
            this.searchRequest.setTarget(SearchRequest.TargetModus.STRUCTURE);
        } else if (this.rbSearchMetadata.getSelection()) {
            this.searchRequest.setTarget(SearchRequest.TargetModus.METADATA);
        } else {
            this.searchRequest.setTarget(SearchRequest.TargetModus.BOTH);
        }
        this.searchRequest.setQueryText(this.simpleSearchText.getText());
        this.resultView.getViewer().setInput((Object)this.searchRequest);
    }

    public void startAdvancedSearch() {
        String searchString = "";
        if (this.rbEndpointPublic.getSelection()) {
            this.searchRequest = new SearchRequest(SearchRequest.EndPoint.PUBLIC);
        } else if (this.rbEndpointStandard.getSelection()) {
            this.searchRequest = new SearchRequest(SearchRequest.EndPoint.STANDARD);
        }
        if (!(this.sliMetadata.getCheckButton().getSelection() || this.sliFullText.getCheckButton().getSelection() || this.sliBaseline.getCheckButton().getSelection())) {
            MessageBox mb = new MessageBox(this.getSite().getWorkbenchWindow().getShell(), 33);
            mb.setMessage(Messages.SearchView_IM_SelectSection);
            mb.setText(Messages.SearchView_AdvancedSearch);
            mb.open();
            this.simpleSearchText.setFocus();
            return;
        }
        if (this.sliMetadata.getCheckButton().getSelection() && !this.sliFullText.getCheckButton().getSelection()) {
            this.searchRequest.setTarget(SearchRequest.TargetModus.METADATA);
        } else if (this.sliMetadata.getCheckButton().getSelection() && this.sliFullText.getCheckButton().getSelection()) {
            this.searchRequest.setTarget(SearchRequest.TargetModus.BOTH);
        }
        if (this.sliMetadata.getCheckButton().getSelection()) {
            searchString = this.getMetaSearchString();
        }
        if (this.sliFullText.getCheckButton().getSelection()) {
            searchString = this.getFulltextSearchString(searchString);
        }
        if (searchString.equals("")) {
            MessageBox mb = new MessageBox(this.getSite().getWorkbenchWindow().getShell(), 40);
            mb.setMessage(ERROR_EMPTY_SEARCH);
            if (mb.open() == 32) {
                this.simpleSearchText.setFocus();
            }
            return;
        }
        this.initResultView();
        this.setHitCountListener();
        this.setPartSearchReadyListener();
        this.searchRequest.setResolvePath(true);
        this.searchRequest.setQueryMetadata(searchString);
        this.resultView.getViewer().setInput((Object)this.searchRequest);
        System.out.println("SUCHSTRING META: " + searchString);
    }

    public void initResultView() {
        IViewPart resView = null;
        try {
            resView = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().showView("info.textgrid.lab.search.views.ResultView");
        }
        catch (PartInitException e) {
            Status status = new Status(4, "info.textgrid.lab.search.ui", Messages.SearchView_EM_OpenView, (Throwable)e);
            Activator.getDefault().getLog().log((IStatus)status);
        }
        if (resView instanceof ResultView) {
            this.resultView = (ResultView)resView;
            this.resultView.setStatusLabel(Messages.SearchView_Searching);
        }
    }

    public void setHitCountListener() {
        if (this.hitCountListener != null) {
            this.searchRequest.removeHitCountListener(this.hitCountListener);
            this.hitCountListener = null;
        }
        if (this.hitCountListener == null) {
            this.hitCountListener = new Listener(){

                public void handleEvent(Event event) {
                    Display.getDefault().asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            SearchView.this.resultView.setStatusLabel(String.valueOf(String.valueOf(SearchView.this.searchRequest.getHitCount())) + Messages.SearchView_ItemsFound);
                        }
                    });
                }
            };
            this.searchRequest.addHitCountListener(this.hitCountListener);
        }
    }

    public void setPartSearchReadyListener() {
        if (this.partSearchReadyListener != null) {
            this.searchRequest.removeHitCountListener(this.partSearchReadyListener);
            this.partSearchReadyListener = null;
        }
    }

    public String getMetaSearchString() {
        Object item;
        int n;
        int n2;
        Object[] objectArray;
        String strResult = "";
        String strMeta = "";
        boolean isFirst = true;
        strResult = this.metaDataMainArea.getMetadataMainSearchString();
        if (this.textTypeTree.getCheckedElements().length != this.searchTextType.getChildCount()) {
            objectArray = this.textTypeTree.getCheckedElements();
            n2 = objectArray.length;
            n = 0;
            while (n < n2) {
                item = objectArray[n];
                if (!item.toString().equals(Messages.SearchView_TextTypes)) {
                    if (isFirst) {
                        strMeta = String.valueOf(strMeta) + "( genre:" + ((SearchTextType)item).getTextType();
                        isFirst = false;
                    } else {
                        strMeta = String.valueOf(strMeta) + " OR genre:" + ((SearchTextType)item).getTextType();
                    }
                }
                ++n;
            }
            if (!isFirst) {
                strMeta = String.valueOf(strMeta) + " )";
            }
        }
        if (!strMeta.equals("")) {
            strResult = !strResult.equals("") ? String.valueOf(strResult) + " AND " + strMeta : strMeta;
        }
        isFirst = true;
        strMeta = "";
        if (this.contentTypeTree.getCheckedElements().length != this.searchContentType.getChildCount()) {
            objectArray = this.contentTypeTree.getCheckedElements();
            n2 = objectArray.length;
            n = 0;
            while (n < n2) {
                item = objectArray[n];
                if (!item.toString().equals(Messages.SearchView_ContentTypes)) {
                    if (isFirst) {
                        strMeta = String.valueOf(strMeta) + "( format:\"" + ((SearchContentType)item).getFormat().toLowerCase() + "\"";
                        isFirst = false;
                    } else {
                        strMeta = String.valueOf(strMeta) + " OR format:\"" + ((SearchContentType)item).getFormat().toLowerCase() + "\"";
                    }
                }
                ++n;
            }
            if (!isFirst) {
                strMeta = String.valueOf(strMeta) + " )";
            }
        }
        if (!strMeta.equals("")) {
            strResult = !strResult.equals("") ? String.valueOf(strResult) + " AND " + strMeta : strMeta;
        }
        isFirst = true;
        strMeta = "";
        if (this.languageTree.getCheckedElements().length != this.mainLanguages.getChildCount()) {
            objectArray = this.languageTree.getCheckedElements();
            n2 = objectArray.length;
            n = 0;
            while (n < n2) {
                item = objectArray[n];
                if (!item.toString().equals(Messages.SearchView_Languages)) {
                    if (isFirst) {
                        strMeta = String.valueOf(strMeta) + "( language:" + ((MajorSearchLanguages)item).getCode().toLowerCase();
                        isFirst = false;
                    } else {
                        strMeta = String.valueOf(strMeta) + " OR language:" + ((MajorSearchLanguages)item).getCode().toLowerCase();
                    }
                }
                ++n;
            }
            if (!isFirst) {
                strMeta = String.valueOf(strMeta) + " )";
            }
        }
        if (!strMeta.equals("")) {
            strResult = !strResult.equals("") ? String.valueOf(strResult) + " AND " + strMeta : strMeta;
        }
        strMeta = "";
        if (!(!this.cbDateBetween.getSelection() || this.textFromDate.getText().trim().equals("") && this.textToDate.getText().trim().equals(""))) {
            if (this.plausiAdvancedMetadataDate()) {
                if (!this.textFromDate.getText().trim().equals("")) {
                    strMeta = "created:[" + this.textFromDate.getText();
                }
                if (!this.textToDate.getText().trim().equals("")) {
                    strMeta = strMeta.equals("") ? "created:" + this.textToDate.getText() : String.valueOf(strMeta) + " TO " + this.textToDate.getText() + "]";
                }
            } else {
                return "";
            }
        }
        if (!strMeta.equals("")) {
            strResult = !strResult.equals("") ? String.valueOf(strResult) + " AND " + strMeta : strMeta;
        }
        return strResult;
    }

    public String getFulltextSearchString(String searchString) {
        if (!this.advancedSearchText.getText().trim().equals("")) {
            if (!searchString.trim().equals("")) {
                searchString = String.valueOf(searchString) + " AND ";
            }
            String ftString = this.advancedSearchText.getText().trim();
            if (this.rbWordDistanceWords.getSelection()) {
                System.out.println("dist-query");
                ftString = "\"" + ftString + "\"~" + this.wordDistanceSpinner.getSelection();
            }
            searchString = String.valueOf(searchString) + ftString;
        }
        return searchString;
    }

    private boolean plausiAdvancedMetadataDate() {
        Date dateTo;
        Date dateFrom;
        boolean result = true;
        SimpleDateFormat standardDateFormat = new SimpleDateFormat("yyyy-MM-dd");
        SimpleDateFormat yearDateFormat = new SimpleDateFormat("yyyy");
        try {
            dateFrom = yearDateFormat.parse(this.textFromDate.getText());
        }
        catch (ParseException parseException) {
            try {
                dateFrom = standardDateFormat.parse(this.textFromDate.getText());
            }
            catch (ParseException parseException2) {
                MessageBox mb = new MessageBox(this.getSite().getWorkbenchWindow().getShell(), 33);
                mb.setMessage(ERROR_INVALID_DATE_FORMAT);
                mb.setText(Messages.SearchView_AdvancedSearch);
                mb.open();
                this.textFromDate.setFocus();
                this.textToDate.selectAll();
                return false;
            }
        }
        try {
            dateTo = yearDateFormat.parse(this.textToDate.getText());
        }
        catch (ParseException parseException) {
            try {
                dateTo = standardDateFormat.parse(this.textToDate.getText());
            }
            catch (ParseException parseException3) {
                MessageBox mb = new MessageBox(this.getSite().getWorkbenchWindow().getShell(), 33);
                mb.setMessage(ERROR_INVALID_DATE_FORMAT);
                mb.setText(Messages.SearchView_AdvancedSearch);
                mb.open();
                this.textToDate.setFocus();
                this.textToDate.selectAll();
                return false;
            }
        }
        if (dateTo.before(dateFrom)) {
            MessageBox mb = new MessageBox(this.getSite().getWorkbenchWindow().getShell(), 33);
            mb.setMessage(ERROR_INVALID_ORDER);
            mb.setText(Messages.SearchView_AdvancedSearch);
            mb.open();
            this.textFromDate.setFocus();
            this.textFromDate.selectAll();
            return false;
        }
        return result;
    }

    private void createEndpointArea(Composite parent) {
        String myEPPN = RBACSession.getInstance().getEPPN();
        this.epComposite = new Group(parent, 0);
        GridLayout gl = new GridLayout(3, false);
        gl.marginWidth = 20;
        this.epComposite.setLayout((Layout)gl);
        this.epComposite.setLayoutData((Object)new GridData(0x1000000, 0x1000000, true, false));
        new Label((Composite)this.epComposite, 0).setText(Messages.SearchView_SearchIn);
        if (myEPPN.equals("")) {
            this.rbEndpointStandard = new Button((Composite)this.epComposite, 16);
            this.rbEndpointStandard.setText(Messages.SearchView_MyProjects);
            this.rbEndpointStandard.setSelection(false);
            this.rbEndpointStandard.setEnabled(false);
        } else {
            this.rbEndpointStandard = new Button((Composite)this.epComposite, 16);
            this.rbEndpointStandard.setText(Messages.SearchView_MyProjects);
            this.rbEndpointStandard.setSelection(true);
            this.rbEndpointStandard.setEnabled(true);
        }
        this.rbEndpointPublic = new Button((Composite)this.epComposite, 16);
        this.rbEndpointPublic.setText(Messages.SearchView_PublicInRep);
        parent.redraw();
    }

    public int getTabFolderSelection() {
        return this.folder.getSelectionIndex();
    }

    public void setProjectSpecificSearchTags(ArrayList<TextGridProject> projectList) {
        this.metaDataMainArea.setProjectSpecificSearchTags(projectList);
        this.regardedMetadataProjects = projectList;
    }

    public ArrayList<TextGridProject> getRegardedMetadataProjects() {
        return this.regardedMetadataProjects;
    }
}

