/*
 * Decompiled with CFR 0.152.
 */
package net.sf.vex.editor;

import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Map;
import net.sf.vex.action.IVexAction;
import net.sf.vex.action.RemoveElementAction;
import net.sf.vex.editor.Messages;
import net.sf.vex.editor.VexEditor;
import net.sf.vex.editor.VexPlugin;
import net.sf.vex.editor.action.ChangeElementAction;
import net.sf.vex.swt.VexWidget;
import net.sf.vex.widget.IVexWidget;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkbenchWindowActionDelegate;

public class VexActionDelegate
implements IWorkbenchWindowActionDelegate {
    private static Map actions = new HashMap();
    private IWorkbenchWindow window;

    public void dispose() {
    }

    public void init(IWorkbenchWindow window) {
        this.window = window;
    }

    public void run(IAction action) {
        IVexAction vexAction = VexActionDelegate.getAction(action.getId());
        if (vexAction == null) {
            return;
        }
        VexWidget vexWidget = this.getVexWidget();
        if (vexWidget != null) {
            vexWidget.setFocus();
            vexAction.run((IVexWidget)vexWidget);
        }
    }

    public void selectionChanged(IAction action, ISelection selection) {
        boolean enabled;
        IVexAction vexAction = VexActionDelegate.getAction(action.getId());
        if (vexAction == null) {
            enabled = false;
        } else {
            VexWidget vexWidget = this.getVexWidget();
            if (vexWidget == null) {
                enabled = false;
            } else {
                String message;
                String elementName;
                enabled = vexAction.isEnabled((IVexWidget)vexWidget);
                if (action.getId().equals(ChangeElementAction.class.getName())) {
                    elementName = vexWidget.getCurrentElement().getName();
                    message = Messages.getString("ChangeElementAction.dynamic.label");
                    action.setText(MessageFormat.format(message, elementName));
                }
                if (action.getId().equals(RemoveElementAction.class.getName())) {
                    elementName = vexWidget.getCurrentElement().getName();
                    message = Messages.getString("RemoveElementAction.dynamic.label");
                    action.setText(MessageFormat.format(message, elementName));
                }
            }
        }
        action.setEnabled(enabled);
    }

    private VexWidget getVexWidget() {
        VexEditor vexEditor;
        IEditorPart editor = this.window.getActivePage().getActiveEditor();
        if (editor != null && (vexEditor = (VexEditor)((Object)editor.getAdapter(VexEditor.class))) != null) {
            return vexEditor.getVexWidget();
        }
        return null;
    }

    private static IVexAction getAction(String actionId) {
        try {
            IVexAction action = (IVexAction)actions.get(actionId);
            if (action == null) {
                action = (IVexAction)Class.forName(actionId).newInstance();
                actions.put(actionId, action);
            }
            return action;
        }
        catch (Exception ex) {
            String message = MessageFormat.format(Messages.getString("VexActionDelegate.errorLoadingAction"), actionId, ex.getMessage());
            VexPlugin.getInstance().log(4, message, ex);
            return null;
        }
    }
}

