/*
 * Decompiled with CFR 0.152.
 */
package net.sf.vex.action;

import net.sf.vex.VexToolkitPlugin;
import net.sf.vex.swt.VexWidget;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.ShellEvent;
import org.eclipse.swt.events.ShellListener;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;

public abstract class ContentAssistant {
    private static final String SETTINGS_SECTION = "contentAssistant";
    private static final String SETTINGS_X = "x";
    private static final String SETTINGS_Y = "y";
    private static final String SETTINGS_WIDTH = "width";
    private static final String SETTINGS_HEIGHT = "height";
    private Shell assistantShell;
    private Text textWidget;
    private Tree treeWidget;
    private IAction[] actions;
    private boolean mouseDown;
    private ControlListener controlListener = new ControlListener(){

        public void controlMoved(ControlEvent e) {
            ContentAssistant.this.saveSize();
        }

        public void controlResized(ControlEvent e) {
            ContentAssistant.this.saveSize();
        }
    };
    private DisposeListener disposeListener = new DisposeListener(){

        public void widgetDisposed(DisposeEvent e) {
            ContentAssistant.this.assistantShell = null;
        }
    };
    private KeyListener keyListener = new KeyListener(){

        public void keyPressed(KeyEvent e) {
            if (e.keyCode == 13) {
                ContentAssistant.this.doAction();
            } else if (e.widget == ContentAssistant.this.textWidget && e.keyCode == 0x1000002) {
                ContentAssistant.this.treeWidget.setFocus();
            }
        }

        public void keyReleased(KeyEvent e) {
        }
    };
    private ModifyListener modifyListener = new ModifyListener(){

        public void modifyText(ModifyEvent e) {
            ContentAssistant.this.repopulateList();
        }
    };
    private MouseListener mouseListener = new MouseListener(){

        public void mouseDoubleClick(MouseEvent e) {
        }

        public void mouseDown(MouseEvent e) {
            ContentAssistant.this.mouseDown = true;
        }

        public void mouseUp(MouseEvent e) {
            ContentAssistant.this.mouseDown = false;
        }
    };
    private SelectionListener selectionListener = new SelectionListener(){

        public void widgetSelected(SelectionEvent e) {
            if (ContentAssistant.this.mouseDown) {
                ContentAssistant.this.doAction();
            }
        }

        public void widgetDefaultSelected(SelectionEvent e) {
        }
    };
    private ShellListener shellListener = new ShellListener(){

        public void shellActivated(ShellEvent e) {
        }

        public void shellClosed(ShellEvent e) {
        }

        public void shellDeactivated(ShellEvent e) {
            ContentAssistant.this.assistantShell.dispose();
        }

        public void shellDeiconified(ShellEvent e) {
        }

        public void shellIconified(ShellEvent e) {
        }
    };

    public abstract IAction[] getActions(VexWidget var1);

    public abstract String getTitle(VexWidget var1);

    public void show(VexWidget vexWidget) {
        this.actions = this.getActions(vexWidget);
        Shell parent = vexWidget.getShell();
        this.assistantShell = new Shell(parent, 2160);
        this.assistantShell.setText(this.getTitle(vexWidget));
        this.assistantShell.addControlListener(this.controlListener);
        this.assistantShell.addDisposeListener(this.disposeListener);
        this.assistantShell.addShellListener(this.shellListener);
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        this.assistantShell.setLayout((Layout)layout);
        this.textWidget = new Text((Composite)this.assistantShell, 4);
        this.textWidget.addModifyListener(this.modifyListener);
        GridData gd = new GridData();
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalAlignment = 4;
        this.textWidget.setLayoutData((Object)gd);
        this.textWidget.addKeyListener(this.keyListener);
        this.textWidget.addModifyListener(this.modifyListener);
        this.treeWidget = new Tree((Composite)this.assistantShell, 4);
        this.treeWidget.addKeyListener(this.keyListener);
        this.treeWidget.addMouseListener(this.mouseListener);
        this.treeWidget.addSelectionListener(this.selectionListener);
        gd = new GridData();
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalAlignment = 4;
        gd.grabExcessVerticalSpace = true;
        gd.verticalAlignment = 4;
        this.treeWidget.setLayoutData((Object)gd);
        this.assistantShell.setBounds(this.getSize());
        this.repopulateList();
        this.mouseDown = false;
        this.assistantShell.open();
    }

    private void doAction() {
        TreeItem[] items = this.treeWidget.getSelection();
        if (items.length > 0) {
            IAction action = (IAction)items[0].getData();
            action.run();
        }
        this.assistantShell.dispose();
    }

    private IDialogSettings getSettings() {
        IDialogSettings rootSettings = VexToolkitPlugin.getDefault().getDialogSettings();
        IDialogSettings settings = rootSettings.getSection(SETTINGS_SECTION);
        if (settings == null) {
            settings = rootSettings.addNewSection(SETTINGS_SECTION);
        }
        return settings;
    }

    private Rectangle getSize() {
        IDialogSettings settings = this.getSettings();
        int x = 100;
        int y = 100;
        int width = 200;
        int height = 300;
        if (settings.get(SETTINGS_X) != null) {
            x = settings.getInt(SETTINGS_X);
            y = settings.getInt(SETTINGS_Y);
            width = settings.getInt(SETTINGS_WIDTH);
            height = settings.getInt(SETTINGS_HEIGHT);
        }
        return new Rectangle(x, y, width, height);
    }

    private void repopulateList() {
        String prefix = this.textWidget.getText();
        this.treeWidget.removeAll();
        TreeItem first = null;
        int i = 0;
        while (i < this.actions.length) {
            IAction action = this.actions[i];
            if (action.getText().startsWith(prefix)) {
                TreeItem item = new TreeItem(this.treeWidget, 0);
                if (first == null) {
                    first = item;
                }
                item.setData((Object)action);
                item.setText(action.getText());
            }
            ++i;
        }
        if (first != null) {
            this.treeWidget.setSelection(new TreeItem[]{first});
        }
    }

    private void saveSize() {
        IDialogSettings settings = this.getSettings();
        Rectangle bounds = this.assistantShell.getBounds();
        settings.put(SETTINGS_X, bounds.x);
        settings.put(SETTINGS_Y, bounds.y);
        settings.put(SETTINGS_WIDTH, bounds.width);
        settings.put(SETTINGS_HEIGHT, bounds.height);
    }
}

