/*
 * Decompiled with CFR 0.152.
 */
package net.sf.vex.action.linked;

import info.textgrid.lab.core.swtutils.AdapterUtils;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import net.sf.vex.action.linked.InsertNodeAction;
import net.sf.vex.action.linked.ReplaceNodeAction;
import net.sf.vex.swt.TextSelectionVex;
import net.sf.vex.widget.IVexWidget;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.wst.xml.core.internal.contentmodel.CMGroup;
import org.eclipse.wst.xml.core.internal.contentmodel.CMNode;
import org.eclipse.wst.xml.core.internal.contentmodel.CMNodeList;
import org.eclipse.wst.xml.core.internal.contentmodel.modelquery.ModelQueryAction;
import org.eclipse.wst.xml.ui.internal.taginfo.MarkupTagInfoProvider;
import org.w3c.dom.Element;

public abstract class AbstractModelQueryActionWrapper
extends Action {
    private static final MarkupTagInfoProvider MARKUP_TAG_INFO_PROVIDER = new MarkupTagInfoProvider();
    private ModelQueryAction modelQueryAction = null;
    private IVexWidget vexWidget;
    private CMNode cmNode;
    private ISourceViewer sourceViewer;
    private static final Pattern REMOVE_TAGS = Pattern.compile("<[^>]+>");
    private static final Pattern CLEAN_SPACE = Pattern.compile("  +");

    protected void init(ModelQueryAction modelQueryAction, IVexWidget vexWidget, ISourceViewer sourceViewer) {
        this.init(modelQueryAction, null, vexWidget, sourceViewer);
    }

    protected void init(ModelQueryAction modelQueryAction, CMNode cmNode, IVexWidget vexWidget, ISourceViewer sourceViewer) {
        this.modelQueryAction = modelQueryAction;
        this.vexWidget = vexWidget;
        this.setSourceViewer(sourceViewer);
        this.setCMNode(cmNode == null ? modelQueryAction.getCMNode() : cmNode);
        this.setText(this.getCMNode().getNodeName());
        String infoFragment = MARKUP_TAG_INFO_PROVIDER.getInfo(this.getCMNode());
        infoFragment = CLEAN_SPACE.matcher(REMOVE_TAGS.matcher(infoFragment).replaceAll("")).replaceAll(" ");
        if (!"".equals(infoFragment)) {
            this.setToolTipText(infoFragment);
            this.setDescription(infoFragment);
        }
        System.out.println(MessageFormat.format("{0}\n  parent: {1}\n  CM Node: {2}\n   user data: {3}", ((Object)((Object)this)).getClass().getSimpleName(), modelQueryAction.getParent(), modelQueryAction.getCMNode(), modelQueryAction.getUserData()));
    }

    public String getToolTipText() {
        super.getToolTipText();
        return super.getToolTipText();
    }

    public IVexWidget getVexWidget() {
        return this.vexWidget;
    }

    public ModelQueryAction getModelQueryAction() {
        return this.modelQueryAction;
    }

    public static AbstractModelQueryActionWrapper create(ModelQueryAction mqa, IVexWidget vexWidget, ISourceViewer sourceViewer) {
        return AbstractModelQueryActionWrapper.create(mqa, null, vexWidget, sourceViewer, null);
    }

    public static AbstractModelQueryActionWrapper create(ModelQueryAction mqa, IVexWidget vexWidget, ISourceViewer sourceViewer, Element element) {
        return AbstractModelQueryActionWrapper.create(mqa, null, vexWidget, sourceViewer, element);
    }

    public static AbstractModelQueryActionWrapper create(ModelQueryAction mqa, CMNode cmNode, IVexWidget vexWidget, ISourceViewer sourceViewer, Element element) {
        switch (mqa.getKind()) {
            case 1: {
                return new InsertNodeAction(mqa, vexWidget, sourceViewer);
            }
            case 4: {
                return new ReplaceNodeAction(mqa, cmNode, vexWidget, sourceViewer, element);
            }
        }
        return null;
    }

    public static AbstractModelQueryActionWrapper[] create(List<ModelQueryAction> mqas, IVexWidget vexWidget, ISourceViewer sourceViewer) {
        return AbstractModelQueryActionWrapper.create(mqas, vexWidget, sourceViewer, null);
    }

    public static AbstractModelQueryActionWrapper[] create(List<ModelQueryAction> mqas, IVexWidget vexWidget, ISourceViewer sourceViewer, Element element) {
        ArrayList<AbstractModelQueryActionWrapper> result = new ArrayList<AbstractModelQueryActionWrapper>(mqas.size());
        for (ModelQueryAction mqa : mqas) {
            AbstractModelQueryActionWrapper.expand(mqa, null, result, vexWidget, sourceViewer, element);
        }
        return result.toArray(new AbstractModelQueryActionWrapper[0]);
    }

    private static void expand(ModelQueryAction mqa, ArrayList<AbstractModelQueryActionWrapper> result, IVexWidget vexWidget, ISourceViewer sourceViewer, Element element) {
        AbstractModelQueryActionWrapper.expand(mqa, null, result, vexWidget, sourceViewer, element);
    }

    private static void expand(ModelQueryAction mqa, CMNode cmNode, ArrayList<AbstractModelQueryActionWrapper> result, IVexWidget vexWidget, ISourceViewer sourceViewer, Element element) {
        if (cmNode == null) {
            cmNode = mqa.getCMNode();
        }
        if (cmNode instanceof CMGroup) {
            int operator = ((CMGroup)cmNode).getOperator();
            if (operator != 1) {
                CMNodeList childNodes = ((CMGroup)cmNode).getChildNodes();
                int i = 0;
                while (i < childNodes.getLength()) {
                    AbstractModelQueryActionWrapper.expand(mqa, childNodes.item(i), result, vexWidget, sourceViewer, element);
                    ++i;
                }
            }
        } else {
            AbstractModelQueryActionWrapper amqaw = AbstractModelQueryActionWrapper.create(mqa, cmNode, vexWidget, sourceViewer, element);
            if (amqaw != null) {
                result.add(amqaw);
            }
        }
    }

    public void setSourceViewer(ISourceViewer sourceViewer) {
        this.sourceViewer = sourceViewer;
    }

    public ISourceViewer getSourceViewer() {
        return this.sourceViewer;
    }

    public IRegion getSelectedSourceRegion() {
        IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
        IEditorPart part = page.getActiveEditor();
        ITextEditor editor = (ITextEditor)AdapterUtils.getAdapter((Object)part, ITextEditor.class);
        if (editor != null) {
            IDocumentProvider dp = editor.getDocumentProvider();
            dp.getDocument((Object)editor.getEditorInput());
            ITextSelection selection = (ITextSelection)editor.getSelectionProvider().getSelection();
            int length = selection.getLength();
            int offset = selection.getOffset();
            return new Region(offset, length);
        }
        if (this.vexWidget != null) {
            TextSelectionVex vexSelection = new TextSelectionVex(this.getVexWidget());
            int startOffset = vexSelection.getSourceStartOffset();
            int endOffset = vexSelection.getSourceEndOffset();
            return new Region(startOffset, endOffset - startOffset);
        }
        return null;
    }

    public void setCMNode(CMNode cmNode) {
        this.cmNode = cmNode;
    }

    public CMNode getCMNode() {
        return this.cmNode;
    }
}

