/*
 * Decompiled with CFR 0.152.
 */
package net.sf.vex.dom;

import java.io.ObjectStreamException;
import java.io.Serializable;

public class AttributeDefinition
implements Comparable,
Serializable {
    private String name;
    private Type type;
    private String defaultValue;
    private String[] values;
    private boolean required;
    private boolean fixed;

    public AttributeDefinition(String name, Type type, String defaultValue, String[] values, boolean required, boolean fixed) {
        this.name = name;
        this.type = type;
        this.defaultValue = defaultValue;
        this.values = values;
        this.required = required;
        this.fixed = fixed;
    }

    public int compareTo(Object other) {
        return this.name.compareTo(((AttributeDefinition)other).name);
    }

    public Type getType() {
        return this.type;
    }

    public String getDefaultValue() {
        return this.defaultValue;
    }

    public boolean isFixed() {
        return this.fixed;
    }

    public String getName() {
        return this.name;
    }

    public boolean isRequired() {
        return this.required;
    }

    public String[] getValues() {
        return this.values;
    }

    public static final class Type
    implements Serializable {
        private String s;
        public static final Type CDATA = new Type("CDATA");
        public static final Type ID = new Type("ID");
        public static final Type IDREF = new Type("IDREF");
        public static final Type IDREFS = new Type("IDREFS");
        public static final Type NMTOKEN = new Type("NMTOKEN");
        public static final Type NMTOKENS = new Type("NMTOKENS");
        public static final Type ENTITY = new Type("ENTITY");
        public static final Type ENTITIES = new Type("ENTITIES");
        public static final Type NOTATION = new Type("NOTATION");
        public static final Type ENUMERATION = new Type("ENUMERATION");

        private Type(String s) {
            this.s = s;
        }

        public static Type get(String s) {
            if (s.equals(CDATA.toString())) {
                return CDATA;
            }
            if (s.equals(ID.toString())) {
                return ID;
            }
            if (s.equals(IDREF.toString())) {
                return IDREF;
            }
            if (s.equals(IDREFS.toString())) {
                return IDREFS;
            }
            if (s.equals(NMTOKEN.toString())) {
                return NMTOKEN;
            }
            if (s.equals(NMTOKENS.toString())) {
                return NMTOKENS;
            }
            if (s.equals(ENTITY.toString())) {
                return ENTITY;
            }
            if (s.equals(ENTITIES.toString())) {
                return ENTITIES;
            }
            if (s.equals(NOTATION.toString())) {
                return NOTATION;
            }
            if (s.equals(ENUMERATION.toString())) {
                return ENUMERATION;
            }
            throw new IllegalArgumentException("Attribute type '" + s + "' not recognized");
        }

        public String toString() {
            return this.s;
        }

        private Object readResolve() throws ObjectStreamException {
            return Type.get(this.toString());
        }
    }
}

