/*
 * Decompiled with CFR 0.152.
 */
package net.sf.vex.dom;

import com.wutka.dtd.DTD;
import com.wutka.dtd.DTDAny;
import com.wutka.dtd.DTDAttribute;
import com.wutka.dtd.DTDCardinal;
import com.wutka.dtd.DTDChoice;
import com.wutka.dtd.DTDContainer;
import com.wutka.dtd.DTDDecl;
import com.wutka.dtd.DTDElement;
import com.wutka.dtd.DTDEmpty;
import com.wutka.dtd.DTDEnumeration;
import com.wutka.dtd.DTDItem;
import com.wutka.dtd.DTDMixed;
import com.wutka.dtd.DTDName;
import com.wutka.dtd.DTDNotationList;
import com.wutka.dtd.DTDPCData;
import com.wutka.dtd.DTDParser;
import com.wutka.dtd.DTDSequence;
import java.io.IOException;
import java.net.URL;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import net.sf.vex.dom.AbstractValidator;
import net.sf.vex.dom.AttributeDefinition;
import net.sf.vex.dom.DFABuilder;
import net.sf.vex.dom.DFAState;

public class DTDValidator
extends AbstractValidator {
    private static final DFAState emptyDFA = new DFAState();
    private Map elementDFAs = new HashMap();
    private Set anySet;
    private Map attributeArrays = new HashMap();
    private Map attributeMaps = new HashMap();

    public static DTDValidator create(URL url) throws IOException {
        DTDParser parser = new DTDParser(url);
        DTD dtd = parser.parse();
        DTDValidator validator = new DTDValidator();
        for (DTDElement element : dtd.elements.values()) {
            DFAState dfa;
            if (element.getContent() instanceof DTDEmpty) {
                dfa = emptyDFA;
            } else if (element.getContent() instanceof DTDAny) {
                dfa = null;
            } else {
                DFABuilder.Node node = DTDValidator.createDFANode(element.getContent());
                dfa = DFABuilder.createDFA(node);
            }
            validator.elementDFAs.put(element.getName(), dfa);
            HashMap<String, AttributeDefinition> defMap = new HashMap<String, AttributeDefinition>();
            Object[] defArray = new AttributeDefinition[element.attributes.size()];
            int i = 0;
            for (DTDAttribute attr : element.attributes.values()) {
                AttributeDefinition.Type type;
                String[] values = null;
                if (attr.getType() instanceof DTDEnumeration) {
                    type = AttributeDefinition.Type.ENUMERATION;
                    values = ((DTDEnumeration)attr.getType()).getItems();
                } else if (attr.getType() instanceof DTDNotationList) {
                    type = AttributeDefinition.Type.ENUMERATION;
                    values = ((DTDNotationList)attr.getType()).getItems();
                } else if (attr.getType() instanceof String) {
                    type = AttributeDefinition.Type.get((String)attr.getType());
                } else {
                    throw new RuntimeException("Unrecognized attribute type for element " + element.getName() + " attribute " + attr.getName() + " type " + attr.getType().getClass().getName());
                }
                AttributeDefinition ad = new AttributeDefinition(attr.getName(), type, attr.getDefaultValue(), values, attr.getDecl() == DTDDecl.REQUIRED, attr.getDecl() == DTDDecl.FIXED);
                defMap.put(attr.getName(), ad);
                defArray[i] = ad;
                ++i;
            }
            validator.attributeMaps.put(element.getName(), defMap);
            Arrays.sort(defArray);
            validator.attributeArrays.put(element.getName(), defArray);
        }
        validator.anySet = new HashSet();
        validator.anySet.addAll(validator.elementDFAs.keySet());
        validator.anySet.add("#PCDATA");
        return validator;
    }

    @Override
    public AttributeDefinition getAttributeDefinition(String element, String attribute) {
        Map attrMap = (Map)this.attributeMaps.get(element);
        return attrMap == null ? null : (AttributeDefinition)attrMap.get(attribute);
    }

    @Override
    public AttributeDefinition[] getAttributeDefinitions(String element) {
        if (this.attributeArrays.containsKey(element)) {
            return (AttributeDefinition[])this.attributeArrays.get(element);
        }
        return new AttributeDefinition[0];
    }

    @Override
    public Set getValidRootElements() {
        return this.elementDFAs.keySet();
    }

    @Override
    public Set getValidItems(String element, String[] prefix, String[] suffix) {
        HashSet<String> candidates = null;
        DFAState dfa = (DFAState)this.elementDFAs.get(element);
        if (dfa == null) {
            return this.anySet;
        }
        DFAState target = dfa.getState(Arrays.asList(prefix));
        if (target == null) {
            return Collections.EMPTY_SET;
        }
        if (prefix.length > 0 && prefix[prefix.length - 1].equals("#PCDATA")) {
            candidates = new HashSet<String>();
            candidates.addAll(target.getValidSymbols());
            candidates.add("#PCDATA");
        } else {
            candidates = target.getValidSymbols();
        }
        HashSet<String> results = new HashSet<String>();
        String[] middle = new String[1];
        Iterator iter = candidates.iterator();
        while (iter.hasNext()) {
            middle[0] = (String)iter.next();
            if (!this.isValidSequence(element, prefix, middle, suffix, true)) continue;
            results.add(middle[0]);
        }
        return Collections.unmodifiableSet(results);
    }

    @Override
    public boolean isValidSequence(String element, String[] nodes, boolean partial) {
        DFAState dfa = (DFAState)this.elementDFAs.get(element);
        if (dfa == null) {
            return true;
        }
        DFAState target = dfa.getState(Arrays.asList(nodes));
        return target != null && (partial || target.isAccepting());
    }

    private DTDValidator() {
    }

    private static DFABuilder.Node createDFANode(DTDItem item) {
        DFABuilder.Node node = null;
        if (item instanceof DTDName) {
            String name = ((DTDName)item).getValue();
            node = DFABuilder.createSymbolNode(name);
        } else if (item instanceof DTDPCData) {
            node = DFABuilder.createSymbolNode("#PCDATA");
        } else if (item instanceof DTDChoice) {
            for (DTDItem child : ((DTDContainer)item).getItemsVec()) {
                DFABuilder.Node newNode = DTDValidator.createDFANode(child);
                node = node == null ? newNode : DFABuilder.createChoiceNode(node, newNode);
            }
        } else if (item instanceof DTDMixed) {
            for (DTDItem child : ((DTDContainer)item).getItemsVec()) {
                DFABuilder.Node newNode = DTDValidator.createDFANode(child);
                node = node == null ? newNode : DFABuilder.createChoiceNode(node, newNode);
            }
            DFABuilder.Node pcdata = DFABuilder.createSymbolNode("#PCDATA");
            node = DFABuilder.createChoiceNode(node, pcdata);
        } else if (item instanceof DTDSequence) {
            for (DTDItem child : ((DTDContainer)item).getItemsVec()) {
                DFABuilder.Node newNode = DTDValidator.createDFANode(child);
                node = node == null ? newNode : DFABuilder.createSequenceNode(node, newNode);
            }
        } else {
            throw new RuntimeException("Unexpected DTDItem subclass: " + item.getClass().getName());
        }
        if (node == null) {
            return node;
        }
        if (item.cardinal == DTDCardinal.OPTIONAL) {
            node = DFABuilder.createOptionalNode(node);
        } else if (item.cardinal == DTDCardinal.ZEROMANY) {
            node = DFABuilder.createRepeatingNode(node, 0);
        } else if (item.cardinal == DTDCardinal.ONEMANY) {
            node = DFABuilder.createRepeatingNode(node, 1);
        }
        return node;
    }
}

