/*
 * Decompiled with CFR 0.152.
 */
package net.sf.vex.dom.linked;

import info.textgrid.util.text.TextUtils;
import java.text.MessageFormat;
import java.util.LinkedList;
import net.sf.vex.VexToolkitPlugin;
import net.sf.vex.dom.Content;
import net.sf.vex.dom.IVexNode;
import net.sf.vex.dom.IVexText;
import net.sf.vex.dom.Position;
import net.sf.vex.dom.linked.LinkedElement;
import net.sf.vex.dom.linked.LinkedNode;
import org.eclipse.wst.sse.core.internal.provisional.INodeNotifier;
import org.eclipse.wst.sse.core.internal.provisional.IndexedRegion;
import org.w3c.dom.Text;

public class LinkedText
extends LinkedNode
implements IVexText {
    private LinkedList<IndentChange> indentCorrections;
    private int endSpaceHack = 0;

    public LinkedText(IVexNode parent, Text text, Content content) {
        super(text);
        this.setParent(parent);
        this.setContent(content);
    }

    @Override
    public Text getDomNode() {
        return (Text)super.getDomNode();
    }

    @Override
    public boolean hasValidContent() {
        String textContent = this.getContent().getString(this.getStartOffset(), this.getEndOffset() - this.getStartOffset());
        int nulPos = textContent.indexOf(0);
        if (nulPos > -1) {
            VexToolkitPlugin.log(2, new IllegalArgumentException(), "Text contains \\0 at pos. {0}! {1}", nulPos, this);
            return false;
        }
        return true;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && this.getText().equals(((LinkedText)obj).getText());
    }

    @Override
    public String toString() {
        return MessageFormat.format("{0}({1}..{2} ({5}, {6}): ''{3}'') <-> {4}", this.getClass().getSimpleName(), this.getStartOffset(), this.getEndOffset(), TextUtils.visualizeControlChars((String)this.getContent().getString(this.getStartOffset(), this.getEndOffset() - this.getStartOffset()), (boolean)true), TextUtils.visualizeControlChars((String)this.getDomNode().toString(), (boolean)false), this.getStartPosition(), this.getEndPosition());
    }

    void deleteTextAbs(int startOffset, int endOffset) {
        int domLength;
        int length;
        if (startOffset < this.getStartOffset() || endOffset > this.getEndOffset()) {
            throw new IllegalArgumentException(MessageFormat.format("The text fragment to delete ({0}..{1}) is not completely managed by this Text node ({2})", startOffset, endOffset, this));
        }
        int relOffset = startOffset - this.getStartOffset();
        relOffset += this.getCorrectionForContentPos(relOffset);
        int relEndOffset = endOffset - this.getStartOffset();
        if ((length = (relEndOffset += this.getCorrectionForContentPos(relEndOffset)) - relOffset) > (domLength = this.getDomNode().getLength())) {
            this.getContent().remove(startOffset, length - domLength);
            length = Math.min(length, domLength);
            VexToolkitPlugin.log(2, null, "The do-not-delete-over-the-end-of-text-nodes guard from TG-207 triggered trying to delete from {0} to {1} in {2}.", startOffset, endOffset, this);
        }
        if (length > 0) {
            this.getDomNode().deleteData(relOffset, length);
        }
    }

    public void insertTextAbs(int offset, String s) {
        int startOffset = this.getStartOffset();
        if (offset < startOffset || offset > this.getEndOffset()) {
            throw new IllegalArgumentException(MessageFormat.format("Cannot insert {0} into {1} at offset {2}: Off limits", s, this, offset));
        }
        int relOffset = offset - startOffset;
        relOffset += this.getCorrectionForContentPos(relOffset);
        if (offset == this.getEndOffset() && " ".equals(s)) {
            ++this.endSpaceHack;
        }
        this.getDomNode().insertData(relOffset, s);
    }

    protected LinkedElement getParentElement() {
        LinkedNode node = this;
        while (!((node = node.getParent()) instanceof LinkedElement)) {
        }
        return (LinkedElement)node;
    }

    protected boolean isPre() {
        LinkedElement parentElement = this.getParentElement();
        return parentElement != null ? parentElement.isPre() : false;
    }

    protected String getWSNormalizedString() {
        String orig = this.getDomNode().getData();
        this.indentCorrections = new LinkedList();
        if (this.isPre()) {
            if (VexToolkitPlugin.isDebugging("net.sf.vex.toolkit/debug/selection")) {
                System.out.println("Did not normalize new text: " + TextUtils.visualizeControlChars((String)orig, (boolean)true));
            }
            return orig;
        }
        StringBuilder target = new StringBuilder(orig.length());
        int t = 0;
        int skippedWS = 0;
        int state = 0;
        int i = 0;
        while (i < orig.length()) {
            char ch = orig.charAt(i);
            switch (state) {
                case 0: {
                    if (Character.isWhitespace(ch) || Character.isISOControl(ch)) {
                        ++skippedWS;
                        break;
                    }
                    if (skippedWS > 0 && this.getDomNode().getPreviousSibling() != null) {
                        target.append(' ');
                        --skippedWS;
                    }
                    target.append(ch);
                    this.indentCorrections.add(new IndentChange(this.getContent().createPosition(t), skippedWS));
                    ++t;
                    state = 1;
                    break;
                }
                case 1: {
                    if (!Character.isWhitespace(ch) && !Character.isISOControl(ch)) {
                        target.append(ch);
                        ++t;
                        break;
                    }
                    state = 2;
                    ++skippedWS;
                    break;
                }
                case 2: {
                    if (Character.isWhitespace(ch) || Character.isISOControl(ch)) {
                        ++skippedWS;
                        break;
                    }
                    target.append(' ');
                    ++t;
                    target.append(ch);
                    if (this.indentCorrections.isEmpty() || this.indentCorrections.getLast().skippedWS != --skippedWS) {
                        this.indentCorrections.add(new IndentChange(this.getContent().createPosition(t), skippedWS));
                    }
                    ++t;
                    state = 1;
                }
            }
            ++i;
        }
        if (state == 0 && orig.length() > 0) {
            if (this.getDomNode().getPreviousSibling() == null && this.getDomNode().getNextSibling() == null) {
                target.append(' ');
                ++t;
                --skippedWS;
            }
            if (this.indentCorrections.isEmpty() || this.indentCorrections.getLast().skippedWS != skippedWS) {
                this.indentCorrections.add(new IndentChange(this.getContent().createPosition(t + 1), skippedWS));
            }
        } else if (state == 2) {
            if (this.getDomNode().getNextSibling() != null) {
                target.append(' ');
                ++t;
                --skippedWS;
            }
            if (this.endSpaceHack > 0) {
                target.append(' ');
                ++t;
                --skippedWS;
                --this.endSpaceHack;
            }
            if (this.indentCorrections.isEmpty() || this.indentCorrections.getLast().skippedWS != skippedWS) {
                this.indentCorrections.add(new IndentChange(this.getContent().createPosition(t + 1), skippedWS));
            }
        }
        if (VexToolkitPlugin.isDebugging("net.sf.vex.toolkit/debug/selection")) {
            System.out.println("Mapped " + TextUtils.visualizeControlChars((String)orig, (boolean)true) + "\n    to " + TextUtils.visualizeControlChars((String)target.toString(), (boolean)true));
        }
        return target.toString();
    }

    public int getCorrectionForSourcePos(int sourcePosition) {
        IndentChange change = null;
        IndentChange next2 = null;
        for (IndentChange next2 : this.indentCorrections) {
            if (next2.contentPosition.getOffset() + next2.skippedWS > sourcePosition) break;
            change = next2;
        }
        int result = 0;
        if (change == null) {
            if (next2 != null && sourcePosition < next2.skippedWS) {
                result = -sourcePosition;
            }
        } else {
            result = -change.skippedWS;
        }
        if (VexToolkitPlugin.isDebugging("net.sf.vex.toolkit/debug/selection")) {
            System.out.println("Correction for source pos " + sourcePosition + ": " + change + " of " + this.indentCorrections + " -> " + result);
            System.out.println(TextUtils.visualizeControlChars((String)this.getDomNode().getData(), (boolean)true));
        }
        return result;
    }

    public int getCorrectionForContentPos(int contentPosition) {
        int result;
        IndentChange change = null;
        boolean startTagCorrection = this.getEndOffset() == this.getStartOffset() && this.getDomNode().getNextSibling() != null;
        for (IndentChange next : this.indentCorrections) {
            if (next.contentPosition.getOffset() > contentPosition && !startTagCorrection) break;
            change = next;
        }
        int n = result = change == null ? 0 : change.skippedWS;
        if (VexToolkitPlugin.isDebugging("net.sf.vex.toolkit/debug/selection")) {
            System.out.println(MessageFormat.format("Correction for content pos {0}: {1} of {2} ->  {3}; start tag correction: {5}; in {4}", contentPosition, change, this.indentCorrections, result, this, startTagCorrection));
        }
        return result;
    }

    @Override
    public void notifyChanged(INodeNotifier notifier, int eventType, Object changedFeature, Object oldValue, Object newValue, int pos) {
        switch (eventType) {
            case 1: 
            case 2: {
                if (!(newValue instanceof String)) break;
                if (VexToolkitPlugin.isDebugging("net.sf.vex.toolkit/debug/nodeadapter")) {
                    System.out.println("Processing: " + this.formatNotification(notifier, eventType, changedFeature, oldValue, newValue, pos));
                }
                int startOffset = this.getStartOffset();
                int endOffset = this.getEndOffset();
                int oldLength = endOffset - startOffset;
                this.getContent().remove(startOffset, oldLength);
                String newContent = this.getWSNormalizedString();
                int newLength = newContent.length();
                this.getContent().insertString(startOffset, newContent);
                this.setContent(this.getContent(), startOffset, startOffset + newLength);
                if (VexToolkitPlugin.isDebugging("net.sf.vex.toolkit/debug/nodeadapter")) {
                    System.out.println("Processed " + this.formatNotification(notifier, eventType, changedFeature, oldValue, newValue, pos));
                    this.getDocument().printDocument();
                }
                if (VexToolkitPlugin.isDebugging("net.sf.vex.toolkit/debug/syncevents")) {
                    System.out.println(MessageFormat.format("changed text to {0}", this));
                }
                return;
            }
        }
        super.notifyChanged(notifier, eventType, changedFeature, oldValue, newValue, pos);
    }

    public int getContentOffsetFor(int sourceOffset) {
        int nodeSourceOffset = ((IndexedRegion)this.getAdapter(IndexedRegion.class)).getStartOffset();
        int relOffset = sourceOffset - nodeSourceOffset;
        relOffset += this.getCorrectionForSourcePos(relOffset);
        return this.getStartOffset() + relOffset;
    }

    private class IndentChange {
        public Position contentPosition;
        public int skippedWS;

        public IndentChange(Position contentPosition, int skippedWS) {
            this.contentPosition = contentPosition;
            this.skippedWS = skippedWS;
        }

        public String toString() {
            return MessageFormat.format("<{0}+{1}>", this.contentPosition, this.skippedWS);
        }
    }
}

