/*
 * Decompiled with CFR 0.152.
 */
package net.sf.vex.layout;

import java.text.MessageFormat;
import net.sf.vex.VexToolkitPlugin;
import net.sf.vex.core.Color;
import net.sf.vex.dom.IVexNode;
import net.sf.vex.dom.linked.LinkedDocument;
import net.sf.vex.dom.linked.LinkedText;
import net.sf.vex.layout.VexAnnotationSupport;
import net.sf.vex.layout.VexAnnotationTracker;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.PlatformObject;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.ui.texteditor.AnnotationPreference;

public class AnnotationRenderingInfo
extends PlatformObject {
    private IVexNode vexNode;
    private VexAnnotationTracker tracker;
    public final Annotation annotation;
    public final VexAnnotationSupport support;
    private AnnotationPreference preference;

    AnnotationRenderingInfo(Annotation annotation, VexAnnotationTracker tracker, IVexNode vexNode) {
        Assert.isLegal((annotation != null ? 1 : 0) != 0, (String)"Cannot create rendering info for null");
        Assert.isLegal((tracker != null ? 1 : 0) != 0, (String)"VexAnnotationSupport required");
        this.annotation = annotation;
        this.tracker = tracker;
        this.support = tracker.getSupport();
        this.vexNode = vexNode;
    }

    public AnnotationPreference getPreference() {
        if (this.preference == null) {
            this.preference = this.support.getPreference(this.annotation);
        }
        return this.preference;
    }

    public boolean isShownInText() {
        boolean result = this.getPreference().getTextPreferenceValue();
        if (result && VexToolkitPlugin.isDebugging("net.sf.vex.toolkit/debug/annotations")) {
            System.out.println(MessageFormat.format("Showing in text: {0}", this.annotation.getText()));
        }
        return result;
    }

    public String toString() {
        return "AnnotationRenderingInfo [annotation=" + this.annotation + ", vexNode=" + this.vexNode + "]";
    }

    public Color getColor() {
        RGB rgb = this.getPreference().getColorPreferenceValue();
        return new Color(rgb.red, rgb.green, rgb.blue);
    }

    public Position getContentPosition() {
        if (this.vexNode instanceof LinkedText) {
            LinkedText text = (LinkedText)this.vexNode;
            Position position = this.tracker.getAnnotationModel().getPosition(this.annotation);
            int contentOffset = text.getContentOffsetFor(position.offset);
            int contentLength = text.getContentOffsetFor(position.offset + position.length) - contentOffset;
            return new Position(contentOffset, contentLength);
        }
        return new Position(this.vexNode.getStartOffset(), this.vexNode.getEndOffset() - this.vexNode.getStartOffset());
    }

    public Position getPositionIn(LinkedDocument document) {
        Position sourcePosition = this.tracker.getAnnotationModel().getPosition(this.annotation);
        IRegion contentRegion = document.contentRegionFor((IRegion)new Region(sourcePosition.offset, sourcePosition.length));
        return new Position(contentRegion.getOffset(), contentRegion.getLength());
    }
}

