/*
 * Decompiled with CFR 0.152.
 */
package net.sf.vex.swing;

import java.awt.BasicStroke;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.image.ImageObserver;
import java.util.HashSet;
import java.util.Set;
import javax.swing.UIManager;
import net.sf.vex.core.Color;
import net.sf.vex.core.ColorResource;
import net.sf.vex.core.FontMetrics;
import net.sf.vex.core.FontResource;
import net.sf.vex.core.FontSpec;
import net.sf.vex.core.Graphics;
import net.sf.vex.core.Rectangle;
import net.sf.vex.swing.AwtColor;
import net.sf.vex.swing.AwtFont;
import net.sf.vex.swing.AwtFontMetrics;

public class AwtGraphics
implements Graphics {
    private Graphics2D g;
    private int originX;
    private int originY;
    private static Set availableFontFamilies = new HashSet();
    private int lineWidth = 1;
    private int lineStyle;

    static {
        GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
        String[] names = ge.getAvailableFontFamilyNames();
        int i = 0;
        while (i < names.length) {
            availableFontFamilies.add(names[i].toLowerCase());
            ++i;
        }
    }

    public AwtGraphics(Graphics2D g) {
        this.g = g;
    }

    @Override
    public void dispose() {
    }

    @Override
    public void drawChars(char[] chars, int offset, int length, int x, int y) {
        this.g.drawString(new String(chars, offset, length), x + this.originX, y + this.originY + this.g.getFontMetrics().getAscent());
    }

    @Override
    public void drawLine(int x1, int y1, int x2, int y2) {
        this.g.drawLine(x1 + this.originX, y1 + this.originY, x2 + this.originX, y2 + this.originY);
    }

    @Override
    public void drawOval(int x, int y, int width, int height) {
        this.g.drawOval(x + this.originX, y + this.originY, width, height);
    }

    @Override
    public void drawRect(int x, int y, int width, int height) {
        this.g.drawRect(x + this.originX, y + this.originY, width, height);
    }

    @Override
    public void drawString(String s, int x, int y) {
        this.g.drawString(s, x + this.originX, y + this.originY + this.g.getFontMetrics().getAscent());
    }

    @Override
    public void fillOval(int x, int y, int width, int height) {
        this.g.fillOval(x + this.originX, y + this.originY, width, height);
    }

    @Override
    public void fillRect(int x, int y, int width, int height) {
        this.g.fillRect(x + this.originX, y + this.originY, width, height);
    }

    @Override
    public Rectangle getClipBounds() {
        java.awt.Rectangle r = this.g.getClipBounds();
        return new Rectangle(r.x - this.originX, r.y - this.originY, r.width, r.height);
    }

    @Override
    public ColorResource getColor() {
        return new AwtColor(this.g.getColor());
    }

    @Override
    public FontResource getFont() {
        return new AwtFont(this.g.getFont());
    }

    @Override
    public FontMetrics getFontMetrics() {
        return new AwtFontMetrics(this.g.getFontMetrics());
    }

    @Override
    public int getLineStyle() {
        return this.lineStyle;
    }

    @Override
    public int getLineWidth() {
        return this.lineWidth;
    }

    @Override
    public boolean isAntiAliased() {
        return false;
    }

    @Override
    public void setAntiAliased(boolean antiAliased) {
    }

    @Override
    public ColorResource setColor(ColorResource color) {
        ColorResource oldColor = this.getColor();
        this.g.setColor(((AwtColor)color).getAwtColor());
        return oldColor;
    }

    @Override
    public FontResource setFont(FontResource font) {
        FontResource oldFont = this.getFont();
        this.g.setFont(((AwtFont)font).getAwtFont());
        return oldFont;
    }

    @Override
    public void setLineStyle(int lineStyle) {
        this.lineStyle = lineStyle;
        this.makeStroke();
    }

    @Override
    public void setLineWidth(int lineWidth) {
        this.lineWidth = lineWidth;
        this.makeStroke();
    }

    @Override
    public int charsWidth(char[] data, int offset, int length) {
        return this.stringWidth(new String(data, offset, length));
    }

    public void setOrigin(int x, int y) {
        this.originX = x;
        this.originY = y;
    }

    @Override
    public ColorResource createColor(Color rgb) {
        return new AwtColor(new java.awt.Color(rgb.getRed(), rgb.getGreen(), rgb.getBlue()));
    }

    @Override
    public FontResource createFont(FontSpec fontSpec) {
        int style = 0;
        if ((fontSpec.getStyle() & 1) > 0) {
            style |= 1;
        }
        if ((fontSpec.getStyle() & 2) > 0) {
            style |= 2;
        }
        int size = Math.round(fontSpec.getSize());
        String name = "sans-serif";
        String[] names = fontSpec.getNames();
        int i = 0;
        while (i < names.length) {
            if (availableFontFamilies.contains(names[i])) {
                name = names[i];
                break;
            }
            ++i;
        }
        return new AwtFont(new Font(name, style, size));
    }

    @Override
    public ColorResource getSystemColor(int id) {
        if (id == 0) {
            return new AwtColor(UIManager.getColor("TextPane.selectionBackground"));
        }
        if (id == 1) {
            return new AwtColor(UIManager.getColor("TextPane.selectionForeground"));
        }
        return new AwtColor(java.awt.Color.BLACK);
    }

    @Override
    public int stringWidth(String s) {
        return this.g.getFontMetrics().stringWidth(s);
    }

    private void makeStroke() {
        float dashLength = this.lineWidth;
        if (this.lineStyle == 1) {
            dashLength = 3 * this.lineWidth;
        }
        BasicStroke stroke = new BasicStroke(this.lineWidth, 2, 0, 1.0f, new float[]{dashLength, dashLength}, 0.0f);
        this.g.setStroke(stroke);
    }

    public void drawImage(Image image, int x, int y, int width, int height) {
        ImageObserver observer = null;
        this.g.drawImage(image, x, y, width, height, observer);
    }

    @Override
    public void drawImage(org.eclipse.swt.graphics.Image image, int x, int y, int width, int height) {
    }
}

