/*
 * Decompiled with CFR 0.152.
 */
package info.textgrid.lab.core.efs.tgcrud;

import info.textgrid.lab.core.efs.tgcrud.Activator;
import info.textgrid.lab.core.efs.tgcrud.ExceptionPassingPipedOutputStream;
import info.textgrid.lab.core.efs.tgcrud.TextGridEFSRuntimeError;
import info.textgrid.lab.core.model.TextGridObject;
import java.io.IOException;
import java.net.URI;
import org.eclipse.core.filesystem.IFileStore;

class CloseExceptionHandler
implements ExceptionPassingPipedOutputStream.ICloseExceptionHandler {
    private IFileStore fileStore;
    private String message;

    public CloseExceptionHandler(IFileStore fileStore, String message) {
        this.fileStore = fileStore;
        this.message = message;
    }

    @Override
    public boolean handleException(Throwable exception) throws IOException {
        if (exception instanceof IOException) {
            IOException ioe = (IOException)exception;
            Throwable cause = ioe.getCause();
            if (cause == null) {
                cause = ioe;
            }
            Activator.logServiceCall("{0}: {1}", this.message, cause);
            Activator.handleError(ioe, "{2} while working on {0}: {1}", this.fileStore, cause, cause.getClass().getSimpleName());
            URI textgridUri = TextGridObject.computeTextGridURI((URI)this.fileStore.toURI());
            TextGridEFSRuntimeError runtimeError = new TextGridEFSRuntimeError("Error updating/creating " + textgridUri.toString());
            runtimeError.initCause(ioe);
            throw runtimeError;
        }
        return false;
    }
}

