/*
 * Decompiled with CFR 0.152.
 */
package info.textgrid.lab.xmleditor.mpeditor;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.cache.RemovalListener;
import com.google.common.cache.RemovalNotification;
import info.textgrid.lab.authn.RBACSession;
import info.textgrid.lab.conf.OfflineException;
import info.textgrid.lab.conf.client.ConfClient;
import info.textgrid.lab.xmleditor.mpeditor.Activator;
import info.textgrid.lab.xmleditor.mpeditor.LabErrorListener;
import info.textgrid.lab.xmleditor.mpeditor.Messages;
import java.io.PrintWriter;
import java.io.StringReader;
import java.io.StringWriter;
import java.text.MessageFormat;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.transform.Source;
import javax.xml.transform.Templates;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.TransformerFactoryConfigurationError;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.text.IDocument;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.progress.UIJob;
import org.eclipse.ui.statushandlers.StatusManager;

public class PreviewPage
extends Composite {
    private final Browser browser;
    protected static QName TEI = new QName("http://www.tei-c.org/ns/1.0", "TEI");
    private static StylesheetManager stylesheetManager = null;

    public PreviewPage(Composite parent, int style) {
        super(parent, style);
        this.setLayout((Layout)new GridLayout(1, false));
        this.browser = new Browser((Composite)this, 0);
        this.browser.setText(Messages.PreviewPage_Loading);
        this.browser.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
    }

    protected void checkSubclass() {
    }

    public void setDocument(final IDocument document) {
        if (this.browser != null && !this.browser.isDisposed()) {
            new Job(Messages.PreviewPage_Updating){

                protected IStatus run(IProgressMonitor monitor) {
                    SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
                    progress.worked(5);
                    String doc = document.get();
                    try {
                        Templates stylesheet;
                        try {
                            stylesheet = PreviewPage.getStylesheetManager().getAssociatedStylesheet(doc);
                            progress.worked(5);
                        }
                        catch (TransformerConfigurationException noStylesheetException) {
                            if (!stylesheetManager.supportsXSLT2() || !TEI.equals(PreviewPage.this.getRootElement(new StreamSource(new StringReader(doc)), (IProgressMonitor)progress.newChild(5)))) {
                                throw noStylesheetException;
                            }
                            String stylesheetURL = Activator.getDefault().getPreferenceStore().getString("defaultPreviewXSLT");
                            stylesheet = PreviewPage.getStylesheetManager().getStylesheet(stylesheetURL);
                            progress.worked(15);
                        }
                        Transformer transformer = stylesheet.newTransformer();
                        progress.worked(15);
                        String sid = RBACSession.getInstance().getSID(false);
                        transformer.setParameter("sessionId", sid);
                        try {
                            StringBuilder pattern = new StringBuilder();
                            String crudEndpoint = ConfClient.getInstance().getValue("tgcrud");
                            pattern.append(crudEndpoint.substring(0, crudEndpoint.lastIndexOf(47) + 1));
                            pattern.append("rest/@URI@/data");
                            if (sid != null && !sid.isEmpty()) {
                                pattern.append("?sessionId=").append(sid);
                            }
                            transformer.setParameter("graphicsURLPattern", pattern.toString());
                        }
                        catch (OfflineException e) {
                            StatusManager.getManager().handle((IStatus)new Status(2, "info.textgrid.lab.xmleditor.mpeditor", "Cannot determine TG-crud instance", (Throwable)e));
                        }
                        StringReader reader = new StringReader(doc);
                        StreamSource source = new StreamSource(reader);
                        StringWriter writer = new StringWriter();
                        StreamResult result = new StreamResult(writer);
                        progress.worked(10);
                        transformer.transform(source, result);
                        progress.worked(45);
                        PreviewPage.this.setText(writer.toString());
                        progress.worked(5);
                        progress.done();
                    }
                    catch (TransformerException e) {
                        PreviewPage.this.handleException(e, PreviewPage.getStylesheetManager().getErrorListener());
                        return Status.CANCEL_STATUS;
                    }
                    catch (TransformerFactoryConfigurationError e) {
                        PreviewPage.this.handleException(e, PreviewPage.getStylesheetManager().getErrorListener());
                        return Status.CANCEL_STATUS;
                    }
                    catch (ExecutionException e) {
                        PreviewPage.this.handleException(e.getCause(), PreviewPage.getStylesheetManager().getErrorListener());
                        return Status.CANCEL_STATUS;
                    }
                    catch (XMLStreamException e) {
                        PreviewPage.this.handleException(e.getCause(), PreviewPage.getStylesheetManager().getErrorListener());
                        return Status.CANCEL_STATUS;
                    }
                    return Status.OK_STATUS;
                }
            }.schedule();
        }
    }

    private void showUsageMessage(String title, String body) {
        String message = Messages.PreviewPage_UsageMessageHTML;
        this.setText(NLS.bind((String)message, (Object)title, (Object)body));
    }

    private IStatus handleException(Throwable e, LabErrorListener errorListener) {
        StringWriter writer = new StringWriter();
        PrintWriter printer = new PrintWriter(writer);
        e.printStackTrace(printer);
        this.showUsageMessage(e.getClass().getSimpleName(), MessageFormat.format(Messages.PreviewPage_ErrorDetailsHTML, e.getLocalizedMessage(), e.getCause() == null ? Messages.PreviewPage_NoCause : e.getCause().getLocalizedMessage(), errorListener == null ? Messages.PreviewPage_NoCause : errorListener.toHTML(true), writer.toString()));
        Status status = new Status(4, "info.textgrid.lab.xmleditor.mpeditor", e.getLocalizedMessage(), e);
        StatusManager.getManager().handle((IStatus)status);
        return status;
    }

    public void setText(final String text) {
        new UIJob(Messages.PreviewPage_UpdatingBrowser){

            public IStatus runInUIThread(IProgressMonitor monitor) {
                if (PreviewPage.this.browser != null && !PreviewPage.this.browser.isDisposed()) {
                    PreviewPage.this.browser.setText(text, true);
                }
                return Status.OK_STATUS;
            }
        }.schedule();
    }

    public static StylesheetManager getStylesheetManager() {
        if (stylesheetManager == null) {
            stylesheetManager = new StylesheetManager();
        }
        return stylesheetManager;
    }

    private QName getRootElement(StreamSource streamSource, IProgressMonitor monitor) throws XMLStreamException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)5);
        XMLInputFactory factory = XMLInputFactory.newInstance();
        factory.setProperty("javax.xml.stream.isSupportingExternalEntities", false);
        factory.setProperty("javax.xml.stream.supportDTD", false);
        XMLStreamReader reader = factory.createXMLStreamReader(streamSource);
        progress.worked(2);
        reader.nextTag();
        progress.worked(3);
        return reader.getName();
    }

    protected static class StylesheetManager {
        private TransformerFactory transformerFactory = null;
        private LoadingCache<String, Templates> cache;
        private LabErrorListener errorListener = new LabErrorListener();

        private TransformerFactory getTransformerFactory() throws TransformerFactoryConfigurationError {
            if (this.transformerFactory == null) {
                try {
                    this.transformerFactory = TransformerFactory.newInstance("net.sf.saxon.TransformerFactoryImpl", null);
                    this.transformerFactory.setErrorListener(this.errorListener);
                }
                catch (TransformerFactoryConfigurationError e) {
                    StatusManager.getManager().handle((IStatus)new Status(2, "info.textgrid.lab.xmleditor.mpeditor", "Could not instantiate saxon: XSLT support is limited to XSLT 1.0", (Throwable)e));
                    this.transformerFactory = TransformerFactory.newInstance();
                }
            }
            return this.transformerFactory;
        }

        public boolean supportsXSLT2() {
            return this.getTransformerFactory().getClass().getCanonicalName().startsWith("net.sf.saxon");
        }

        public Templates getStylesheet(String uri) throws ExecutionException {
            return (Templates)this.cache.get((Object)uri);
        }

        public Templates getStylesheet(final Source source) throws ExecutionException {
            return (Templates)this.cache.get((Object)source.getSystemId(), (Callable)new Callable<Templates>(){

                @Override
                public Templates call() throws Exception {
                    return StylesheetManager.this.getTransformerFactory().newTemplates(source);
                }
            });
        }

        public Templates getAssociatedStylesheet(String document) throws TransformerConfigurationException, ExecutionException {
            StringReader anaReader = new StringReader(document);
            StreamSource anaSource = new StreamSource(anaReader);
            Source stylesheetSource = this.getTransformerFactory().getAssociatedStylesheet(anaSource, null, null, null);
            return this.getStylesheet(stylesheetSource);
        }

        public LabErrorListener getErrorListener() {
            return this.errorListener;
        }

        public StylesheetManager() {
            this.cache = CacheBuilder.newBuilder().recordStats().expireAfterAccess(30L, TimeUnit.MINUTES).maximumSize(5L).removalListener((RemovalListener)new RemovalListener<String, Templates>(){

                public void onRemoval(RemovalNotification<String, Templates> notification) {
                    StatusManager.getManager().handle((IStatus)new Status(1, "info.textgrid.lab.xmleditor.mpeditor", notification.toString()));
                }
            }).build((CacheLoader)new CacheLoader<String, Templates>(){

                public Templates load(String systemId) throws Exception {
                    Templates templates = StylesheetManager.this.getTransformerFactory().newTemplates(new StreamSource(systemId));
                    StatusManager.getManager().handle((IStatus)new Status(1, "info.textgrid.lab.xmleditor.mpeditor", "Loaded XSLT stylesheet from " + systemId));
                    return templates;
                }
            });
        }
    }
}

