/*
 * Decompiled with CFR 0.152.
 */
package info.textgrid.lab.authn;

import info.textgrid.lab.authn.AuthBrowser;
import info.textgrid.lab.authn.Messages;
import info.textgrid.lab.authn.RBACSession;
import info.textgrid.lab.authn.UserIDDialog;
import info.textgrid.namespaces.middleware.tgauth.UserDetail;
import java.text.MessageFormat;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.window.IShellProvider;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.menus.WorkbenchWindowControlContribution;

public class LoginControlContribution
extends WorkbenchWindowControlContribution
implements SelectionListener,
AuthBrowser.ISIDChangedListener {
    private Link loginLink;
    private Composite contributionArea;

    public LoginControlContribution() {
    }

    public LoginControlContribution(String id) {
        super(id);
    }

    protected Control createControl(Composite parent) {
        this.contributionArea = new Composite(parent, 0);
        this.contributionArea.setLayout((Layout)new GridLayout(1, false));
        this.loginLink = new Link(this.contributionArea, 0);
        this.setupLoginLink(RBACSession.getInstance().getSID(false), RBACSession.getInstance().getEPPN());
        GridDataFactory.fillDefaults().hint(200, -1).align(0x1000000, 0x1000000).applyTo((Control)this.loginLink);
        this.loginLink.addSelectionListener((SelectionListener)this);
        AuthBrowser.addSIDChangedListener(this);
        return this.contributionArea;
    }

    public void widgetDefaultSelected(SelectionEvent e) {
        this.widgetSelected(e);
    }

    public void widgetSelected(SelectionEvent e) {
        RBACSession.neverAsk(false);
        if ("".equals(RBACSession.getInstance().getSID(false))) {
            RBACSession.getInstance().getSID(true);
        } else {
            IWorkbenchWindow shellProvider = this.getWorkbenchWindow();
            if (shellProvider == null) {
                shellProvider = PlatformUI.getWorkbench().getModalDialogShellProvider();
            }
            new UserIDDialog((IShellProvider)shellProvider).open();
        }
    }

    @Override
    public void sidChanged(String newSID, String newEPPN) {
        this.setupLoginLink(newSID, newEPPN);
    }

    private void setupLoginLink(String sid, String eppn) {
        if (this.loginLink != null && !this.loginLink.isDisposed()) {
            if ("".equals(sid)) {
                this.loginLink.setText(Messages.LoginControlContribution_LoginLink);
                this.loginLink.setToolTipText(Messages.LoginControlContribution_LoginTooltip);
            } else {
                this.loginLink.setText("<a>" + eppn + "</a>");
                UserDetail details = RBACSession.getInstance().getDetails(eppn);
                this.loginLink.setToolTipText(MessageFormat.format(Messages.LoginControlContribution_LoggedInTooltip, details.getEPPN(), details.getName(), details.getMail(), details.getOrganisation()));
            }
        }
    }

    public void dispose() {
        if (this.loginLink != null && !this.loginLink.isDisposed()) {
            this.loginLink.removeSelectionListener((SelectionListener)this);
        }
        AuthBrowser.removeSIDChangedListener(this);
        super.dispose();
    }
}

