/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.core.internal.di;

import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.lang.reflect.AnnotatedElement;
import org.eclipse.e4.core.di.IInjector;
import org.eclipse.e4.core.di.annotations.GroupUpdates;
import org.eclipse.e4.core.di.annotations.Optional;
import org.eclipse.e4.core.di.suppliers.IObjectDescriptor;
import org.eclipse.e4.core.di.suppliers.IRequestor;
import org.eclipse.e4.core.di.suppliers.PrimaryObjectSupplier;
import org.eclipse.e4.core.internal.di.InjectorImpl;

public abstract class Requestor<L extends AnnotatedElement>
implements IRequestor {
    protected final L location;
    private final WeakReference<Object> objectRef;
    protected final boolean track;
    private final boolean groupUpdates;
    private final boolean isOptional;
    private final int objectHashcode;
    private final IInjector injector;
    protected final PrimaryObjectSupplier primarySupplier;
    private PrimaryObjectSupplier tempSupplier;
    protected Object[] actualArgs;
    private IObjectDescriptor[] objectDescriptors;

    protected abstract IObjectDescriptor[] calcDependentObjects();

    public Requestor(L location, IInjector injector, PrimaryObjectSupplier primarySupplier, PrimaryObjectSupplier tempSupplier, Object requestingObject, boolean track) {
        this.location = location;
        this.injector = injector;
        this.primarySupplier = primarySupplier;
        this.tempSupplier = tempSupplier;
        if (requestingObject != null) {
            this.objectRef = primarySupplier != null ? primarySupplier.makeReference(requestingObject) : new WeakReference<Object>(requestingObject);
            this.objectHashcode = requestingObject.hashCode();
        } else {
            this.objectRef = null;
            this.objectHashcode = 0;
        }
        this.track = track;
        this.groupUpdates = location == null ? false : location.isAnnotationPresent(GroupUpdates.class);
        this.isOptional = location == null ? false : location.isAnnotationPresent(Optional.class);
    }

    public L getLocation() {
        return this.location;
    }

    public IInjector getInjector() {
        return this.injector;
    }

    public PrimaryObjectSupplier getPrimarySupplier() {
        return this.primarySupplier;
    }

    public PrimaryObjectSupplier getTempSupplier() {
        return this.tempSupplier;
    }

    public void clearTempSupplier() {
        this.tempSupplier = null;
    }

    @Override
    public Object getRequestingObject() {
        if (this.objectRef == null) {
            return null;
        }
        return this.objectRef.get();
    }

    @Override
    public Class<?> getRequestingObjectClass() {
        Object object = this.getRequestingObject();
        if (object == null) {
            return null;
        }
        return object.getClass();
    }

    public Reference<Object> getReference() {
        return this.objectRef;
    }

    public boolean shouldTrack() {
        return this.track;
    }

    public boolean shouldGroupUpdates() {
        return this.groupUpdates;
    }

    public boolean isOptional() {
        return this.isOptional;
    }

    public boolean isResolved() {
        return this.actualArgs != null;
    }

    public void setResolvedArgs(Object[] actualArgs) {
        this.actualArgs = actualArgs;
    }

    @Override
    public boolean isValid() {
        return this.getRequestingObject() != null;
    }

    @Override
    public void resolveArguments(boolean initial) {
        ((InjectorImpl)this.injector).resolveArguments(this, initial);
    }

    @Override
    public void disposed(PrimaryObjectSupplier objectSupplier) {
        ((InjectorImpl)this.injector).disposed(objectSupplier);
        if (objectSupplier == this.primarySupplier && this.objectRef != null) {
            this.objectRef.clear();
        }
    }

    @Override
    public boolean uninject(Object object, PrimaryObjectSupplier objectSupplier) {
        Object originatingObject = this.getRequestingObject();
        if (originatingObject == null) {
            return false;
        }
        if (originatingObject != object) {
            return true;
        }
        this.injector.uninject(object, objectSupplier);
        return false;
    }

    public IObjectDescriptor[] getDependentObjects() {
        if (this.objectDescriptors == null) {
            this.objectDescriptors = this.calcDependentObjects();
        }
        return this.objectDescriptors;
    }

    protected void clearResolvedArgs() {
        if (this.actualArgs == null) {
            return;
        }
        int i = 0;
        while (i < this.actualArgs.length) {
            this.actualArgs[i] = null;
            ++i;
        }
        this.actualArgs = null;
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.location == null ? 0 : this.location.hashCode());
        result = 31 * result + (this.groupUpdates ? 1231 : 1237);
        result = 31 * result + (this.injector == null ? 0 : this.injector.hashCode());
        result = 31 * result + (this.isOptional ? 1231 : 1237);
        result = 31 * result + (this.primarySupplier == null ? 0 : this.primarySupplier.hashCode());
        result = 31 * result + this.objectHashcode;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Requestor other = (Requestor)obj;
        if (this.location == null ? other.location != null : !this.location.equals(other.location)) {
            return false;
        }
        if (this.groupUpdates != other.groupUpdates) {
            return false;
        }
        if (this.injector != other.injector) {
            return false;
        }
        if (this.isOptional != other.isOptional) {
            return false;
        }
        if (this.primarySupplier != other.primarySupplier) {
            return false;
        }
        return this.getRequestingObject() == other.getRequestingObject();
    }
}

