/*
 * Decompiled with CFR 0.152.
 */
package net.sf.vex.editor.config;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.TreeSet;
import net.sf.vex.editor.VexPlugin;
import net.sf.vex.editor.config.ConfigEvent;
import net.sf.vex.editor.config.ConfigRegistry;
import net.sf.vex.editor.config.DocumentType;
import net.sf.vex.editor.config.IConfigListener;
import net.sf.vex.editor.config.Messages;
import net.sf.vex.editor.config.PluginProject;
import net.sf.vex.editor.config.Style;
import org.eclipse.core.resources.IFile;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.PropertyPage;

public class StylePropertyPage
extends PropertyPage {
    private Style style;
    private static final int NAME_WIDTH = 150;
    private Composite pane;
    private Text nameText;
    private Table doctypesTable;
    private IConfigListener configListener;

    protected Control createContents(Composite parent) {
        this.pane = new Composite(parent, 0);
        this.createPropertySheet();
        this.configListener = new IConfigListener(){

            @Override
            public void configChanged(ConfigEvent e) {
                StylePropertyPage.this.populateDoctypes();
            }

            @Override
            public void configLoaded(ConfigEvent e) {
                StylePropertyPage.this.setMessage(StylePropertyPage.this.getTitle());
                StylePropertyPage.this.populateStyle();
                StylePropertyPage.this.setValid(true);
                try {
                    StylePropertyPage.this.getPluginProject().writeConfigXml();
                }
                catch (Exception ex) {
                    String message = MessageFormat.format(Messages.getString("StylePropertyPage.writeError"), "vex-plugin.xml");
                    VexPlugin.getInstance().log(4, message, ex);
                }
            }
        };
        ConfigRegistry.getInstance().addConfigListener(this.configListener);
        if (ConfigRegistry.getInstance().isConfigLoaded()) {
            this.populateStyle();
            this.populateDoctypes();
        } else {
            this.setValid(false);
            this.setMessage(Messages.getString("StylePropertyPage.loading"));
        }
        return this.pane;
    }

    private void createPropertySheet() {
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        this.pane.setLayout((Layout)layout);
        Label label = new Label(this.pane, 0);
        label.setText(Messages.getString("StylePropertyPage.name"));
        this.nameText = new Text(this.pane, 2048);
        GridData gd = new GridData();
        gd.widthHint = 150;
        this.nameText.setLayoutData((Object)gd);
        String resourcePath = ((IFile)this.getElement()).getProjectRelativePath().toString();
        PluginProject config = this.getPluginProject();
        this.style = (Style)config.getItemForResource(resourcePath);
        if (this.style == null) {
            this.style = new Style(config);
            this.style.setResourcePath(resourcePath);
            config.addItem(this.style);
        }
        if (this.style.getSimpleId() == null || this.style.getSimpleId().length() == 0) {
            this.style.setSimpleId(this.style.generateSimpleId());
        }
        label = new Label(this.pane, 0);
        label.setText(Messages.getString("StylePropertyPage.doctypes"));
        gd = new GridData();
        gd.horizontalSpan = 2;
        label.setLayoutData((Object)gd);
        Composite tablePane = new Composite(this.pane, 2048);
        gd = new GridData(1808);
        gd.heightHint = 200;
        gd.horizontalSpan = 2;
        tablePane.setLayoutData((Object)gd);
        FillLayout fillLayout = new FillLayout();
        tablePane.setLayout((Layout)fillLayout);
        this.doctypesTable = new Table(tablePane, 32);
    }

    public PluginProject getPluginProject() {
        IFile file = (IFile)this.getElement();
        return PluginProject.get(file.getProject());
    }

    public boolean performOk() {
        this.performApply();
        return super.performOk();
    }

    public void performApply() {
        this.style.setName(this.nameText.getText());
        List doctypeList = ConfigRegistry.getInstance().getAllConfigItems("net.sf.vex.editor.doctypes");
        Collections.sort(doctypeList);
        ArrayList<String> selectedDoctypes = new ArrayList<String>();
        TableItem[] tia = this.doctypesTable.getItems();
        int i = 0;
        while (i < tia.length) {
            if (tia[i].getChecked()) {
                selectedDoctypes.add(tia[i].getText());
            }
            ++i;
        }
        this.style.removeAllDocumentTypes();
        i = 0;
        while (i < doctypeList.size()) {
            if (selectedDoctypes.contains(((DocumentType)doctypeList.get(i)).getName())) {
                this.style.addDocumentType(((DocumentType)doctypeList.get(i)).getPublicId());
            }
            ++i;
        }
        try {
            this.getPluginProject().writeConfigXml();
        }
        catch (Exception e) {
            String message = MessageFormat.format(Messages.getString("StylePropertyPage.writeError"), "vex-plugin.xml");
            VexPlugin.getInstance().log(4, message, e);
        }
        ConfigRegistry.getInstance().fireConfigChanged(new ConfigEvent((Object)this));
    }

    protected void performDefaults() {
        super.performDefaults();
        this.populateStyle();
        this.populateDoctypes();
    }

    public void dispose() {
        super.dispose();
        if (this.configListener != null) {
            ConfigRegistry.getInstance().removeConfigListener(this.configListener);
        }
    }

    private void populateStyle() {
        this.setText(this.nameText, this.style.getName());
    }

    private void populateDoctypes() {
        TreeSet selectedDoctypes = new TreeSet(this.style.getDocumentTypes());
        this.doctypesTable.removeAll();
        List doctypeList = ConfigRegistry.getInstance().getAllConfigItems("net.sf.vex.editor.doctypes");
        Collections.sort(doctypeList);
        int i = 0;
        while (i < doctypeList.size()) {
            TableItem item1 = new TableItem(this.doctypesTable, 0);
            item1.setText(((DocumentType)doctypeList.get(i)).getName());
            if (selectedDoctypes.contains(((DocumentType)doctypeList.get(i)).getPublicId())) {
                item1.setChecked(true);
            }
            ++i;
        }
    }

    private void setText(Text textBox, String s) {
        textBox.setText(s == null ? "" : s);
    }
}

