/*
 * Decompiled with CFR 0.152.
 */
package info.textgrid.lab.core.metadataeditor;

import com.logabit.xlayout.XLayout;
import com.logabit.xlayout.XLayoutFactory;
import com.logabit.xlayout.source.XLayoutSource;
import info.textgrid.lab.core.metadataeditor.Activator;
import info.textgrid.lab.core.metadataeditor.IMetadataPart;
import info.textgrid.lab.core.metadataeditor.Messages;
import info.textgrid.lab.core.metadataeditor.elements.ICheckableElement;
import info.textgrid.lab.core.metadataeditor.elements.IControl;
import info.textgrid.lab.core.metadataeditor.utils.TEIHeaderGenerator;
import info.textgrid.lab.core.model.CrudServiceException;
import info.textgrid.lab.core.model.ITextGridProjectListener;
import info.textgrid.lab.core.model.TextGridObject;
import info.textgrid.lab.core.model.TextGridProject;
import info.textgrid.lab.core.model.TextGridProjectFile;
import info.textgrid.lab.core.swtutils.AdapterUtils;
import info.textgrid.namespaces.metadata.core._2010.ObjectType;
import info.textgrid.namespaces.metadata.projectfile._2008_11_27.TgProjectFile;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.lang.reflect.InvocationTargetException;
import java.util.List;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMElement;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.ISaveablePart;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.forms.widgets.Section;
import org.eclipse.ui.navigator.CommonNavigator;
import org.eclipse.ui.part.ViewPart;
import org.eclipse.ui.progress.UIJob;

public class MetaDataView
extends ViewPart
implements IMetadataPart,
ISelectionListener,
TextGridObject.ITextGridObjectListener,
ITextGridProjectListener,
ISaveablePart,
IPartListener {
    public static final String ID = "info.textgrid.lab.core.metadataeditor.view";
    private XLayoutFactory factory = XLayoutFactory.getFactory();
    private XLayout layout = null;
    private XLayoutSource xmlInputSource = null;
    private Button save = null;
    private Button meta2tei = null;
    private Button reload = null;
    private MessageBox mb_notSaved = null;
    private MessageBox mb_modified = null;
    private TextGridObject tgObj = null;
    private Composite parent = null;
    private Composite top = null;
    private String project_id = null;
    private InputStream inputFromOM = null;
    private String defaultPartName = "";
    private OMElement _omElem = null;
    private OBJECT_TYPE objectType = OBJECT_TYPE.ITEM;
    private boolean editable = true;
    private boolean tgp_selected = false;
    private TextGridObject selectedTGOWhileNotVisible = null;
    private boolean isBuildingView = false;
    private boolean checkFieldTriggered = false;
    private String xPathQuery = null;

    public void createPartControl(Composite parent) {
        this.defaultPartName = this.getPartName();
        this.parent = parent;
        TextGridObject.addListener((TextGridObject.ITextGridObjectListener)this);
        TextGridProject.addListener((ITextGridProjectListener)this);
        this.getSite().getWorkbenchWindow().getSelectionService().addPostSelectionListener((ISelectionListener)this);
        this.getViewSite().getPage().addPartListener((IPartListener)this);
        this.mb_notSaved = new MessageBox(parent.getShell(), 33);
        this.mb_modified = new MessageBox(parent.getShell(), 196);
        this.mb_modified.setMessage(Messages.MetaDataView_saveChangesQuestion);
        this.rebuild(false);
        this.setVisible(false);
        if (!this.layout.isVisible()) {
            Object obj;
            ISelection sel;
            Object obj2;
            ISelection sel2;
            TextGridObject tgF;
            IFile fileIn;
            IEditorInput input;
            IEditorPart editor = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActiveEditor();
            if (editor != null && (input = editor.getEditorInput()) instanceof IFileEditorInput && (fileIn = ((IFileEditorInput)input).getFile()) != null && (tgF = (TextGridObject)fileIn.getAdapter(TextGridObject.class)) != null) {
                this.tgObj = tgF;
                this.setMetadataInView(this.tgObj, true);
                return;
            }
            IViewPart publishView = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().findView("info.textgrid.lab.tgpublish.client.gui.tgpview");
            if (publishView != null && (sel2 = publishView.getSite().getSelectionProvider().getSelection()) != null && sel2 instanceof IStructuredSelection && (obj2 = ((IStructuredSelection)sel2).getFirstElement()) != null) {
                TextGridObject tgO = (TextGridObject)AdapterUtils.getAdapter((Object)obj2, TextGridObject.class);
                if (tgO == null) {
                    return;
                }
                this.tgObj = tgO;
                this.setMetadataInView(this.tgObj, true);
                return;
            }
            IViewPart naviView = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().findView("info.textgrid.lab.navigator.view");
            if (naviView != null && (sel = naviView.getSite().getSelectionProvider().getSelection()) != null && sel instanceof IStructuredSelection && (obj = ((IStructuredSelection)sel).getFirstElement()) != null) {
                TextGridObject tgO = (TextGridObject)AdapterUtils.getAdapter((Object)obj, TextGridObject.class);
                if (tgO == null) {
                    return;
                }
                this.tgObj = tgO;
                this.setMetadataInView(this.tgObj, true);
                return;
            }
        }
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, "info.textgrid.lab.core.metadataeditor.MetadataEditorView");
    }

    public void setVisible(boolean visible) {
        this.layout.setVisible(visible);
        if (!visible) {
            this.setContentDescription(Messages.MetaDataView_noMetadata);
        }
        this.layout.setModified(false);
    }

    private void rebuild(boolean readProjectFile) {
        if (this.isBuildingView) {
            return;
        }
        try {
            InputStream custom_input;
            this.isBuildingView = true;
            this.layout = this.factory.createXLayout();
            this.layout.registerMetadataPart(this);
            if (this.top != null) {
                this.top.dispose();
            }
            this.top = new Composite(this.parent, 0);
            this.top.setBackground(this.parent.getBackground());
            this.top.setLayout(this.parent.getLayout());
            this.top.setLayoutData(this.parent.getLayoutData());
            this.top.setData(this.parent.getData());
            this.xmlInputSource = null;
            String type = this.objectType.toString();
            InputStream input_xul = this.getClass().getClassLoader().getResourceAsStream("metadata-" + type + ".xl.xml");
            boolean xul_inputSource_created = false;
            if (readProjectFile && (custom_input = this.getInputStreamFromProjectFile()) != null) {
                try {
                    String xul_content = MetaDataView.convertStreamToString(input_xul);
                    String custom_content = MetaDataView.convertStreamToString(custom_input);
                    xul_content = xul_content.replaceFirst("<tg:custom-placeholder.*?/>", custom_content);
                    this.xmlInputSource = new XLayoutSource("MetaData-XUL" + type + "_" + String.valueOf(System.currentTimeMillis()), new ByteArrayInputStream(xul_content.getBytes("UTF-8")));
                    xul_inputSource_created = true;
                }
                catch (Exception e2) {
                    Activator.handleError(e2);
                    this.isBuildingView = false;
                    return;
                }
            }
            if (!xul_inputSource_created) {
                this.xmlInputSource = new XLayoutSource("MetaData-XUL" + type, input_xul);
            }
            this.layout.draw(this.top, this.xmlInputSource, type, true);
            this.editable = true;
            this.save = (Button)this.layout.getControl("btnSave");
            if (this.save != null) {
                this.save.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        MetaDataView.this.doSave(null);
                        super.widgetSelected(e);
                    }
                });
            }
            this.reload = (Button)this.layout.getControl("btnReload");
            if (this.reload != null) {
                this.reload.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        if (MetaDataView.this.tgObj == null) {
                            return;
                        }
                        Job reloadJob = new Job(Messages.MetaDataView_reloading){

                            protected IStatus run(IProgressMonitor monitor) {
                                if (monitor == null) {
                                    monitor = new NullProgressMonitor();
                                }
                                try {
                                    MetaDataView.this.tgObj.reloadMetadata(true);
                                }
                                catch (CrudServiceException e) {
                                    Activator.handleError(e, Messages.MetaDataView_reloadFailed, MetaDataView.this.tgObj);
                                    return Status.CANCEL_STATUS;
                                }
                                return Status.OK_STATUS;
                            }
                        };
                        reloadJob.schedule();
                        try {
                            reloadJob.join();
                        }
                        catch (InterruptedException e1) {
                            Activator.handleError(e1);
                        }
                        if (reloadJob.getResult() != Status.OK_STATUS) {
                            return;
                        }
                        MetaDataView.this.setMetadataInView(MetaDataView.this.tgObj, false);
                        System.out.println(Messages.MetaDataView_reloaded);
                        super.widgetSelected(e);
                    }
                });
            }
            this.meta2tei = (Button)this.layout.getControl("btnMeta2tei");
            if (this.meta2tei != null && this.tgObj != null) {
                this.meta2tei.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent event) {
                        System.out.println(Messages.MetaDataView_copyTEI);
                        TEIHeaderGenerator generator = new TEIHeaderGenerator(MetaDataView.this.tgObj, true);
                        generator.setUser(true);
                        generator.schedule();
                    }
                });
            }
            this.meta2tei.setToolTipText(Messages.MetaDataView_copyTEI2Clipboard);
            this.parent.layout(true, true);
            this.layout.setModified(false);
        }
        finally {
            this.isBuildingView = false;
        }
    }

    public static String convertStreamToString(InputStream is) throws Exception {
        BufferedReader reader = new BufferedReader(new InputStreamReader(is));
        StringBuilder sb = new StringBuilder();
        String line = null;
        while ((line = reader.readLine()) != null) {
            sb.append(String.valueOf(line) + "\n");
        }
        is.close();
        return sb.toString();
    }

    public void selectionChanged(IWorkbenchPart sourcepart, ISelection selection) {
        IEditorPart ePart;
        IEditorInput input;
        boolean isViewVisible = true;
        this.selectedTGOWhileNotVisible = null;
        try {
            if (!PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().isPartVisible((IWorkbenchPart)this)) {
                isViewVisible = false;
            }
        }
        catch (Exception exception) {}
        boolean found = false;
        if (sourcepart != null && sourcepart instanceof IEditorPart && (input = (ePart = (IEditorPart)sourcepart).getEditorInput()) instanceof IFileEditorInput) {
            IFile fileIn = ((IFileEditorInput)input).getFile();
            found = true;
            if (fileIn != null) {
                TextGridObject tgF = (TextGridObject)fileIn.getAdapter(TextGridObject.class);
                if (tgF != null) {
                    if (isViewVisible) {
                        if (tgF == this.tgObj && this.tgObj != null && !this.tgp_selected) {
                            return;
                        }
                        this.setMetadataInView(tgF, this.tgp_selected);
                        this.tgp_selected = false;
                    } else {
                        this.selectedTGOWhileNotVisible = tgF;
                    }
                } else {
                    this.askSaving(this.tgObj);
                    this.setVisible(false);
                    this.tgObj = tgF;
                }
            }
        }
        if (!found && selection instanceof IStructuredSelection) {
            Object obj = ((IStructuredSelection)selection).getFirstElement();
            TextGridObject tgO = (TextGridObject)AdapterUtils.getAdapter((Object)obj, TextGridObject.class);
            if (tgO != null) {
                if (isViewVisible) {
                    if (tgO == this.tgObj && this.tgObj != null && !this.tgp_selected) {
                        return;
                    }
                    this.setMetadataInView(tgO, this.tgp_selected);
                    this.tgp_selected = false;
                    return;
                }
                this.selectedTGOWhileNotVisible = tgO;
            } else if (sourcepart instanceof CommonNavigator && obj instanceof TextGridProject) {
                this.tgp_selected = true;
                this.askSaving(this.tgObj);
                return;
            }
        }
    }

    private boolean checkObjectType(TextGridObject obj) throws CoreException {
        if (obj != null) {
            try {
                ObjectType type = obj.getMetadataForReading();
                OBJECT_TYPE previous_type = this.objectType;
                if (type.getItem() != null) {
                    this.objectType = OBJECT_TYPE.ITEM;
                } else if (type.getWork() != null) {
                    this.objectType = OBJECT_TYPE.WORK;
                } else if (type.getEdition() != null) {
                    this.objectType = OBJECT_TYPE.EDITION;
                } else if (type.getCollection() != null) {
                    this.objectType = OBJECT_TYPE.COLLECTION;
                } else {
                    String contentTypeId = obj.getContentTypeID();
                    if (contentTypeId != null && !"".equals(contentTypeId)) {
                        this.objectType = contentTypeId.toLowerCase().contains("tg.work+") ? OBJECT_TYPE.WORK : (contentTypeId.toLowerCase().contains("tg.edition+") ? OBJECT_TYPE.EDITION : (contentTypeId.toLowerCase().contains("tg.collection+") ? OBJECT_TYPE.COLLECTION : OBJECT_TYPE.ITEM));
                    }
                }
                if (!this.objectType.equals((Object)previous_type)) {
                    return true;
                }
            }
            catch (CrudServiceException e) {
                Activator.handleError(e, Messages.MetaDataView_fetchMetadataFailed, new Object[0]);
            }
        }
        return false;
    }

    public void setMetadataInView(final TextGridObject tgO, boolean rebuild) {
        try {
            Label l;
            if (this.tgObj != tgO) {
                this.askSaving(this.tgObj);
            }
            this.tgObj = tgO;
            boolean type_changed = this.checkObjectType(this.tgObj);
            String tgO_project_id = null;
            tgO_project_id = tgO.getProject();
            if (tgO_project_id != null && this.project_id != null && !tgO_project_id.equals(this.project_id) || rebuild || type_changed) {
                this.rebuild(true);
            }
            this.project_id = tgO_project_id;
            if (this.layout == null || this.layout.getForm() == null || this.layout.getForm().isDisposed()) {
                return;
            }
            if (!this.layout.isVisible()) {
                this.setVisible(true);
                this.rebuild(true);
            }
            if ((l = this.layout.getInfoLabel()) != null) {
                if (tgO.isNew()) {
                    l.setForeground(this.getSite().getShell().getDisplay().getSystemColor(9));
                    l.setText(Messages.MetaDataView_autoSave_info);
                } else {
                    l.setText("");
                }
            }
            Job getJob = new Job(Messages.MetaDataView_fetchingMetadata){

                protected IStatus run(IProgressMonitor monitor) {
                    if (monitor == null) {
                        monitor = new NullProgressMonitor();
                    }
                    try {
                        MetaDataView.this.tgObj.reloadMetadata(true);
                        MetaDataView.this._omElem = MetaDataView.this.tgObj.getMetadataXML();
                        new UIJob(""){

                            public IStatus runInUIThread(IProgressMonitor monitor) {
                                try {
                                    if (MetaDataView.this.layout == null || MetaDataView.this.layout.isDisposed() || MetaDataView.this.layout.getForm() == null) {
                                        return Status.CANCEL_STATUS;
                                    }
                                    MetaDataView.this.setContentDescription(" " + tgO.getTitle());
                                    MetaDataView.this.layout.setOMElement(MetaDataView.this._omElem, MetaDataView.this.objectType.toString(), MetaDataView.this.tgObj.getURI().toString());
                                    if (MetaDataView.this.checkFieldTriggered) {
                                        if (MetaDataView.this.xPathQuery != null) {
                                            MetaDataView.this.doCheckField(MetaDataView.this.xPathQuery);
                                        }
                                        MetaDataView.this.checkFieldTriggered = false;
                                        MetaDataView.this.xPathQuery = null;
                                    }
                                    MetaDataView.this.checkAllFields();
                                    if (tgO.hasPermissions(4)) {
                                        MetaDataView.this.setEditable(true);
                                        if (tgO.isNew() && MetaDataView.this.save != null) {
                                            MetaDataView.this.save.setEnabled(false);
                                        } else if (MetaDataView.this.save != null && !MetaDataView.this.save.isEnabled()) {
                                            MetaDataView.this.save.setEnabled(true);
                                        }
                                    } else {
                                        MetaDataView.this.setEditable(false);
                                    }
                                    MetaDataView.this.layout.setModified(false);
                                }
                                catch (CoreException e) {
                                    MetaDataView.this.setVisible(false);
                                    Activator.handleError(e);
                                    return Status.CANCEL_STATUS;
                                }
                                return Status.OK_STATUS;
                            }
                        }.schedule();
                    }
                    catch (CoreException e) {
                        new UIJob(""){

                            public IStatus runInUIThread(IProgressMonitor monitor) {
                                MetaDataView.this.setVisible(false);
                                return Status.OK_STATUS;
                            }
                        }.schedule();
                        Activator.handleError(e);
                        return Status.CANCEL_STATUS;
                    }
                    return Status.OK_STATUS;
                }
            };
            getJob.schedule();
        }
        catch (CoreException e) {
            this.setVisible(false);
            Activator.handleError(e);
        }
    }

    private InputStream getInputStreamFromProjectFile() {
        this.inputFromOM = null;
        if (this.tgObj == null) {
            return null;
        }
        TextGridProject project = null;
        try {
            project = this.tgObj.getProjectInstance();
        }
        catch (CrudServiceException e1) {
            Activator.handleError(e1);
            return null;
        }
        catch (CoreException e1) {
            Activator.handleError(e1);
            return null;
        }
        if (project == null) {
            return null;
        }
        final TextGridProjectFile projectFile = new TextGridProjectFile(project);
        IRunnableWithProgress fetchJob = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) {
                try {
                    OMElement xul_elem;
                    if (monitor == null) {
                        monitor = new NullProgressMonitor();
                    }
                    monitor.beginTask(Messages.MetaDataView_fetchingProjectfile, -1);
                    TgProjectFile projectFileData = projectFile.getProjectFileData(false, true, monitor);
                    OMElement[] appDataChildren = TextGridProjectFile.extractAppDataChildren((TgProjectFile)projectFileData);
                    OMElement mySection = null;
                    if (appDataChildren != null && appDataChildren.length > 0) {
                        OMElement[] oMElementArray = appDataChildren;
                        int n = appDataChildren.length;
                        int n2 = 0;
                        while (n2 < n) {
                            OMElement child = oMElementArray[n2];
                            if (child.getQName().equals(TextGridProjectFile.metadataSectionQName)) {
                                mySection = child;
                                break;
                            }
                            ++n2;
                        }
                    }
                    if (mySection != null && (xul_elem = mySection.getFirstChildWithName(new QName("tr"))) != null) {
                        ByteArrayOutputStream baos = new ByteArrayOutputStream();
                        OutputStreamWriter w = new OutputStreamWriter((OutputStream)baos, "UTF-8");
                        xul_elem.serialize((Writer)w);
                        MetaDataView.this.inputFromOM = new ByteArrayInputStream(baos.toByteArray());
                        ((Writer)w).flush();
                        ((Writer)w).close();
                        baos.close();
                    }
                    monitor.done();
                }
                catch (Exception e) {
                    Activator.handleError(e);
                }
            }
        };
        try {
            this.getSite().getWorkbenchWindow().getWorkbench().getProgressService().busyCursorWhile(fetchJob);
        }
        catch (InvocationTargetException e) {
            Activator.handleError(e);
        }
        catch (InterruptedException e) {
            Activator.handleError(e);
        }
        return this.inputFromOM;
    }

    public void setFocus() {
        if (this.parent != null && !this.parent.isDisposed()) {
            this.parent.setFocus();
        }
        if (this.selectedTGOWhileNotVisible == null || this.selectedTGOWhileNotVisible == this.tgObj && this.tgObj != null && !this.tgp_selected) {
            return;
        }
        try {
            this.setMetadataInView(this.selectedTGOWhileNotVisible, this.tgp_selected);
        }
        catch (Exception exception) {}
        this.tgp_selected = false;
    }

    private void askSaving(final TextGridObject oldTgo) {
        if (oldTgo == null) {
            return;
        }
        if (oldTgo.isNew()) {
            this.update();
            return;
        }
        try {
            if (this.isDirty()) {
                String title = Messages.MetaDataView_lastObject;
                title = oldTgo.getTitle();
                this.mb_modified.setMessage(NLS.bind((String)Messages.MetaDataView_saveChanges_question, (Object)title));
                if (this.mb_modified.open() == 64) {
                    if (!this.makeChangesPersistent(oldTgo, true)) {
                        System.out.println(Messages.MetaDataView_changesDiscarded);
                    }
                } else {
                    new Job(""){

                        protected IStatus run(IProgressMonitor monitor) {
                            if (monitor == null) {
                                monitor = new NullProgressMonitor();
                            }
                            try {
                                oldTgo.reloadMetadata(true);
                                new UIJob(Messages.MetaDataView_reloading){

                                    public IStatus runInUIThread(IProgressMonitor monitor) {
                                        MetaDataView.this.layout.setModified(false);
                                        System.out.println(Messages.MetaDataView_changesDiscarded);
                                        return Status.OK_STATUS;
                                    }
                                }.schedule();
                            }
                            catch (CoreException e) {
                                Activator.handleError(e, Messages.MetaDataView_reloadFailed2, new Object[0]);
                                return Status.CANCEL_STATUS;
                            }
                            return Status.OK_STATUS;
                        }
                    }.schedule();
                }
            }
        }
        catch (CoreException e) {
            Activator.handleError(e);
        }
    }

    private boolean makeChangesPersistent(final TextGridObject tgO, final boolean loadAfterSaving) {
        OMElement omElem = this.layout.getOMElement();
        tgO.setMetadataXML(omElem);
        if (tgO.isNew()) {
            return false;
        }
        if (!this.checkAllFields()) {
            return false;
        }
        Job saveJob = new Job(Messages.MetaDataView_makePersistent){

            protected IStatus run(IProgressMonitor monitor) {
                if (monitor == null) {
                    monitor = new NullProgressMonitor();
                }
                try {
                    tgO.reloadMetadata(false);
                    tgO.makeMetadataPersistent(monitor);
                    System.out.println(Messages.MetaDataView_changesSaved);
                    if (!loadAfterSaving) {
                        new UIJob(""){

                            public IStatus runInUIThread(IProgressMonitor monitor) {
                                MetaDataView.this.setMetadataInView(tgO, false);
                                MetaDataView.this.layout.setModified(false);
                                return Status.OK_STATUS;
                            }
                        }.schedule();
                    }
                }
                catch (CoreException e) {
                    Activator.handleError(e, Messages.MetaDataView_saveFailed, new Object[0]);
                    return Status.CANCEL_STATUS;
                }
                return Status.OK_STATUS;
            }
        };
        saveJob.schedule();
        return true;
    }

    private void setEditable(boolean editable) {
        List<Control> controls = this.layout.getAllControls();
        for (Control c : controls) {
            if (c == null || c.isDisposed() || c instanceof Label || c instanceof Section || c instanceof Composite && !(c instanceof Combo) || c instanceof Link) continue;
            c.setEnabled(editable);
        }
        if (this.reload != null) {
            this.reload.setEnabled(true);
        }
        if (this.meta2tei != null) {
            this.meta2tei.setEnabled(true);
        }
        this.editable = editable;
    }

    private boolean checkAllFields() {
        if (this.isBuildingView) {
            return true;
        }
        boolean valid = true;
        if (this.layout != null) {
            for (IControl c : this.layout.getAllControlElements()) {
                valid &= c.validate();
            }
        }
        return valid;
    }

    @Override
    public void update() {
        this.checkAllFields();
        OMElement elem = this.layout.getOMElement();
        if (this.tgObj != null) {
            this.tgObj.setMetadataXML(elem);
        }
    }

    public void dispose() {
        TextGridObject.removeListener((TextGridObject.ITextGridObjectListener)this);
        this.getSite().getWorkbenchWindow().getSelectionService().removePostSelectionListener((ISelectionListener)this);
        if (this.layout != null) {
            this.layout.dispose();
        }
        super.dispose();
    }

    public void textGridProjectChanged(ITextGridProjectListener.Event event, TextGridProject project) {
        block6: {
            try {
                if (event != ITextGridProjectListener.Event.CONTENT_CHANGED || this.tgObj == null || project == null || this.tgObj.getMetadataForReading().getItem() == null || !project.equals((Object)this.tgObj.getProjectInstance())) break block6;
                Job reloadJob = new Job(Messages.MetaDataView_reloading){

                    protected IStatus run(IProgressMonitor monitor) {
                        if (monitor == null) {
                            monitor = new NullProgressMonitor();
                        }
                        try {
                            MetaDataView.this.tgObj.reloadMetadata(true);
                        }
                        catch (CrudServiceException e) {
                            Activator.handleError(e, Messages.MetaDataView_reloadFailed, MetaDataView.this.tgObj);
                            return Status.CANCEL_STATUS;
                        }
                        return Status.OK_STATUS;
                    }
                };
                reloadJob.schedule();
                try {
                    reloadJob.join();
                }
                catch (InterruptedException e1) {
                    Activator.handleWarning(e1);
                }
                if (reloadJob.getResult() != Status.OK_STATUS) {
                    return;
                }
                this.setMetadataInView(this.tgObj, false);
            }
            catch (CrudServiceException e) {
                Activator.handleWarning(e);
            }
            catch (CoreException e) {
                Activator.handleWarning(e);
            }
        }
    }

    public void textGridObjectChanged(TextGridObject.ITextGridObjectListener.Event event, TextGridObject object) {
        block9: {
            block13: {
                block12: {
                    block11: {
                        block10: {
                            if (object == null || object != this.tgObj) break block9;
                            if (event != TextGridObject.ITextGridObjectListener.Event.METADATA_INCOMPLETE) break block10;
                            this.checkAllFields();
                            break block9;
                        }
                        if (event != TextGridObject.ITextGridObjectListener.Event.CREATED) break block11;
                        Job reloadJob = new Job(Messages.MetaDataView_reloading){

                            protected IStatus run(IProgressMonitor monitor) {
                                if (monitor == null) {
                                    monitor = new NullProgressMonitor();
                                }
                                try {
                                    MetaDataView.this.tgObj.reloadMetadata(true);
                                }
                                catch (CrudServiceException e) {
                                    Activator.handleError(e);
                                    return Status.CANCEL_STATUS;
                                }
                                return Status.OK_STATUS;
                            }
                        };
                        reloadJob.schedule();
                        try {
                            reloadJob.join();
                        }
                        catch (InterruptedException e) {
                            Activator.handleError(e);
                        }
                        if (reloadJob.getResult() != Status.OK_STATUS) {
                            return;
                        }
                        this.setMetadataInView(this.tgObj, false);
                        break block9;
                    }
                    if (event != TextGridObject.ITextGridObjectListener.Event.DELETED) break block12;
                    this.layout.setModified(false);
                    this.setVisible(false);
                    break block9;
                }
                if (event != TextGridObject.ITextGridObjectListener.Event.METADATA_SAVED) break block13;
                this.layout.setModified(false);
                break block9;
            }
            if (event != TextGridObject.ITextGridObjectListener.Event.METADATA_CHANGED_FROM_OUTSIDE) break block9;
            try {
                if (this.layout.getForm() == null) {
                    return;
                }
                boolean type_changed = this.checkObjectType(this.tgObj);
                if (type_changed) {
                    this.rebuild(true);
                }
                if (!this.layout.isVisible()) {
                    this.setVisible(true);
                    this.rebuild(true);
                }
                boolean mod = this.layout.isModified();
                this.layout.setOMElement(this.tgObj.getMetadataXML(), this.objectType.toString(), this.tgObj.getURI().toString());
                this.layout.setModified(mod);
            }
            catch (CrudServiceException e) {
                Activator.handleError(e);
            }
            catch (CoreException e) {
                Activator.handleError(e);
            }
        }
    }

    public void doSave(IProgressMonitor monitor) {
        if (this.isDirty()) {
            if (!this.checkAllFields()) {
                this.mb_notSaved.setMessage(Messages.MetaDataView_saveFailedTryAgain);
                this.mb_notSaved.open();
                return;
            }
            this.update();
            this.makeChangesPersistent(this.tgObj, false);
        }
    }

    public void doSaveAs() {
    }

    public boolean isDirty() {
        boolean dirty = this.layout.isModified();
        if (dirty) {
            this.setPartName(" " + this.defaultPartName);
        } else {
            this.setPartName(this.defaultPartName);
        }
        this.checkAllFields();
        return dirty;
    }

    public boolean isSaveAsAllowed() {
        return false;
    }

    public boolean isSaveOnCloseNeeded() {
        return this.tgObj == null || !this.tgObj.isNew();
    }

    @Override
    public boolean validate() {
        return this.isDirty();
    }

    public void partActivated(IWorkbenchPart part) {
    }

    public void partBroughtToTop(IWorkbenchPart part) {
    }

    public void partClosed(IWorkbenchPart part) {
        if (this.tgObj != null && this.layout != null && !this.layout.isDisposed() && this.layout.isModified()) {
            new Job(""){

                protected IStatus run(IProgressMonitor monitor) {
                    if (monitor == null) {
                        monitor = new NullProgressMonitor();
                    }
                    try {
                        MetaDataView.this.tgObj.reloadMetadata(true);
                    }
                    catch (CoreException e) {
                        Activator.handleWarning(e, Messages.MetaDataView_reloadAfterCloseFailed, new Object[0]);
                        return Status.CANCEL_STATUS;
                    }
                    return Status.OK_STATUS;
                }
            }.schedule();
        }
    }

    public void partDeactivated(IWorkbenchPart part) {
    }

    public void partOpened(IWorkbenchPart part) {
    }

    @Override
    public boolean isEditable() {
        return this.editable;
    }

    public TextGridObject getTextGridObject() {
        return this.tgObj;
    }

    public void triggerCheckField(String xpathQuery) {
        this.doCheckField(xpathQuery);
        this.checkFieldTriggered = true;
        this.xPathQuery = xpathQuery;
    }

    private boolean doCheckField(String xpathQuery) {
        this.update();
        String[] tokens = xpathQuery.trim().split("/");
        if (tokens == null || tokens.length < 4) {
            throw new RuntimeException(NLS.bind((String)Messages.MetaDataView_queryIncomplete, (Object)xpathQuery));
        }
        String fieldPath = "";
        int i = 1;
        while (i < tokens.length) {
            fieldPath = String.valueOf(fieldPath) + "/" + tokens[i].replaceFirst(".+:", "");
            ++i;
        }
        ICheckableElement elem = this.layout.getPathControlsMap().get(fieldPath);
        if (elem != null) {
            elem.setRequired(true);
            return elem.validate();
        }
        return true;
    }

    public void reloadProjectFile(TextGridProject project) throws CoreException {
        if (this.tgObj != null && project.equals((Object)this.tgObj.getProjectInstance())) {
            this.askSaving(this.tgObj);
            this.setMetadataInView(this.tgObj, true);
        }
    }

    public static enum OBJECT_TYPE {
        ITEM{

            public String toString() {
                return "item";
            }
        }
        ,
        WORK{

            public String toString() {
                return "work";
            }
        }
        ,
        EDITION{

            public String toString() {
                return "edition";
            }
        }
        ,
        COLLECTION{

            public String toString() {
                return "collection";
            }
        };

    }
}

