/*
 * Decompiled with CFR 0.152.
 */
package net.sf.vex.css;

import java.io.Serializable;

public class RelativeLength
implements Serializable {
    private static final long serialVersionUID = 1L;
    private float percentage;
    private int absolute;
    boolean isAbsolute;
    private static RelativeLength ZERO = new RelativeLength(0.0f, 0, true);

    public static RelativeLength createAbsolute(int value) {
        if (value == 0) {
            return ZERO;
        }
        return new RelativeLength(0.0f, value, true);
    }

    public static RelativeLength createRelative(float percentage) {
        return new RelativeLength(percentage, 0, false);
    }

    public int get(int referenceLength) {
        if (this.isAbsolute) {
            return this.absolute;
        }
        return Math.round(this.percentage * (float)referenceLength);
    }

    private RelativeLength(float percentage, int absolute, boolean isAbsolute) {
        this.percentage = percentage;
        this.absolute = absolute;
        this.isAbsolute = isAbsolute;
    }
}

