/*
 * Decompiled with CFR 0.152.
 */
package net.sf.vex.layout;

import java.util.ArrayList;
import java.util.List;
import net.sf.vex.core.Caret;
import net.sf.vex.core.Insets;
import net.sf.vex.dom.IVexElement;
import net.sf.vex.layout.AbstractBlockBox;
import net.sf.vex.layout.BlockBox;
import net.sf.vex.layout.Box;
import net.sf.vex.layout.ElementOrRangeCallback;
import net.sf.vex.layout.HCaret;
import net.sf.vex.layout.LayoutContext;
import net.sf.vex.layout.LayoutUtils;
import net.sf.vex.layout.TableBox;
import net.sf.vex.layout.TableCellBox;
import net.sf.vex.layout.TableRowGroupBox;
import net.sf.vex.layout.TextCaret;

public class TableRowBox
extends AbstractBlockBox {
    public TableRowBox(LayoutContext context, TableRowGroupBox parent, IVexElement element) {
        super(context, parent, element);
    }

    public TableRowBox(LayoutContext context, BlockBox parent, int startOffset, int endOffset) {
        super(context, parent, startOffset, endOffset);
    }

    @Override
    protected List createChildren(final LayoutContext context) {
        final ArrayList children = new ArrayList();
        IVexElement element = this.findContainingElement();
        final int[] widths = this.getTableBox().getColumnWidths();
        LayoutUtils.iterateTableCells(context.getStyleSheet(), element, this.getStartOffset(), this.getEndOffset(), new ElementOrRangeCallback(){
            private int column = 0;

            @Override
            public void onElement(IVexElement child, String displayStyle) {
                children.add(new TableCellBox(context, (BlockBox)TableRowBox.this, child, widths[this.column++]));
            }

            @Override
            public void onRange(IVexElement parent, int startOffset, int endOffset) {
                children.add(new TableCellBox(context, TableRowBox.this, startOffset, endOffset, widths[this.column++]));
            }
        });
        return children;
    }

    @Override
    public void drawBox(LayoutContext context, int x, int y, int containerWidth, boolean drawBorders) {
    }

    @Override
    public Caret getCaret(LayoutContext context, int offset) {
        int hSpacing = this.getTableBox().getHorizonalSpacing();
        Box[] children = this.getChildren();
        if (children == null) {
            int relative = offset - this.getStartOffset();
            int size = this.getEndOffset() - this.getStartOffset();
            int y = 0;
            if (size > 0) {
                y = this.getHeight() * relative / size;
            }
            return new HCaret(0, y, this.getWidth());
        }
        int x = hSpacing / 2;
        int[] widths = this.getTableBox().getColumnWidths();
        int i = 0;
        while (i < children.length) {
            Box child = children[i];
            if (child.hasContent()) {
                if (offset < child.getStartOffset()) {
                    return new TextCaret(x, 0, this.getHeight());
                }
                if (offset >= child.getStartOffset() && offset <= child.getEndOffset()) {
                    Caret caret = child.getCaret(context, offset);
                    caret.translate(child.getX(), child.getY());
                    return caret;
                }
                x += widths[i] + hSpacing;
            }
            ++i;
        }
        return new TextCaret(x, 0, this.getHeight());
    }

    @Override
    public Insets getInsets(LayoutContext context, int containerWidth) {
        return Insets.ZERO_INSETS;
    }

    @Override
    public int getMarginBottom() {
        return 0;
    }

    @Override
    public int getMarginTop() {
        return 0;
    }

    @Override
    public int getNextLineOffset(LayoutContext context, int offset, int x) {
        BlockBox[] children = this.getContentChildren();
        int[] widths = this.getTableBox().getColumnWidths();
        int leftEdge = 0;
        int i = 0;
        while (i < children.length) {
            if (leftEdge + widths[i] > x) {
                int newOffset = children[i].getNextLineOffset(context, offset, x - leftEdge);
                if (newOffset == children[i].getEndOffset() + 1) {
                    return -1;
                }
                return newOffset;
            }
            leftEdge += widths[i];
            ++i;
        }
        return -1;
    }

    @Override
    public int getPreviousLineOffset(LayoutContext context, int offset, int x) {
        BlockBox[] children = this.getContentChildren();
        int[] widths = this.getTableBox().getColumnWidths();
        int leftEdge = 0;
        int i = 0;
        while (i < children.length) {
            if (leftEdge + widths[i] > x) {
                int newOffset = children[i].getPreviousLineOffset(context, offset, x - leftEdge);
                if (newOffset == children[i].getStartOffset() - 1) {
                    return -1;
                }
                return newOffset;
            }
            leftEdge += widths[i];
            ++i;
        }
        return -1;
    }

    public TableBox getTableBox() {
        return (TableBox)this.getParent().getParent().getParent();
    }

    @Override
    protected int positionChildren(LayoutContext context) {
        Box child;
        int hSpacing;
        int childX = hSpacing = this.getTableBox().getHorizonalSpacing();
        int topInset = 0;
        int height = 0;
        int bottomInset = 0;
        int i = 0;
        while (i < this.getChildren().length) {
            child = this.getChildren()[i];
            Insets insets = child.getInsets(context, this.getWidth());
            child.setX(childX += insets.getLeft());
            childX += child.getWidth() + insets.getRight() + hSpacing;
            topInset = Math.max(topInset, insets.getTop());
            height = Math.max(height, child.getHeight());
            bottomInset = Math.max(bottomInset, insets.getBottom());
            ++i;
        }
        this.setHeight(topInset + height + bottomInset);
        i = 0;
        while (i < this.getChildren().length) {
            child = this.getChildren()[i];
            child.setY(topInset);
            child.setHeight(height);
            ++i;
        }
        return -1;
    }

    @Override
    public int viewToModel(LayoutContext context, int x, int y) {
        Box[] children = this.getChildren();
        if (children == null) {
            int charCount = this.getEndOffset() - this.getStartOffset() - 1;
            if (charCount == 0 || this.getHeight() == 0) {
                return this.getEndOffset();
            }
            return this.getStartOffset() + charCount * y / this.getHeight();
        }
        int i = 0;
        while (i < children.length) {
            Box child = children[i];
            if (child.hasContent()) {
                if (x < child.getX()) {
                    return child.getStartOffset() - 1;
                }
                if (x < child.getX() + child.getWidth()) {
                    return child.viewToModel(context, x - child.getX(), y - child.getY());
                }
            }
            ++i;
        }
        return this.getEndOffset();
    }
}

