/*
 * Decompiled with CFR 0.152.
 */
package info.textgrid.lab.feedback.ui.bugreport2;

import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import com.google.common.io.Files;
import info.textgrid.lab.feedback.ui.bugreport2.Messages;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.nio.charset.Charset;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.ExpandBar;
import org.eclipse.swt.widgets.ExpandItem;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.statushandlers.StatusManager;
import org.eclipse.wb.swt.ResourceManager;

public class BugDataPage
extends WizardPage {
    protected Text logFile;
    protected Text configurationData;
    private Text text;
    private boolean reportDetails = true;
    private final List<File> files = Lists.newArrayList();
    Button saveLogButton;

    public List<File> getFiles() {
        return this.files;
    }

    public BugDataPage() {
        super(Messages.BugDataPage_PageTitle);
        this.setTitle(Messages.BugDataPage_this_title);
        this.setDescription(Messages.BugDataPage_this_description);
    }

    void saveGeneratedStuff() {
        FileDialog saveDialog = new FileDialog(this.getShell(), 8192);
        saveDialog.setText(Messages.BugDataPage_Save_generated_files);
        saveDialog.setFileName("textgridlab.log");
        if (saveDialog.open() != null) {
            final File logFile = new File(saveDialog.getFilterPath(), saveDialog.getFileName());
            String logPath = logFile.getPath();
            String ext = Files.getFileExtension((String)logPath);
            final File cfgFile = new File(logPath.substring(0, logPath.length() - ext.length()).concat("cfg"));
            final String logData = this.logFile.getText();
            final String configData = this.configurationData.getText();
            try {
                this.getContainer().run(true, false, new IRunnableWithProgress(){

                    public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (String)Messages.BugDataPage_SavingFiles, (int)2);
                        try {
                            Files.write((CharSequence)logData, (File)logFile, (Charset)Charset.forName("UTF-8"));
                            progress.worked(1);
                            if (progress.isCanceled()) {
                                throw new InterruptedException();
                            }
                            Files.write((CharSequence)configData, (File)cfgFile, (Charset)Charset.forName("UTF-8"));
                            progress.worked(1);
                        }
                        catch (IOException e) {
                            throw new InvocationTargetException(e);
                        }
                    }
                });
                this.setMessage(NLS.bind((String)Messages.BugDataPage_LogDataWrittenTo, (Object)logFile, (Object)cfgFile));
            }
            catch (InvocationTargetException e1) {
                String msg = NLS.bind((String)Messages.BugDataPage_ErrorSavingFiles, (Object)e1.getCause().getLocalizedMessage());
                this.setMessage(msg, 3);
                StatusManager.getManager().handle((IStatus)new Status(4, "info.textgrid.lab.feedback.ui", msg, e1.getCause()));
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    public void createControl(Composite parent) {
        Composite container = new Composite(parent, 0);
        this.setControl((Control)container);
        container.setLayout((Layout)new GridLayout(1, false));
        this.setPageComplete(false);
        Group grpAutogeneratedDetails = new Group(container, 0);
        grpAutogeneratedDetails.setText(Messages.BugDataPage_grpAutogeneratedDetails_text);
        GridData gd_grpAutogeneratedDetails = new GridData(4, 4, true, true, 1, 1);
        gd_grpAutogeneratedDetails.widthHint = 400;
        grpAutogeneratedDetails.setLayoutData((Object)gd_grpAutogeneratedDetails);
        grpAutogeneratedDetails.setLayout((Layout)new GridLayout(1, false));
        ScrolledComposite scrolledComposite = new ScrolledComposite((Composite)grpAutogeneratedDetails, 2560);
        scrolledComposite.setExpandVertical(true);
        scrolledComposite.setExpandHorizontal(true);
        scrolledComposite.setShowFocusedControl(true);
        scrolledComposite.setAlwaysShowScrollBars(true);
        scrolledComposite.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        Composite composite = new Composite((Composite)scrolledComposite, 0);
        composite.setLayout((Layout)new GridLayout(1, false));
        Label lblNewLabel = new Label(composite, 64);
        lblNewLabel.setLayoutData((Object)new GridData(4, 128, true, false, 1, 1));
        lblNewLabel.setText(Messages.BugDataPage_lblNewLabel_text);
        Composite composite_1 = new Composite(composite, 0);
        composite_1.setLayoutData((Object)new GridData(4, 4, false, false, 1, 1));
        GridLayout composite_1GridLayout = new GridLayout(2, false);
        composite_1GridLayout.marginHeight = 0;
        composite_1GridLayout.marginWidth = 0;
        composite_1.setLayout((Layout)composite_1GridLayout);
        final Button btnCheckButton = new Button(composite_1, 32);
        btnCheckButton.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        btnCheckButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (btnCheckButton.getSelection()) {
                    BugDataPage.this.setMessage(null, 2);
                    BugDataPage.this.reportDetails = true;
                } else {
                    BugDataPage.this.setMessage(Messages.BugDataPage_AttachLabel, 2);
                    BugDataPage.this.reportDetails = false;
                }
            }
        });
        btnCheckButton.setSelection(true);
        btnCheckButton.setText(Messages.BugDataPage_btnCheckButton_text);
        this.saveLogButton = new Button(composite_1, 0x820000);
        this.saveLogButton.addSelectionListener((SelectionListener)new SaveGeneratedStuffHandler());
        this.saveLogButton.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
        this.saveLogButton.setToolTipText(Messages.BugDataPage_saveLogButton_toolTipText);
        this.saveLogButton.setImage(ResourceManager.getPluginImage("org.eclipse.ui", "/icons/full/etool16/saveall_edit.gif"));
        this.saveLogButton.setText("");
        ExpandBar expandBar = new ExpandBar(composite, 0);
        expandBar.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        ExpandItem logFileXE = new ExpandItem(expandBar, 0);
        logFileXE.setText(Messages.BugDataPage_xpndtmNewExpanditem_text);
        this.logFile = new Text((Composite)expandBar, 2562);
        this.logFile.setText(Messages.BugDataPage_logFile_text);
        logFileXE.setControl((Control)this.logFile);
        logFileXE.setHeight(200);
        ExpandItem configurationDetailsXE = new ExpandItem(expandBar, 0);
        configurationDetailsXE.setText(Messages.BugDataPage_xpndtmNewExpanditem_1_text);
        this.configurationData = new Text((Composite)expandBar, 2818);
        this.configurationData.setText(Messages.BugDataPage_logFile_text);
        configurationDetailsXE.setControl((Control)this.configurationData);
        configurationDetailsXE.setHeight(200);
        new Label(composite, 0);
        scrolledComposite.setMinSize(new Point(0, 0));
        scrolledComposite.setContent((Control)composite);
        Group grpAttachments = new Group(container, 0);
        grpAttachments.setText(Messages.BugDataPage_grpAttachments_text);
        grpAttachments.setLayout((Layout)new GridLayout(2, false));
        GridData gd_grpAttachments = new GridData(4, 1024, true, false, 1, 1);
        gd_grpAttachments.widthHint = 400;
        grpAttachments.setLayoutData((Object)gd_grpAttachments);
        Label lblNewLabel_1 = new Label((Composite)grpAttachments, 0);
        lblNewLabel_1.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 2, 1));
        lblNewLabel_1.setText(Messages.BugDataPage_lblNewLabel_1_text);
        this.text = new Text((Composite)grpAttachments, 2440);
        this.text.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetDefaultSelected(SelectionEvent e) {
                if ((e.detail & 0x100) != 0) {
                    BugDataPage.this.files.clear();
                }
            }
        });
        this.text.setEditable(false);
        this.text.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        Button btnNewButton = new Button((Composite)grpAttachments, 0);
        btnNewButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FileDialog fileDialog = new FileDialog(BugDataPage.this.getShell(), 4098);
                fileDialog.setText(Messages.BugDataPage_AttachTitle);
                if (fileDialog.getFilterPath() == null || fileDialog.getFilterPath().isEmpty()) {
                    fileDialog.setFilterPath(System.getProperty("user.home", "/"));
                }
                if (fileDialog.open() != null) {
                    BugDataPage.this.files.clear();
                    String[] stringArray = fileDialog.getFileNames();
                    int n = stringArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String filename = stringArray[n2];
                        BugDataPage.this.files.add(new File(fileDialog.getFilterPath(), filename));
                        ++n2;
                    }
                }
                BugDataPage.this.text.setText(Joiner.on((String)", ").join((Object[])fileDialog.getFileNames()));
            }
        });
        btnNewButton.setText(Messages.BugDataPage_btnNewButton_text);
    }

    public void setSummary(String systemSummary, String systemLog) {
        this.logFile.setText(systemLog);
        this.configurationData.setText(systemSummary);
        this.setPageComplete(true);
    }

    private File getTempFile(Text text) throws IOException {
        if (text.isDisposed()) {
            return null;
        }
        if (this.reportDetails && !text.getText().isEmpty()) {
            File file = File.createTempFile("textgridlab", ".log");
            file.deleteOnExit();
            Files.write((CharSequence)text.getText(), (File)file, (Charset)Charset.forName("UTF-8"));
            return file;
        }
        return null;
    }

    public File getTempLogFile() throws IOException {
        return this.getTempFile(this.logFile);
    }

    public File getTempConfFile() throws IOException {
        return this.getTempFile(this.configurationData);
    }

    private final class SaveGeneratedStuffHandler
    extends SelectionAdapter {
        private SaveGeneratedStuffHandler() {
        }

        public void widgetSelected(SelectionEvent e) {
            BugDataPage.this.saveGeneratedStuff();
        }
    }
}

