/*
 * Decompiled with CFR 0.152.
 */
package info.textgrid.lab.search;

import com.google.common.base.Joiner;
import info.textgrid.lab.core.model.CrudServiceException;
import info.textgrid.lab.core.model.TextGridObject;
import info.textgrid.lab.core.swtutils.ChunkingElementCollector;
import info.textgrid.lab.search.Activator;
import info.textgrid.lab.search.KWICEntry;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMElement;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.PlatformObject;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.progress.IDeferredWorkbenchAdapter;
import org.eclipse.ui.progress.IElementCollector;
import org.eclipse.ui.statushandlers.StatusManager;

public class SingleSearchResult
extends PlatformObject
implements IDeferredWorkbenchAdapter {
    @Deprecated
    private static final String XPATH_AUTHORS = ".//tg:agent[@role='author']";
    private TextGridObject mytgo = null;
    private Integer mycount = null;
    private ArrayList<Object> allChildren;
    private final int EXTRA_CHILDREN = 2;
    private String TEXTGRID_METADATA_NAMESPACE = "http://textgrid.info/namespaces/metadata/core/2010";
    private KWICEntry[] kwicEntryList = new KWICEntry[0];

    public SingleSearchResult(OMElement resultDocument, boolean isTextQuery, boolean wantKwic, boolean isComplete) {
        OMElement tgObjectMD = resultDocument.getFirstChildWithName(new QName(this.TEXTGRID_METADATA_NAMESPACE, "tgObjectMetadata"));
        String matches = "";
        if (isTextQuery) {
            OMElement matchesOM = resultDocument.getFirstChildWithName(new QName("http://textgrid.info/namespaces/metadata", "matches"));
            matches = matchesOM.getText();
            if (wantKwic) {
                OMElement kwicEntries = resultDocument.getFirstChildWithName(new QName("http://textgrid.info/namespaces/metadata", "result"));
                this.kwicEntryList = SingleSearchResult.parse_kwicResult(kwicEntries);
            }
        }
        this.mytgo = null;
        try {
            this.mytgo = TextGridObject.getInstance((OMElement)tgObjectMD, (boolean)isComplete);
            Activator.debugLog("instantiated TGO " + this.mytgo.getTitle());
        }
        catch (CoreException ce) {
            Status status = new Status(4, "info.textgrid.lab.search", "Eclipse Core Exception!", (Throwable)ce);
            Activator.getDefault().getLog().log((IStatus)status);
        }
        if (this.mytgo != null) {
            this.mycount = isTextQuery && !matches.equals("") ? new Integer(matches) : new Integer(0);
        }
    }

    public SingleSearchResult(TextGridObject tgo, Integer count, KWICEntry[] kwicEntries) {
        this.mytgo = tgo;
        this.mycount = count;
        if (!this.mytgo.isComplete()) {
            try {
                this.mytgo.reloadMetadata(false);
            }
            catch (CrudServiceException cse) {
                Status status = new Status(4, "info.textgrid.lab.search", "Could not reload Metadata from CRUD!", (Throwable)cse);
                Activator.getDefault().getLog().log((IStatus)status);
            }
        }
        this.allChildren = new ArrayList(kwicEntries.length + 2);
        this.allChildren.add(new String("Project: " + this.getProjectName()));
        this.allChildren.add(new String("Authors: " + this.getAuthors()));
        KWICEntry[] kWICEntryArray = kwicEntries;
        int n = kwicEntries.length;
        int n2 = 0;
        while (n2 < n) {
            KWICEntry e = kWICEntryArray[n2];
            e.setParent(this);
            this.allChildren.add((Object)e);
            ++n2;
        }
    }

    public TextGridObject getTGO() {
        return this.mytgo;
    }

    public Integer getCount() {
        return this.mycount;
    }

    public Object[] getChildren() {
        return this.allChildren.toArray(new Object[0]);
    }

    public String getURI() {
        return this.getTGO().getURI().toString();
    }

    public String getTGMD() {
        try {
            String result = this.getTGO().serialize();
            return result;
        }
        catch (Exception e) {
            Status status = new Status(4, "info.textgrid.lab.search", "Exception serializing TextGridObject", (Throwable)e);
            Activator.getDefault().getLog().log((IStatus)status);
            return "not resolved";
        }
    }

    public String getProjectName() {
        try {
            return this.getTGO().getProjectInstance().getName();
        }
        catch (CoreException e1) {
            Status status = new Status(4, "info.textgrid.lab.search", "Exception getting Project Name for Object", (Throwable)e1);
            Activator.getDefault().getLog().log((IStatus)status);
            return "<unknown project>";
        }
    }

    public String getAuthors() {
        List authors;
        block3: {
            try {
                authors = this.getTGO().getAuthors();
                if (!authors.isEmpty()) break block3;
                return "(not specified)";
            }
            catch (CoreException e) {
                StatusManager.getManager().handle(e, "info.textgrid.lab.search");
                return "";
            }
        }
        return Joiner.on((String)"; ").join((Iterable)authors);
    }

    public String toString() {
        String result = "";
        if (!this.getCount().equals(new Integer(0))) {
            result = String.valueOf(this.getCount().toString()) + " ";
        }
        try {
            result = String.valueOf(result) + this.getTGO().getTitle();
        }
        catch (Exception e) {
            Status status = new Status(4, "info.textgrid.lab.search", "Exception getting title for Object", (Throwable)e);
            Activator.getDefault().getLog().log((IStatus)status);
        }
        return result;
    }

    public static KWICEntry[] parse_kwicResult(OMElement result) {
        ArrayList<KWICEntry> kes = new ArrayList<KWICEntry>();
        Iterator iter = result.getChildElements();
        while (iter.hasNext()) {
            OMElement nextEntry = (OMElement)iter.next();
            KWICEntry ke = new KWICEntry(nextEntry, "http://textgrid.info/namespaces/metadata");
            kes.add(ke);
        }
        return kes.toArray(new KWICEntry[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fetchDeferredChildren(Object object, IElementCollector collector, IProgressMonitor monitor) {
        monitor.beginTask("Retrieving children of " + this.toString(), -1);
        SingleSearchResult singleSearchResult = this;
        synchronized (singleSearchResult) {
            ChunkingElementCollector groupingCollector;
            if (object instanceof SingleSearchResult) {
                groupingCollector = new ChunkingElementCollector(collector, 16);
                this.allChildren = new ArrayList(this.kwicEntryList.length + 2);
                this.allChildren.add(new String("Project: " + this.getProjectName()));
                collector.add((Object)new String("Project: " + this.getProjectName()), monitor);
                this.allChildren.add(new String("Authors: " + this.getAuthors()));
                collector.add((Object)new String("Authors: " + this.getAuthors()), monitor);
                KWICEntry[] kWICEntryArray = this.kwicEntryList;
                int n = this.kwicEntryList.length;
                int n2 = 0;
                while (n2 < n) {
                    KWICEntry e = kWICEntryArray[n2];
                    e.setParent(this);
                    this.allChildren.add((Object)e);
                    groupingCollector.add((Object)e, monitor);
                    ++n2;
                }
            } else {
                throw new IllegalArgumentException(MessageFormat.format("SingleSearchResult''s fetchDeferredChildren does not know the children of {0}s like {1}", object.getClass(), object));
            }
            collector.done();
            monitor.done();
            groupingCollector.done();
        }
    }

    public ISchedulingRule getRule(Object object) {
        return null;
    }

    public boolean isContainer() {
        return true;
    }

    public Object[] getChildren(Object o) {
        return null;
    }

    public ImageDescriptor getImageDescriptor(Object object) {
        return null;
    }

    public String getLabel(Object o) {
        return null;
    }

    public Object getParent(Object o) {
        return null;
    }
}

