/*
 * Decompiled with CFR 0.152.
 */
package info.textgrid.utils.linkrewriter;

import com.google.common.base.Predicate;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import info.textgrid._import.ElementSpec;
import info.textgrid._import.ImportObject;
import info.textgrid._import.ImportSpec;
import info.textgrid._import.NodeRewriteSpec;
import info.textgrid._import.ReplaceMethod;
import info.textgrid._import.RevisionPolicyType;
import info.textgrid._import.XmlConfiguration;
import info.textgrid.utils.linkrewriter.AbstractRewriter;
import info.textgrid.utils.linkrewriter.ILinkRewriter;
import info.textgrid.utils.linkrewriter.ImportMapping;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.EnumMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.bind.JAXB;
import javax.xml.namespace.QName;
import javax.xml.stream.FactoryConfigurationError;
import javax.xml.stream.XMLEventFactory;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLEventWriter;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.events.Attribute;
import javax.xml.stream.events.Characters;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;

public class ConfigurableXMLRewriter
extends AbstractRewriter
implements ILinkRewriter {
    private static final QName XML_ID = new QName("http://www.w3.org/XML/1998/namespace", "id");
    private static final Logger logger = Logger.getLogger(ConfigurableXMLRewriter.class.getCanonicalName());
    private Set<String> missingReferences;
    private final EnumMap<ReplaceMethod, Replacer> replacers;
    private final ListMultimap<QName, ElementSpec> elements = ArrayListMultimap.create((int)15, (int)1);
    private final Map<QName, XmlConfiguration.ProcessingInstruction> processingInstructions = Maps.newHashMap();
    private XmlConfiguration configuration;
    private URI base;
    private boolean mergeMode;
    private IMergeLinkAdjuster mergeLinkAdjuster;
    private static List<String> internalSpecs;
    private static Map<URI, XmlConfiguration> internalConfigurations;

    public URI getBase() {
        return this.base;
    }

    public void setBase(URI base) {
        this.base = base;
    }

    public static URI relativize(URI base, URI child) {
        int j;
        int i;
        base = base.normalize();
        child = child.normalize();
        String[] bParts = base.getPath().split("\\/");
        String[] cParts = child.getPath().split("\\/");
        if (bParts.length > 0 && !base.getPath().endsWith("/")) {
            bParts = Arrays.copyOf(bParts, bParts.length - 1);
        }
        for (i = 0; i < bParts.length && i < cParts.length && bParts[i].equals(cParts[i]); ++i) {
        }
        StringBuilder sb = new StringBuilder();
        for (j = 0; j < bParts.length - i; ++j) {
            sb.append("../");
        }
        for (j = i; j < cParts.length; ++j) {
            if (j != i) {
                sb.append("/");
            }
            sb.append(cParts[j]);
        }
        return URI.create(sb.toString());
    }

    XmlConfiguration getConfiguration() {
        return this.configuration;
    }

    public void configure(XmlConfiguration configuration) {
        this.configuration = configuration;
        for (ElementSpec element : configuration.getElement()) {
            this.elements.put((Object)element.getName(), (Object)element);
        }
        for (XmlConfiguration.ProcessingInstruction pi : configuration.getProcessingInstruction()) {
            this.processingInstructions.put(pi.getName(), pi);
        }
    }

    public void configure(URI uri) throws IllegalArgumentException {
        ImportSpec spec;
        if ("internal".equals(uri.getScheme())) {
            URL resource = this.getClass().getClassLoader().getResource("specs/" + uri.getSchemeSpecificPart() + ".xml");
            spec = (ImportSpec)JAXB.unmarshal((URL)resource, ImportSpec.class);
        } else {
            spec = uri.getScheme() == null || uri.getSchemeSpecificPart() == null ? this.getMapping().toImportSpec() : (ImportSpec)JAXB.unmarshal((URI)uri, ImportSpec.class);
        }
        if (spec != null && spec.getXmlConfiguration() != null) {
            XmlConfiguration config;
            final String fragment = uri.getFragment();
            if (fragment != null) {
                try {
                    config = (XmlConfiguration)Iterables.find(spec.getXmlConfiguration(), (Predicate)new Predicate<XmlConfiguration>(){

                        public boolean apply(XmlConfiguration input) {
                            return fragment.equals(input.getId());
                        }
                    });
                }
                catch (NoSuchElementException e) {
                    throw new IllegalArgumentException(MessageFormat.format("Could not find configuration {0} in {1}", fragment, uri), e);
                }
            } else if (spec.getXmlConfiguration().size() == 1) {
                config = spec.getXmlConfiguration().get(0);
            } else {
                throw new IllegalArgumentException(MessageFormat.format("{0} contains more than one configuration, please specify a fragment.", uri));
            }
            if (config != null) {
                this.configure(config);
            }
        }
    }

    public static List<String> getInternalSpecs() {
        if (internalSpecs == null) {
            internalSpecs = Lists.newLinkedList();
            InputStream inputStream = ConfigurableXMLRewriter.class.getClassLoader().getResourceAsStream("specs/INDEX.txt");
            try {
                BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream, "UTF-8"));
                String line = reader.readLine();
                while (line != null) {
                    if (!line.startsWith("#") && line.trim().length() > 0) {
                        internalSpecs.add(line.trim());
                    }
                    line = reader.readLine();
                }
            }
            catch (UnsupportedEncodingException e) {
                throw new IllegalStateException("UTF-8 must be available. This is a broken JRE.", e);
            }
            catch (IOException e) {
                throw new IllegalStateException("Error reading internal spec file list. This is a bug.", e);
            }
        }
        return internalSpecs;
    }

    public static Map<URI, XmlConfiguration> getInternalConfigurations() {
        if (internalConfigurations == null) {
            internalConfigurations = Maps.newLinkedHashMap();
            for (String internalSpec : ConfigurableXMLRewriter.getInternalSpecs()) {
                URL resource = ConfigurableXMLRewriter.class.getClassLoader().getResource("specs/" + internalSpec + ".xml");
                ImportSpec spec = (ImportSpec)JAXB.unmarshal((URL)resource, ImportSpec.class);
                for (XmlConfiguration configuration : spec.getXmlConfiguration()) {
                    try {
                        internalConfigurations.put(new URI("internal", internalSpec, configuration.getId()), configuration);
                    }
                    catch (URISyntaxException e) {
                        throw new IllegalStateException(e);
                    }
                }
            }
        }
        return internalConfigurations;
    }

    protected Replacer getReplacer(ReplaceMethod method) {
        return this.replacers.get((Object)method);
    }

    public ConfigurableXMLRewriter(ImportMapping mapping, boolean export) {
        super(mapping, export);
        this.replacers = Maps.newEnumMap(ReplaceMethod.class);
        this.replacers.put(ReplaceMethod.NONE, new Replacer(){

            @Override
            public String apply(String to) {
                return to;
            }
        });
        this.replacers.put(ReplaceMethod.FULL, new Replacer(){

            @Override
            public String apply(String to) {
                String replacement = this.rewriteSingleLink(to);
                return replacement == null ? to : replacement;
            }
        });
        this.replacers.put(ReplaceMethod.TOKEN, new Replacer(){

            @Override
            public String apply(String to) {
                StringTokenizer tokenizer = new StringTokenizer(to, " \t\n\r\f", true);
                StringBuilder result = new StringBuilder(to.length());
                while (tokenizer.hasMoreTokens()) {
                    String token = tokenizer.nextToken();
                    String rewritten = this.rewriteSingleLink(token);
                    if (rewritten == null) {
                        result.append(token);
                        continue;
                    }
                    result.append(rewritten);
                }
                return result.toString();
            }
        });
    }

    protected String replaceElementContent(StartElement startElement, String content) {
        ElementSpec elementSpec = this.getElementSpec(startElement);
        if (elementSpec == null) {
            return content;
        }
        Replacer replacer = this.replacers.get((Object)elementSpec.getMethod());
        if (replacer == null) {
            return content;
        }
        return replacer.apply(content);
    }

    protected String replaceAttributeValue(StartElement element, Attribute attribute) {
        String value = attribute.getValue();
        try {
            if (this.mergeMode && XML_ID.equals(attribute.getName())) {
                return this.mergeLinkAdjuster.getMergedID(value);
            }
            ElementSpec.Attribute attributeSpec = this.getAttributeSpec(element, attribute);
            Replacer replacer = this.getReplacer(attributeSpec.getMethod());
            if (replacer != null) {
                return replacer.apply(value);
            }
        }
        catch (NoSuchElementException e) {
            // empty catch block
        }
        return value;
    }

    private ElementSpec.Attribute getAttributeSpec(StartElement element, Attribute attribute) throws NoSuchElementException {
        ElementSpec elementSpec = this.getElementSpec(element);
        if (elementSpec == null) {
            throw new NoSuchElementException("No element spec.");
        }
        try {
            return ConfigurableXMLRewriter.find(elementSpec.getAttribute(), attribute.getName());
        }
        catch (NoSuchElementException e) {
            if (elementSpec != this.configuration.getAnyElement() && this.configuration.getAnyElement() != null) {
                return ConfigurableXMLRewriter.find(this.configuration.getAnyElement().getAttribute(), attribute.getName());
            }
            throw e;
        }
    }

    private ElementSpec getElementSpec(StartElement element) {
        List elementSpecs = this.elements.get((Object)element.getName());
        for (ElementSpec elementSpec : elementSpecs) {
            if (elementSpec.getMode() != null && !elementSpec.getMode().equals((Object)this.getImportMode()) || !this.fulfillsRequirements(elementSpec, element)) continue;
            return elementSpec;
        }
        return this.configuration.getAnyElement();
    }

    private boolean fulfillsRequirements(ElementSpec elementSpec, StartElement element) {
        for (ElementSpec.Required required : elementSpec.getRequired()) {
            Attribute attribute = element.getAttributeByName(required.getAttribute());
            if (attribute == null) {
                return false;
            }
            if (required.getPattern() == null || attribute.getValue().matches(required.getPattern())) continue;
            return false;
        }
        return true;
    }

    @Override
    public void rewrite(InputStream input, OutputStream output) throws IOException, XMLStreamException {
        XMLInputFactory inputFactory = XMLInputFactory.newInstance();
        inputFactory.setProperty("javax.xml.stream.isCoalescing", true);
        inputFactory.setProperty("javax.xml.stream.supportDTD", false);
        inputFactory.setProperty("javax.xml.stream.isSupportingExternalEntities", false);
        XMLStreamReader streamReader = inputFactory.createXMLStreamReader(input);
        String encoding = streamReader.getEncoding();
        if (encoding == null) {
            encoding = "UTF-8";
        }
        XMLEventReader reader = inputFactory.createXMLEventReader(streamReader);
        XMLEventWriter writer = XMLOutputFactory.newInstance().createXMLEventWriter(output, "UTF-8");
        this.rewrite(reader, writer);
    }

    public void rewrite(XMLEventReader reader, XMLEventWriter writer) throws FactoryConfigurationError, XMLStreamException {
        if (logger.isLoggable(Level.FINEST)) {
            StringWriter specWriter = new StringWriter();
            if (this.getMapping() != null) {
                JAXB.marshal((Object)this.getMapping().toImportSpec(), (Writer)specWriter);
            }
            logger.finest(MessageFormat.format("Starting a rewriting session.\n  * Configuration: {0}\u00a0({1})\n  * Base: {2}\n  * Spec:\n{3}", this.getConfiguration().getId(), this.getConfiguration().getDescription(), this.getBase(), specWriter.toString()));
        }
        XMLEventFactory eventFactory = XMLEventFactory.newInstance();
        LinkedList startElements = Lists.newLinkedList();
        while (reader.hasNext()) {
            XMLEvent event = reader.nextEvent();
            if (event.isStartElement()) {
                StartElement startElement = event.asStartElement();
                startElements.push(startElement);
                StartElement newStartElement = eventFactory.createStartElement(startElement.getName().getPrefix(), startElement.getName().getNamespaceURI(), startElement.getName().getLocalPart(), null, startElement.getNamespaces(), startElement.getNamespaceContext());
                writer.add(newStartElement);
                Iterator<Attribute> attributes = startElement.getAttributes();
                while (attributes.hasNext()) {
                    Attribute attribute = attributes.next();
                    writer.add(eventFactory.createAttribute(attribute.getName(), this.replaceAttributeValue(startElement, attribute)));
                }
                continue;
            }
            if (event.isCharacters()) {
                Characters characters = event.asCharacters();
                writer.add(eventFactory.createCharacters(this.replaceElementContent((StartElement)startElements.peek(), characters.getData())));
                continue;
            }
            writer.add(event);
            if (!event.isEndElement()) continue;
            startElements.pop();
        }
    }

    protected static <T extends NodeRewriteSpec> T find(Iterable<T> iterable, final QName name) throws NoSuchElementException {
        return (T)((NodeRewriteSpec)Iterables.find(iterable, (Predicate)new Predicate<NodeRewriteSpec>(){

            public boolean apply(NodeRewriteSpec input) {
                return name.equals(input.getName());
            }
        }));
    }

    public ConfigurableXMLRewriter recordMissingReferences() {
        this.missingReferences = Sets.newHashSet();
        return this;
    }

    public Set<String> getMissingReferences() {
        return ImmutableSet.copyOf(this.missingReferences);
    }

    public void setMergeMode(boolean mergeMode) {
        this.mergeMode = mergeMode;
    }

    public void setMergeLinkAdjuster(IMergeLinkAdjuster adjuster) {
        this.mergeLinkAdjuster = adjuster;
        this.setMergeMode(adjuster != null);
    }

    public static class DefaultMergeLinkAdjuster
    implements IMergeLinkAdjuster {
        private final String currentDocumentToken;

        public DefaultMergeLinkAdjuster(URI currentURI) {
            this.currentDocumentToken = currentURI.getSchemeSpecificPart();
        }

        @Override
        public String getMergedID(String id) {
            return id + "." + this.currentDocumentToken;
        }

        @Override
        public String getMergedLink(String prefix, String fragment) {
            if (null == prefix || prefix.isEmpty()) {
                return "#" + this.getMergedID(fragment);
            }
            if (null == fragment || fragment.isEmpty()) {
                return null;
            }
            return "#" + fragment + "." + URI.create(prefix).getSchemeSpecificPart();
        }
    }

    public static interface IMergeLinkAdjuster {
        public String getMergedID(String var1);

        public String getMergedLink(String var1, String var2);
    }

    protected abstract class Replacer {
        protected Replacer() {
        }

        public abstract String apply(String var1);

        protected String rewriteSingleLink(String link) {
            try {
                String toReplace;
                URI uri = new URI(link.trim());
                String fragment = uri.getRawFragment();
                String string = toReplace = fragment == null ? uri.toString() : uri.toString().substring(0, uri.toString().length() - fragment.length() - 1);
                if (ConfigurableXMLRewriter.this.mergeMode) {
                    String mergedLink = ConfigurableXMLRewriter.this.mergeLinkAdjuster.getMergedLink(toReplace, fragment);
                    if (logger.isLoggable(Level.FINEST)) {
                        logger.finest(MessageFormat.format("Merge mode rewriting {0}\u00a0to {1}", link, mergedLink));
                    }
                    if (mergedLink == null) {
                        return link;
                    }
                    return mergedLink;
                }
                String replacement = null;
                if (ConfigurableXMLRewriter.this.isExport()) {
                    String genericURI;
                    ImportObject importObject = ConfigurableXMLRewriter.this.getMapping().getImportObjectForTextGridURI(toReplace);
                    if (importObject == null && (genericURI = this.getGenericURI(toReplace)) != null) {
                        importObject = ConfigurableXMLRewriter.this.getMapping().getImportObjectForTextGridURI(genericURI);
                    }
                    if (importObject != null) {
                        replacement = this.relativize(importObject.getLocalData());
                    }
                    if (logger.isLoggable(Level.FINEST)) {
                        logger.finest(MessageFormat.format("Export mode rewriting {0}\u00a0to {1}, relativized from {2}", link, replacement, importObject != null ? importObject.getLocalData() : "(not found)"));
                    }
                } else {
                    String resolved = this.resolve(toReplace);
                    ImportObject importObject = ConfigurableXMLRewriter.this.getMapping().getImportObjectForLocalURI(resolved);
                    if (importObject != null) {
                        String genericURI;
                        replacement = importObject.getTextgridUri();
                        if (ConfigurableXMLRewriter.this.getMapping().getImportRevisionPolicy().equals((Object)RevisionPolicyType.LATEST) && (genericURI = this.getGenericURI(replacement)) != null) {
                            replacement = genericURI;
                        }
                    }
                    if (logger.isLoggable(Level.FINEST)) {
                        logger.finest(MessageFormat.format("Import mode rewriting {0} (resolved {1}) to {2}", toReplace, resolved, replacement));
                    }
                }
                if (replacement != null) {
                    if (fragment == null) {
                        return replacement;
                    }
                    return replacement.concat("#").concat(fragment);
                }
                if (ConfigurableXMLRewriter.this.missingReferences != null && !"".equals(toReplace)) {
                    ConfigurableXMLRewriter.this.missingReferences.add(toReplace);
                    logger.log(Level.FINEST, "Recording missing reference {0}", toReplace);
                }
            }
            catch (URISyntaxException e) {
                logger.log(Level.FINEST, "Replacer skipping non-URI: " + link, e);
            }
            return null;
        }

        private String getGenericURI(String textGridURI) {
            int dot = textGridURI.lastIndexOf(46);
            if (dot > 0) {
                return textGridURI.substring(0, dot);
            }
            return null;
        }

        private String resolve(String localData) {
            if (ConfigurableXMLRewriter.this.getBase() != null) {
                return ConfigurableXMLRewriter.this.getBase().resolve(localData).toString();
            }
            return localData;
        }

        private String relativize(String localData) {
            if (ConfigurableXMLRewriter.this.getBase() != null) {
                URI localURI = URI.create(localData);
                return ConfigurableXMLRewriter.relativize(ConfigurableXMLRewriter.this.getBase(), localURI).toString();
            }
            return localData;
        }
    }
}

