/*
 * Decompiled with CFR 0.152.
 */
package info.textgrid.lab.core.aggregations.ui.treeWriter;

import info.textgrid.lab.core.aggregations.ui.model.Aggregation;
import info.textgrid.lab.core.aggregations.ui.model.TGOentry;
import info.textgrid.lab.core.aggregations.ui.treeWriter.Messages;
import info.textgrid.lab.core.model.TextGridObject;
import info.textgrid.lab.ui.core.Activator;
import java.io.ByteArrayOutputStream;
import java.net.URI;
import java.util.List;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.osgi.util.NLS;

public class AggregationWriter {
    private static final String ORE_NS = "http://www.openarchives.org/ore/terms/";
    public static final String RDF_NS = "http://www.w3.org/1999/02/22-rdf-syntax-ns#";

    public ByteArrayOutputStream writeAggregation(Aggregation aggregation, List<URI> URIs, boolean saveAsRevision, IProgressMonitor monitor) throws XMLStreamException, CoreException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)1);
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        XMLOutputFactory outputFactory = XMLOutputFactory.newInstance();
        XMLStreamWriter writer = outputFactory.createXMLStreamWriter(output);
        writer.writeStartDocument();
        writer.setPrefix("rdf", RDF_NS);
        writer.writeStartElement(RDF_NS, "RDF");
        writer.writeNamespace("rdf", RDF_NS);
        writer.writeNamespace("ore", ORE_NS);
        writer.writeStartElement(RDF_NS, "Description");
        if (aggregation != null) {
            Object[] objectArray = aggregation.getChildren();
            int n = objectArray.length;
            int n2 = 0;
            while (n2 < n) {
                Object child = objectArray[n2];
                writer.writeEmptyElement(ORE_NS, "aggregates");
                if (child instanceof Aggregation) {
                    Aggregation childAggregation = (Aggregation)child;
                    childAggregation.save((IProgressMonitor)progress.newChild(1), saveAsRevision);
                    long start = System.currentTimeMillis();
                    while (childAggregation.getObject().isNew()) {
                        if (System.currentTimeMillis() - start <= 10000L) continue;
                        throw new CoreException((IStatus)new Status(4, "info.textgrid.lab.core.aggregations.ui", NLS.bind((String)Messages.AggregationWriter_EM_NoURI, (Object)childAggregation.getObject().getTitle())));
                    }
                    if (childAggregation.getLatest()) {
                        writer.writeAttribute("rdf:resource", childAggregation.getObject().getLatestURI());
                    } else if (childAggregation.getRevision() != null) {
                        writer.writeAttribute("rdf:resource", childAggregation.getRevision().getURI().toString());
                    } else {
                        writer.writeAttribute("rdf:resource", childAggregation.getObject().getURI().toString());
                    }
                } else if (child instanceof TGOentry) {
                    if (((TGOentry)child).getLatest()) {
                        if (((TGOentry)child).isRestrictedTextGridObject()) {
                            writer.writeAttribute("rdf:resource", ((TGOentry)child).getRestrictedTgo().getURI());
                        } else {
                            writer.writeAttribute("rdf:resource", ((TGOentry)child).getTgo().getLatestURI());
                        }
                    } else if (((TGOentry)child).getRevision() != null) {
                        writer.writeAttribute("rdf:resource", ((TGOentry)child).getRevision().getURI().toString());
                    } else {
                        writer.writeAttribute("rdf:resource", ((TGOentry)child).getTgo().getURI().toString());
                    }
                } else if (child instanceof TextGridObject) {
                    writer.writeAttribute("rdf:resource", ((TextGridObject)child).getURI().toString());
                } else {
                    Activator.handleError(null, (String)Messages.AggregationWriter_EM_StrangeObject, (Object[])new Object[]{aggregation, child});
                }
                ++n2;
            }
        } else if (!URIs.isEmpty()) {
            for (URI uri : URIs) {
                writer.writeEmptyElement(ORE_NS, "aggregates");
                writer.writeAttribute("rdf:resource", uri.toString());
            }
        }
        writer.writeEndElement();
        writer.writeEndElement();
        writer.writeEndDocument();
        writer.flush();
        writer.close();
        return output;
    }
}

