/*
 * Decompiled with CFR 0.152.
 */
package info.textgrid.lab.authn;

import info.textgrid.lab.authn.Activator;
import info.textgrid.lab.authn.Messages;
import info.textgrid.lab.authn.RBACSession;
import info.textgrid.lab.core.tgauthclient.TgAuthClientUtilities;
import info.textgrid.namespaces.middleware.tgauth.AuthenticationFault;
import info.textgrid.namespaces.middleware.tgauth.GetMyUserAttributesRequest;
import info.textgrid.namespaces.middleware.tgauth.GetMyUserAttributesResponse;
import info.textgrid.namespaces.middleware.tgauth.PortTgextra;
import info.textgrid.namespaces.middleware.tgauth.UserAttribute;
import java.text.MessageFormat;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.ui.IStartup;
import org.eclipse.ui.statushandlers.StatusManager;

public class AutoLogin
implements IStartup {
    public IStatus autoLogin() {
        IPreferenceStore prefs;
        String lastSid;
        String sid = RBACSession.getInstance().getSID(false);
        if ((sid == null || sid.isEmpty()) && !(lastSid = (prefs = Activator.getDefault().getPreferenceStore()).getString(Activator.LAST_SID)).isEmpty()) {
            PortTgextra tgextra = TgAuthClientUtilities.getTgAuthServiceStub();
            GetMyUserAttributesRequest request = new GetMyUserAttributesRequest();
            request.setAuth(lastSid);
            String lastEPPN = prefs.getString("lastEPPN");
            try {
                GetMyUserAttributesResponse userAttributes = tgextra.getMyUserAttributes(request);
                RBACSession.login(lastSid, lastEPPN, true);
                StringBuilder sb = new StringBuilder();
                for (UserAttribute attr : userAttributes.getAttribute()) {
                    sb.append(MessageFormat.format("{0}={1} ({2} [{3}]) [{4}; {5}]\n", attr.getName(), attr.getValue(), attr.getDisplayname(), attr.getDescription(), attr.getLdapname(), attr.getInclass()));
                }
                Status status = new Status(1, "info.textgrid.lab.authn", MessageFormat.format("Automatically logged in as {0} with saved session data.\n\nUser attributes: {1}", RBACSession.getInstance().getEPPN(), sb.toString()));
                StatusManager.getManager().handle((IStatus)status);
                return status;
            }
            catch (AuthenticationFault e) {
                Status status = new Status(2, "info.textgrid.lab.authn", MessageFormat.format("Automatic login using saved session failed: {2}, {0} ({1}). The previous user was {3}.", e.getFaultInfo().getFaultMessage(), e.getFaultInfo().getFaultNo(), e.getMessage(), lastEPPN));
                StatusManager.getManager().handle((IStatus)status);
                return status;
            }
        }
        return Status.CANCEL_STATUS;
    }

    public void earlyStartup() {
        Job job = new Job(Messages.AutoLogin_TryingAutoLogin){

            protected IStatus run(IProgressMonitor monitor) {
                return AutoLogin.this.autoLogin();
            }
        };
        job.schedule();
    }
}

