/*
 * Decompiled with CFR 0.152.
 */
package net.sf.vex.action.linked;

import info.textgrid.lab.core.swtutils.AdapterUtils;
import java.text.MessageFormat;
import net.sf.vex.VexToolkitPlugin;
import net.sf.vex.action.linked.AbstractModelQueryActionWrapper;
import net.sf.vex.widget.IVexWidget;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocument;
import org.eclipse.wst.xml.core.internal.contentmodel.CMElementDeclaration;
import org.eclipse.wst.xml.core.internal.contentmodel.CMNode;
import org.eclipse.wst.xml.core.internal.contentmodel.modelquery.ModelQueryAction;
import org.eclipse.wst.xml.ui.internal.contentassist.XMLContentModelGenerator;
import org.w3c.dom.Node;

public class InsertNodeAction
extends AbstractModelQueryActionWrapper {
    private XMLContentModelGeneratorExtension contentModelGenerator;

    @Override
    public ISourceViewer getSourceViewer() {
        IEditorPart activeEditor;
        ISourceViewer viewer = super.getSourceViewer();
        if (viewer == null && (activeEditor = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActiveEditor()) != null && (viewer = (ISourceViewer)AdapterUtils.getAdapter((Object)activeEditor, ISourceViewer.class)) != null) {
            this.setSourceViewer(viewer);
        }
        return viewer;
    }

    private XMLContentModelGeneratorExtension getContentModelGenerator() {
        if (this.contentModelGenerator == null) {
            this.contentModelGenerator = new XMLContentModelGeneratorExtension();
        }
        return this.contentModelGenerator;
    }

    public InsertNodeAction(ModelQueryAction action, IVexWidget vexWidget, ISourceViewer sourceViewer) {
        if (action.getKind() != 1) {
            throw new IllegalArgumentException(MessageFormat.format("Tried to create an insert node action from a model query action ({0}) of kind {1}, not {2} (= INSERT)", action, action.getKind(), 1));
        }
        this.init(action, null, vexWidget, sourceViewer);
        this.setText(action.getCMNode().getNodeName());
    }

    public void run() {
        ModelQueryAction action = this.getModelQueryAction();
        StringBuffer sb = new StringBuffer();
        IRegion selection = this.getSelectedSourceRegion();
        IStructuredDocument document = (IStructuredDocument)this.getSourceViewer().getDocument();
        try {
            if (selection.getLength() == 0) {
                this.getContentModelGenerator().generateTag(action.getParent(), (CMElementDeclaration)action.getCMNode(), sb);
                document.replace(selection.getOffset(), 0, sb.toString());
            } else {
                String oldSource = document.get(selection.getOffset(), selection.getLength());
                this.getContentModelGenerator().generateStartTag(action.getParent(), (CMElementDeclaration)action.getCMNode(), sb);
                int startTagLength = sb.length();
                sb.append(oldSource);
                this.getContentModelGenerator().generateEndTag(action.getParent(), (CMElementDeclaration)action.getCMNode(), sb);
                document.replace(selection.getOffset(), selection.getLength(), sb.toString());
                if (this.getSourceViewer() != null) {
                    this.getSourceViewer().setSelectedRange(selection.getOffset() + startTagLength, selection.getLength());
                }
                if (this.getVexWidget() != null) {
                    this.getVexWidget().reLayout();
                    this.getVexWidget().selectSourceRegion((IRegion)new Region(selection.getOffset() + startTagLength, selection.getLength()));
                }
            }
            if (this.getVexWidget() != null) {
                this.getVexWidget().reLayout();
            }
        }
        catch (BadLocationException e) {
            VexToolkitPlugin.log(4, e, "Could not insert element string ({0}) into the source document at position {1}: bad location", sb.toString(), selection);
        }
    }

    public class XMLContentModelGeneratorExtension
    extends XMLContentModelGenerator {
        public void generateEndTag(Node parentNode, CMElementDeclaration elementDecl, StringBuffer buffer) {
            String tagName = this.getRequiredName(parentNode, (CMNode)elementDecl);
            super.generateEndTag(tagName, parentNode, elementDecl, buffer);
        }

        public void generateStartTag(Node parentNode, CMElementDeclaration elementDecl, StringBuffer buffer) {
            String tagName = this.getRequiredName(parentNode, (CMNode)elementDecl);
            super.generateStartTag(tagName, parentNode, elementDecl, buffer);
        }
    }
}

